/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.report;

import com.google.common.base.Joiner;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.fidm.base.DisclosureFileHelper;
import kd.epm.far.business.fidm.base.DisclosureLogHelper;
import kd.epm.far.business.fidm.base.DisclosureZipFileHelper;
import kd.epm.far.business.fidm.base.dto.ZipFileItem;
import kd.epm.far.business.fidm.report.DisclosureReportHelper;
import kd.epm.far.business.fidm.report.dto.ReportDownloadInput;
import kd.epm.far.business.fidm.report.dto.ReportDownloadResult;
import kd.epm.far.business.fidm.task.dto.TaskMessage;
import kd.epm.far.business.fidm.word.WordToPdfUtils;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.GlobalIdUtil;

public class DisclosureReportFileHelper {
    protected static final WatchLogger logger = BcmLogFactory.getWatchLogInstance(DisclosureReportFileHelper.class);
    private static final Double MaxProcessValue = 10000.0;

    public static ReportDownloadResult downloadReport(ReportDownloadInput input, Consumer<TaskMessage> taskConsumer) {
        ArrayList<String> msgList = new ArrayList<String>(2);
        List<Long> reportIds = input.getReportIds();
        String fileType = input.getFileType();
        String timeStr = new SimpleDateFormat("yyyyMMdd").format(new Date());
        String zipFileName = String.format(ResManager.loadKDString((String)"\u6211\u7684\u62a5\u544a%s", (String)"DisclosureReportHelper_4", (String)"epm-far-business", (Object[])new Object[0]), timeStr);
        ArrayList<ZipFileItem> zipFileItemList = new ArrayList<ZipFileItem>(reportIds.size());
        ArrayList<String> fileNames = new ArrayList<String>(reportIds.size());
        Double chapterProcessValue = MaxProcessValue / (double)reportIds.size();
        for (Long reportId : reportIds) {
            if (taskConsumer != null) {
                taskConsumer.accept(new TaskMessage(chapterProcessValue, ""));
            }
            ArrayList<String> strTips = new ArrayList<String>(10);
            DynamicObject report = DisclosureReportHelper.getReport(reportId, false);
            if (report == null) continue;
            String reportName = report.getString("name");
            String docUrl = DisclosureReportHelper.mergeReport(reportId, strTips);
            for (String tip : strTips) {
                msgList.add(reportName + "\uff1a" + tip);
            }
            if (StringUtils.isEmpty((CharSequence)docUrl)) continue;
            if (StringUtils.isEmpty((CharSequence)reportName)) {
                reportName = String.valueOf(GlobalIdUtil.genGlobalLongId());
            }
            if (fileNames.contains(reportName)) {
                reportName = reportName + GlobalIdUtil.genGlobalLongId();
            } else {
                fileNames.add(reportName);
            }
            ZipFileItem zipFileItem = new ZipFileItem();
            zipFileItem.setFileName(reportName + ".docx");
            zipFileItem.setUrl(docUrl);
            zipFileItem.setTempFile(false);
            if ("pdf".equalsIgnoreCase(fileType)) {
                String pdfUrl = WordToPdfUtils.getPdfUrl(docUrl, reportName, DisclosureFileHelper.getUrlPrefix());
                zipFileItem.setFileName(reportName + ".pdf");
                zipFileItem.setUrl(pdfUrl);
                zipFileItem.setTempFile(true);
            }
            zipFileItemList.add(zipFileItem);
        }
        String tempUrl = "";
        if (input.isNeedZip()) {
            tempUrl = DisclosureZipFileHelper.zipFile(zipFileName, zipFileItemList, DisclosureFileHelper.getUrlPrefix());
        }
        ReportDownloadResult reportDownloadResult = new ReportDownloadResult();
        reportDownloadResult.setInput(input);
        reportDownloadResult.setTips(msgList);
        reportDownloadResult.setZipFileItems(zipFileItemList);
        reportDownloadResult.setZipUrl(tempUrl);
        return reportDownloadResult;
    }

    public static String downloadReport(IFormView view, Long reportId, String fileType) {
        DynamicObject report = DisclosureReportHelper.getReport(reportId);
        if (report == null) {
            return "";
        }
        String reportName = report.getString("name");
        ArrayList<String> strMessage = new ArrayList<String>(2);
        String docUrl = DisclosureReportHelper.mergeReport(reportId, strMessage);
        if (StringUtils.isEmpty((CharSequence)docUrl)) {
            String errInfo = ResManager.loadKDString((String)"\u4e0b\u8f7d\u62a5\u544a\u5931\u8d25\u3002", (String)"DisclosureReportHelper_2", (String)"epm-far-business", (Object[])new Object[0]);
            view.showErrorNotification(errInfo);
            return "";
        }
        String doownloadUrl = "";
        doownloadUrl = "pdf".equalsIgnoreCase(fileType) ? WordToPdfUtils.getPdfUrl(docUrl, reportName, DisclosureFileHelper.getUrlPrefix()) : UrlService.getAttachmentFullUrl((String)docUrl);
        if (view != null) {
            ((IClientViewProxy)view.getService(IClientViewProxy.class)).addAction("download", (Object)doownloadUrl);
            if (strMessage != null && strMessage.size() > 0) {
                String title = ResManager.loadKDString((String)"\u6587\u4ef6\u4e0b\u8f7d\u5f02\u5e38\u4fe1\u606f", (String)"DisclosureReportHelper_5", (String)"epm-far-business", (Object[])new Object[0]);
                view.showMessage(title, Joiner.on((String)"\n").join(strMessage), MessageTypes.Default);
            }
            DynamicObject reportEx = BusinessDataServiceHelper.loadSingle((Object)reportId, (String)"fidm_report");
            Long dmModelId = reportEx.getLong("model.id");
            ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
            ModelInfo modelInfo = modelStrategyEx.getModel().getModelInfo();
            DisclosureLogHelper.writeReportOper(OperationResult.SUCCESS, modelInfo, reportEx, OperationName.EXPORT_REPORT2);
        }
        return doownloadUrl;
    }

    public static void downloadChapter(IFormView view, Long reportId, Long chapterId, String fileType) {
        DynamicObject chapter = QueryServiceHelper.queryOne((String)"fidm_chapter", (String)"id,number,name,previewurl,model.id", (QFilter[])new QFilter("id", "=", (Object)chapterId).toArray());
        if (chapter == null) {
            String errInfo = ResManager.loadKDString((String)"\u4e0b\u8f7d\u7ae0\u8282\u5931\u8d25\u3002", (String)"DisclosureReportHelper_3", (String)"epm-far-business", (Object[])new Object[0]);
            view.showErrorNotification(errInfo);
            return;
        }
        String docUrl = chapter.getString("previewurl");
        String fileName = chapter.getString("name");
        if ("pdf".equalsIgnoreCase(fileType)) {
            String pdfUrl = WordToPdfUtils.getPdfUrl(docUrl, fileName, DisclosureFileHelper.getUrlPrefix());
            ((IClientViewProxy)view.getService(IClientViewProxy.class)).addAction("download", (Object)pdfUrl);
        } else {
            String wordUrl = UrlService.getAttachmentFullUrl((String)docUrl);
            ((IClientViewProxy)view.getService(IClientViewProxy.class)).addAction("download", (Object)wordUrl);
        }
        DynamicObject report = BusinessDataServiceHelper.loadSingle((Object)reportId, (String)"fidm_report");
        Long dmModelId = report.getLong("model.id");
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        ModelInfo modelInfo = modelStrategyEx.getModel().getModelInfo();
        DisclosureLogHelper.writeReportChapter(OperationResult.SUCCESS, modelInfo, report, chapter, OperationName.EXPORT_REPORT);
    }
}

