/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.report;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.enums.MyReportStatusEnum;
import kd.epm.far.business.common.enums.OpenWordEnum;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.perm.PermissionHelper;
import kd.epm.far.business.common.util.PlatUtil;
import kd.epm.far.business.common.util.ResultInfo;
import kd.epm.far.business.common.util.StringExUitls;
import kd.epm.far.business.fidm.base.DisclosureFileHelper;
import kd.epm.far.business.fidm.base.DisclosureLogHelper;
import kd.epm.far.business.fidm.base.ISaveOperation;
import kd.epm.far.business.fidm.perm.PermClassReportHelper;
import kd.epm.far.business.fidm.report.DisclosureReportNameHelper;
import kd.epm.far.business.fidm.report.ReportChapterHelper;
import kd.epm.far.business.fidm.report.ReportFlowStatusHelper;
import kd.epm.far.business.fidm.template.DisclosureTemplateHelper;
import kd.epm.far.business.fidm.web.WebModuleRefreshHelper;
import kd.epm.far.business.fidm.word.MergeDocUtils;
import kd.epm.far.business.fidm.word.dto.MergeDocFileItem;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.QFBuilder;

public class DisclosureReportHelper {
    protected static final WatchLogger logger = BcmLogFactory.getWatchLogInstance(DisclosureReportHelper.class);
    private static final String BCM_ENTITY = "bcmentity";
    private static final String EPM_ENTITY = "epmentity";
    private static final String BCM_FY = "year";
    private static final String EPM_PERIOD = "budgetperiod";
    private static final String BCM_PERIOD = "period";
    private static final String VERSION = "version";
    private static final String SCENARIO = "scenario";
    private static final String FIELD_MODEL = "model";
    private static final String FIELD_ISPREVIEW = "ispreview";
    private static final String FIELD_STATUS = "status";
    private static final String FIELD_ISARCHIVED = "isarchived";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_REPORT = "report";
    public static final Set<String> BCMDIM = new HashSet<String>(Arrays.asList("Entity", "Year", "Period"));
    public static final Set<String> EPMDIM = new HashSet<String>(Arrays.asList("Entity", "BudgetPeriod", "Version"));

    public static DynamicObject getReport(Long reportId) {
        return DisclosureReportHelper.getReport(reportId, true);
    }

    public static DynamicObject getReport(Long reportId, boolean showException) {
        DynamicObject reportDy = QueryServiceHelper.queryOne((String)"fidm_report", (String)"id,name,docurl,status,isedit,modifytime,creator.id,creator.name,model.id", (QFilter[])new QFilter("id", "=", (Object)reportId).toArray());
        if (showException && reportDy == null) {
            logger.error("report id not exist:" + reportId);
            throw new KDBizException(ResManager.loadKDString((String)"\u6211\u7684\u62a5\u544a\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"DisclosureReportHelper_0", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return reportDy;
    }

    public static String changeDimNumber2F7Sign(String dimNumber, String modeltype) {
        dimNumber = StringExUitls.toLowerCase(dimNumber);
        String result = "";
        if (DisModelTypeEnum.EB.getType().equalsIgnoreCase(modeltype)) {
            switch (dimNumber) {
                case "entity": {
                    result = EPM_ENTITY;
                    break;
                }
                case "budgetperiod": {
                    result = EPM_PERIOD;
                    break;
                }
                case "version": {
                    result = VERSION;
                }
            }
        } else {
            switch (dimNumber) {
                case "entity": {
                    result = BCM_ENTITY;
                    break;
                }
                case "year": {
                    result = BCM_FY;
                    break;
                }
                case "period": {
                    result = BCM_PERIOD;
                }
            }
        }
        return result;
    }

    public static List<DimensionInfo> getDimList(Long dmModelId, Long reportId) {
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        List<DimensionInfo> allDimensionIds = modelStrategyEx.getDim().getDimList();
        ArrayList<DimensionInfo> dimensions = new ArrayList<DimensionInfo>(16);
        DynamicObjectCollection reportDims = QueryServiceHelper.query((String)"fidm_report_dim", (String)"id,dimid.id,dimid.number,dimmemberid,dimtype", (QFilter[])new QFilter[]{new QFilter(FIELD_REPORT, "=", (Object)reportId)});
        for (DynamicObject dim : reportDims) {
            DimensionInfo find = DimensionUtils.getDimByNumber(allDimensionIds, dim.getString("dimid.number"));
            if (find == null) continue;
            Long memberId = dim.getLong("dimmemberid");
            DimMemberInfo memberInfo = modelStrategyEx.getDimMember().findMemberById(find.getEntityName(), memberId, false);
            if (memberInfo == null) continue;
            find.getMembers().add(memberInfo);
            dimensions.add(find);
        }
        return dimensions;
    }

    public static List<DimensionInfo> getOldRecentMembers(Long dmModelId, Long reportId) {
        ArrayList<DimensionInfo> dimensionInfos = new ArrayList<DimensionInfo>(16);
        if (reportId == null || reportId <= 0L) {
            return dimensionInfos;
        }
        try {
            ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
            List<DimensionInfo> allDimList = modelStrategyEx.getDim().getDimList();
            DynamicObject report = BusinessDataServiceHelper.loadSingle((Object)reportId, (String)"fidm_report");
            if (report != null) {
                String paramnumber;
                DimensionInfo scenario;
                DimensionInfo period;
                DimensionInfo year;
                DimensionInfo entity = DisclosureReportHelper.getDimensionInfo(allDimList, (DynamicObject)report.get(BCM_ENTITY), "Entity");
                if (entity != null) {
                    dimensionInfos.add(entity);
                }
                if ((year = DisclosureReportHelper.getDimensionInfo(allDimList, (DynamicObject)report.get(BCM_FY), "Year")) != null) {
                    dimensionInfos.add(year);
                }
                if ((period = DisclosureReportHelper.getDimensionInfo(allDimList, (DynamicObject)report.get(BCM_PERIOD), "Period")) != null) {
                    dimensionInfos.add(period);
                }
                if ((scenario = DisclosureReportHelper.getDimensionInfo(allDimList, (DynamicObject)report.get(SCENARIO), "Scenario")) != null) {
                    dimensionInfos.add(scenario);
                }
                if (StringUtils.isNotEmpty((CharSequence)(paramnumber = report.getString("paramnumber")))) {
                    String[] dimMemberArray;
                    for (String dimData : dimMemberArray = paramnumber.split(";")) {
                        DimMemberInfo member;
                        DimensionInfo find;
                        int splitIndex = dimData.indexOf(".");
                        if (splitIndex < 0) continue;
                        String dimNumber = dimData.substring(0, splitIndex);
                        String memberNumber = dimData.substring(splitIndex + 1, dimData.length());
                        DimensionInfo current = DimensionUtils.getDimByNumber(allDimList, dimNumber);
                        if (current == null || (find = (DimensionInfo)dimensionInfos.stream().filter(m -> m.getNumber().equalsIgnoreCase(dimNumber)).findFirst().orElse(null)) != null || !StringUtils.isNotEmpty((CharSequence)dimNumber) || !StringUtils.isNotEmpty((CharSequence)memberNumber) || (member = modelStrategyEx.getDimMember().findMemberByNumber(dimNumber, memberNumber, false)) == null) continue;
                        current.getMembers().add(member);
                        dimensionInfos.add(current);
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
        }
        return dimensionInfos;
    }

    private static DimensionInfo getDimensionInfo(List<DimensionInfo> allDimList, DynamicObject memberDy, String dimNumber) {
        DimensionInfo entity;
        if (memberDy != null && (entity = DimensionUtils.getDimByNumber(allDimList, dimNumber)) != null) {
            entity.getMembers().add(DimensionUtils.convertToMemberInfo(memberDy));
            return entity;
        }
        return null;
    }

    public static String mergeReport(Long reportId, List<String> strTips) {
        if (Objects.isNull(reportId)) {
            return null;
        }
        DynamicObject rpt = BusinessDataServiceHelper.loadSingle((Object)reportId, (String)"fidm_report");
        Long dmModelId = rpt.getLong("model.id");
        List<Long> chapterids = PermClassReportHelper.getValiadChaptersByReport(dmModelId, reportId);
        QFBuilder qf = new QFBuilder(FIELD_MODEL, "=", (Object)dmModelId);
        qf.add(new QFilter("id", "in", chapterids));
        DynamicObject[] chapters = BusinessDataServiceHelper.load((String)"fidm_chapter", (String)"id,name,previewurl", (QFilter[])qf.toArray(), (String)"sequence");
        int index = 0;
        ArrayList<MergeDocFileItem> fileItems = new ArrayList<MergeDocFileItem>(chapters.length);
        for (DynamicObject chapter : chapters) {
            MergeDocFileItem fileItem = new MergeDocFileItem();
            fileItem.setTempFile(false);
            fileItem.setUrl(chapter.getString("previewurl"));
            fileItem.setName(chapter.getString(FIELD_NAME));
            fileItem.setSeq(++index);
            fileItems.add(fileItem);
        }
        String docUrl = "";
        try {
            byte[] fileData = MergeDocUtils.merge(fileItems, strTips);
            ByteArrayInputStream finalInputStream = new ByteArrayInputStream(fileData);
            docUrl = DisclosureFileHelper.saveAsNew(finalInputStream, "fidm", "fidm_webpreview", reportId, rpt.getString(FIELD_NAME));
            rpt.set("docurl", (Object)docUrl);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{rpt});
        }
        catch (Exception e) {
            logger.error(ResManager.loadKDString((String)"\u6309\u7ae0\u8282\u5408\u5e76\u751f\u6210\u62a5\u544a\u5f02\u5e38\u3002", (String)"DisclosureReportHelper_1", (String)"epm-far-business", (Object[])new Object[0]), (Throwable)e);
        }
        return docUrl;
    }

    public static boolean existsReport(long modelId, long templateId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter(FIELD_MODEL, "=", (Object)modelId));
        qFilters.add(new QFilter(FIELD_ISPREVIEW, "=", (Object)"0"));
        qFilters.add(new QFilter("template", "=", (Object)templateId));
        return QueryServiceHelper.exists((String)"fidm_report", (QFilter[])qFilters.toArray(new QFilter[0]));
    }

    public static ResultInfo saveReport(long modelId, long reportId, String name, long permClassId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter(FIELD_MODEL, "=", (Object)modelId));
        qFilters.add(new QFilter("id", "=", (Object)reportId));
        qFilters.add(new QFilter(FIELD_ISPREVIEW, "=", (Object)"0"));
        DynamicObject report = BusinessDataServiceHelper.loadSingle((String)"fidm_report", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (report == null) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u62a5\u544a\u5df2\u4e0d\u5b58\u5728\u3002", (String)"ReportServiceHelper_0", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (!DisclosureReportHelper.hasWritePermission(modelId, reportId)) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u62a5\u544a\u7684\u8bfb\u5199\u6743\u9650\u3002", (String)"ReportServiceHelper_4", (String)"epm-far-business", (Object[])new Object[0]));
        }
        String modelType = new ModelStrategyEx(modelId).getModel().getModelInfo().getModelType();
        ResultInfo checkResult = DisclosureReportNameHelper.checkReportName(modelId, report, name, modelType);
        if (Boolean.FALSE.equals(checkResult.isSuccess())) {
            return checkResult;
        }
        if (MyReportStatusEnum.COMMITED.getValue().equals(report.getString(FIELD_STATUS))) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u7684\u62a5\u544a\u4e0d\u53ef\u7f16\u8f91\u3002", (String)"ReportServiceHelper_1", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (MyReportStatusEnum.AUDITED.getValue().equals(report.getString(FIELD_STATUS))) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u7684\u62a5\u544a\u4e0d\u53ef\u7f16\u8f91\u3002", (String)"ReportServiceHelper_2", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (MyReportStatusEnum.ARCHIVED.getValue().equals(report.getString(FIELD_ISARCHIVED))) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u5df2\u5f52\u6863\u7684\u62a5\u544a\u4e0d\u53ef\u7f16\u8f91\u3002", (String)"ReportServiceHelper_3", (String)"epm-far-business", (Object[])new Object[0]));
        }
        PlatUtil.executeWithTXNew(tx -> {
            report.set(FIELD_NAME, (Object)name);
            report.set("modifier", (Object)RequestContext.get().getCurrUserId());
            report.set("modifytime", (Object)TimeServiceHelper.now());
            SaveServiceHelper.save((IDataEntityType)report.getDynamicObjectType(), (Object[])new Object[]{report});
            PermissionHelper.savePermClassEntity(modelId, reportId, "fidm_report", permClassId, OperationStatus.EDIT);
        });
        return ResultInfo.success(reportId);
    }

    public static ResultInfo deleteReport(long dmModelId, long reportId) {
        DynamicObject report = BusinessDataServiceHelper.loadSingle((Object)reportId, (String)"fidm_report");
        if (report == null) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u62a5\u544a\u5df2\u4e0d\u5b58\u5728\u3002", (String)"ReportServiceHelper_0", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (!DisclosureReportHelper.hasWritePermission(dmModelId, reportId)) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u62a5\u544a\u7684\u8bfb\u5199\u6743\u9650\u3002", (String)"ReportServiceHelper_4", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (!MyReportStatusEnum.UNCOMMIT.getValue().equals(report.getString(FIELD_STATUS)) && !MyReportStatusEnum.BACKED.getValue().equals(report.getString(FIELD_STATUS))) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u53ea\u80fd\u5220\u9664\u72b6\u6001\u4e3a\u672a\u63d0\u4ea4\u7684\u62a5\u544a\u3002", (String)"ReportServiceHelper_5", (String)"epm-far-business", (Object[])new Object[0]));
        }
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        ModelInfo modelInfo = modelStrategyEx.getModel().getModelInfo();
        try {
            PlatUtil.executeWithTXNew(tx -> {
                ReportChapterHelper.delChapterModule(reportId);
                DeleteServiceHelper.delete((String)"fidm_report_dim", (QFilter[])new QFilter[]{new QFilter(FIELD_REPORT, "=", (Object)reportId)});
                DeleteServiceHelper.delete((String)"fidm_report", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)reportId)});
                PermissionHelper.savePermClassEntity(dmModelId, reportId, "fidm_report", 0L, OperationStatus.EDIT);
            });
            DisclosureLogHelper.writeReportOper(OperationResult.SUCCESS, modelInfo, report, OperationName.DELETE_REPORT);
        }
        catch (Exception ex) {
            DisclosureLogHelper.writeReportOper(OperationResult.FAILURE, modelInfo, report, OperationName.DELETE_REPORT);
            logger.error("dm delete report fail", (Throwable)ex);
            throw ex;
        }
        return ResultInfo.success(reportId);
    }

    public static ResultInfo setReportFlowStatus(long modelId, long reportId, String operateType, String remark) {
        if (!DisclosureReportHelper.hasWritePermission(modelId, reportId)) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u8be5\u62a5\u544a\u7684\u8bfb\u5199\u6743\u9650\u3002", (String)"ReportServiceHelper_4", (String)"epm-far-business", (Object[])new Object[0]));
        }
        try {
            ReportFlowStatusHelper.updateFlowStatus(reportId, operateType, remark);
        }
        catch (KDBizException e) {
            return ResultInfo.fail(e.getMessage());
        }
        return ResultInfo.success(reportId);
    }

    public static Tuple<Boolean, String> saveReportChapter(Long reportId, Long chapterId, ISaveOperation saveOperation, String eventArgs, int saveWordType) {
        DynamicObject[] moduleList;
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        JSONArray itemList = jsonObject.getJSONArray("itemList");
        DynamicObject chapter = BusinessDataServiceHelper.loadSingle((Object)chapterId, (String)"fidm_chapter");
        if (chapter == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ae0\u8282\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"DisclosureServiceHelper_3", (String)"epm-far-business", (Object[])new Object[0]));
        }
        Long dmModelId = chapter.getLong("model.id");
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        ModelInfo modelInfo = modelStrategyEx.getModel().getModelInfo();
        WebModuleRefreshHelper.resetDataResultByWebData(itemList);
        DynamicObjectCollection chapterModules = chapter.getDynamicObjectCollection("entryentity");
        ArrayList<DynamicObject> saveNewModules = new ArrayList<DynamicObject>(chapterModules.size());
        List moduleIds = chapterModules.stream().map(e -> e.getLong("module.id")).filter(e -> !e.equals(0L)).distinct().collect(Collectors.toList());
        for (DynamicObject module : moduleList = BusinessDataServiceHelper.load((Object[])moduleIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fidm_modulerepository"))) {
            String moduleId = module.getString("id");
            JSONObject itemObject = itemList.stream().filter(m -> moduleId.equalsIgnoreCase(((JSONObject)m).getString("id"))).findFirst().orElse(null);
            if (itemObject == null) continue;
            module.set("properties", (Object)itemObject.toJSONString());
            module.set("modifier", (Object)RequestContext.get().getCurrUserId());
            module.set("modifytime", (Object)TimeServiceHelper.now());
            saveNewModules.add(module);
        }
        String newFileUrl = saveOperation.getUrl(chapter);
        chapter.set("previewurl", (Object)newFileUrl);
        chapter.set("savewordtype", (Object)saveWordType);
        chapter.set("comefrom", (Object)OpenWordEnum.getComefromByType(String.valueOf(saveWordType)).getType());
        chapter.set("modifytime", (Object)TimeServiceHelper.now());
        DynamicObject report = BusinessDataServiceHelper.loadSingle((Object)reportId, (String)"fidm_report");
        if (report != null) {
            report.set("modifier", (Object)RequestContext.get().getCurrUserId());
            report.set("modifytime", (Object)new Date());
        }
        try (TXHandle tx = TX.required();){
            try {
                SaveServiceHelper.save((DynamicObject[])saveNewModules.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{chapter});
                if (report != null) {
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{report});
                }
                DisclosureLogHelper.writeReportChapter(OperationResult.SUCCESS, OperationName.SAVE, modelInfo, report, chapter);
            }
            catch (Exception e2) {
                tx.markRollback();
                DisclosureLogHelper.writeReportChapter(OperationResult.FAILURE, OperationName.SAVE, modelInfo, report, chapter);
                throw new KDBizException((Throwable)e2, new ErrorCode("", e2.getMessage()), new Object[0]);
            }
        }
        return new Tuple((Object)true, (Object)newFileUrl);
    }

    public static List<Long> getChapterInfoByReport(Long reportId) {
        if (!LongUtil.isvalidLong((Object)reportId)) {
            return new ArrayList<Long>(100);
        }
        DynamicObject reportDy = BusinessDataServiceHelper.loadSingle((Object)reportId, (String)"fidm_report");
        if (reportDy != null) {
            DynamicObjectCollection entryentitys = reportDy.getDynamicObjectCollection("entryentity");
            return entryentitys.stream().map(x -> x.getLong("chapter.id")).collect(Collectors.toList());
        }
        return new ArrayList<Long>(100);
    }

    public static boolean hasWritePermission(long modelId, long reportId) {
        DynamicObject report = BusinessDataServiceHelper.loadSingleFromCache((Object)reportId, (String)"fidm_report");
        if (report != null) {
            boolean result = PermissionHelper.hasWritePerm(modelId, "fidm_report", reportId);
            if (result) {
                result = DisclosureTemplateHelper.hasWritePermission(modelId, report.getLong("template.id"));
            }
            return result;
        }
        return false;
    }
}

