/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.report;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.f7.base.MutilF7DimsionUtils;
import kd.epm.far.business.common.f7.dto.MutilF7DimsionInfo;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.util.FarNumberRule;
import kd.epm.far.business.common.util.ResultInfo;
import kd.epm.far.business.fidm.report.dto.ReportNameResult;
import kd.epm.far.common.common.util.DateTimeUtils;
import kd.epm.far.common.common.util.GlobalIdUtil;
import kd.epm.far.common.common.util.QFBuilder;

public class DisclosureReportNameHelper {
    private static final String FIELD_MODEL = "model";
    private static final String FIELD_ISPREVIEW = "ispreview";
    private static final String FIELD_NAME = "name";
    private static final String FIELD_BCMENTITY = "bcmentity";
    private static final String FIELD_PERIOD = "period";
    private static final String FIELD_YEAR = "year";
    private static final String FIELD_SCENARIO = "scenario";
    private static final String FIELD_EPMENTITY = "epmentity";
    private static final String FIELD_BUDGETPERIOD = "budgetperiod";
    private static final String FIELD_VERSION = "version";
    private static final String FIELD_DATATYPE = "datatype";

    public static void checkReportName(Long dmModelId, Long templateId, List<MutilF7DimsionInfo> mutilF7DimsionInfos, String reportName) {
        if (StringUtils.isEmpty((String)reportName)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u544a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReportGenerateEditPlugin_1", (String)"epm-far-business", (Object[])new Object[0]));
        }
        ResultInfo wordNameRes = FarNumberRule.checkWordName(reportName);
        if (!wordNameRes.isSuccess().booleanValue()) {
            throw new KDBizException(wordNameRes.getMessage());
        }
        if (reportName.length() > 100) {
            throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u544a\u540d\u79f0\u957f\u5ea6\u8d85\u8fc7\u9650\u5236\uff0c\u6700\u5927\u957f\u5ea6\u4e3a100\u3002", (String)"ReportServiceHelper_12", (String)"epm-far-business", (Object[])new Object[0]));
        }
        QFBuilder qFilter = DisclosureReportNameHelper.getReportFilter(dmModelId, templateId, mutilF7DimsionInfos);
        qFilter.add(new QFilter(FIELD_NAME, "=", (Object)reportName));
        if (QueryServiceHelper.exists((String)"fidm_report", (QFilter[])qFilter.toArray())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u544a\u540d\u79f0\u5df2\u5b58\u5728\u3002", (String)"ReportGenerateEditPlugin_4", (String)"epm-far-business", (Object[])new Object[0]));
        }
    }

    private static QFBuilder getReportFilter(Long dmModelId, Long templateId, List<MutilF7DimsionInfo> mutilF7DimsionInfos) {
        ModelInfo modelInfo = new ModelStrategyEx(dmModelId).getModel().getModelInfo();
        QFBuilder reportFilter = new QFBuilder();
        if (DisModelTypeEnum.EB.getType().equalsIgnoreCase(modelInfo.getModelType())) {
            List<Long> entityIds;
            List<Long> budgetPeriodIds;
            List<Long> versionIds = MutilF7DimsionUtils.getMemberId(mutilF7DimsionInfos, FIELD_VERSION);
            if (versionIds.size() > 0) {
                reportFilter.add(new QFilter(FIELD_VERSION, "in", versionIds));
            }
            if ((budgetPeriodIds = MutilF7DimsionUtils.getMemberId(mutilF7DimsionInfos, "budgetPeriod")).size() > 0) {
                reportFilter.add(new QFilter(FIELD_BUDGETPERIOD, "in", budgetPeriodIds));
            }
            if ((entityIds = MutilF7DimsionUtils.getMemberId(mutilF7DimsionInfos, "entity")).size() > 0) {
                reportFilter.add(new QFilter(FIELD_EPMENTITY, "in", entityIds));
            }
        } else {
            List<Long> entityIds;
            List<Long> periodIds;
            List<Long> yearIds = MutilF7DimsionUtils.getMemberId(mutilF7DimsionInfos, FIELD_YEAR);
            if (yearIds.size() > 0) {
                reportFilter.add(new QFilter(FIELD_YEAR, "in", yearIds));
            }
            if ((periodIds = MutilF7DimsionUtils.getMemberId(mutilF7DimsionInfos, FIELD_PERIOD)).size() > 0) {
                reportFilter.add(new QFilter(FIELD_PERIOD, "in", periodIds));
            }
            if ((entityIds = MutilF7DimsionUtils.getMemberId(mutilF7DimsionInfos, "entity")).size() > 0) {
                reportFilter.add(new QFilter(FIELD_BCMENTITY, "in", entityIds));
            }
        }
        reportFilter.add("template", "=", (Object)templateId);
        reportFilter.add(FIELD_MODEL, "=", (Object)dmModelId);
        return reportFilter;
    }

    public static List<ReportNameResult> createReportName(Long dmModelId, Long templateId, List<MutilF7DimsionInfo> mutilF7DimsionInfos) {
        DynamicObject template = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"fidm_template");
        if (template == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u544a\u6a21\u677f\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"DisclosureServiceHelper_7", (String)"epm-far-business", (Object[])new Object[0]));
        }
        DynamicObjectCollection reportNameRule = template.getDynamicObjectCollection("reportnamedefined");
        if (reportNameRule.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5728\u62a5\u544a\u6a21\u677f\u7f16\u8f91\u4e2d\u5b9a\u4e49\u540d\u79f0\u89c4\u5219\u3002", (String)"DisclosureServiceHelper_22", (String)"epm-far-business", (Object[])new Object[0]));
        }
        MutilF7DimsionInfo entityDim = MutilF7DimsionUtils.getDimInfo(mutilF7DimsionInfos, "entity");
        if (entityDim == null || entityDim.getMemberInfos().size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReportGenerateEditPlugin_5", (String)"epm-far-business", (Object[])new Object[0]));
        }
        int dsq = DisclosureReportNameHelper.getMaxDesq(dmModelId, templateId, mutilF7DimsionInfos);
        ArrayList<ReportNameResult> reportNameResults = new ArrayList<ReportNameResult>(entityDim.getMemberInfos().size());
        for (DimMemberInfo entityMember : entityDim.getMemberInfos()) {
            String reportName = "";
            int reportDsq = 0;
            String reportNameStr = "";
            for (DynamicObject reportNameDy : reportNameRule) {
                String fieldName = reportNameDy.getString("fieldname");
                String fieldType = fieldName.substring(0, 3);
                if ("dim".equals(fieldType)) {
                    String number;
                    String valuetype;
                    String dimInfo = fieldName.substring(3, fieldName.length());
                    String dimNumber = dimInfo.split("/")[1];
                    MutilF7DimsionInfo dimsionInfo = MutilF7DimsionUtils.getDimInfo(mutilF7DimsionInfos, dimNumber = dimNumber.split("_")[0]);
                    if (dimsionInfo == null) continue;
                    if (!"entity".equalsIgnoreCase(dimNumber)) {
                        valuetype = reportNameDy.getString("valuetype");
                        if ("1".equals(valuetype)) {
                            if (dimsionInfo.getMemberInfos().size() > 0) {
                                number = dimsionInfo.getMemberInfos().get(0).getNumber();
                                reportNameStr = reportNameStr + number;
                            }
                        } else if ("2".equals(valuetype) && dimsionInfo.getMemberInfos().size() > 0) {
                            number = dimsionInfo.getMemberInfos().get(0).getName();
                            reportNameStr = reportNameStr + number;
                        }
                    } else {
                        valuetype = reportNameDy.getString("valuetype");
                        if ("1".equals(valuetype)) {
                            number = entityMember.getNumber();
                            reportNameStr = reportNameStr + number;
                        } else if ("2".equals(valuetype)) {
                            String name = entityMember.getName();
                            reportNameStr = reportNameStr + name;
                        }
                    }
                    reportNameStr = DisclosureReportNameHelper.addBreakCombo(reportNameStr, reportNameDy);
                    continue;
                }
                if ("val".equals(fieldType)) {
                    String value = reportNameDy.getString("value");
                    reportNameStr = reportNameStr + value;
                    reportNameStr = DisclosureReportNameHelper.addBreakCombo(reportNameStr, reportNameDy);
                    continue;
                }
                if ("dsq".equals(fieldType)) {
                    reportNameStr = reportNameStr + dsq;
                    reportDsq = dsq++;
                    reportNameStr = DisclosureReportNameHelper.addBreakCombo(reportNameStr, reportNameDy);
                    continue;
                }
                if ("dat".equals(fieldType)) {
                    String valuetype = reportNameDy.getString("valuetype");
                    String date = DateTimeUtils.format((Date)new Date(), (String)"yyyy-MM-dd");
                    String[] datesplit = date.split("-");
                    String day = datesplit[2];
                    String month = datesplit[1];
                    String year = datesplit[0];
                    if ("3".equals(valuetype)) {
                        reportNameStr = reportNameStr + day;
                    } else if ("4".equals(valuetype)) {
                        reportNameStr = reportNameStr + month + day;
                    } else if ("5".equals(valuetype)) {
                        reportNameStr = reportNameStr + year + month + day;
                    }
                    reportNameStr = DisclosureReportNameHelper.addBreakCombo(reportNameStr, reportNameDy);
                    continue;
                }
                if ("tna".equals(fieldType)) {
                    reportNameStr = reportNameStr + template.getString(FIELD_NAME);
                    reportNameStr = DisclosureReportNameHelper.addBreakCombo(reportNameStr, reportNameDy);
                    continue;
                }
                if (!"tnm".equals(fieldType)) continue;
                reportNameStr = reportNameStr + template.getString("number");
                reportNameStr = DisclosureReportNameHelper.addBreakCombo(reportNameStr, reportNameDy);
            }
            reportName = !StringUtils.isEmpty((String)reportNameStr) ? reportNameStr : entityMember.getName() + "_" + String.valueOf(GlobalIdUtil.genGlobalLongId());
            DisclosureReportNameHelper.checkReportName(dmModelId, templateId, mutilF7DimsionInfos, reportName);
            ReportNameResult reportNameResult = new ReportNameResult();
            reportNameResult.setName(reportName);
            reportNameResult.setDesq(reportDsq);
            reportNameResult.setEntityMember(entityMember);
            reportNameResults.add(reportNameResult);
        }
        return reportNameResults;
    }

    private static int getMaxDesq(Long dmModelId, Long templateId, List<MutilF7DimsionInfo> mutilF7DimsionInfos) {
        QFBuilder qfBuilder = DisclosureReportNameHelper.getReportFilter(dmModelId, templateId, mutilF7DimsionInfos);
        String selectField = "name,desq";
        DynamicObjectCollection reportList = QueryServiceHelper.query((String)"fidm_report", (String)selectField, (QFilter[])qfBuilder.toArray());
        int dsq = 0;
        for (DynamicObject report : reportList) {
            if (report.getInt("desq") < dsq) continue;
            dsq = report.getInt("desq");
        }
        return dsq + 1;
    }

    private static String addBreakCombo(String result, DynamicObject reportName) {
        String breakcombo;
        switch (breakcombo = reportName.getString("breakcombo")) {
            case "1": {
                result = result + "-";
                break;
            }
            case "2": {
                result = result + ".";
                break;
            }
            case "3": {
                result = result + " ";
                break;
            }
            case "4": {
                break;
            }
        }
        return result;
    }

    public static ResultInfo checkReportName(long modelId, DynamicObject report, String newName, String modelType) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(10);
        qFilters.add(new QFilter(FIELD_MODEL, "=", (Object)modelId));
        qFilters.add(new QFilter("template.id", "=", (Object)report.getLong("template.id")));
        qFilters.add(new QFilter(FIELD_ISPREVIEW, "=", (Object)"0"));
        qFilters.add(new QFilter("id", "!=", (Object)report.getLong("id")));
        qFilters.add(new QFilter(FIELD_NAME, "=", (Object)newName));
        if (DisModelTypeEnum.CM.getType().equals(modelType) || DisModelTypeEnum.RPT.getType().equals(modelType)) {
            qFilters.add(new QFilter(FIELD_BCMENTITY, "=", (Object)report.getLong("bcmentity_id")));
            qFilters.add(new QFilter(FIELD_YEAR, "=", (Object)report.getLong("year_id")));
            qFilters.add(new QFilter(FIELD_PERIOD, "=", (Object)report.getLong("period_id")));
            qFilters.add(new QFilter(FIELD_SCENARIO, "=", (Object)report.getLong("scenario_id")));
        } else if (DisModelTypeEnum.EB.getType().equals(modelType)) {
            qFilters.add(new QFilter(FIELD_EPMENTITY, "=", (Object)report.getLong("epmentity_id")));
            qFilters.add(new QFilter(FIELD_BUDGETPERIOD, "=", (Object)report.getLong("budgetperiod_id")));
            qFilters.add(new QFilter(FIELD_VERSION, "=", (Object)report.getLong("version_id")));
            qFilters.add(new QFilter(FIELD_DATATYPE, "=", (Object)report.getLong("datatype_id")));
        }
        return DisclosureReportNameHelper.checkReportName(newName, qFilters);
    }

    public static ResultInfo checkReportName(String name, List<QFilter> qFilters) {
        if (StringUtils.isEmpty((String)name)) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u62a5\u544a\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReportServiceHelper_11", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (name.length() > 100) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u62a5\u544a\u540d\u79f0\u957f\u5ea6\u8d85\u8fc7\u9650\u5236\uff0c\u6700\u5927\u957f\u5ea6\u4e3a100\u3002", (String)"ReportServiceHelper_12", (String)"epm-far-business", (Object[])new Object[0]));
        }
        qFilters.add(new QFilter(FIELD_NAME, "=", (Object)name));
        boolean exists = QueryServiceHelper.exists((String)"fidm_report", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (exists) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u62a5\u544a\u540d\u79f0\u5df2\u5b58\u5728\u3002", (String)"ReportServiceHelper_13", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return ResultInfo.success();
    }
}

