/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.report;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.ChapterCommitStatusEnum;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.util.ResultInfo;
import kd.epm.far.business.fidm.base.DisclosureLogHelper;
import kd.epm.far.business.fidm.chapter.DisclosureChapterHelper;
import kd.epm.far.business.fidm.perm.PermClassBaseHelper;
import kd.epm.far.business.fidm.perm.PermClassReportHelper;
import kd.epm.far.business.fidm.report.DisclosureReportHelper;
import kd.epm.far.common.common.enums.Permission.DataTypeEnum;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.LongUtil;
import org.apache.commons.collections4.CollectionUtils;

public class ReportChapterHelper {
    private static final String PERMCLASS = "permclass";
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(ReportChapterHelper.class);

    public static Map<String, String> getReport(Long reportId) {
        if (!LongUtil.isvalidLong((Object)reportId)) {
            return null;
        }
        DynamicObject reportDy = DisclosureReportHelper.getReport(reportId);
        if (reportDy == null) {
            return null;
        }
        LinkedHashMap<String, String> report = new LinkedHashMap<String, String>(20);
        report.put("id", reportDy.getString("id"));
        report.put("name", reportDy.getString("name"));
        return report;
    }

    public static List<Map<String, Object>> getChapterInfoByReport(Long reportId) {
        if (!LongUtil.isvalidLong((Object)reportId)) {
            return new ArrayList<Map<String, Object>>(100);
        }
        DynamicObject rpt = BusinessDataServiceHelper.loadSingle((Object)reportId, (String)"fidm_report");
        DynamicObjectCollection entryentitys = rpt.getDynamicObjectCollection("entryentity");
        List<Long> chapterIds = entryentitys.stream().map(x -> x.getLong("chapter.id")).collect(Collectors.toList());
        List<Map<String, Object>> chapters = ReportChapterHelper.getChapterInfo(chapterIds);
        for (Map<String, Object> chapter : chapters) {
            boolean isCheck = false;
            DynamicObject entry = entryentitys.stream().filter(x -> Objects.equals(x.getString("chapter.id"), chapter.get("id").toString())).findFirst().orElse(null);
            if (entry != null) {
                isCheck = entry.getBoolean("ischeck");
            }
            chapter.put("ischeck", isCheck);
        }
        return chapters;
    }

    public static List<Map<String, Object>> getChapterInfoByReportAndPerm(Long dmModelId, Long reportId) {
        Map<Long, String> chapterPermMap = PermClassReportHelper.getChapterPermMapByReport(dmModelId, reportId);
        return ReportChapterHelper.getChapterInfoByReportAndPerm(reportId, chapterPermMap);
    }

    public static List<Map<String, Object>> getChapterInfoByReportAndPerm(Long reportId, Map<Long, String> chapterPermMap) {
        List<Map<String, Object>> chapters = ReportChapterHelper.getChapterInfoByReport(reportId);
        if (chapterPermMap != null) {
            ArrayList<Map<String, Object>> newChapters = new ArrayList<Map<String, Object>>(chapters.size());
            for (Map<String, Object> chapterItem : chapters) {
                String perm = chapterPermMap.get(LongUtil.toLong((Object)chapterItem.get("id")));
                if (StringUtils.isEmpty((String)perm)) {
                    perm = DataTypeEnum.WRITEIN.getIndex();
                }
                if (PermClassBaseHelper.isNoPerm(perm)) continue;
                chapterItem.put("perm", perm);
                newChapters.add(chapterItem);
            }
            chapters = newChapters;
        } else {
            for (Map<String, Object> chapterItem : chapters) {
                chapterItem.put("perm", DataTypeEnum.WRITEIN.getIndex());
            }
        }
        return chapters;
    }

    public static Map<String, Object> getChapterInfo(Long reportId, Long chapterId) {
        if (!LongUtil.isvalidLong((Object)reportId)) {
            return null;
        }
        DynamicObject rpt = BusinessDataServiceHelper.loadSingle((Object)reportId, (String)"fidm_report");
        DynamicObjectCollection entryentitys = rpt.getDynamicObjectCollection("entryentity");
        List<Map<String, Object>> chapters = ReportChapterHelper.getChapterInfo(Collections.singletonList(chapterId));
        if (chapters.size() == 0) {
            return null;
        }
        Map<String, Object> chapter = chapters.get(0);
        boolean isCheck = false;
        DynamicObject entry = entryentitys.stream().filter(x -> Objects.equals(x.getString("chapter.id"), chapter.get("id").toString())).findFirst().orElse(null);
        if (entry != null) {
            isCheck = entry.getBoolean("ischeck");
        }
        chapter.put("ischeck", isCheck);
        return chapter;
    }

    public static List<Map<String, Object>> getChapterInfo(List<Long> chapterIds) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(100);
        if (chapterIds == null) {
            return list;
        }
        String selectedFiled = "id,number,name,permclass.id,permclass.number,commitstatus,description,modifytime,modifier.name,sendbacktime,sendbacker.name,committime,commitor.name,sequence";
        DynamicObjectCollection chapters = QueryServiceHelper.query((String)"fidm_chapter", (String)selectedFiled, (QFilter[])new QFilter("id", "in", chapterIds).toArray(), (String)"sequence");
        for (DynamicObject chapterDy : chapters) {
            LinkedHashMap<String, String> chapter = new LinkedHashMap<String, String>(20);
            chapter.put("id", chapterDy.getString("id"));
            chapter.put("number", chapterDy.getString("number"));
            chapter.put("name", chapterDy.getString("name"));
            chapter.put("permClassId", chapterDy.getString("permclass.id"));
            chapter.put("permClassName", chapterDy.getString("permclass.number"));
            chapter.put("commitStatus", chapterDy.getString("commitstatus"));
            chapter.put("commitStatusName", ChapterCommitStatusEnum.getNameByType(chapterDy.getString("commitstatus")));
            chapter.put("description", chapterDy.getString("description"));
            chapter.put("modifyTime", chapterDy.getString("modifytime"));
            chapter.put("modifier", chapterDy.getString("modifier.name"));
            chapter.put("sendbackTime", chapterDy.getString("sendbacktime"));
            chapter.put("sendbacker", chapterDy.getString("sendbacker.name"));
            chapter.put("commitTime", chapterDy.getString("committime"));
            chapter.put("commitor", chapterDy.getString("commitor.name"));
            chapter.put("sequence", chapterDy.getString("sequence"));
            list.add(chapter);
        }
        return list;
    }

    public static void checkTemplateChapters(Long templateId) {
        DynamicObject template = QueryServiceHelper.queryOne((String)"fidm_template", (String)"id,name", (QFilter[])new QFilter("id", "=", (Object)templateId).toArray());
        String templateName = template.getString("name");
        DynamicObjectCollection oldChapters = QueryServiceHelper.query((String)"fidm_chapter", (String)"id,permclass", (QFilter[])new QFilter("template", "=", (Object)templateId).and(new QFilter("enable", "=", (Object)"1")).toArray());
        if (oldChapters.size() == 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u62a5\u544a\u6a21\u677f[%1$s]\u6ca1\u6709\u5b58\u5728\u6709\u6548\u7ae0\u8282\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ReportListPlugin_26", (String)"epm-far-business", (Object[])new Object[0]), templateName));
        }
    }

    public static void delChapterModule(Long reportId) {
        DynamicObject report = BusinessDataServiceHelper.loadSingle((Object)reportId, (String)"fidm_report");
        DynamicObjectCollection reportChapterList = report.getDynamicObjectCollection("entryentity");
        if (reportChapterList.isEmpty()) {
            return;
        }
        ArrayList<Long> chapterIds = new ArrayList<Long>();
        for (DynamicObject dyn : reportChapterList) {
            Long chapterId = dyn.getLong("chapter.id");
            DynamicObject chapter = BusinessDataServiceHelper.loadSingle((Object)chapterId, (String)"fidm_chapter");
            if (Objects.isNull(chapter)) continue;
            chapterIds.add(chapterId);
            DynamicObjectCollection chapterModuleList = chapter.getDynamicObjectCollection("entryentity");
            List moduleIds = chapterModuleList.stream().map(v -> v.getLong("module.id")).collect(Collectors.toList());
            if (!CollectionUtils.isNotEmpty(moduleIds)) continue;
            DeleteServiceHelper.delete((String)"fidm_modulerepository", (QFilter[])new QFilter("id", "in", moduleIds).toArray());
        }
        if (CollectionUtils.isNotEmpty(chapterIds)) {
            DeleteServiceHelper.delete((String)"fidm_chapter", (QFilter[])new QFilter("id", "in", chapterIds).toArray());
        }
    }

    public static void openReportChapterEditView(IFormView view, IFormPlugin plugin, Long reportId, Long chapterId) {
        if (Objects.isNull(chapterId)) {
            return;
        }
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId("fidm_chapter");
        formShowParameter.setPkId((Object)chapterId);
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setBillStatus(BillOperationStatus.EDIT);
        formShowParameter.setParentPageId(view.getPageId());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("reportId", (Object)reportId.toString());
        formShowParameter.setCloseCallBack(new CloseCallBack(plugin, "REPORTCHAPTER_BASEINFO_CLOSED"));
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u7ae0\u8282\u4fe1\u606f", (String)"DesignChapterHelper_13", (String)"epm-far-business", (Object[])new Object[0]));
        view.showForm((FormShowParameter)formShowParameter);
    }

    public static void batchSavePermClass(List<DynamicObject> newChapterDynList) {
        ArrayList<DynamicObject> entityList = new ArrayList<DynamicObject>(newChapterDynList.size());
        for (DynamicObject newChapterDyn : newChapterDynList) {
            if (newChapterDyn.get(PERMCLASS) == null) continue;
            DynamicObject entity = BusinessDataServiceHelper.newDynamicObject((String)"bcm_permclass_entity");
            entity.set("entityname", (Object)newChapterDyn.getDataEntityType().getName());
            entity.set("fidmmodel", (Object)newChapterDyn.getLong("model.id"));
            entity.set("entityid", (Object)newChapterDyn.getLong("id"));
            entity.set(PERMCLASS, newChapterDyn.get(PERMCLASS));
            entityList.add(entity);
        }
        if (entityList.size() != 0) {
            SaveServiceHelper.save((DynamicObject[])entityList.toArray(new DynamicObject[0]));
        }
    }

    public static ResultInfo setFinalize(Long reportId, Long chapterId) {
        DynamicObjectCollection entryentitys;
        List dynamicObjects;
        DynamicObject report = DisclosureReportHelper.getReport(reportId);
        DynamicObject chapter = DisclosureChapterHelper.getChapter(chapterId);
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(report.getLong("model.id"));
        ModelInfo modelInfo = modelStrategyEx.getModel().getModelInfo();
        DynamicObject rpt = BusinessDataServiceHelper.loadSingle((Object)reportId, (String)"fidm_report");
        if (rpt != null && !(dynamicObjects = (entryentitys = rpt.getDynamicObjectCollection("entryentity")).stream().filter(v -> v.getLong("chapter.id") == chapterId.longValue()).collect(Collectors.toList())).isEmpty()) {
            if (((DynamicObject)dynamicObjects.get(0)).getBoolean("ischeck")) {
                return ResultInfo.fail(ResManager.loadKDString((String)"\u8be5\u7ae0\u8282\u5df2\u5b9a\u7a3f\uff0c\u4e0d\u80fd\u518d\u6b21\u6267\u884c\u7f6e\u4e3a\u5b9a\u7a3f\u64cd\u4f5c\u3002", (String)"DesignChapterHelper_20", (String)"epm-far-business", (Object[])new Object[0]));
            }
            ((DynamicObject)dynamicObjects.get(0)).set("ischeck", (Object)"1");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{rpt});
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{rpt});
                DisclosureLogHelper.writeReportChapter(OperationResult.SUCCESS, OperationName.COMMIT, modelInfo, report, chapter);
            }
            catch (Exception ex) {
                DisclosureLogHelper.writeReportChapter(OperationResult.FAILURE, OperationName.COMMIT, modelInfo, report, chapter);
                throw ex;
            }
        }
        return ResultInfo.success();
    }

    public static ResultInfo setDraft(Long reportId, Long chapterId) {
        DynamicObjectCollection entryentitys;
        List dynamicObjects;
        DynamicObject report = DisclosureReportHelper.getReport(reportId);
        DynamicObject chapter = DisclosureChapterHelper.getChapter(chapterId);
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(report.getLong("model.id"));
        ModelInfo modelInfo = modelStrategyEx.getModel().getModelInfo();
        DynamicObject rpt = BusinessDataServiceHelper.loadSingle((Object)reportId, (String)"fidm_report");
        if (rpt != null && !(dynamicObjects = (entryentitys = rpt.getDynamicObjectCollection("entryentity")).stream().filter(v -> v.getLong("chapter.id") == chapterId.longValue()).collect(Collectors.toList())).isEmpty()) {
            if (!((DynamicObject)dynamicObjects.get(0)).getBoolean("ischeck")) {
                return ResultInfo.fail(ResManager.loadKDString((String)"\u8be5\u7ae0\u8282\u5df2\u662f\u8349\u7a3f\uff0c\u4e0d\u80fd\u518d\u6b21\u6267\u884c\u7f6e\u4e3a\u8349\u7a3f\u64cd\u4f5c\u3002", (String)"DesignChapterHelper_21", (String)"epm-far-business", (Object[])new Object[0]));
            }
            ((DynamicObject)dynamicObjects.get(0)).set("ischeck", (Object)"0");
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{rpt});
                DisclosureLogHelper.writeReportChapter(OperationResult.SUCCESS, OperationName.BACKED, modelInfo, report, chapter);
            }
            catch (Exception ex) {
                DisclosureLogHelper.writeReportChapter(OperationResult.FAILURE, OperationName.BACKED, modelInfo, report, chapter);
                throw ex;
            }
        }
        return ResultInfo.success();
    }
}

