/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.report;

import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.util.Assert;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.MyReportStatusEnum;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.fidm.base.DisclosureFormHelper;
import kd.epm.far.business.fidm.base.DisclosureLogHelper;
import kd.epm.far.business.fidm.report.dto.ReportFlowFormInput;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;

public class ReportFlowStatusHelper {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(ReportFlowStatusHelper.class);
    public static final String OP_COMMIT = "A";
    public static final String OP_UNCOMMIT = "B";
    public static final String OP_AUDIT = "C";
    public static final String OP_UNAUDIT = "D";
    public static final String OP_ARCHIVE = "E";
    public static final String OP_UNARCHIVE = "F";
    public static final String OP_INIT = "G";

    public static void updateFlowStatus(Long reportId, String opType, String remark) {
        Assert.noNullElements((Object[])new Object[]{reportId, opType});
        if (!QueryServiceHelper.exists((String)"fidm_report", (Object)reportId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"ReportListPlugin_1", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (StringUtils.isNotEmpty((String)remark) && remark.length() > 200) {
            throw new KDBizException(ResManager.loadKDString((String)"\u64cd\u4f5c\u5907\u6ce8\u7684\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7200\u3002", (String)"ReportFlowStatusHelper_7", (String)"epm-far-business", (Object[])new Object[0]));
        }
        DynamicObject report = BusinessDataServiceHelper.loadSingle((Object)reportId, (String)"fidm_report");
        String isarchived = report.getString("isarchived");
        String oldStatus = report.getString("status");
        String name = report.getString("name");
        Date now = new Date();
        long userId = Long.parseLong(RequestContext.get().getUserId());
        StringBuilder errMsg = new StringBuilder(16);
        switch (opType) {
            case "E": {
                if (MyReportStatusEnum.AUDITED.getValue().equals(oldStatus) && MyReportStatusEnum.UNARCHIVE.getValue().equals(isarchived)) {
                    report.set("isarchived", (Object)MyReportStatusEnum.ARCHIVED.getValue());
                    report.set("archiver", (Object)userId);
                    report.set("archivetime", (Object)now);
                    break;
                }
                errMsg.append(String.format(ResManager.loadKDString((String)"\u62a5\u544a\u201c%s\u201d \u5f52\u6863\u5931\u8d25\uff0c\u5f52\u6863\u53ea\u80fd\u64cd\u4f5c\u5df2\u5ba1\u6838\u72b6\u6001\u4e14\u672a\u5f52\u6863\u7684\u62a5\u544a\u3002", (String)"ReportFlowStatusHelper_1", (String)"epm-far-business", (Object[])new Object[0]), name));
                break;
            }
            case "F": {
                if (MyReportStatusEnum.AUDITED.getValue().equals(oldStatus) && MyReportStatusEnum.ARCHIVED.getValue().equals(isarchived)) {
                    report.set("isarchived", (Object)MyReportStatusEnum.UNARCHIVE.getValue());
                    report.set("cancelarchiver", (Object)userId);
                    report.set("cancelarchivetime", (Object)now);
                    break;
                }
                errMsg.append(String.format(ResManager.loadKDString((String)"\u62a5\u544a\u201c%s\u201d \u53cd\u5f52\u6863\u5931\u8d25\uff0c\u53cd\u5f52\u6863\u53ea\u80fd\u64cd\u4f5c\u5df2\u5f52\u6863\u7684\u62a5\u544a\u3002", (String)"ReportFlowStatusHelper_2", (String)"epm-far-business", (Object[])new Object[0]), name));
                break;
            }
            case "A": {
                if ((MyReportStatusEnum.UNCOMMIT.getValue().equals(oldStatus) || MyReportStatusEnum.BACKED.getValue().equals(oldStatus)) && MyReportStatusEnum.UNARCHIVE.getValue().equals(isarchived)) {
                    report.set("status", (Object)MyReportStatusEnum.COMMITED.getValue());
                    report.set("submitter", (Object)userId);
                    report.set("submittime", (Object)now);
                    break;
                }
                errMsg.append(String.format(ResManager.loadKDString((String)"\u62a5\u544a\u201c%s\u201d \u63d0\u4ea4\u5931\u8d25\uff0c\u63d0\u4ea4\u53ea\u80fd\u64cd\u4f5c\u672a\u63d0\u4ea4\u72b6\u6001\u7684\u62a5\u544a\u3002", (String)"ReportFlowStatusHelper_3", (String)"epm-far-business", (Object[])new Object[0]), name));
                break;
            }
            case "B": {
                if (MyReportStatusEnum.COMMITED.getValue().equals(oldStatus) && MyReportStatusEnum.UNARCHIVE.getValue().equals(isarchived)) {
                    report.set("status", (Object)MyReportStatusEnum.BACKED.getValue());
                    report.set("callbacker", (Object)userId);
                    report.set("callbacktime", (Object)now);
                    break;
                }
                errMsg.append(String.format(ResManager.loadKDString((String)"\u62a5\u544a\u201c%s\u201d \u6253\u56de\u5931\u8d25\uff0c\u6253\u56de\u53ea\u80fd\u64cd\u4f5c\u5df2\u63d0\u4ea4\u72b6\u6001\u7684\u62a5\u544a\u3002", (String)"ReportFlowStatusHelper_4", (String)"epm-far-business", (Object[])new Object[0]), name));
                break;
            }
            case "C": {
                if (MyReportStatusEnum.COMMITED.getValue().equals(oldStatus) && MyReportStatusEnum.UNARCHIVE.getValue().equals(isarchived)) {
                    report.set("status", (Object)MyReportStatusEnum.AUDITED.getValue());
                    report.set("reviewer", (Object)userId);
                    report.set("reviewtime", (Object)now);
                    break;
                }
                errMsg.append(String.format(ResManager.loadKDString((String)"\u62a5\u544a\u201c%s\u201d\u5ba1\u6838\u5931\u8d25\uff0c\u5ba1\u6838\u53ea\u80fd\u64cd\u4f5c\u5df2\u63d0\u4ea4\u72b6\u6001\u7684\u62a5\u544a\u3002", (String)"ReportFlowStatusHelper_5", (String)"epm-far-business", (Object[])new Object[0]), name));
                break;
            }
            case "D": {
                if (MyReportStatusEnum.AUDITED.getValue().equals(oldStatus) && MyReportStatusEnum.UNARCHIVE.getValue().equals(isarchived)) {
                    report.set("status", (Object)MyReportStatusEnum.COMMITED.getValue());
                    report.set("cancelreviewer", (Object)userId);
                    report.set("cancelreviewertime", (Object)now);
                    break;
                }
                errMsg.append(String.format(ResManager.loadKDString((String)"\u62a5\u544a\u201c%s\u201d \u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u53cd\u5ba1\u6838\u53ea\u80fd\u64cd\u4f5c\u5df2\u5ba1\u6838\u72b6\u6001\u4e14\u672a\u5f52\u6863\u7684\u62a5\u544a\u3002", (String)"ReportFlowStatusHelper_6", (String)"epm-far-business", (Object[])new Object[0]), name));
                break;
            }
        }
        if (errMsg.length() > 0) {
            throw new KDBizException(errMsg.toString());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{report});
        ReportFlowStatusHelper.saveStatusChangeLog(opType, oldStatus, isarchived, report, remark);
    }

    private static void saveStatusChangeLog(String opType, String oldStatus, String oldArchivedStatus, DynamicObject newReport, String remark) {
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(newReport.getLong("model.id"));
        ModelInfo modelInfo = modelStrategyEx.getModel().getModelInfo();
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"fidm_fieldchangelog");
        log.set("entitykey", (Object)newReport.getLong("id"));
        log.set("model", newReport.get("model"));
        log.set("dealuser", (Object)Long.parseLong(RequestContext.get().getUserId()));
        log.set("operation", (Object)opType);
        log.set("dealtime", (Object)new Date());
        if (!StringUtils.isEmpty((String)remark)) {
            log.set("remark", (Object)remark);
        }
        String field = "status";
        if (OP_ARCHIVE.equals(opType) || OP_UNARCHIVE.equals(opType)) {
            field = "isarchived";
            log.set("oldvalue", (Object)(StringUtils.isEmpty((String)oldArchivedStatus) ? "" : MyReportStatusEnum.getStatusEnumByValue(oldArchivedStatus)));
        } else {
            log.set("oldvalue", (Object)(StringUtils.isEmpty((String)oldStatus) ? "" : MyReportStatusEnum.getStatusEnumByValue(oldStatus)));
        }
        log.set("newvalue", (Object)MyReportStatusEnum.getStatusEnumByValue(newReport.getString(field)));
        log.set("dealfieldkey", (Object)field);
        log.set("dealfieldname", (Object)newReport.getDynamicObjectType().getProperty(field).getDisplayName().getLocaleValue());
        OperationName operationName = ReportFlowStatusHelper.getOperationName(opType);
        try {
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
            DisclosureLogHelper.writeReportOper(OperationResult.SUCCESS, modelInfo, newReport, operationName);
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            DisclosureLogHelper.writeReportOper(OperationResult.FAILURE, modelInfo, newReport, operationName);
            throw ex;
        }
        if (OP_INIT.equals(opType)) {
            DynamicObject dynamicObject = (DynamicObject)OrmUtils.clone((IDataEntityBase)log, (boolean)false, (boolean)true);
            field = "isarchived";
            dynamicObject.set("oldvalue", (Object)(StringUtils.isEmpty((String)oldArchivedStatus) ? "" : MyReportStatusEnum.getStatusEnumByValue(oldArchivedStatus)));
            dynamicObject.set("newvalue", (Object)MyReportStatusEnum.getStatusEnumByValue(newReport.getString(field)));
            dynamicObject.set("dealfieldkey", (Object)field);
            dynamicObject.set("dealfieldname", (Object)newReport.getDynamicObjectType().getProperty(field).getDisplayName().getLocaleValue());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
    }

    public static void comfirmForm(IFormView view, IFormPlugin plugin, List<Long> reportIds, String opKey) {
        String msg = "";
        if (reportIds == null || reportIds.size() <= 0) {
            msg = ResManager.loadKDString((String)"\u6211\u7684\u62a5\u544a\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReportFlowStatusHelper_8", (String)"epm-far-business", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
        String operType = "";
        if ("btn_submit".equals(opKey)) {
            operType = OP_COMMIT;
        } else if ("btn_back".equals(opKey)) {
            operType = OP_UNCOMMIT;
        } else if ("btn_audit".equals(opKey)) {
            operType = OP_AUDIT;
        } else if ("btn_unaudit".equals(opKey)) {
            operType = OP_UNAUDIT;
        } else if ("btn_archiver".equals(opKey)) {
            operType = OP_ARCHIVE;
        } else if ("btn_cancelarchiver".equals(opKey)) {
            operType = OP_UNARCHIVE;
        }
        if (StringUtils.isEmpty((String)operType)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u672a\u77e5\u6d41\u7a0b\u64cd\u4f5c\u3002", (String)"ReportFlowStatusHelper_9", (String)"epm-far-business", (Object[])new Object[0]));
            return;
        }
        ReportFlowFormInput formParam = new ReportFlowFormInput();
        formParam.setReports(reportIds);
        formParam.setOperType(operType);
        String formId = "fidm_flowcommitpage";
        FormShowParameter formShowParameter = DisclosureFormHelper.createFormParam(formParam);
        formShowParameter.setFormId(formId);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u786e\u8ba4", (String)"ReportFlowStatusHelper_10", (String)"epm-far-business", (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack(plugin, formId);
        formShowParameter.setCloseCallBack(closeCallBack);
        view.showForm(formShowParameter);
    }

    public static String getOperMsg(String operType) {
        String msg = ResManager.loadKDString((String)"\u672a\u77e5", (String)"ReportFlowStatusHelper_11", (String)"epm-far-business", (Object[])new Object[0]);
        if (OP_COMMIT.equalsIgnoreCase(operType)) {
            msg = ResManager.loadKDString((String)"\u63d0\u4ea4", (String)"ReportFlowStatusHelper_12", (String)"epm-far-business", (Object[])new Object[0]);
        } else if (OP_UNCOMMIT.equalsIgnoreCase(operType)) {
            msg = ResManager.loadKDString((String)"\u6253\u56de", (String)"ReportFlowStatusHelper_13", (String)"epm-far-business", (Object[])new Object[0]);
        } else if (OP_AUDIT.equalsIgnoreCase(operType)) {
            msg = ResManager.loadKDString((String)"\u5ba1\u6838", (String)"ReportFlowStatusHelper_14", (String)"epm-far-business", (Object[])new Object[0]);
        } else if (OP_UNAUDIT.equalsIgnoreCase(operType)) {
            msg = ResManager.loadKDString((String)"\u53cd\u5ba1\u6838", (String)"ReportFlowStatusHelper_15", (String)"epm-far-business", (Object[])new Object[0]);
        } else if (OP_ARCHIVE.equalsIgnoreCase(operType)) {
            msg = ResManager.loadKDString((String)"\u5f52\u6863", (String)"ReportFlowStatusHelper_16", (String)"epm-far-business", (Object[])new Object[0]);
        } else if (OP_UNARCHIVE.equalsIgnoreCase(operType)) {
            msg = ResManager.loadKDString((String)"\u53cd\u5f52\u6863", (String)"ReportFlowStatusHelper_17", (String)"epm-far-business", (Object[])new Object[0]);
        }
        return msg;
    }

    public static OperationName getOperationName(String operType) {
        OperationName operationName = OperationName.UNKNOWN;
        if (OP_COMMIT.equalsIgnoreCase(operType)) {
            operationName = OperationName.COMMIT_REPORT;
        } else if (OP_UNCOMMIT.equalsIgnoreCase(operType)) {
            operationName = OperationName.BACKED_REPORT;
        } else if (OP_AUDIT.equalsIgnoreCase(operType)) {
            operationName = OperationName.AUDIT;
        } else if (OP_UNAUDIT.equalsIgnoreCase(operType)) {
            operationName = OperationName.UNAUDIT;
        } else if (OP_ARCHIVE.equalsIgnoreCase(operType)) {
            operationName = OperationName.ARCHIVE;
        } else if (OP_UNARCHIVE.equalsIgnoreCase(operType)) {
            operationName = OperationName.UNARCHIVE;
        }
        return operationName;
    }
}

