/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.report;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.far.business.common.thread.ThreadPoolService;
import kd.epm.far.business.fidm.html.dto.HtmlPreviewNode;
import kd.epm.far.business.fidm.module.calculate.ModuleDataGeneralHelper;
import kd.epm.far.business.fidm.report.dto.ModuleResetInput;
import kd.epm.far.business.fidm.report.dto.ModuleResetResult;
import kd.epm.far.business.fidm.task.dto.TaskMessage;
import kd.epm.far.business.fidm.web.WebModuleResetHelper;
import kd.epm.far.business.fidm.wpsplugin.WpsModuleResetHelper;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;

public class ReportModuleResetService {
    protected static final WatchLogger logger = BcmLogFactory.getWatchLogInstance(ReportModuleResetService.class);

    public static List<JSONObject> getValidItems(JSONObject jsonObject, boolean resetAll) {
        String tips = "";
        JSONArray oldItemArray = jsonObject.getJSONArray("itemList");
        if (oldItemArray == null) {
            return new ArrayList<JSONObject>(10);
        }
        List<JSONObject> itemList = new ArrayList<JSONObject>(oldItemArray.size());
        for (Object item : oldItemArray) {
            if (!(item instanceof JSONObject)) continue;
            itemList.add((JSONObject)item);
        }
        if (!resetAll && (itemList = ModuleDataGeneralHelper.filerErrorModules(itemList)).size() == 0) {
            tips = ResManager.loadKDString((String)"\u6587\u6863\u5185\u5bb9\u6ca1\u6709\u6267\u884c\u5931\u8d25\u6216\u672a\u6267\u884c\u8ba1\u7b97\u7684\u7ec4\u4ef6\uff0c\u4e0d\u80fd\u505a\u7ec4\u4ef6\u6570\u636e\u8ba1\u7b97\u64cd\u4f5c\u3002", (String)"AbstractReportPlugin_25", (String)"epm-far-business", (Object[])new Object[0]);
            throw new KDBizException(tips);
        }
        return itemList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModuleResetResult calc(ModuleResetInput moduleResetInput, Consumer<TaskMessage> taskConsumer, Double allModuleTaskIns) {
        ArrayList<JSONObject> newItemList = new ArrayList<JSONObject>(moduleResetInput.getModuleList().size());
        long start = System.currentTimeMillis();
        if (moduleResetInput.getModuleList().size() > 0) {
            Double moduleTaskIns = allModuleTaskIns / (double)moduleResetInput.getModuleList().size();
            CountDownLatch latch = new CountDownLatch(moduleResetInput.getModuleList().size());
            for (JSONObject module : moduleResetInput.getModuleList()) {
                ThreadPoolService.runInModuleCalculateThread(() -> {
                    try {
                        JSONObject moduleResult = ModuleDataGeneralHelper.getData(moduleResetInput.getDmModelId(), moduleResetInput.getChapterId(), moduleResetInput.getDimensionInfos(), moduleResetInput.getModifyName(), module);
                        newItemList.add(moduleResult);
                        if (taskConsumer != null) {
                            taskConsumer.accept(new TaskMessage(moduleTaskIns, ""));
                        }
                        latch.countDown();
                    }
                    catch (Exception e) {
                        latch.countDown();
                        logger.error("DM ModuleReset ThreadPoolService.runInModuleCalculateThread error", (Throwable)e);
                    }
                });
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                logger.error("DM ModuleReset ThreadPoolService.runInModuleCalculateThread Interrupted", (Throwable)e);
            }
        } else if (taskConsumer != null) {
            taskConsumer.accept(new TaskMessage(allModuleTaskIns, ""));
        }
        logger.info(String.format("%s--fidm--ModuleReset--spentime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
        ModuleResetResult result = new ModuleResetResult();
        result.setInput(moduleResetInput);
        result.setModuleList(newItemList);
        if (moduleResetInput.isResetWord()) {
            String url = WpsModuleResetHelper.replaceData(result);
            result.setNewTempWordUrl(url);
        } else {
            HtmlPreviewNode previewNode = WebModuleResetHelper.replaceData(result);
            result.setPreviewJson(previewNode);
        }
        return result;
    }
}

