/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.task;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.thread.ThreadPoolService;
import kd.epm.far.business.fidm.report.DisclosureGenerateService;
import kd.epm.far.business.fidm.report.dto.GenerateInput;
import kd.epm.far.business.fidm.report.dto.GenerateInputFormular;
import kd.epm.far.business.fidm.report.dto.GenerateResult;
import kd.epm.far.business.fidm.task.base.AbstractTaskEx;
import kd.epm.far.business.fidm.task.dto.GenerateTaskInput;
import kd.epm.far.business.fidm.task.dto.GenerateTaskResult;
import kd.epm.far.business.fidm.task.dto.TaskMessage;
import kd.epm.far.common.common.Recorder;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;

public class DisclosureGenerateTask
extends AbstractTaskEx {
    protected static final WatchLogger logger = BcmLogFactory.getWatchLogInstance((boolean)true, DisclosureGenerateTask.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        Recorder serviceRecord = new Recorder(null);
        String message = ResManager.loadKDString((String)"\u5df2\u7ecf\u8fdb\u5165\u4efb\u52a1\u6267\u884c\u73af\u8282\uff0c\u5f00\u59cb\u6267\u884c\u4efb\u52a1", (String)"DisclosureGenerateTask_0", (String)"epm-far-business", (Object[])new Object[0]);
        this.feedbackProgress(0, message, null);
        GenerateTaskInput generateTaskInput = null;
        ArrayList<GenerateResult> reportResults = new ArrayList<GenerateResult>(100);
        long startTime = System.currentTimeMillis();
        try {
            if (this.isStop()) {
                this.nowStop("");
                this.endTask(generateTaskInput, "");
                return;
            }
            if (params.get("input") == null || StringUtils.isEmpty((String)params.get("input").toString())) {
                message = ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u8f93\u5165\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"DisclosureGenerateTask_1", (String)"epm-far-business", (Object[])new Object[0]);
                this.nowStop(message);
                this.endTask(generateTaskInput, message);
                return;
            }
            generateTaskInput = (GenerateTaskInput)JSON.parseObject((String)params.get("input").toString(), GenerateTaskInput.class);
            if (generateTaskInput == null || generateTaskInput.getGenetateFormResult() == null) {
                message = ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u8f93\u5165\u53c2\u6570\u5f02\u5e38\u3002", (String)"DisclosureGenerateTask_2", (String)"epm-far-business", (Object[])new Object[0]);
                this.nowStop(message);
                this.endTask(generateTaskInput, message);
                return;
            }
            this.setRequestContext(generateTaskInput);
            List<GenerateInput> inputList = generateTaskInput.getGenetateFormResult().getInputList();
            if (inputList == null || inputList.size() == 0) {
                message = ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u8f93\u5165\u53c2\u6570\u5f02\u5e38\u3002", (String)"DisclosureGenerateTask_2", (String)"epm-far-business", (Object[])new Object[0]);
                this.nowStop(message);
                this.endTask(generateTaskInput, message);
                return;
            }
            serviceRecord.setRecord((Object)generateTaskInput);
            AtomicInteger currrentProceess = new AtomicInteger(0);
            Consumer<TaskMessage> fillbackConsumer = r -> {
                if (this.isStop()) {
                    this.nowStop("");
                } else {
                    currrentProceess.addAndGet(r.getProcess().intValue());
                    this.feedbackProgress(currrentProceess.get() / 100, r.getMessage(), null);
                }
            };
            CountDownLatch latch = new CountDownLatch(inputList.size());
            int reportCount = inputList.size();
            GenerateInputFormular generateInputFormular = generateTaskInput.getGenetateFormResult().getFormularInput();
            for (GenerateInput input : inputList) {
                ThreadPoolService.runInReportGeneralThread(() -> {
                    try {
                        GenerateResult generateResult = DisclosureGenerateService.createReport(input, generateInputFormular, fillbackConsumer, reportCount);
                        reportResults.add(generateResult);
                        latch.countDown();
                    }
                    catch (Exception e) {
                        latch.countDown();
                        logger.error("DM ThreadPoolService.runInReportGeneralThread error", (Throwable)e);
                    }
                });
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                logger.error("DM ThreadPoolService.runInReportGeneralThread Interrupted", (Throwable)e);
            }
        }
        catch (KDBizException kdEx) {
            this.endTask(generateTaskInput, kdEx.getMessage());
            return;
        }
        catch (Exception e) {
            message = ResManager.loadKDString((String)"\u62a5\u544a\u751f\u6210\u670d\u52a1\u5f02\u5e38\uff0c\u8be6\u60c5\u89c1\u65e5\u5fd7\u3002", (String)"DisclosureGenerateTask_4", (String)"epm-far-business", (Object[])new Object[0]);
            logger.error(message, (Throwable)e);
            this.endTask(generateTaskInput, message);
            return;
        }
        logger.info("fidm--------reportgeneraltask----------costtimes:" + (System.currentTimeMillis() - startTime));
        GenerateTaskResult taskResult = new GenerateTaskResult();
        taskResult.setSuccess(true);
        taskResult.setResult(reportResults);
        taskResult.setInput(generateTaskInput);
        taskResult.setMessage(ResManager.loadKDString((String)"\u62a5\u544a\u751f\u6210\u670d\u52a1\u6267\u884c\u5b8c\u6bd5\u3002", (String)"DisclosureGenerateTask_5", (String)"epm-far-business", (Object[])new Object[0]));
        this.endTask(taskResult);
    }

    private void nowStop(String message) {
        if (StringUtils.isNotEmpty((String)message)) {
            this.feedbackProgress(100, message, null);
        }
        this.stop();
    }

    private void endTask(GenerateTaskResult result) {
        LinkedHashMap<String, String> customData = new LinkedHashMap<String, String>(10);
        customData.put("result", JSON.toJSONString((Object)result));
        this.feedbackCustomdata(customData);
    }

    private void endTask(GenerateTaskInput generateTaskInput, String errorMsg) {
        GenerateTaskResult taskResult = new GenerateTaskResult();
        taskResult.setSuccess(false);
        taskResult.setInput(generateTaskInput);
        taskResult.setMessage(errorMsg);
        this.endTask(taskResult);
    }
}

