/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.task;

import com.alibaba.fastjson.JSON;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.util.StringUtils;
import kd.epm.far.business.fidm.report.ReportModuleResetService;
import kd.epm.far.business.fidm.report.dto.ModuleResetInput;
import kd.epm.far.business.fidm.report.dto.ModuleResetResult;
import kd.epm.far.business.fidm.task.base.AbstractTaskEx;
import kd.epm.far.business.fidm.task.dto.ModuleResetTaskInput;
import kd.epm.far.business.fidm.task.dto.ModuleResetTaskResult;
import kd.epm.far.business.fidm.task.dto.TaskMessage;
import kd.epm.far.common.common.Recorder;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;

public class DisclosureModuleResetTask
extends AbstractTaskEx {
    private static final Double MaxProcessValue = 10000.0;
    protected static final WatchLogger logger = BcmLogFactory.getWatchLogInstance((boolean)true, DisclosureModuleResetTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        Recorder serviceRecord = new Recorder(null);
        String message = ResManager.loadKDString((String)"\u5df2\u7ecf\u8fdb\u5165\u4efb\u52a1\u6267\u884c\u73af\u8282\uff0c\u5f00\u59cb\u6267\u884c\u4efb\u52a1", (String)"DisclosureModuleResetTask_0", (String)"epm-far-business", (Object[])new Object[0]);
        this.feedbackProgress(0, message, null);
        ModuleResetResult moduleResetResult = null;
        ModuleResetTaskInput taskInput = null;
        long startTime = System.currentTimeMillis();
        try {
            if (this.isStop()) {
                this.nowStop("");
                this.endTask(taskInput, "");
                return;
            }
            if (params.get("input") == null || StringUtils.isEmpty((String)params.get("input").toString())) {
                message = ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u8f93\u5165\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"DisclosureModuleResetTask_1", (String)"epm-far-business", (Object[])new Object[0]);
                this.nowStop(message);
                this.endTask(taskInput, message);
                return;
            }
            taskInput = (ModuleResetTaskInput)JSON.parseObject((String)params.get("input").toString(), ModuleResetTaskInput.class);
            if (taskInput == null) {
                message = ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u8f93\u5165\u53c2\u6570\u5f02\u5e38\u3002", (String)"DisclosureModuleResetTask_2", (String)"epm-far-business", (Object[])new Object[0]);
                this.nowStop(message);
                this.endTask(taskInput, message);
                return;
            }
            this.setRequestContext(taskInput);
            ModuleResetInput moduleResetInput = taskInput.getInput();
            if (moduleResetInput == null) {
                message = ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u8f93\u5165\u53c2\u6570\u5f02\u5e38\u3002", (String)"DisclosureModuleResetTask_2", (String)"epm-far-business", (Object[])new Object[0]);
                this.nowStop(message);
                this.endTask(taskInput, message);
                return;
            }
            serviceRecord.setRecord((Object)taskInput);
            AtomicInteger currrentProceess = new AtomicInteger(0);
            Consumer<TaskMessage> fillbackConsumer = r -> {
                if (this.isStop()) {
                    this.nowStop("");
                } else {
                    currrentProceess.addAndGet(r.getProcess().intValue());
                    this.feedbackProgress(currrentProceess.get() / 100, r.getMessage(), null);
                }
            };
            moduleResetResult = ReportModuleResetService.calc(moduleResetInput, fillbackConsumer, MaxProcessValue);
        }
        catch (KDBizException kdEx) {
            this.endTask(taskInput, kdEx.getMessage());
            return;
        }
        catch (Exception e) {
            message = ResManager.loadKDString((String)"\u7ec4\u4ef6\u8ba1\u7b97\u670d\u52a1\u5f02\u5e38\uff0c\u8be6\u60c5\u89c1\u65e5\u5fd7\u3002", (String)"DisclosureModuleResetTask_4", (String)"epm-far-business", (Object[])new Object[0]);
            logger.error(message, (Throwable)e);
            this.endTask(taskInput, message);
            return;
        }
        logger.info("fidm--------reportgeneraltask----------costtimes:" + (System.currentTimeMillis() - startTime));
        ModuleResetTaskResult taskResult = new ModuleResetTaskResult();
        taskResult.setSuccess(true);
        taskResult.setResult(moduleResetResult);
        taskResult.setInput(taskInput);
        taskResult.setMessage(ResManager.loadKDString((String)"\u7ec4\u4ef6\u8ba1\u7b97\u670d\u52a1\u6267\u884c\u5b8c\u6bd5\u3002", (String)"DisclosureModuleResetTask_5", (String)"epm-far-business", (Object[])new Object[0]));
        this.endTask(taskResult);
    }

    private void nowStop(String message) {
        if (StringUtils.isNotEmpty((String)message)) {
            this.feedbackProgress(100, message, null);
        }
        this.stop();
    }

    private void endTask(ModuleResetTaskResult result) {
        LinkedHashMap<String, String> customData = new LinkedHashMap<String, String>(10);
        customData.put("result", JSON.toJSONString((Object)result));
        this.feedbackCustomdata(customData);
    }

    private void endTask(ModuleResetTaskInput taskInput, String errorMsg) {
        ModuleResetTaskResult taskResult = new ModuleResetTaskResult();
        taskResult.setSuccess(false);
        taskResult.setInput(taskInput);
        taskResult.setMessage(errorMsg);
        this.endTask(taskResult);
    }
}

