/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.PreviewFormType;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.fidm.design.DisclosurePreviewService;
import kd.epm.far.business.fidm.design.dto.ChapterPreviewResult;
import kd.epm.far.business.fidm.design.dto.PreviewFormParam;
import kd.epm.far.business.fidm.design.preview.DisclosurePreviewHelper;
import kd.epm.far.business.fidm.task.base.AbstractTaskEx;
import kd.epm.far.business.fidm.task.dto.PreviewTaskInput;
import kd.epm.far.business.fidm.task.dto.PreviewTaskResult;
import kd.epm.far.business.fidm.task.dto.TaskMessage;
import kd.epm.far.common.common.Recorder;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;

public class DisclosurePreviewTask
extends AbstractTaskEx {
    protected static final WatchLogger logger = BcmLogFactory.getWatchLogInstance((boolean)true, DisclosurePreviewTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> params) throws KDException {
        Recorder serviceRecord = new Recorder(null);
        String message = ResManager.loadKDString((String)"\u5df2\u7ecf\u8fdb\u5165\u4efb\u52a1\u6267\u884c\u73af\u8282\uff0c\u5f00\u59cb\u6267\u884c\u4efb\u52a1", (String)"DisclosurePreviewTask_0", (String)"epm-far-business", (Object[])new Object[0]);
        this.feedbackProgress(0, message, null);
        ChapterPreviewResult previewResult = null;
        PreviewTaskInput previewInput = null;
        long startTime = System.currentTimeMillis();
        try {
            if (this.isStop()) {
                this.stop();
                this.endTask(previewInput, "");
                return;
            }
            if (params.get("input") == null || StringUtils.isEmpty((String)params.get("input").toString())) {
                message = ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u8f93\u5165\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"DisclosurePreviewTask_1", (String)"epm-far-business", (Object[])new Object[0]);
                this.stop();
                this.endTask(previewInput, message);
                return;
            }
            previewInput = (PreviewTaskInput)JSON.parseObject((String)params.get("input").toString(), PreviewTaskInput.class);
            PreviewFormParam previewFormParam = previewInput.getFormParam();
            Map<String, DimMemberInfo> memberMap = previewInput.getMemberMap();
            if (previewFormParam == null || memberMap == null) {
                message = ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u8f93\u5165\u53c2\u6570\u5f02\u5e38\u3002", (String)"DisclosurePreviewTask_2", (String)"epm-far-business", (Object[])new Object[0]);
                this.stop();
                this.endTask(previewInput, message);
                return;
            }
            serviceRecord.setRecord((Object)previewInput);
            this.setRequestContext(previewInput);
            PreviewTaskInput newPreviewInput = previewInput;
            AtomicInteger currrentProceess = new AtomicInteger(0);
            Consumer<TaskMessage> fillbackConsumer = r -> {
                if (this.isStop()) {
                    this.stop();
                    this.endTask(newPreviewInput, "");
                } else {
                    currrentProceess.addAndGet(r.getProcess().intValue());
                    this.feedbackProgress(currrentProceess.get() / 100, r.getMessage(), null);
                }
            };
            if (PreviewFormType.ChapterDesgin.getType().equals(previewFormParam.getPreviewFormType())) {
                DynamicObject chapter = DisclosurePreviewHelper.getChapter(previewFormParam.getChapterId());
                List<JSONObject> moduleList = DisclosurePreviewHelper.getModuleList(previewFormParam.getDmModelId(), chapter);
                previewResult = DisclosurePreviewService.chapterPreview(previewFormParam.getDmModelId(), previewFormParam.getTemplateId(), previewFormParam.getChapterId(), moduleList, memberMap, previewFormParam.getUserName(), previewFormParam.getRandFileName(), previewFormParam.getUrlPrefix(), previewFormParam.getOpenWordEnumType(), fillbackConsumer);
            } else if (PreviewFormType.ModuleRepository.getType().equals(previewFormParam.getPreviewFormType())) {
                previewResult = DisclosurePreviewService.modulePreview(previewFormParam.getDmModelId(), previewFormParam.getModule(), memberMap, previewFormParam.getUserName(), previewFormParam.getRandFileName(), previewFormParam.getUrlPrefix(), previewFormParam.getOpenWordEnumType(), fillbackConsumer);
            } else if (PreviewFormType.ChapterRepository.getType().equals(previewFormParam.getPreviewFormType())) {
                previewResult = DisclosurePreviewService.chapterRepositoryPreview(previewFormParam.getDmModelId(), previewFormParam.getChapterId(), memberMap, previewFormParam.getUserName(), previewFormParam.getRandFileName(), previewFormParam.getUrlPrefix(), previewFormParam.getOpenWordEnumType(), fillbackConsumer);
            } else if (PreviewFormType.Template.getType().equals(previewFormParam.getPreviewFormType())) {
                previewResult = DisclosurePreviewService.templatePreview(previewFormParam.getDmModelId(), previewFormParam.getTemplateId(), memberMap, previewFormParam.getUserName(), previewFormParam.getRandFileName(), previewFormParam.getUrlPrefix(), previewFormParam.getOpenWordEnumType(), fillbackConsumer);
            } else {
                message = ResManager.loadKDString((String)"\u672c\u4efb\u52a1\u4e0d\u652f\u6301\u8be5\u573a\u666f\u7684\u9884\u89c8\u751f\u6210\u3002", (String)"DisclosurePreviewTask_3", (String)"epm-far-business", (Object[])new Object[0]);
                this.feedbackProgress(100, message, null);
                this.stop();
            }
        }
        catch (KDBizException kdEx) {
            this.endTask(previewInput, kdEx.getMessage());
            return;
        }
        catch (Exception e) {
            message = ResManager.loadKDString((String)"\u9884\u89c8\u751f\u6210\u670d\u52a1\u5f02\u5e38\uff0c\u8be6\u60c5\u89c1\u65e5\u5fd7\u3002", (String)"DisclosurePreviewTask_4", (String)"epm-far-business", (Object[])new Object[0]);
            logger.error(message, (Throwable)e);
            this.endTask(previewInput, message);
            return;
        }
        logger.info("fidm--------previewtask----------costtimes:" + (System.currentTimeMillis() - startTime));
        PreviewTaskResult taskResult = new PreviewTaskResult();
        taskResult.setSuccess(true);
        taskResult.setResult(previewResult);
        taskResult.setInput(previewInput);
        taskResult.setMessage(ResManager.loadKDString((String)"\u9884\u89c8\u751f\u6210\u670d\u52a1\u6267\u884c\u5b8c\u6bd5\u3002", (String)"DisclosurePreviewTask_5", (String)"epm-far-business", (Object[])new Object[0]));
        this.endTask(taskResult);
    }

    private void endTask(PreviewTaskResult result) {
        LinkedHashMap<String, String> customData = new LinkedHashMap<String, String>(10);
        customData.put("result", JSON.toJSONString((Object)result));
        this.feedbackCustomdata(customData);
    }

    private void endTask(PreviewTaskInput input, String errorMsg) {
        PreviewTaskResult taskResult = new PreviewTaskResult();
        taskResult.setSuccess(false);
        taskResult.setInput(input);
        taskResult.setMessage(errorMsg);
        this.endTask(taskResult);
    }
}

