/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.template;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.epm.far.business.fidm.chapter.DisclosureCopyHelper;
import kd.epm.far.business.fidm.chapter.dto.ChapterModuleCopyResult;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogHelper;
import kd.epm.far.common.common.log.oplog.AnalysisOpLogParam;
import kd.epm.far.common.common.log.oplog.OperationCategory;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.GlobalIdUtil;

public class DisclosureTemplateCopyHelper {
    public static long copyTempalte(DynamicObject sourceTemplateDy, String newNumber, String newName) {
        long newId = 0L;
        try (TXHandle tx = TX.required();){
            try {
                DynamicObject user = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
                user.set("id", (Object)RequestContext.get().getCurrUserId());
                Date date = new Date();
                CloneUtils cloneUtils = new CloneUtils(true, true);
                DynamicObject newTemplate = (DynamicObject)cloneUtils.clone((IDataEntityBase)sourceTemplateDy);
                newTemplate.set("number", (Object)newNumber);
                newTemplate.set("name", (Object)newName);
                newTemplate.set("creator", (Object)user);
                newTemplate.set("createtime", (Object)date);
                newTemplate.set("modifier", (Object)user);
                newTemplate.set("modifytime", (Object)date);
                newTemplate.set("status", (Object)"0");
                newTemplate.set("permclass", null);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newTemplate});
                long oldTemplateId = sourceTemplateDy.getLong("id");
                DisclosureTemplateCopyHelper.copyChapter(cloneUtils, oldTemplateId, newTemplate, user, date);
                newId = newTemplate.getLong("id");
                DisclosureTemplateCopyHelper.writeOpLog(OperationResult.SUCCESS, sourceTemplateDy, "fidm");
            }
            catch (Exception e) {
                tx.markRollback();
                DisclosureTemplateCopyHelper.writeOpLog(OperationResult.SUCCESS, sourceTemplateDy, "fidm");
                throw new KDBizException(e.getMessage());
            }
        }
        return newId;
    }

    private static void copyChapter(CloneUtils cloneUtils, long oldTemplateId, DynamicObject newTemplate, DynamicObject user, Date date) {
        DynamicObject[] oldChapters = BusinessDataServiceHelper.load((Object[])QueryServiceHelper.query((String)"fidm_chapter", (String)"id", (QFilter[])new QFilter("template", "=", (Object)oldTemplateId).toArray()).stream().map(c -> c.getLong("id")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fidm_chapter"));
        ArrayList<DynamicObject> newValues = new ArrayList<DynamicObject>(oldChapters.length);
        user.set("id", (Object)RequestContext.get().getCurrUserId());
        for (DynamicObject dy : oldChapters) {
            DynamicObject newChapter = (DynamicObject)cloneUtils.clone((IDataEntityBase)dy);
            long oldChapterId = dy.getLong("id");
            long newChapterId = GlobalIdUtil.genGlobalLongId();
            newChapter.set("id", (Object)newChapterId);
            newChapter.set("template", (Object)newTemplate);
            newChapter.set("previewurl", null);
            newChapter.set("creator", (Object)user);
            newChapter.set("createtime", (Object)date);
            newChapter.set("modifier", (Object)user);
            newChapter.set("modifytime", (Object)date);
            newChapter.set("commitstatus", (Object)"A");
            newChapter.set("commitor", null);
            newChapter.set("committime", null);
            newChapter.set("sendbacker", null);
            newChapter.set("sendbacktime", null);
            newChapter.set("permclass", null);
            newValues.add(newChapter);
            DisclosureCopyHelper.copyVariable(cloneUtils, oldChapterId, newChapterId, user, date);
            DisclosureCopyHelper.copyDataSet(cloneUtils, oldChapterId, newChapterId, user, date);
            List<ChapterModuleCopyResult> moduleMap = DisclosureCopyHelper.copyChapterModule(cloneUtils, oldChapterId, newChapter, user, date, null);
            DisclosureCopyHelper.copyChapterHtml(oldChapterId, newChapterId, user, date, moduleMap);
            DisclosureCopyHelper.copyChapterFile(oldChapterId, newChapterId, newChapter, moduleMap);
        }
        SaveServiceHelper.save((DynamicObject[])newValues.toArray(new DynamicObject[0]));
    }

    private static void writeOpLog(OperationResult result, DynamicObject template, String appId) {
        DynamicObject model = template.getDynamicObject("model");
        if (Objects.isNull(model)) {
            return;
        }
        String templateNumber = template.getString("number");
        AnalysisOpLogParam logParam = new AnalysisOpLogParam().buildOpCategory(OperationCategory.TEMPLATE).buildOpName(OperationName.COPY).buildFormNumber("fidm_templatelist").buildAppId(appId).buildFormatParams(new Object[]{model.getString("number"), templateNumber}).buildOpResult(result);
        AnalysisOpLogHelper.writeOperationLog((AnalysisOpLogParam)logParam);
    }
}

