/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.config.DMConfigServiceHelper;
import kd.epm.far.business.common.enums.AppCatalogTypeEnum;
import kd.epm.far.business.common.enums.ChapterComeFromEnum;
import kd.epm.far.business.common.enums.DisModelTypeEnum;
import kd.epm.far.business.common.enums.DiscTemplateCatalogTypeEnum;
import kd.epm.far.business.common.enums.OpenWordEnum;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimMemberInfo;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.common.perm.PermissionHelper;
import kd.epm.far.business.common.util.FarNumberRule;
import kd.epm.far.business.common.util.PlatUtil;
import kd.epm.far.business.common.util.ResultInfo;
import kd.epm.far.business.epmclient.EpmTemplateServiceHelper;
import kd.epm.far.business.fidm.report.DisclosureReportHelper;
import kd.epm.far.business.fidm.template.TemplateCatalogHelper;
import kd.epm.far.common.common.Pair;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.util.GlobalIdUtil;
import kd.epm.far.common.common.util.LongUtil;
import kd.epm.far.common.common.util.QFBuilder;

public class DisclosureTemplateHelper {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(DisclosureTemplateHelper.class);
    public static final List<String> BCM_FIXEDDIM = Arrays.asList("Entity".toLowerCase(Locale.ENGLISH) + "_f7", "Year".toLowerCase(Locale.ENGLISH) + "_f7", "Period".toLowerCase(Locale.ENGLISH) + "_f7");
    public static final List<String> EPM_FIXEDDIM = Arrays.asList("Entity".toLowerCase(Locale.ENGLISH) + "_f7", "BudgetPeriod".toLowerCase(Locale.ENGLISH) + "_f7", "Version".toLowerCase(Locale.ENGLISH) + "_f7");
    private static final String DIMF7MAP = "dimf7map";
    private static final String DIM2NAMEANDMODEL = "dim2NameAndModel";
    private static final String REALMODELID = "realModelId";
    private static final String ALLOWABLEDRAG = "allowableDrag";
    private static final String MODELTYPE = "modelType";

    public static DynamicObject getTemplate(Long templateId) {
        return DisclosureTemplateHelper.getTemplate(templateId, true);
    }

    public static DynamicObject getTemplate(Long templateId, boolean showException) {
        DynamicObject templateDy = QueryServiceHelper.queryOne((String)"fidm_template", (String)"id,number,name,model.id", (QFilter[])new QFilter("id", "=", (Object)templateId).toArray());
        if (showException && templateDy == null) {
            logger.error("dm template id not exist:" + templateId);
            throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u544a\u6a21\u677f\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"DisclosureServiceHelper_7", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return templateDy;
    }

    public static List<String> getDefaultDimList(String modelType) {
        ArrayList<String> paramDim = new ArrayList<String>(BCM_FIXEDDIM);
        if (DisModelTypeEnum.EB.getType().equalsIgnoreCase(modelType)) {
            paramDim = new ArrayList<String>(EPM_FIXEDDIM);
        }
        return paramDim;
    }

    public static DynamicObject getTemplateCataLog(Long templateId) {
        String selectField = "templatecatalog";
        QFBuilder qfBuilder = new QFBuilder();
        qfBuilder.add(new QFilter("id", "=", (Object)templateId));
        DynamicObject template = BusinessDataServiceHelper.loadSingle((String)"fidm_template", (String)selectField, (QFilter[])qfBuilder.toArray());
        if (template != null && template.getDynamicObject("templatecatalog") != null) {
            return template.getDynamicObject("templatecatalog");
        }
        return null;
    }

    public static Map<String, Object> getInitCache(Long modelId, List<String> paramDim) {
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId);
        List<DimensionInfo> allDims = modelStrategyEx.getDim().getDimList();
        HashMap<String, Long> dimF7Map = new HashMap<String, Long>(allDims.size());
        LinkedHashMap<String, Pair> dim2NameAndModel = new LinkedHashMap<String, Pair>(allDims.size());
        String modelType = modelStrategyEx.getModel().getModelInfo().getModelType();
        ArrayList<String> allowableDrag = new ArrayList<String>(10);
        for (DimensionInfo dim : allDims) {
            String dimNumber = dim.getNumber().toLowerCase(Locale.ENGLISH) + "_f7";
            dimF7Map.put(dimNumber, Long.valueOf(dim.getId().toString()));
            dim2NameAndModel.put(dimNumber, Pair.onePair((Object)dim.getName(), (Object)dim.getEntityName()));
            if (DisModelTypeEnum.EB.getType().equalsIgnoreCase(modelType)) {
                if (EPM_FIXEDDIM.contains(dimNumber)) continue;
                allowableDrag.add(dimNumber);
                continue;
            }
            if (paramDim == null) {
                if (BCM_FIXEDDIM.contains(dimNumber)) continue;
                allowableDrag.add(dimNumber);
                continue;
            }
            if (BCM_FIXEDDIM.contains(dimNumber) && paramDim.contains(dimNumber)) continue;
            allowableDrag.add(dimNumber);
        }
        HashMap<String, Object> cache = new HashMap<String, Object>();
        cache.put(REALMODELID, Long.toString(modelId));
        cache.put(DIMF7MAP, dimF7Map);
        cache.put(DIM2NAMEANDMODEL, dim2NameAndModel);
        cache.put(ALLOWABLEDRAG, allowableDrag);
        cache.put(MODELTYPE, modelType);
        return cache;
    }

    public static List<ComboItem> getDimCombols(Map<String, String> paramDimMap, boolean hasdsq) {
        ArrayList<ComboItem> fieldData = new ArrayList<ComboItem>(16);
        for (Map.Entry<String, String> paramDim : paramDimMap.entrySet()) {
            ComboItem comboItem = new ComboItem(new LocaleString(paramDim.getValue()), "dim" + paramDim.getKey());
            fieldData.add(comboItem);
        }
        fieldData.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5e38\u91cf", (String)"DisclosureTemplateHelper_4", (String)"epm-far-business", (Object[])new Object[0])), "val"));
        ComboItem desq = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6d41\u6c34\u53f7", (String)"DisclosureTemplateHelper_5", (String)"epm-far-business", (Object[])new Object[0])), "dsq");
        if (hasdsq) {
            desq.setItemVisible(false);
        }
        fieldData.add(desq);
        fieldData.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7cfb\u7edf\u65e5\u671f", (String)"DisclosureTemplateHelper_6", (String)"epm-far-business", (Object[])new Object[0])), "dat"));
        fieldData.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6a21\u677f\u540d\u79f0", (String)"DisclosureTemplateHelper_7", (String)"epm-far-business", (Object[])new Object[0])), "tna"));
        fieldData.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801", (String)"DisclosureTemplateHelper_8", (String)"epm-far-business", (Object[])new Object[0])), "tnm"));
        return fieldData;
    }

    public static void checkSave(Long dmModelId, IDataModel iDataModel, String appId) {
        String number = iDataModel.getValue("number").toString();
        String name = iDataModel.getValue("name").toString();
        if (StringUtils.isEmpty((String)number) || StringUtils.isEmpty((String)name)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7f16\u7801\u548c\u540d\u79f0\u3002", (String)"DisclosureTemplateHelper_15", (String)"epm-far-business", (Object[])new Object[0]));
        }
        Matcher matcherNumber = Pattern.compile("^(?!_)[-a-zA-Z0-9.]+$").matcher(number);
        if (!matcherNumber.matches() || number.contains("..") || number.startsWith(".") || number.startsWith("-")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u7801\u53ea\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\uff0c\u4e0d\u53ef\u4ee5\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e0d\u53ef\u8fde\u7eed\u3002", (String)"DisclosureTemplateHelper_0", (String)"epm-far-business", (Object[])new Object[0]));
        }
        Matcher matcherName = Pattern.compile("[^%]+").matcher(name);
        if (!matcherName.matches() || name.contains("..") || name.startsWith(".") || name.startsWith("-")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u53ef\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u201c%\u201c\u3002", (String)"DisclosureTemplateHelper_1", (String)"epm-far-business", (Object[])new Object[0]));
        }
        Object id = iDataModel.getValue("id");
        QFilter qf = new QFilter("model", "=", (Object)dmModelId);
        qf.and("number", "=", (Object)number);
        qf.and("templatecatalog.catalogtype", "=", (Object)DiscTemplateCatalogTypeEnum.getCatalogByAppId(appId).getType());
        if (!"0".equals(id.toString())) {
            qf.and("id", "!=", id);
        }
        if (QueryServiceHelper.exists((String)"fidm_template", (QFilter[])qf.toArray())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"DisclosureTemplateHelper_2", (String)"epm-far-business", (Object[])new Object[0]));
        }
    }

    public static String changeValueTypeItem(String valueType) {
        if (ResManager.loadKDString((String)"\u7f16\u7801", (String)"DisclosureTemplateHelper_10", (String)"epm-far-business", (Object[])new Object[0]).equals(valueType)) {
            return "1";
        }
        if (ResManager.loadKDString((String)"\u540d\u79f0", (String)"DisclosureTemplateHelper_11", (String)"epm-far-business", (Object[])new Object[0]).equals(valueType)) {
            return "2";
        }
        if (ResManager.loadKDString((String)"\u65e5", (String)"DisclosureTemplateHelper_12", (String)"epm-far-business", (Object[])new Object[0]).equals(valueType)) {
            return "3";
        }
        if (ResManager.loadKDString((String)"\u6708+\u65e5", (String)"DisclosureTemplateHelper_13", (String)"epm-far-business", (Object[])new Object[0]).equals(valueType)) {
            return "4";
        }
        if (ResManager.loadKDString((String)"\u5e74+\u6708+\u65e5", (String)"DisclosureTemplateHelper_14", (String)"epm-far-business", (Object[])new Object[0]).equals(valueType)) {
            return "5";
        }
        if (!StringUtils.isEmpty((String)valueType)) {
            return valueType;
        }
        return "";
    }

    public static String changeValuetoText(String valueType) {
        if ("1".equals(valueType)) {
            return ResManager.loadKDString((String)"\u7f16\u7801", (String)"DisclosureTemplateHelper_10", (String)"epm-far-business", (Object[])new Object[0]);
        }
        if ("2".equals(valueType)) {
            return ResManager.loadKDString((String)"\u540d\u79f0", (String)"DisclosureTemplateHelper_11", (String)"epm-far-business", (Object[])new Object[0]);
        }
        if ("3".equals(valueType)) {
            return ResManager.loadKDString((String)"\u65e5", (String)"DisclosureTemplateHelper_12", (String)"epm-far-business", (Object[])new Object[0]);
        }
        if ("4".equals(valueType)) {
            return ResManager.loadKDString((String)"\u6708+\u65e5", (String)"DisclosureTemplateHelper_13", (String)"epm-far-business", (Object[])new Object[0]);
        }
        if ("5".equals(valueType)) {
            return ResManager.loadKDString((String)"\u5e74+\u6708+\u65e5", (String)"DisclosureTemplateHelper_14", (String)"epm-far-business", (Object[])new Object[0]);
        }
        return "";
    }

    public static List<String> getTemplateDimKey(Long dmModelId, Long templateId) {
        ArrayList<String> dimensionIds = new ArrayList<String>(16);
        DynamicObject template = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"fidm_template");
        DynamicObjectCollection parammembentry = template.getDynamicObjectCollection("parammembentry");
        Map<Integer, String> desqList = new ModelStrategyEx(dmModelId).getDim().getDimSortKey();
        for (Map.Entry<Integer, String> desq : desqList.entrySet()) {
            for (DynamicObject doc : parammembentry) {
                String dimNum = doc.getDynamicObject("paramdimension").getString("number");
                if (!dimNum.equals(desq.getValue())) continue;
                String dimensionId = doc.getDynamicObject("paramdimension").getString("id");
                dimensionIds.add(dimensionId);
            }
        }
        return dimensionIds;
    }

    public static ResultInfo setTemplateStatus(long modelId, long templateId, boolean enable) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        qFilters.add(new QFilter("outputtype", "=", (Object)String.valueOf(1)));
        qFilters.add(new QFilter("templatecatalog.catalogtype", "=", (Object)AppCatalogTypeEnum.FIDM_CATALOG.getType()));
        qFilters.add(new QFilter("id", "=", (Object)templateId));
        DynamicObject template = BusinessDataServiceHelper.loadSingle((String)"fidm_template", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (template == null || !DisclosureTemplateHelper.hasWritePermission(modelId, templateId)) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u6a21\u677f\u5df2\u4e0d\u5b58\u5728\u6216\u65e0\u6743\u9650\u3002", (String)"DisclosureTemplateHelper_16", (String)"epm-far-business", (Object[])new Object[0]));
        }
        template.set("status", (Object)(enable ? "1" : "0"));
        template.set("modifier", (Object)RequestContext.get().getCurrUserId());
        template.set("modifytime", (Object)TimeServiceHelper.now());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{template});
        return ResultInfo.success(templateId);
    }

    public static ResultInfo deleteTemplate(long modelId, long templateId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        qFilters.add(new QFilter("id", "=", (Object)templateId));
        DynamicObject template = BusinessDataServiceHelper.loadSingle((String)"fidm_template", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (template == null || !DisclosureTemplateHelper.hasWritePermission(modelId, templateId)) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u6a21\u677f\u5df2\u4e0d\u5b58\u5728\u6216\u65e0\u6743\u9650\u3002", (String)"DisclosureTemplateHelper_16", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if ("1".equals(template.getString("status"))) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u8be5\u6a21\u677f\u5df2\u7ecf\u542f\u7528\uff0c\u4e0d\u53ef\u4ee5\u5220\u9664\u3002", (String)"DisclosureTemplateHelper_17", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (DisclosureReportHelper.existsReport(modelId, templateId)) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u8be5\u6a21\u677f\u5df2\u7ecf\u751f\u6210\u62a5\u544a\uff0c\u8bf7\u5148\u5220\u9664\u62a5\u544a\u518d\u5220\u9664\u6a21\u677f\u3002", (String)"DisclosureTemplateHelper_18", (String)"epm-far-business", (Object[])new Object[0]));
        }
        PlatUtil.executeWithTXNew(tx -> {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"fidm_template"), (Object[])new Object[]{templateId});
            PermissionHelper.savePermClassEntity(modelId, templateId, "fidm_template", 0L, OperationStatus.EDIT);
            QFilter chapterFilter = new QFilter("model", "=", (Object)modelId).and("template", "=", (Object)templateId);
            DynamicObject[] chapters = BusinessDataServiceHelper.load((String)"fidm_chapter", (String)"id,entryentity", (QFilter[])chapterFilter.toArray());
            ArrayList<Long> chapterIds = new ArrayList<Long>(chapters.length);
            ArrayList moduleIds = new ArrayList(6);
            for (DynamicObject chapter : chapters) {
                chapterIds.add(chapter.getLong("id"));
                DynamicObjectCollection chapterModules = chapter.getDynamicObjectCollection("entryentity");
                List mIds = chapterModules.stream().map(e -> e.getLong("id")).filter(e -> !e.equals(0L)).distinct().collect(Collectors.toList());
                if (mIds.isEmpty()) continue;
                moduleIds.addAll(mIds);
            }
            if (!chapterIds.isEmpty()) {
                QFilter variableFilter = new QFilter("model", "=", (Object)modelId).and("chapterid", "in", chapterIds);
                DeleteServiceHelper.delete((String)"fidm_disc_variable", (QFilter[])variableFilter.toArray());
                QFilter datasetFilter = new QFilter("discmodel", "=", (Object)modelId).and("chapterid", "in", chapterIds);
                DeleteServiceHelper.delete((String)"fidm_dataset", (QFilter[])datasetFilter.toArray());
                if (!moduleIds.isEmpty()) {
                    QFilter moduleFilter = new QFilter("model", "=", (Object)modelId).and("id", "in", moduleIds);
                    DeleteServiceHelper.delete((String)"fidm_modulerepository", (QFilter[])moduleFilter.toArray());
                }
            }
            DeleteServiceHelper.delete((String)"fidm_chapter", (QFilter[])chapterFilter.toArray());
        });
        return ResultInfo.success(templateId);
    }

    public static ResultInfo saveTemplate(long modelId, long templateId, String number, String name, long catalogId, long permClassId, String description, List<Map<String, Object>> defmembentry, List<Map<String, Object>> parammembentry, boolean isAutoNumberName) {
        DynamicObject template;
        long userId = RequestContext.get().getCurrUserId();
        Date now = TimeServiceHelper.now();
        OperationStatus operationStatus = OperationStatus.EDIT;
        if (templateId <= 0L) {
            if (isAutoNumberName) {
                Pair<String, String> numberName = EpmTemplateServiceHelper.getDefaultTemplateNumberName(modelId);
                if (StringUtils.isEmpty((String)number)) {
                    number = (String)numberName.p1;
                }
                if (StringUtils.isEmpty((String)name)) {
                    name = (String)numberName.p2;
                }
            }
            operationStatus = OperationStatus.ADDNEW;
            templateId = GlobalIdUtil.genGlobalLongId();
            template = BusinessDataServiceHelper.newDynamicObject((String)"fidm_template");
            if (StringUtils.isEmpty((String)number)) {
                return ResultInfo.fail(ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DisclosureTemplateHelper_19", (String)"epm-far-business", (Object[])new Object[0]));
            }
            if (DisclosureTemplateHelper.existsTemplate(modelId, number)) {
                return ResultInfo.fail(ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"DisclosureTemplateHelper_20", (String)"epm-far-business", (Object[])new Object[0]));
            }
            if (!FarNumberRule.checkNumber(number)) {
                return ResultInfo.fail(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"DisclosureTemplateHelper_21", (String)"epm-far-business", (Object[])new Object[0]));
            }
            template.set("id", (Object)templateId);
            template.set("model", (Object)modelId);
            template.set("number", (Object)number);
            template.set("outputtype", (Object)"1");
            template.set("status", (Object)"0");
            template.set("sequence", (Object)DisclosureTemplateHelper.getMaxDesq(modelId, templateId));
            template.set("creator", (Object)userId);
            template.set("createtime", (Object)now);
        } else {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
            qFilters.add(new QFilter("model", "=", (Object)modelId));
            qFilters.add(new QFilter("outputtype", "=", (Object)String.valueOf(1)));
            qFilters.add(new QFilter("templatecatalog.catalogtype", "=", (Object)AppCatalogTypeEnum.FIDM_CATALOG.getType()));
            qFilters.add(new QFilter("id", "=", (Object)templateId));
            template = BusinessDataServiceHelper.loadSingle((String)"fidm_template", (QFilter[])qFilters.toArray(new QFilter[0]));
            if (template == null || !DisclosureTemplateHelper.hasWritePermission(modelId, templateId)) {
                return ResultInfo.fail(ResManager.loadKDString((String)"\u6a21\u677f\u5df2\u4e0d\u5b58\u5728\u6216\u65e0\u6743\u9650\u3002", (String)"DisclosureTemplateHelper_16", (String)"epm-far-business", (Object[])new Object[0]));
            }
        }
        if (StringUtils.isEmpty((String)name)) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u6a21\u677f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DisclosureTemplateHelper_22", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (number.length() > 50) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u6a21\u677f\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc750\u3002", (String)"DisclosureTemplateHelper_28", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (name.length() > 100) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u6a21\u677f\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7100\u3002", (String)"DisclosureTemplateHelper_29", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (StringUtils.isNotEmpty((String)description) && description.length() > 100) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u6a21\u677f\u63cf\u8ff0\u8bf4\u660e\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7100\u3002", (String)"DisclosureTemplateHelper_30", (String)"epm-far-business", (Object[])new Object[0]));
        }
        ArrayList<Long> catalogIds = new ArrayList<Long>(1);
        catalogIds.add(catalogId);
        if (catalogId == 0L || TemplateCatalogHelper.getCatalogs(modelId, catalogIds, true).isEmpty()) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u5206\u7c7b\u5df2\u4e0d\u5b58\u5728\u6216\u65e0\u6743\u9650\u3002", (String)"DisclosureTemplateHelper_23", (String)"epm-far-business", (Object[])new Object[0]));
        }
        template.set("name", (Object)name);
        template.set("templatecatalog", (Object)catalogId);
        template.set("permclass", (Object)permClassId);
        template.set("description", (Object)description);
        template.set("modifier", (Object)userId);
        template.set("modifytime", (Object)now);
        ResultInfo result = DisclosureTemplateHelper.setTemplateDimMembers(modelId, template, defmembentry, parammembentry);
        if (Boolean.FALSE.equals(result.isSuccess())) {
            return result;
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{template});
        PermissionHelper.savePermClassEntity(modelId, templateId, "fidm_template", permClassId, operationStatus);
        return ResultInfo.success(templateId);
    }

    private static boolean existsTemplate(long modelId, String number) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        qFilters.add(new QFilter("outputtype", "=", (Object)String.valueOf(1)));
        qFilters.add(new QFilter("templatecatalog.catalogtype", "=", (Object)AppCatalogTypeEnum.FIDM_CATALOG.getType()));
        qFilters.add(new QFilter("number", "=", (Object)number));
        return QueryServiceHelper.exists((String)"fidm_template", (QFilter[])qFilters.toArray(new QFilter[0]));
    }

    public static int getMaxDesq(long modelId, long catalogId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        qFilters.add(new QFilter("outputtype", "=", (Object)String.valueOf(1)));
        qFilters.add(new QFilter("templatecatalog.catalogtype", "=", (Object)AppCatalogTypeEnum.FIDM_CATALOG.getType()));
        qFilters.add(new QFilter("templatecatalog", "=", (Object)catalogId));
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"fidm_template", (String)"sequence", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"sequence desc", (int)1);
        if (dys != null && !dys.isEmpty()) {
            return ((DynamicObject)dys.get(0)).getInt("sequence") + 1;
        }
        return 1;
    }

    private static ResultInfo setTemplateDimMembers(long modelId, DynamicObject template, List<Map<String, Object>> defmembentry, List<Map<String, Object>> parammembentry) {
        DimensionInfo dim;
        DynamicObjectCollection dimDefDatas = template.getDynamicObjectCollection("defmembentry");
        DynamicObjectCollection dimParamDatas = template.getDynamicObjectCollection("parammembentry");
        dimDefDatas.clear();
        dimParamDatas.clear();
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId);
        List<DimensionInfo> allDimensions = modelStrategyEx.getDim().getDimList();
        for (Map<String, Object> member : defmembentry) {
            dim = DimensionUtils.getDimById(allDimensions, LongUtil.toLong((Object)member.get("DimensionId")));
            if (dim == null) {
                return ResultInfo.fail(ResManager.loadKDString((String)"\u7ef4\u5ea6\u4e0d\u5b58\u5728\u3002", (String)"DisclosureTemplateHelper_24", (String)"epm-far-business", (Object[])new Object[0]));
            }
            DimMemberInfo memberInfo = modelStrategyEx.getDimMember().findMemberById(dim.getEntityName(), LongUtil.toLong((Object)member.get("MemberId")));
            if (memberInfo == null) {
                return ResultInfo.fail(ResManager.loadKDString((String)"\u7ef4\u5ea6%s\u7684\u6210\u5458\u4e0d\u5b58\u5728\u3002", (String)"DisclosureTemplateHelper_25", (String)"epm-far-business", (Object[])new Object[0]));
            }
            DynamicObject dy = dimDefDatas.addNew();
            dy.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            dy.set("defdimension", member.get("DimensionId"));
            dy.set("defmemberid", member.get("MemberId"));
            dy.set("seq", member.get("Dseq"));
            dy.set("defdimtype", member.get("DimensionType"));
        }
        for (Map<String, Object> member : parammembentry) {
            dim = DimensionUtils.getDimById(allDimensions, LongUtil.toLong((Object)member.get("DimensionId")));
            if (dim == null) {
                return ResultInfo.fail(ResManager.loadKDString((String)"\u7ef4\u5ea6\u4e0d\u5b58\u5728\u3002", (String)"DisclosureTemplateHelper_24", (String)"epm-far-business", (Object[])new Object[0]));
            }
            DynamicObject dy = dimParamDatas.addNew();
            dy.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            dy.set("paramdimension", member.get("DimensionId"));
            dy.set("seq", member.get("Dseq"));
            dy.set("paramdimtype", member.get("DimensionType"));
        }
        return ResultInfo.success();
    }

    public static void updateTempateSaveWordType(Long templateId, OpenWordEnum openWordEnum) {
        DynamicObject[] chapters;
        DynamicObject templateDy = DisclosureTemplateHelper.getTemplate(templateId);
        QFBuilder qf = new QFBuilder("model", "=", (Object)templateDy.getLong("model.id"));
        qf.and("template", "=", (Object)templateId);
        for (DynamicObject chapter : chapters = BusinessDataServiceHelper.load((String)"fidm_chapter", (String)"id,savewordtype,comefrom", (QFilter[])qf.toArray(), (String)"sequence")) {
            chapter.set("savewordtype", (Object)openWordEnum.getTypeToInt());
            chapter.set("comefrom", (Object)ChapterComeFromEnum.FIDM.getType());
        }
        SaveServiceHelper.save((DynamicObject[])chapters);
    }

    public static List<Long> getChapterInfoByTemplate(Long templateId) {
        if (!LongUtil.isvalidLong((Object)templateId)) {
            return new ArrayList<Long>(100);
        }
        DynamicObjectCollection chapters = QueryServiceHelper.query((String)"fidm_chapter", (String)"id", (QFilter[])new QFilter("template", "=", (Object)templateId).toArray());
        return chapters.stream().map(m -> m.getLong("id")).collect(Collectors.toList());
    }

    public static boolean hasWritePermission(long modelId, long templateId) {
        DynamicObject template = BusinessDataServiceHelper.loadSingleFromCache((Object)templateId, (String)"fidm_template");
        if (template != null) {
            boolean result = PermissionHelper.hasWritePerm(modelId, "fidm_template", templateId);
            if (result) {
                result = TemplateCatalogHelper.hasWritePermission(modelId, template.getLong("templatecatalog.id"));
            }
            return result;
        }
        return false;
    }

    public static Map<Long, String> getTemplateOpenWordType(List<Long> templateIds) {
        String defaultOpenType = DMConfigServiceHelper.getAndCheckOpenWordEnum();
        DynamicObjectCollection chapters = QueryServiceHelper.query((String)"fidm_chapter", (String)"id,template.id,savewordtype", (QFilter[])new QFilter("template", "in", templateIds).toArray());
        HashMap<Long, HashSet<String>> templateSavewordTypes = new HashMap<Long, HashSet<String>>(templateIds.size());
        for (DynamicObject chapter : chapters) {
            Long templateId = chapter.getLong("template.id");
            HashSet<String> list = (HashSet<String>)templateSavewordTypes.get(templateId);
            if (list == null) {
                list = new HashSet<String>(10);
                templateSavewordTypes.put(templateId, list);
            }
            list.add(chapter.getString("savewordtype"));
        }
        HashMap<Long, String> templateWords = new HashMap<Long, String>(templateSavewordTypes.size());
        for (Map.Entry template : templateSavewordTypes.entrySet()) {
            Set<String> editType = ((Set)template.getValue()).stream().collect(Collectors.toSet());
            templateWords.put((Long)template.getKey(), OpenWordEnum.getText(editType));
        }
        for (Long templateId : templateIds) {
            String text = (String)templateWords.get(templateId);
            if (!StringUtils.isEmpty((String)text)) continue;
            templateWords.put(templateId, OpenWordEnum.getByType(defaultOpenType).getName());
        }
        return templateWords;
    }
}

