/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.template;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.org.model.EnableEnum;
import kd.bos.org.model.StatusEnum;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.AppCatalogTypeEnum;
import kd.epm.far.business.common.enums.DiscTemplateCatalogTypeEnum;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.ModelInfo;
import kd.epm.far.business.common.perm.PermissionHelper;
import kd.epm.far.business.common.util.FarNumberRule;
import kd.epm.far.business.common.util.PlatUtil;
import kd.epm.far.business.common.util.ResultInfo;
import kd.epm.far.business.fidm.base.DisclosureLogHelper;
import kd.epm.far.business.fidm.template.dto.TempCatalog;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.GlobalIdUtil;

public class TemplateCatalogHelper {
    public static List<TempCatalog> getCatalogs(long modelId, List<Long> catalogIds, boolean onlyWritePermission) {
        QFilter permqFilter;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        qFilters.add(new QFilter("catalogtype", "=", (Object)AppCatalogTypeEnum.FIDM_CATALOG.getType()));
        qFilters.add(new QFilter("status", "=", (Object)StatusEnum.Checked.toString()).and("enable", "=", (Object)EnableEnum.Enable.toString()).or("parent", "=", (Object)0));
        if (catalogIds != null) {
            qFilters.add(new QFilter("id", "in", catalogIds));
            if (catalogIds.isEmpty()) {
                return new ArrayList<TempCatalog>(0);
            }
        }
        if (onlyWritePermission) {
            permqFilter = PermissionHelper.getWritePermFilter(modelId, "fidm_tmplcatalog");
            qFilters.add(permqFilter);
        } else {
            permqFilter = PermissionHelper.getReadAndWritePermFilter(modelId, "fidm_tmplcatalog");
            qFilters.add(permqFilter);
        }
        DynamicObjectCollection catalogDatas = QueryServiceHelper.query((String)"fidm_tmplcatalog", (String)"id,number,name,longnumber,sequence,level,isleaf,parent.id,parent.name,instruction,permclass.id,permclass.number,creator.name,createtime,modifier.name,modifytime", (QFilter[])qFilters.toArray(new QFilter[0]));
        ArrayList<TempCatalog> catalogs = new ArrayList<TempCatalog>(catalogDatas.size());
        for (DynamicObject dy : catalogDatas) {
            TempCatalog catalog = new TempCatalog();
            catalog.setId(dy.getLong("id"));
            catalog.setNumber(dy.getString("number"));
            catalog.setName(dy.getString("name"));
            catalog.setLongNumber(dy.getString("longnumber"));
            catalog.setLevel(dy.getInt("level"));
            catalog.setIsLeaf(dy.getBoolean("isleaf"));
            catalog.setDseq(dy.getInt("sequence"));
            catalog.setParentId(dy.getLong("parent.id"));
            catalog.setDescription(dy.getString("instruction"));
            catalog.setPermClassId(dy.getLong("permclass.id"));
            catalog.setPermClassNumber(dy.getString("permclass.number"));
            catalog.setParentName(dy.getString("parent.name"));
            catalog.setCreator(dy.getString("creator.name"));
            catalog.setCreateTime(dy.getDate("createtime"));
            catalog.setModifier(dy.getString("modifier.name"));
            catalog.setModifyTime(dy.getDate("modifytime"));
            catalogs.add(catalog);
        }
        return catalogs;
    }

    public static ResultInfo addCatalog(long modelId, String number, String name, long parentId, long permClassId, String description) {
        if (StringUtils.isEmpty((String)number)) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TemplateCatalogHelper_0", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (number.length() > 30) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u5206\u7c7b\u7f16\u7801\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc730\u3002", (String)"TemplateCatalogHelper_13", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (number.contains(".") || number.contains("-")) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u5305\u542b\u534a\u89d2\u5c0f\u6570\u70b9\u6216\u8005\u534a\u89d2\u6a2a\u7ebf\u3002", (String)"TemplateCatalogHelper_12", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (!FarNumberRule.checkNumber(number)) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u5206\u7c7b\u7f16\u7801\u4e0d\u53ef\u5305\u542b\u534a\u89d2\u6570\u5b57\u3001\u534a\u89d2\u5b57\u6bcd\u3001\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u4ee5\u5916\u7684\u5b57\u7b26\uff0c\u4e0d\u53ef\u4ee5\u534a\u89d2\u5c0f\u6570\u70b9\u3001\u534a\u89d2\u6a2a\u7ebf\u548c\u534a\u89d2\u4e0b\u5212\u7ebf\u5f00\u5934\uff0c\u5c0f\u6570\u70b9\u4e4b\u95f4\u5fc5\u987b\u6709\u5176\u4ed6\u5b57\u7b26\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"TemplateCatalogHelper_11", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (TemplateCatalogHelper.existsCatalogByNumber(modelId, number)) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u5206\u7c7b\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"TemplateCatalogHelper_1", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)name)) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TemplateCatalogHelper_4", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (TemplateCatalogHelper.existsCatalogByName(modelId, 0L, name)) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u5206\u7c7b\u540d\u79f0\u5df2\u5b58\u5728\u3002", (String)"TemplateCatalogHelper_2", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (name.length() > 100) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u5206\u7c7b\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7100\u3002", (String)"TemplateCatalogHelper_14", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (StringUtils.isNotEmpty((String)description) && description.length() > 500) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u5206\u7c7b\u8bf4\u660e\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7500\u3002", (String)"TemplateCatalogHelper_15", (String)"epm-far-business", (Object[])new Object[0]));
        }
        ArrayList<Long> catalogIds = new ArrayList<Long>(1);
        catalogIds.add(parentId);
        List<TempCatalog> parents = TemplateCatalogHelper.getCatalogs(modelId, catalogIds, true);
        if (parents.isEmpty()) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u4e0a\u7ea7\u5206\u7c7b\u4e0d\u5b58\u5728\u6216\u65e0\u6743\u9650\u3002", (String)"TemplateCatalogHelper_5", (String)"epm-far-business", (Object[])new Object[0]));
        }
        long id = GlobalIdUtil.genGlobalLongId();
        long userId = RequestContext.get().getCurrUserId();
        Date now = TimeServiceHelper.now();
        DynamicObject parentCatalog = BusinessDataServiceHelper.loadSingle((Object)parentId, (String)"fidm_tmplcatalog");
        parentCatalog.set("isleaf", (Object)false);
        DynamicObject catalog = BusinessDataServiceHelper.newDynamicObject((String)"fidm_tmplcatalog");
        catalog.set("id", (Object)id);
        catalog.set("masterid", (Object)id);
        catalog.set("model", (Object)modelId);
        catalog.set("number", (Object)number);
        catalog.set("name", (Object)name);
        catalog.set("longnumber", (Object)(parents.get(0).getLongNumber() + "." + number));
        catalog.set("level", (Object)(parents.get(0).getLevel() + 1));
        catalog.set("isleaf", (Object)true);
        catalog.set("sequence", (Object)TemplateCatalogHelper.getMaxDesq(modelId, parentId));
        catalog.set("parent", (Object)parentId);
        catalog.set("instruction", (Object)description);
        catalog.set("permclass", (Object)permClassId);
        catalog.set("catalogtype", (Object)AppCatalogTypeEnum.FIDM_CATALOG.getType());
        catalog.set("status", (Object)StatusEnum.Checked.toString());
        catalog.set("enable", (Object)EnableEnum.Enable.toString());
        catalog.set("creator", (Object)userId);
        catalog.set("createtime", (Object)now);
        catalog.set("modifier", (Object)userId);
        catalog.set("modifytime", (Object)now);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{parentCatalog, catalog});
        PermissionHelper.savePermClassEntity(modelId, id, "fidm_tmplcatalog", permClassId, OperationStatus.ADDNEW);
        return ResultInfo.success(id);
    }

    public static ResultInfo updateCatalog(long modelId, long catalogId, String name, long permClassId, String description) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        qFilters.add(new QFilter("catalogtype", "=", (Object)AppCatalogTypeEnum.FIDM_CATALOG.getType()));
        qFilters.add(new QFilter("id", "=", (Object)catalogId));
        DynamicObject catalog = BusinessDataServiceHelper.loadSingle((String)"fidm_tmplcatalog", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (catalog == null || !TemplateCatalogHelper.hasWritePermission(modelId, catalogId)) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u5206\u7c7b\u5df2\u4e0d\u5b58\u5728\u6216\u65e0\u6743\u9650\u3002", (String)"TemplateCatalogHelper_6", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (StringUtils.isEmpty((String)name)) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TemplateCatalogHelper_4", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (TemplateCatalogHelper.existsCatalogByName(modelId, catalogId, name)) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u5206\u7c7b\u540d\u79f0\u5df2\u5b58\u5728\u3002", (String)"TemplateCatalogHelper_7", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (name.length() > 100) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u5206\u7c7b\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7100\u3002", (String)"TemplateCatalogHelper_14", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (StringUtils.isNotEmpty((String)description) && description.length() > 500) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u5206\u7c7b\u8bf4\u660e\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7500\u3002", (String)"TemplateCatalogHelper_15", (String)"epm-far-business", (Object[])new Object[0]));
        }
        catalog.set("name", (Object)name);
        catalog.set("permclass", (Object)permClassId);
        catalog.set("instruction", (Object)description);
        catalog.set("modifier", (Object)RequestContext.get().getCurrUserId());
        catalog.set("modifytime", (Object)TimeServiceHelper.now());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{catalog});
        PermissionHelper.savePermClassEntity(modelId, catalogId, "fidm_tmplcatalog", permClassId, OperationStatus.EDIT);
        return ResultInfo.success(catalogId);
    }

    public static ResultInfo deleteCatalog(long modelId, long catalogId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        qFilters.add(new QFilter("catalogtype", "=", (Object)AppCatalogTypeEnum.FIDM_CATALOG.getType()));
        qFilters.add(new QFilter("id", "=", (Object)catalogId));
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(modelId);
        ModelInfo modelInfo = modelStrategyEx.getModel().getModelInfo();
        DynamicObject catalog = BusinessDataServiceHelper.loadSingle((String)"fidm_tmplcatalog", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (catalog == null || !TemplateCatalogHelper.hasWritePermission(modelId, catalogId)) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u5206\u7c7b\u5df2\u4e0d\u5b58\u5728\u6216\u65e0\u6743\u9650\u3002", (String)"TemplateCatalogHelper_6", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (catalog.getLong("parent.id") == 0L) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u6839\u8282\u70b9\u4e0d\u80fd\u5220\u9664\u3002", (String)"TemplateCatalogHelper_8", (String)"epm-far-business", (Object[])new Object[0]));
        }
        List<Long> catalogIds = TemplateCatalogHelper.getCatalogIdsByLongNumber(modelId, catalog.getString("longnumber"));
        catalogIds.add(catalogId);
        DynamicObject[] catalogs = (DynamicObject[])QueryServiceHelper.query((String)"fidm_tmplcatalog", (String)"id,number,name", (QFilter[])new QFilter("id", "in", catalogIds).toArray()).toArray((Object[])new DynamicObject[0]);
        PlatUtil.executeWithTXNew(tx -> {
            try {
                DynamicObject[] templates = TemplateCatalogHelper.getTemplatesByCatalogIds(modelId, catalogIds);
                if (templates != null && templates.length > 0) {
                    for (DynamicObject template : templates) {
                        template.set("templatecatalog", (Object)catalog.getLong("parent.id"));
                    }
                    SaveServiceHelper.save((DynamicObject[])templates);
                }
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"fidm_tmplcatalog"), (Object[])catalogIds.toArray());
                ArrayList<QFilter> qFilters1 = new ArrayList<QFilter>(6);
                qFilters1.add(new QFilter("model", "=", (Object)modelId));
                qFilters1.add(new QFilter("catalogtype", "=", (Object)AppCatalogTypeEnum.FIDM_CATALOG.getType()));
                qFilters1.add(new QFilter("parent", "=", (Object)catalog.getLong("parent.id")));
                qFilters1.add(new QFilter("id", "!=", (Object)catalogId));
                boolean existsChild = QueryServiceHelper.exists((String)"fidm_tmplcatalog", (QFilter[])qFilters1.toArray(new QFilter[0]));
                if (!existsChild) {
                    DynamicObject parent = BusinessDataServiceHelper.loadSingle((Object)catalog.getLong("parent.id"), (String)"fidm_tmplcatalog");
                    parent.set("isleaf", (Object)true);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{parent});
                }
                Iterator iterator = catalogIds.iterator();
                while (iterator.hasNext()) {
                    long id = (Long)iterator.next();
                    PermissionHelper.savePermClassEntity(modelId, id, "fidm_tmplcatalog", 0L, OperationStatus.EDIT);
                }
                DisclosureLogHelper.writeTemplateCataLog(OperationResult.SUCCESS, OperationName.CATALOG_DELETE, modelInfo, catalogs);
            }
            catch (Exception ex) {
                DisclosureLogHelper.writeTemplateCataLog(OperationResult.FAILURE, OperationName.CATALOG_DELETE, modelInfo, catalogs);
                throw ex;
            }
        });
        return ResultInfo.success(catalogId);
    }

    public static ResultInfo moveCatalog(long modelId, long catalogId, int type) {
        long moveId;
        DynamicObject[] dys;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        qFilters.add(new QFilter("catalogtype", "=", (Object)AppCatalogTypeEnum.FIDM_CATALOG.getType()));
        qFilters.add(new QFilter("id", "=", (Object)catalogId));
        DynamicObject currentCatalog = BusinessDataServiceHelper.loadSingle((String)"fidm_tmplcatalog", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (currentCatalog == null) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u5206\u7c7b\u5df2\u4e0d\u5b58\u5728\u6216\u65e0\u6743\u9650\u3002", (String)"TemplateCatalogHelper_6", (String)"epm-far-business", (Object[])new Object[0]));
        }
        if (!TemplateCatalogHelper.hasWritePermission(modelId, currentCatalog.getLong("parent.id"))) {
            return ResultInfo.fail(ResManager.loadKDString((String)"\u4e0a\u7ea7\u5206\u7c7b\u4e0d\u5b58\u5728\u6216\u65e0\u6743\u9650\u3002", (String)"TemplateCatalogHelper_5", (String)"epm-far-business", (Object[])new Object[0]));
        }
        int seq = currentCatalog.getInt("sequence");
        ArrayList<QFilter> qMoveFilters = new ArrayList<QFilter>(6);
        qMoveFilters.add(new QFilter("model", "=", (Object)modelId));
        qMoveFilters.add(new QFilter("catalogtype", "=", (Object)AppCatalogTypeEnum.FIDM_CATALOG.getType()));
        qMoveFilters.add(new QFilter("parent", "=", (Object)currentCatalog.getLong("parent.id")));
        if (type == 1) {
            qMoveFilters.add(new QFilter("sequence", "<", (Object)seq));
            dys = BusinessDataServiceHelper.load((String)"fidm_tmplcatalog", (String)"id,sequence", (QFilter[])qMoveFilters.toArray(new QFilter[0]), (String)"sequence desc", (int)1);
            if (dys == null || dys.length == 0) {
                return ResultInfo.fail(ResManager.loadKDString((String)"\u8be5\u5206\u7c7b\u5df2\u662f\u5f53\u524d\u7236\u8282\u70b9\u7684\u7b2c\u4e00\u4e2a\uff0c\u4e0d\u80fd\u4e0a\u79fb\u3002", (String)"TemplateCatalogHelper_9", (String)"epm-far-business", (Object[])new Object[0]));
            }
            moveId = dys[0].getLong("id");
        } else {
            qMoveFilters.add(new QFilter("sequence", ">", (Object)seq));
            dys = BusinessDataServiceHelper.load((String)"fidm_tmplcatalog", (String)"id,sequence", (QFilter[])qMoveFilters.toArray(new QFilter[0]), (String)"sequence asc", (int)1);
            if (dys == null || dys.length == 0) {
                return ResultInfo.fail(ResManager.loadKDString((String)"\u8be5\u5206\u7c7b\u5df2\u662f\u5f53\u524d\u7236\u8282\u70b9\u7684\u6700\u540e\u4e00\u4e2a\uff0c\u4e0d\u80fd\u4e0b\u79fb\u3002", (String)"TemplateCatalogHelper_10", (String)"epm-far-business", (Object[])new Object[0]));
            }
            moveId = dys[0].getLong("id");
        }
        DynamicObject dyMove = BusinessDataReader.loadSingle((Object)moveId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fidm_tmplcatalog"));
        if (dyMove != null) {
            currentCatalog.set("sequence", (Object)dyMove.getInt("sequence"));
            dyMove.set("sequence", (Object)seq);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{currentCatalog, dyMove});
        }
        return ResultInfo.success(moveId);
    }

    private static boolean existsCatalogByNumber(long modelId, String number) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        qFilters.add(new QFilter("catalogtype", "=", (Object)AppCatalogTypeEnum.FIDM_CATALOG.getType()));
        qFilters.add(new QFilter("number", "=", (Object)number));
        return QueryServiceHelper.exists((String)"fidm_tmplcatalog", (QFilter[])qFilters.toArray(new QFilter[0]));
    }

    private static boolean existsCatalogByName(long modelId, long id, String name) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        qFilters.add(new QFilter("catalogtype", "=", (Object)AppCatalogTypeEnum.FIDM_CATALOG.getType()));
        qFilters.add(new QFilter("name", "=", (Object)name));
        qFilters.add(new QFilter("id", "!=", (Object)id));
        return QueryServiceHelper.exists((String)"fidm_tmplcatalog", (QFilter[])qFilters.toArray(new QFilter[0]));
    }

    private static int getMaxDesq(long modelId, long parentId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        qFilters.add(new QFilter("catalogtype", "=", (Object)AppCatalogTypeEnum.FIDM_CATALOG.getType()));
        qFilters.add(new QFilter("parent", "=", (Object)parentId));
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"fidm_tmplcatalog", (String)"sequence", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"sequence desc", (int)1);
        if (dys != null && !dys.isEmpty()) {
            return ((DynamicObject)dys.get(0)).getInt("sequence") + 1;
        }
        return 1;
    }

    private static List<Long> getCatalogIdsByLongNumber(long modelId, String longNumber) {
        ArrayList<Long> ids = new ArrayList<Long>(6);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(6);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        qFilters.add(new QFilter("catalogtype", "=", (Object)AppCatalogTypeEnum.FIDM_CATALOG.getType()));
        qFilters.add(new QFilter("longnumber", "like", (Object)(longNumber + ".%")));
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"fidm_tmplcatalog", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (dys != null) {
            for (DynamicObject row : dys) {
                ids.add(row.getLong("id"));
            }
        }
        return ids;
    }

    private static DynamicObject[] getTemplatesByCatalogIds(long modelId, List<Long> catalogIds) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(5);
        qFilters.add(new QFilter("model", "=", (Object)modelId));
        qFilters.add(new QFilter("outputtype", "=", (Object)String.valueOf(1)));
        qFilters.add(new QFilter("templatecatalog.catalogtype", "=", (Object)AppCatalogTypeEnum.FIDM_CATALOG.getType()));
        qFilters.add(new QFilter("templatecatalog.id", "in", catalogIds));
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"fidm_template", (String)"id", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (dys != null) {
            ArrayList<Long> ids = new ArrayList<Long>(dys.size());
            for (DynamicObject dy : dys) {
                ids.add(dy.getLong("id"));
            }
            return BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fidm_template"));
        }
        return new DynamicObject[0];
    }

    public static DynamicObject addCatalogRoot(Long dmModelId, DiscTemplateCatalogTypeEnum catalogTypeEnum) {
        QFilter mqFilter = new QFilter("model", "=", (Object)dmModelId);
        QFilter nqFilter = new QFilter("number", "=", (Object)"root");
        QFilter catelogType = new QFilter("catalogtype", "=", (Object)catalogTypeEnum.getType());
        DynamicObject catalog = BusinessDataServiceHelper.loadSingle((String)"fidm_tmplcatalog", (QFilter[])new QFilter[]{mqFilter, nqFilter, catelogType});
        if (catalog == null) {
            catalog = BusinessDataServiceHelper.newDynamicObject((String)"fidm_tmplcatalog");
            catalog.set("model", (Object)dmModelId);
            catalog.set("number", (Object)"root");
            catalog.set("longnumber", (Object)"root");
            catalog.set("name", catalogTypeEnum.getLanguageName());
            catalog.set("isleaf", (Object)Boolean.TRUE);
            catalog.set("catalogtype", (Object)catalogTypeEnum.getType());
            catalog.set("status", (Object)"C");
            catalog.set("enable", (Object)"1");
            SaveServiceHelper.save((IDataEntityType)catalog.getDynamicObjectType(), (Object[])new Object[]{catalog});
        }
        return catalog;
    }

    public static boolean hasWritePermission(long modelId, long catalogId) {
        boolean result;
        DynamicObject catalog = BusinessDataServiceHelper.loadSingleFromCache((Object)catalogId, (String)"fidm_tmplcatalog");
        if (catalog != null && (result = PermissionHelper.hasWritePerm(modelId, "fidm_tmplcatalog", catalogId))) {
            if (catalog.getLong("parent.id") == 0L) {
                return true;
            }
            return TemplateCatalogHelper.hasWritePermission(modelId, catalog.getLong("parent.id"));
        }
        return false;
    }
}

