/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.template.convert;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.config.DMConfigServiceHelper;
import kd.epm.far.business.common.enums.OpenWordEnum;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.module.ModuleServiceHelper;
import kd.epm.far.business.fidm.base.DisclosureFileHelper;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.base.DisclosureLogHelper;
import kd.epm.far.business.fidm.base.DisclosureZipFileHelper;
import kd.epm.far.business.fidm.base.dto.ZipFileItem;
import kd.epm.far.business.fidm.template.convert.DisclosureTemplateSplitFileHelper;
import kd.epm.far.business.fidm.template.convert.dto.TemplateSplitWordDto;
import kd.epm.far.business.fidm.template.convert.dto.TemplateUploadFile;
import kd.epm.far.business.fidm.template.convert.dto.TemplateUploadParam;
import kd.epm.far.business.fidm.template.convert.dto.TemplateUploadSingleParam;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.log.oplog.OperationName;
import kd.epm.far.common.common.log.oplog.OperationResult;
import kd.epm.far.common.common.util.GlobalIdUtil;
import kd.epm.far.common.common.util.LongUtil;

public class DisclosureTemplateImportService {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(DisclosureTemplateImportService.class);
    public static final List<String> FileTypeFilter = Arrays.asList(".doc", ".docx");
    public static final String ReportNumberPrefix = "ReportNumber";

    public static String getNewTemplateNumber(Long dmModelId, int index) {
        String templateNumber = ReportNumberPrefix + (index < 10 ? "0" + index : Integer.valueOf(index));
        QFilter filter = new QFilter("model", "=", (Object)dmModelId);
        filter.and(new QFilter("number", "like", (Object)"ReportNumber%"));
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"fidm_template", (String)"number", (QFilter[])filter.toArray());
        List existNumberList = dys.stream().map(m -> m.getString("number")).collect(Collectors.toList());
        if (existNumberList.size() == 0) {
            return templateNumber;
        }
        String baseTemplateNumber = templateNumber;
        int childIndex = 1;
        if (existNumberList.contains(templateNumber)) {
            templateNumber = baseTemplateNumber + "-" + (childIndex < 10 ? "0" + childIndex : Integer.valueOf(childIndex));
            while (existNumberList.contains(templateNumber)) {
                templateNumber = baseTemplateNumber + "-" + (++childIndex < 10 ? "0" + childIndex : Integer.valueOf(childIndex));
            }
            return templateNumber;
        }
        return templateNumber;
    }

    public static List<ZipFileItem> getWordFile(List<TemplateUploadFile> fileList) {
        ArrayList<ZipFileItem> fileItemList = new ArrayList<ZipFileItem>(100);
        for (TemplateUploadFile file : fileList) {
            if (".zip".equalsIgnoreCase(file.getFileType())) {
                List<ZipFileItem> zipFileItemList = DisclosureZipFileHelper.unzipFile(file.getUrl(), FileTypeFilter, DisclosureFileHelper.getUrlPrefix(), file.getFileType());
                if (zipFileItemList.size() <= 0) continue;
                fileItemList.addAll(zipFileItemList);
                continue;
            }
            ZipFileItem zipFileItem = new ZipFileItem();
            zipFileItem.setTempFile(file.isTempFile());
            zipFileItem.setUrl(file.getUrl());
            zipFileItem.setFileName(file.getFileName());
            fileItemList.add(zipFileItem);
        }
        return fileItemList;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean createChapter(TemplateUploadParam uploadParam) {
        String openType = DMConfigServiceHelper.getAndCheckOpenWordEnum();
        OpenWordEnum openWordEnum = OpenWordEnum.WEB;
        if (OpenWordEnum.WPSPLUGIN.getType().equalsIgnoreCase(openType)) {
            openWordEnum = OpenWordEnum.WPSPLUGIN;
        }
        int index = 0;
        ArrayList<Object> singleParamList = new ArrayList<Object>(uploadParam.getZipFileItems().size());
        for (ZipFileItem zipFileItem : uploadParam.getZipFileItems()) {
            ++index;
            Object singleParam = new TemplateUploadSingleParam();
            ((TemplateUploadSingleParam)singleParam).setSourceTemplateId(uploadParam.getTemplateId());
            ((TemplateUploadSingleParam)singleParam).setTemplateId(null);
            ((TemplateUploadSingleParam)singleParam).setDmModelId(uploadParam.getDmModelId());
            ((TemplateUploadSingleParam)singleParam).setConvertmodule(uploadParam.isConvertmodule());
            ((TemplateUploadSingleParam)singleParam).setSplit(uploadParam.isSplit());
            ((TemplateUploadSingleParam)singleParam).setOpenAfterCreate(uploadParam.isOpenAfterCreate());
            ((TemplateUploadSingleParam)singleParam).setSplititem(uploadParam.getSplititem());
            ((TemplateUploadSingleParam)singleParam).setZipFileItem(zipFileItem);
            ((TemplateUploadSingleParam)singleParam).setIndex(index);
            if (index == 1) {
                ((TemplateUploadSingleParam)singleParam).setTemplateId(uploadParam.getTemplateId());
            }
            singleParamList.add(singleParam);
        }
        if (!uploadParam.isSplit() && uploadParam.getZipFileItems().size() > 1) {
            ArrayList<TemplateSplitWordDto> fileDataList = new ArrayList<TemplateSplitWordDto>(100);
            for (Object singleParam : singleParamList) {
                List<TemplateSplitWordDto> dtoList = DisclosureTemplateSplitFileHelper.splitWord(((TemplateUploadSingleParam)singleParam).getZipFileItem(), "1", ((TemplateUploadSingleParam)singleParam).isConvertmodule());
                for (TemplateSplitWordDto templateSplitWordDto : dtoList) {
                    templateSplitWordDto.setFileName(DisclosureFileHelper.getFileNameNotFileType(((TemplateUploadSingleParam)singleParam).getZipFileItem().getFileName()));
                }
                if (dtoList.size() <= 0) continue;
                fileDataList.addAll(dtoList);
            }
            boolean bl = true;
            for (TemplateSplitWordDto fileData : fileDataList) {
                void var10_22;
                void var6_9;
                String chapterNumber = DisclosureTemplateImportService.getChapterNumber((int)var6_9);
                String string = DisclosureFileHelper.getFileNameNotFileType(fileData.getFileName());
                if (StringUtils.isEmpty((String)string)) {
                    String string2 = ResManager.loadKDString((String)"\u6b63\u6587", (String)"DisclosureServiceHelper_27", (String)"epm-far-business", (Object[])new Object[0]);
                }
                ByteArrayInputStream finalInputStream = new ByteArrayInputStream(fileData.getFileData());
                Long newChapterId = GlobalIdUtil.genGlobalLongId();
                String url = DisclosureFileHelper.saveAsNew(finalInputStream, "fidm", "fidm_webdesign", newChapterId, (String)var10_22);
                DisclosureTemplateImportService.createChapter(uploadParam.getDmModelId(), uploadParam.getTemplateId(), newChapterId, chapterNumber, (String)var10_22, openWordEnum, url, (int)var6_9, fileData.getModuleList());
                ++var6_9;
            }
        } else {
            for (TemplateUploadSingleParam templateUploadSingleParam : singleParamList) {
                List<Object> fileDataList = new ArrayList(100);
                fileDataList = DisclosureTemplateSplitFileHelper.splitWord(templateUploadSingleParam.getZipFileItem(), templateUploadSingleParam.getSplititem(), templateUploadSingleParam.isConvertmodule());
                if (!LongUtil.isvalidLong((Object)templateUploadSingleParam.getTemplateId())) {
                    Long l;
                    String templateNumber = DisclosureTemplateImportService.getNewTemplateNumber(templateUploadSingleParam.getDmModelId(), templateUploadSingleParam.getIndex());
                    String templateName = DisclosureFileHelper.getFileNameNotFileType(templateUploadSingleParam.getZipFileItem().getFileName());
                    if (StringUtils.isEmpty((String)templateName)) {
                        templateName = templateNumber;
                    }
                    if (LongUtil.isvalidLong((Object)(l = DisclosureTemplateImportService.copyTempalte(templateUploadSingleParam.getSourceTemplateId(), templateNumber, templateName)))) {
                        templateUploadSingleParam.setTemplateId(l);
                    }
                }
                if (!LongUtil.isvalidLong((Object)templateUploadSingleParam.getTemplateId())) continue;
                int chapterIndex = 1;
                for (TemplateSplitWordDto templateSplitWordDto : fileDataList) {
                    String chapterNumber = DisclosureTemplateImportService.getChapterNumber(chapterIndex);
                    String chapterName = DisclosureFileHelper.getFileNameNotFileType(templateSplitWordDto.getFileName());
                    if (StringUtils.isEmpty((String)chapterName)) {
                        chapterName = ResManager.loadKDString((String)"\u6b63\u6587", (String)"DisclosureServiceHelper_27", (String)"epm-far-business", (Object[])new Object[0]);
                    }
                    ByteArrayInputStream finalInputStream = new ByteArrayInputStream(templateSplitWordDto.getFileData());
                    Long newChapterId = GlobalIdUtil.genGlobalLongId();
                    String url = DisclosureFileHelper.saveAsNew(finalInputStream, "fidm", "fidm_webdesign", newChapterId, chapterName);
                    DisclosureTemplateImportService.createChapter(templateUploadSingleParam.getDmModelId(), templateUploadSingleParam.getTemplateId(), newChapterId, chapterNumber, chapterName, openWordEnum, url, chapterIndex, templateSplitWordDto.getModuleList());
                    ++chapterIndex;
                }
            }
        }
        return true;
    }

    private static String getChapterNumber(int index) {
        String indexStr = String.valueOf(index);
        if (indexStr.length() == 1) {
            return "00" + indexStr;
        }
        if (indexStr.length() == 2) {
            return "0" + indexStr;
        }
        return indexStr;
    }

    private static void createChapter(Long dmModelId, Long templateId, Long newChapterId, String chapterNumber, String chapterName, OpenWordEnum openWordEnum, String url, int sequence, List<JSONObject> moduleList) {
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        DynamicObject template = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"fidm_template");
        if (template == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u544a\u6a21\u677f\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"DisclosureServiceHelper_7", (String)"epm-far-business", (Object[])new Object[0]));
        }
        template.set("modifytime", (Object)TimeServiceHelper.now());
        DynamicObject chapter = BusinessDataServiceHelper.newDynamicObject((String)"fidm_chapter");
        chapter.set("id", (Object)newChapterId);
        chapter.set("model", (Object)template.getLong("model.id"));
        chapter.set("template", (Object)templateId);
        chapter.set("number", (Object)chapterNumber);
        chapter.set("name", (Object)chapterName);
        chapter.set("status", (Object)"A");
        chapter.set("enable", (Object)"1");
        chapter.set("commitstatus", (Object)"A");
        chapter.set("sequence", (Object)sequence);
        chapter.set("url", (Object)url);
        chapter.set("createtime", (Object)new Date());
        chapter.set("creator", (Object)RequestContext.get().getUserId());
        chapter.set("masterid", (Object)GlobalIdUtil.genGlobalLongId());
        chapter.set("savewordtype", (Object)openWordEnum.getTypeToInt());
        chapter.set("comefrom", (Object)OpenWordEnum.getComefromByType(chapter.getString("savewordtype")).getType());
        DynamicObjectCollection chapterModules = chapter.getDynamicObjectCollection("entryentity");
        ArrayList<DynamicObject> moduleDyList = new ArrayList<DynamicObject>(moduleList.size());
        ArrayList<Long> moduleIds = new ArrayList<Long>(moduleList.size());
        int moduleIndex = 1;
        for (JSONObject module : moduleList) {
            Long moduleId = module.getLong("id");
            String bookmarkKey = DisclosureJsonHelper.getValue(module, "bookmark", "key", "");
            DynamicObject chapterModule = new DynamicObject(chapterModules.getDynamicObjectType());
            chapterModule.set("module", (Object)moduleId);
            chapterModule.set("key", (Object)bookmarkKey);
            chapterModule.set("seq", (Object)moduleIndex);
            chapterModule.set("id", (Object)GlobalIdUtil.genGlobalLongId());
            chapterModules.add((Object)chapterModule);
            DynamicObject moduleDy = BusinessDataServiceHelper.newDynamicObject((String)"fidm_modulerepository");
            moduleDy.set("id", (Object)moduleId);
            moduleDy.set("model", (Object)dmModelId);
            moduleDy.set("template", (Object)templateId);
            moduleDy.set("status", (Object)"1");
            moduleDy.set("creator", (Object)RequestContext.get().getCurrUserId());
            moduleDy.set("createtime", (Object)TimeServiceHelper.now());
            moduleDy.set("modifier", (Object)RequestContext.get().getCurrUserId());
            moduleDy.set("modifytime", (Object)TimeServiceHelper.now());
            moduleDy.set("number", (Object)module.getString("number"));
            moduleDy.set("name", (Object)ModuleServiceHelper.converToModuleName(module.getString("name")));
            moduleDy.set("type", (Object)module.getString("type"));
            moduleDy.set("datasetid", (Object)DisclosureJsonHelper.getValue(module, "dataset", "id", 0L));
            moduleDy.set("scope", (Object)"1");
            moduleDy.set("properties", (Object)module.toJSONString());
            moduleDyList.add(moduleDy);
            moduleIds.add(moduleId);
            ++moduleIndex;
        }
        try (TXHandle tx = TX.required();){
            try {
                if (moduleIds.size() > 0) {
                    DeleteServiceHelper.delete((String)"fidm_modulerepository", (QFilter[])new QFilter[]{new QFilter("id", "in", moduleIds)});
                }
                if (moduleDyList.size() > 0) {
                    SaveServiceHelper.save((DynamicObject[])moduleDyList.toArray(new DynamicObject[0]));
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{chapter});
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{template});
            }
            catch (Exception ex) {
                tx.markRollback();
                logger.error("createChapter error", (Throwable)ex);
                DisclosureLogHelper.writeTemplateChapter(OperationResult.FAILURE, OperationName.SAVE, modelStrategyEx.getModel().getModelInfo(), template, chapter);
                throw new KDBizException(ResManager.loadKDString((String)"\u521b\u5efa\u7ae0\u8282\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u8be6\u60c5\u65e5\u5fd7\u3002", (String)"DisclosureServiceHelper_26", (String)"epm-far-business", (Object[])new Object[0]));
            }
        }
    }

    private static Long copyTempalte(Long sourceTemplateId, String newNumber, String newName) {
        Long newId = 0L;
        DynamicObject sourceTemplateDy = BusinessDataServiceHelper.loadSingle((Object)sourceTemplateId, (String)"fidm_template");
        if (sourceTemplateDy == null) {
            return newId;
        }
        try (TXHandle tx = TX.required();){
            try {
                DynamicObject user = BusinessDataServiceHelper.newDynamicObject((String)"bos_user");
                user.set("id", (Object)RequestContext.get().getCurrUserId());
                Date date = new Date();
                CloneUtils cloneUtils = new CloneUtils(true, true);
                DynamicObject newTemplate = (DynamicObject)cloneUtils.clone((IDataEntityBase)sourceTemplateDy);
                newTemplate.set("number", (Object)newNumber);
                newTemplate.set("name", (Object)newName);
                newTemplate.set("creator", (Object)user);
                newTemplate.set("createtime", (Object)date);
                newTemplate.set("modifier", (Object)user);
                newTemplate.set("modifytime", (Object)date);
                newTemplate.set("status", (Object)"0");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newTemplate});
                newId = newTemplate.getLong("id");
                DisclosureLogHelper.writeTemplate("fidm_templatelist", OperationResult.SUCCESS, OperationName.CREATE, newId);
            }
            catch (Exception e) {
                tx.markRollback();
                DisclosureLogHelper.writeTemplate("fidm_templatelist", OperationResult.FAILURE, OperationName.CREATE, newId);
            }
        }
        return newId;
    }
}

