/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.template.convert;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.ModuleEnum;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.module.DisclosureDefaultJsonHelper;
import kd.epm.far.business.fidm.template.convert.dto.TemplateTextSplitDto;
import kd.epm.far.business.fidm.word.dto.WordModuleNode;
import kd.epm.far.business.fidm.word.dto.WordNode;
import kd.epm.far.business.fidm.word.dto.WordParagraphNode;
import kd.epm.far.business.fidm.word.dto.WordRootNode;
import kd.epm.far.business.fidm.word.dto.WordTableCellNode;
import kd.epm.far.business.fidm.word.dto.WordTableNode;
import kd.epm.far.business.fidm.word.dto.WordTableRowNode;
import kd.epm.far.business.fidm.word.dto.WordTextNode;
import kd.epm.far.business.fidm.word.helper.WordBookmarkHelper;
import kd.epm.far.business.fidm.word.helper.WordModuleNodeHelper;
import kd.epm.far.business.fidm.word.helper.WordNodeJsonHelper;
import kd.epm.far.common.common.util.GlobalIdUtil;

public class DisclosureTemplateModuleHelper {
    public static List<JSONObject> createModuelList(List<WordRootNode> rootNodes, boolean isConvertModule) {
        ArrayList<JSONObject> moduleList = new ArrayList<JSONObject>(100);
        LinkedHashMap<String, Integer> moduleMap = new LinkedHashMap<String, Integer>(100);
        for (WordRootNode rootNode : rootNodes) {
            List<JSONObject> modules = DisclosureTemplateModuleHelper.createModuelList(rootNode, moduleMap, isConvertModule);
            if (modules.size() <= 0) continue;
            moduleList.addAll(modules);
        }
        return moduleList;
    }

    private static List<JSONObject> createModuelList(WordRootNode rootNode, Map<String, Integer> moduleMap, boolean isConvertModule) {
        ArrayList<JSONObject> moduleList = new ArrayList<JSONObject>(100);
        for (WordNode wordNode : rootNode.getChilds()) {
            WordParagraphNode paragraphNode;
            List<JSONObject> modules;
            if (wordNode instanceof WordTableNode) {
                List<JSONObject> modules2 = DisclosureTemplateModuleHelper.createModuelList((WordTableNode)wordNode, moduleMap, isConvertModule);
                if (modules2.size() <= 0) continue;
                moduleList.addAll(modules2);
                continue;
            }
            if (!(wordNode instanceof WordParagraphNode) || (modules = DisclosureTemplateModuleHelper.createModuelList(paragraphNode = (WordParagraphNode)wordNode, moduleMap, isConvertModule)).size() <= 0) continue;
            moduleList.addAll(modules);
        }
        return moduleList;
    }

    private static List<JSONObject> createModuelList(WordTableNode tableNode, Map<String, Integer> moduleMap, boolean isConvertModule) {
        ArrayList<JSONObject> moduleList = new ArrayList<JSONObject>(100);
        for (WordNode rowWordNode : tableNode.getChilds()) {
            if (!(rowWordNode instanceof WordTableRowNode)) continue;
            WordTableRowNode rowNode = (WordTableRowNode)rowWordNode;
            for (WordNode cellWordNode : rowNode.getChilds()) {
                if (!(cellWordNode instanceof WordTableCellNode)) continue;
                WordTableCellNode cellNode = (WordTableCellNode)cellWordNode;
                for (WordNode paragraphWordNode : cellNode.getChilds()) {
                    List<JSONObject> modules;
                    if (!(paragraphWordNode instanceof WordParagraphNode) || (modules = DisclosureTemplateModuleHelper.createModuelList((WordParagraphNode)paragraphWordNode, moduleMap, isConvertModule)).size() <= 0) continue;
                    moduleList.addAll(modules);
                }
            }
        }
        return moduleList;
    }

    private static List<JSONObject> createModuelList(WordParagraphNode paragraphNode, Map<String, Integer> moduleMap, boolean isConvertModule) {
        ArrayList<TemplateTextSplitDto> moduleList = new ArrayList<TemplateTextSplitDto>(100);
        int index = 0;
        while (index < paragraphNode.getChilds().size()) {
            WordNode wordNode = paragraphNode.getChilds().get(index);
            ++index;
            if (!(wordNode instanceof WordTextNode)) continue;
            WordTextNode source = (WordTextNode)wordNode;
            List<WordModuleNode> chartNodes = WordModuleNodeHelper.getWordModuleNodes(source);
            if (!isConvertModule) {
                source.getChilds().removeAll(chartNodes);
                chartNodes = new ArrayList<WordModuleNode>(1);
            }
            List<TemplateTextSplitDto> dtoList = DisclosureTemplateModuleHelper.createModuelList(source, moduleMap);
            if (chartNodes.size() > 0) {
                for (WordModuleNode wordModuleNode : chartNodes) {
                    TemplateTextSplitDto chartModule = DisclosureTemplateModuleHelper.createModule(moduleMap, wordModuleNode);
                    if (chartModule == null) continue;
                    dtoList.add(chartModule);
                }
                source.getChilds().removeAll(chartNodes);
            }
            for (TemplateTextSplitDto dto : dtoList) {
                if (dto.getModule() == null) continue;
                moduleList.add(dto);
            }
            if (dtoList.size() == 0) continue;
            if (dtoList.size() == 1) {
                DisclosureTemplateModuleHelper.setBookmark(source, dtoList.get(0));
                continue;
            }
            TemplateTextSplitDto moduleDto = dtoList.stream().filter(m -> m.getModule() != null).findFirst().orElse(null);
            if (moduleDto == null) continue;
            List<WordTextNode> newTextNodes = DisclosureTemplateModuleHelper.merge(source, dtoList);
            paragraphNode.getChilds().remove(index - 1);
            for (int i = newTextNodes.size() - 1; i >= 0; --i) {
                paragraphNode.getChilds().add(index - 1, newTextNodes.get(i));
            }
            index = index + newTextNodes.size() - 1;
        }
        return moduleList.stream().map(m -> m.getModule()).collect(Collectors.toList());
    }

    private static List<WordTextNode> merge(WordTextNode source, List<TemplateTextSplitDto> dtoList) {
        if (dtoList == null || dtoList.size() == 0) {
            return new ArrayList<WordTextNode>(1);
        }
        ArrayList<WordTextNode> wordTextNodes = new ArrayList<WordTextNode>(dtoList.size());
        WordTextNode cur = DisclosureTemplateModuleHelper.copyTextNode(source);
        boolean childreIsSet = false;
        for (TemplateTextSplitDto dto : dtoList) {
            if (dto.getModule() != null) {
                if (StringUtils.isNotEmpty((String)cur.getContent())) {
                    if (childreIsSet) {
                        cur.getChilds().clear();
                    } else {
                        childreIsSet = true;
                    }
                    wordTextNodes.add(cur);
                    cur = DisclosureTemplateModuleHelper.copyTextNode(source);
                }
                WordTextNode moduleTextNode = DisclosureTemplateModuleHelper.copyTextNode(source);
                moduleTextNode.getChilds().clear();
                moduleTextNode.setContent(dto.getText());
                DisclosureTemplateModuleHelper.setBookmark(moduleTextNode, dto);
                wordTextNodes.add(moduleTextNode);
                continue;
            }
            cur.setContent(cur.getContent() + dto.getText());
        }
        if (StringUtils.isNotEmpty((String)cur.getContent())) {
            if (childreIsSet) {
                cur.getChilds().clear();
            }
            wordTextNodes.add(cur);
        }
        return wordTextNodes;
    }

    private static WordTextNode copyTextNode(WordTextNode source) {
        WordTextNode cur = WordNodeJsonHelper.copyEx(source, WordTextNode.class);
        cur.setBookMarkKeys(new ArrayList<String>(1));
        cur.setId("");
        cur.setContent("");
        return cur;
    }

    private static void setBookmark(WordTextNode textNode, TemplateTextSplitDto dto) {
        if (dto == null || dto.getModule() == null) {
            return;
        }
        String bookmark = DisclosureJsonHelper.getValue(dto.getModule(), "bookmark", "key", "");
        textNode.setBookMarkKeys(Collections.singletonList(bookmark));
        textNode.setContent(dto.getText());
    }

    private static List<TemplateTextSplitDto> createModuelList(WordTextNode textNode, Map<String, Integer> moduleMap) {
        ArrayList<TemplateTextSplitDto> dtoList = new ArrayList<TemplateTextSplitDto>(100);
        String content = textNode.getContent();
        if (StringUtils.isEmpty((String)content)) {
            return dtoList;
        }
        String[] splitStrs = content.split("\\{\\{");
        for (int i = 0; i < splitStrs.length; ++i) {
            String itemName;
            ModuleEnum moduleEnum;
            if (i == 0) continue;
            String item = splitStrs[i];
            JSONObject module = null;
            int begin = 0;
            int end = item.indexOf("}}");
            if (begin < end && begin >= 0 && (moduleEnum = DisclosureTemplateModuleHelper.getModuleEnumByName(itemName = item.substring(begin, end - begin))) != null && (module = DisclosureTemplateModuleHelper.createModule(moduleMap, moduleEnum)) != null) {
                TemplateTextSplitDto dto = new TemplateTextSplitDto();
                dto.setModule(module);
                dto.setText("{{" + module.getString("name") + "}}");
                dtoList.add(dto);
                if (item.length() > end + 2) {
                    TemplateTextSplitDto dto2 = new TemplateTextSplitDto();
                    dto2.setModule(null);
                    dto2.setText(item.substring(end + 2, item.length()));
                    dtoList.add(dto2);
                }
            }
            if (module != null) continue;
            item = "{{" + item;
            TemplateTextSplitDto dto = new TemplateTextSplitDto();
            dto.setModule(null);
            dto.setText(item);
            dtoList.add(dto);
        }
        return dtoList;
    }

    private static TemplateTextSplitDto createModule(Map<String, Integer> moduleMap, WordModuleNode wordModuleNode) {
        if (wordModuleNode == null || StringUtils.isEmpty((String)wordModuleNode.getModuleType())) {
            return null;
        }
        ModuleEnum moduleEnum = null;
        for (ModuleEnum value : ModuleEnum.values()) {
            if (!value.getType().equals(wordModuleNode.getModuleType().trim())) continue;
            moduleEnum = value;
        }
        JSONObject module = DisclosureTemplateModuleHelper.createModule(moduleMap, moduleEnum);
        if (module == null) {
            return null;
        }
        TemplateTextSplitDto dto = new TemplateTextSplitDto();
        dto.setModule(module);
        dto.setText("{{" + module.getString("name") + "}}");
        return dto;
    }

    private static JSONObject createModule(Map<String, Integer> moduleMap, ModuleEnum moduleEnum) {
        if (moduleEnum == null) {
            return null;
        }
        Integer cur = moduleMap.get(moduleEnum.getType());
        cur = cur == null ? Integer.valueOf(1) : Integer.valueOf(cur + 1);
        moduleMap.put(moduleEnum.getType(), cur);
        return DisclosureTemplateModuleHelper.createModule(moduleEnum, cur);
    }

    private static JSONObject createModule(ModuleEnum moduleEnum, int index) {
        JSONObject module = DisclosureDefaultJsonHelper.getDefaultJsonObejct(moduleEnum, false);
        if (module != null) {
            Long moduleId = GlobalIdUtil.genGlobalLongId();
            String indexStr = index < 10 ? "0" + index : String.valueOf(index);
            module.put("id", (Object)moduleId.toString());
            module.put("number", (Object)(moduleEnum.getNumber() + indexStr));
            module.put("name", (Object)(moduleEnum.getName() + indexStr));
            String bookmarkKey = WordBookmarkHelper.createBookmarName(moduleId);
            WordBookmarkHelper.createBookmarkNode(module, bookmarkKey);
        }
        return module;
    }

    private static ModuleEnum getModuleEnumByName(String name) {
        for (ModuleEnum value : ModuleEnum.values()) {
            if (ModuleEnum.REPORT_SECTION.getType().equalsIgnoreCase(value.getType()) || ModuleEnum.EB_REPORT_SECTION.getType().equalsIgnoreCase(value.getType()) || !value.getName().equals(name)) continue;
            return value;
        }
        return null;
    }
}

