/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.template.convert;

import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.epm.far.business.fidm.base.DisclosureFileHelper;
import kd.epm.far.business.fidm.base.dto.ZipFileItem;
import kd.epm.far.business.fidm.template.convert.DisclosureTemplateModuleHelper;
import kd.epm.far.business.fidm.template.convert.dto.TemplateContentNodeDto;
import kd.epm.far.business.fidm.template.convert.dto.TemplateSplitWordDto;
import kd.epm.far.business.fidm.word.WordConvert;
import kd.epm.far.business.fidm.word.base.WordConstants;
import kd.epm.far.business.fidm.word.dto.WordNode;
import kd.epm.far.business.fidm.word.dto.WordParagraphNode;
import kd.epm.far.business.fidm.word.dto.WordRootNode;
import kd.epm.far.business.fidm.word.dto.WordTableNode;
import kd.epm.far.business.fidm.word.helper.WordParagraphNodeHelper;
import kd.epm.far.business.fidm.word.helper.WordRootHelper;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;

public class DisclosureTemplateSplitFileHelper {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(DisclosureTemplateSplitFileHelper.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<TemplateSplitWordDto> splitWord(ZipFileItem zipFileItem, String splititem, boolean isConvertModule) {
        ArrayList<TemplateSplitWordDto> templateSplitWordDtos = new ArrayList<TemplateSplitWordDto>(100);
        try (InputStream in = DisclosureFileHelper.getFileInputStream(zipFileItem.getUrl(), zipFileItem.isTempFile());){
            int titleLevel;
            WordConvert wordConvert = new WordConvert();
            List<WordRootNode> rootNodes = wordConvert.fromWord(in);
            WordRootNode headRoot = WordRootHelper.find(rootNodes, WordConstants.WordContentType.Head);
            WordRootNode footRoot = WordRootHelper.find(rootNodes, WordConstants.WordContentType.Foot);
            WordRootNode contentRoot = WordRootHelper.find(rootNodes, WordConstants.WordContentType.Content);
            if (contentRoot == null) {
                ArrayList<TemplateSplitWordDto> arrayList2 = templateSplitWordDtos;
                return arrayList2;
            }
            List<Object> newContentRoots = new ArrayList(100);
            newContentRoots = "2".equalsIgnoreCase(splititem) ? ((titleLevel = DisclosureTemplateSplitFileHelper.getMaxTitleStyle(contentRoot)) <= 0 ? DisclosureTemplateSplitFileHelper.splitByContent(contentRoot) : DisclosureTemplateSplitFileHelper.splitByTitleLevel(contentRoot, titleLevel)) : DisclosureTemplateSplitFileHelper.splitByContent(contentRoot);
            for (TemplateContentNodeDto templateContentNodeDto : newContentRoots) {
                try {
                    List<WordRootNode> newRootNodes = WordRootHelper.combine(templateContentNodeDto.getContent(), headRoot, footRoot);
                    List<JSONObject> moduelList = DisclosureTemplateModuleHelper.createModuelList(newRootNodes, isConvertModule);
                    byte[] fileData = wordConvert.toWord(newRootNodes);
                    TemplateSplitWordDto dto = new TemplateSplitWordDto();
                    dto.setFileData(fileData);
                    dto.setModuleList(moduelList);
                    dto.setFileName(templateContentNodeDto.getFileName());
                    templateSplitWordDtos.add(dto);
                }
                catch (Exception ex1) {
                    logger.error("splitWord error TemplateContentNodeDto item ", (Throwable)ex1);
                }
            }
            ArrayList<TemplateSplitWordDto> arrayList = templateSplitWordDtos;
            return arrayList;
        }
        catch (KDBizException kdBizException) {
            throw kdBizException;
        }
        catch (Exception ex) {
            logger.error("splitWord error ", (Throwable)ex);
            return templateSplitWordDtos;
        }
    }

    private static List<TemplateContentNodeDto> splitByTitleLevel(WordRootNode rootNode, int titleStyle) {
        ArrayList<TemplateContentNodeDto> rootNodes = new ArrayList<TemplateContentNodeDto>(100);
        String fileName = "";
        WordRootNode newRoot = new WordRootNode(WordConstants.WordContentType.Content.getType());
        for (WordNode wordNode : rootNode.getChilds()) {
            if (wordNode instanceof WordTableNode) {
                newRoot.getChilds().add(wordNode);
                continue;
            }
            if (!(wordNode instanceof WordParagraphNode)) continue;
            WordParagraphNode paragraphNode = (WordParagraphNode)wordNode;
            if (paragraphNode.getTitleStyle() == titleStyle) {
                if (newRoot.getChilds().size() > 0) {
                    TemplateContentNodeDto dto = new TemplateContentNodeDto();
                    dto.setContent(newRoot);
                    dto.setFileName(fileName);
                    rootNodes.add(dto);
                }
                newRoot = new WordRootNode(WordConstants.WordContentType.Content.getType());
                fileName = DisclosureTemplateSplitFileHelper.getTitleString(paragraphNode);
                newRoot.getChilds().add(wordNode);
                continue;
            }
            if (StringUtils.isEmpty((String)fileName)) {
                fileName = DisclosureTemplateSplitFileHelper.getTitleString(paragraphNode);
            }
            newRoot.getChilds().add(wordNode);
        }
        if (newRoot.getChilds().size() > 0) {
            TemplateContentNodeDto dto = new TemplateContentNodeDto();
            dto.setContent(newRoot);
            dto.setFileName(fileName);
            rootNodes.add(dto);
        }
        return rootNodes;
    }

    private static List<TemplateContentNodeDto> splitByContent(WordRootNode rootNode) {
        ArrayList<TemplateContentNodeDto> rootNodes = new ArrayList<TemplateContentNodeDto>(100);
        TemplateContentNodeDto dto = new TemplateContentNodeDto();
        dto.setContent(rootNode);
        dto.setFileName(ResManager.loadKDString((String)"\u6b63\u6587", (String)"DisclosureServiceHelper_27", (String)"epm-far-business", (Object[])new Object[0]));
        rootNodes.add(dto);
        return rootNodes;
    }

    private static String getTitleString(WordParagraphNode paragraphNode) {
        String fileName = WordParagraphNodeHelper.getString(paragraphNode, 40);
        if (StringUtils.isEmpty((String)fileName)) {
            return fileName;
        }
        return fileName.replace("{", "").replace("}", "");
    }

    private static int getMaxTitleStyle(WordRootNode rootNode) {
        int titleStyle = 10000;
        for (WordNode wordNode : rootNode.getChilds()) {
            WordParagraphNode paragraphNode;
            if (!(wordNode instanceof WordParagraphNode) || (paragraphNode = (WordParagraphNode)wordNode).getTitleStyle() <= 0 || paragraphNode.getTitleStyle() >= titleStyle) continue;
            titleStyle = paragraphNode.getTitleStyle();
        }
        if (titleStyle >= 1000) {
            titleStyle = 0;
        }
        return titleStyle;
    }
}

