/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.template.dto;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.far.business.fidm.template.dto.BaseEntry;
import kd.epm.far.business.fidm.template.dto.Dimension;
import kd.epm.far.business.fidm.template.dto.DiscTemplateModel;
import kd.epm.far.business.fidm.template.dto.ILoader;
import kd.epm.far.business.fidm.template.dto.Member;

public class DefaultDimensionEntry
extends BaseEntry
implements ILoader<DynamicObjectCollection, List<DefaultDimensionEntry>, DiscTemplateModel> {
    private static final long serialVersionUID = 1L;

    public DefaultDimensionEntry(DiscTemplateModel template) {
        super(template);
        this.setDataEntityNumber("fidm_template.defmembentry");
    }

    @Override
    protected DynamicObjectCollection genDynamicObjectCollection(DynamicObject parent, AtomicInteger incrementer) {
        DynamicObject dyna = this.convert2SimpleDynamicObject();
        DynamicObjectCollection coll = new DynamicObjectCollection(dyna.getDynamicObjectType(), (Object)parent);
        dyna.set("seq", (Object)incrementer.getAndIncrement());
        dyna.set("defdimtype", (Object)this.getDimension().getDataEntityNumber());
        dyna.set("defdimension", (Object)this.getDimension().getId());
        dyna.set("defmemberid", (Object)this.getMember().getId());
        coll.add((Object)dyna);
        return coll;
    }

    @Override
    protected boolean isIncludeField(Object key) {
        return super.isIncludeField(key) || "defdimtype".equals(key) || "defdimension".equals(key) || "defmemberid".equals(key);
    }

    @Override
    public List<DefaultDimensionEntry> loadDynaObject(DynamicObjectCollection dynamicObjects, Supplier<DiscTemplateModel> s) {
        ArrayList<DefaultDimensionEntry> entries = new ArrayList<DefaultDimensionEntry>();
        for (DynamicObject o : dynamicObjects) {
            DefaultDimensionEntry entry = new DefaultDimensionEntry(s.get());
            entry.setId(o.getLong("id"));
            entry.setSeq(o.getInt("seq"));
            Dimension d = new Dimension();
            DynamicObject dyna = BusinessDataServiceHelper.loadSingleFromCache((Object)o.getDynamicObject("defdimension").get("id"), (String)o.getString("defdimtype"), (String)"id,name,number,membermodel,fieldmapped");
            d.loadSimpleDynamicObject(dyna);
            d.setDataEntityNumber(dyna.getDataEntityType().getName());
            String membermodel = dyna.getString("membermodel");
            d.setMemberEntityNumber(membermodel);
            d.setFieldmapped(dyna.getString("fieldmapped"));
            entry.setDimension(d);
            Member m = new Member();
            m.setDimension(d);
            m.setDataEntityNumber(membermodel);
            DynamicObject memberDy = BusinessDataServiceHelper.loadSingleFromCache((Object)o.getLong("defmemberid"), (String)membermodel, (String)"id,name,number");
            m.loadSimpleDynamicObject(memberDy);
            entry.setMember(m);
            entries.add(entry);
        }
        return entries;
    }
}

