/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.template.dto;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.far.business.fidm.template.dto.DefaultDimensionEntry;
import kd.epm.far.business.fidm.template.dto.DynaEntityObject;
import kd.epm.far.business.fidm.template.dto.ParamDimensionEntry;
import kd.epm.far.business.fidm.template.dto.TemplateCatalog;
import kd.epm.far.common.common.util.ISupportGZip;
import kd.epm.far.common.common.util.ThrowableHelper;

public class DiscTemplateModel
extends DynaEntityObject
implements ISupportGZip {
    private static final long serialVersionUID = 1L;

    public DiscTemplateModel() {
        this.put("defmembentry", (Object)new ArrayList());
        this.put("parammembentry", (Object)new ArrayList());
        this.setDataEntityNumber("fidm_template");
    }

    public static DiscTemplateModel genTemplateModelById(Long templateId) {
        DynamicObject dyna = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"fidm_template");
        DiscTemplateModel templateModel = new DiscTemplateModel();
        templateModel.loadDynaObj2Model(dyna);
        return templateModel;
    }

    public String getDescription() {
        return (String)this.get("description");
    }

    public void setDescription(String description) {
        this.put("description", (Object)description);
    }

    public void addDefaultDimensionEntries(DefaultDimensionEntry entry) {
        this.getDefaultDimensionEntries().add(entry);
    }

    public List<DefaultDimensionEntry> getDefaultDimensionEntries() {
        return (List)this.get("defmembentry");
    }

    public void addParamDimensionEntries(ParamDimensionEntry entry) {
        this.getParamDimensionEntries().add(entry);
    }

    public List<ParamDimensionEntry> getParamDimensionEntries() {
        return (List)this.get("parammembentry");
    }

    public long getModelId() {
        return this.get("model") == null ? 0L : (Long)this.get("model");
    }

    public void setModelId(long modelId) {
        this.put("model", (Object)modelId);
    }

    public Integer getOutputType() {
        return (Integer)this.get("outputtype");
    }

    public void setOutputType(int outputtype) {
        this.put("outputtype", (Object)outputtype);
    }

    public Integer getSequence() {
        return (Integer)this.get("sequence");
    }

    public void setSequence(int sequence) {
        this.put("sequence", (Object)sequence);
    }

    public Date getCreateTime() {
        return (Date)this.get("createTime");
    }

    public void setCreateTime(Date createTime) {
        this.put("createTime", (Object)createTime);
    }

    public Date getModifyTime() {
        return (Date)this.get("modifytime");
    }

    public void setModifyTime(Date modifyTime) {
        this.put("modifytime", (Object)modifyTime);
    }

    public long getCreatorId() {
        return (Long)this.get("creator");
    }

    public void setCreatorId(long creatorId) {
        this.put("creator", (Object)creatorId);
    }

    public long getModifierId() {
        return (Long)this.get("modifier");
    }

    public void setModifierId(long modifierId) {
        this.put("modifier", (Object)modifierId);
    }

    public TemplateCatalog getTemplateCatalog() {
        return (TemplateCatalog)this.get("templatecatalog");
    }

    public void setTemplateCatalog(TemplateCatalog catalog) {
        this.put("templatecatalog", (Object)catalog);
    }

    public TplStatus getStatus() {
        return TplStatus.getStatus((String)this.get("status"));
    }

    public void setStatus(String statuValue) {
        this.put("status", (Object)statuValue);
    }

    private void loadDynaObj2Model(DynamicObject dyna) {
        try {
            Predicate<String> pexist = prop -> dyna.getDataEntityType().getProperties().containsKey(prop) && dyna.get(prop) != null;
            this.setId(dyna.getLong("id"));
            this.setName(dyna.getString("name"));
            this.setNumber(dyna.getString("number"));
            this.setModelId(this.defaultIfNotExist(pexist, "model", 0L, () -> dyna.getDynamicObject("model").getLong("id")));
            this.setTemplateCatalog(this.defaultIfNotExist(pexist, "templatecatalog", null, () -> {
                TemplateCatalog catalog = new TemplateCatalog();
                DynamicObject v = dyna.getDynamicObject("templatecatalog");
                catalog.setId(v.getLong("id"));
                catalog.setName(v.getString("name"));
                return catalog;
            }));
            this.setSequence(dyna.getInt("sequence"));
            DynamicObjectCollection entries = dyna.getDynamicObjectCollection("defmembentry");
            this.getDefaultDimensionEntries().addAll(new DefaultDimensionEntry(this).loadDynaObject(entries, () -> this));
            entries = dyna.getDynamicObjectCollection("parammembentry");
            this.getParamDimensionEntries().addAll(new ParamDimensionEntry(this).loadDynaObject(entries, () -> this));
        }
        catch (Throwable t) {
            throw new KDBizException(String.format("load [%s] template to model error!\n %s", dyna.getString("number"), ThrowableHelper.toString((Throwable)t)));
        }
    }

    private <R> R defaultIfNotExist(Predicate<String> p, String prop, R defaultValue, Supplier<R> supplier) {
        if (!p.test(prop)) {
            return defaultValue;
        }
        return supplier.get();
    }

    @Override
    public boolean isIncludeField(Object key) {
        return super.isIncludeField(key) || "templatecatalog".equals(key) || "outputtype".equals(key) || "description".equals(key);
    }

    public static enum TplStatus {
        ENABLE("1"),
        DISABLE("0");

        private final String statuValue;

        private TplStatus(String statuValue) {
            this.statuValue = statuValue;
        }

        public static TplStatus getStatus(String statuValue) {
            if ("1".equals(statuValue)) {
                return ENABLE;
            }
            return DISABLE;
        }

        public String getStatuValue() {
            return this.statuValue;
        }
    }
}

