/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.util.StringUtils;
import net.sourceforge.pinyin4j.PinyinHelper;

public class TypeUtils {
    public static Object[] convertToObject(Collection list) {
        if (list == null || list.size() == 0) {
            return new Object[0];
        }
        return list.toArray();
    }

    public static String convertToString(Object value) {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public static BigDecimal convertValueToDecimal(String value) {
        BigDecimal val = new BigDecimal(0);
        try {
            val = new BigDecimal(value);
        }
        catch (Exception ex) {
            val = new BigDecimal(0);
        }
        return val;
    }

    public static BigDecimal convertToDecimal(Object value) {
        BigDecimal val = new BigDecimal(0);
        if (value == null) {
            return val;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        return TypeUtils.convertValueToDecimal(value.toString());
    }

    public static Integer convertValueToInt(Object value) {
        return TypeUtils.convertValueToInt(value, 0);
    }

    public static Integer convertValueToInt(Object value, int defaultVal) {
        Integer val = defaultVal;
        if (value == null) {
            return val;
        }
        try {
            val = Integer.valueOf(value.toString());
        }
        catch (Exception ex) {
            val = defaultVal;
        }
        if (val == null) {
            val = defaultVal;
        }
        return val;
    }

    public static Long convertValueToLong(Object value) {
        return TypeUtils.convertValueToLong(value, 0L);
    }

    public static List<Long> convertValueToLongList(Object[] values) {
        if (values == null) {
            return new ArrayList<Long>(1);
        }
        ArrayList<Long> list = new ArrayList<Long>(values.length);
        for (Object value : values) {
            list.add(TypeUtils.convertValueToLong(value, 0L));
        }
        return list;
    }

    public static Long convertValueToLong(Object value, Long defaultVal) {
        Long val = defaultVal;
        if (value == null) {
            return val;
        }
        try {
            val = Long.valueOf(value.toString());
        }
        catch (Exception ex) {
            val = defaultVal;
        }
        if (val == null) {
            val = defaultVal;
        }
        return val;
    }

    public static Long convertToLong(Object value) {
        Long val = 0L;
        if (value == null) {
            return val;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        return TypeUtils.convertValueToLong(value.toString());
    }

    public static Double convertValueToDoule(Object input) {
        double foo;
        try {
            foo = Double.parseDouble(input.toString());
        }
        catch (Exception e) {
            foo = 0.0;
        }
        return foo;
    }

    public static boolean convertValueToBool(Object value, boolean defaultVal) {
        boolean val = defaultVal;
        if (value == null) {
            return val;
        }
        try {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof BigDecimal) {
                return ((BigDecimal)value).intValue() == 1;
            }
            if (value instanceof Number) {
                return ((Number)value).intValue() == 1;
            }
            if (value instanceof String) {
                String valStr = value.toString();
                if ("true".equalsIgnoreCase(valStr) || "Y".equalsIgnoreCase(valStr) || "1".equalsIgnoreCase(valStr)) {
                    return true;
                }
                if ("false".equalsIgnoreCase(valStr) || "N".equalsIgnoreCase(valStr) || "0".equalsIgnoreCase(valStr)) {
                    return false;
                }
                return defaultVal;
            }
            val = Boolean.parseBoolean(value.toString());
        }
        catch (Exception ex) {
            val = defaultVal;
        }
        return val;
    }

    public static String getMapValueString(Map map, String key) {
        if (map == null || StringUtils.isEmpty((String)key)) {
            return "";
        }
        return map.get(key) == null ? "" : map.get(key).toString();
    }

    public static boolean getMapValueBool(Map map, String key, boolean defaultVal) {
        if (map == null || StringUtils.isEmpty((String)key)) {
            return defaultVal;
        }
        return map.get(key) == null ? defaultVal : TypeUtils.convertValueToBool(map.get(key), defaultVal);
    }

    public static Long getMapValueLong(Map map, String key) {
        return TypeUtils.getMapValueLong(map, key, 0L);
    }

    public static Long getMapValueLong(Map map, String key, Long defaultVal) {
        if (map == null || StringUtils.isEmpty((String)key)) {
            return defaultVal;
        }
        return map.get(key) == null ? defaultVal : TypeUtils.convertValueToLong(map.get(key), defaultVal);
    }

    public static String toPinYinString(String str) {
        if (StringUtils.isBlank((String)str)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        String[] arr = null;
        for (int i = 0; i < str.length(); ++i) {
            arr = PinyinHelper.toHanyuPinyinStringArray((char)str.charAt(i));
            if (arr != null && arr.length > 0) {
                for (String string : arr) {
                    sb.append(string);
                }
                continue;
            }
            if (arr != null) continue;
            sb.append(str.charAt(i));
        }
        return sb.toString();
    }

    public static int countChineseChars(String str) {
        int length = 0;
        int i = 0;
        while (i < str.length()) {
            int codePoint = str.codePointAt(i);
            i += Character.charCount(codePoint);
            if (codePoint >= 19968 && codePoint <= 40869) {
                length += 2;
                continue;
            }
            ++length;
        }
        return length;
    }

    public static boolean equalsIgnoreTrim(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.toString().trim().equalsIgnoreCase(o2.toString().trim());
    }

    public static boolean isNumber(Object obj) {
        return obj instanceof Byte || obj instanceof Short || obj instanceof Integer || obj instanceof Long || obj instanceof Float || obj instanceof Double || obj instanceof BigInteger || obj instanceof BigDecimal || obj instanceof Number || obj instanceof AtomicInteger || obj instanceof AtomicLong;
    }

    public static boolean containsIgnore(Collection<String> list, String checkString) {
        if (list == null || list.size() == 0 || StringUtils.isEmpty((String)checkString)) {
            return false;
        }
        checkString = checkString.trim();
        for (String item : list) {
            if (StringUtils.isEmpty((String)item) || !checkString.equalsIgnoreCase(item.trim())) continue;
            return true;
        }
        return false;
    }

    public static boolean endsWithIgnore(Collection<String> endStrs, String checkString) {
        if (endStrs == null || endStrs.size() == 0 || StringUtils.isEmpty((String)checkString)) {
            return false;
        }
        checkString = checkString.trim().toLowerCase(Locale.ENGLISH);
        for (String item : endStrs) {
            if (StringUtils.isEmpty((String)item) || !checkString.endsWith(item)) continue;
            return true;
        }
        return false;
    }

    public static boolean endsWithIgnore(String endStr, String checkString) {
        if (StringUtils.isEmpty((String)endStr) || StringUtils.isEmpty((String)checkString)) {
            return false;
        }
        endStr = endStr.trim().toLowerCase(Locale.ENGLISH);
        return (checkString = checkString.trim().toLowerCase(Locale.ENGLISH)).endsWith(endStr);
    }

    public static List<String> splitString(String content, String regex) {
        String[] arary = content.split(regex);
        ArrayList<String> list = new ArrayList<String>(arary.length);
        for (String item : arary) {
            if (item == null || "".equals(item.trim())) continue;
            list.add(item.trim());
        }
        return list;
    }
}

