/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.OpenWordEnum;
import kd.epm.far.business.common.enums.WordDataType;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.fidm.base.DisclosureFileHelper;
import kd.epm.far.business.fidm.chapter.DisclosureChapterHelper;
import kd.epm.far.business.fidm.html.HtmlConvert;
import kd.epm.far.business.fidm.html.HtmlReplaceHelper;
import kd.epm.far.business.fidm.html.dto.HtmlNode;
import kd.epm.far.business.fidm.html.dto.HtmlPreviewNode;
import kd.epm.far.business.fidm.web.WebModuleToNodeHelper;
import kd.epm.far.business.fidm.word.WordConvert;
import kd.epm.far.business.fidm.word.base.WordConstants;
import kd.epm.far.business.fidm.word.dto.WordNode;
import kd.epm.far.business.fidm.word.dto.WordRootNode;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.util.GlobalIdUtil;

public class WebHtmlService {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(WebHtmlService.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public HtmlNode getHtmlByUrl(String docUrl, boolean isTempFile) {
        HtmlNode htmlNode = new HtmlNode();
        String tips = "";
        if (StringUtils.isEmpty((String)docUrl)) {
            return htmlNode;
        }
        try (InputStream in = DisclosureFileHelper.getFileInputStream(docUrl, isTempFile);){
            WordConvert wordConvert = new WordConvert();
            HtmlConvert htmlConvert = new HtmlConvert();
            List<WordRootNode> rootNodes = wordConvert.fromWord(in);
            for (WordRootNode rootNode : rootNodes) {
                String html = htmlConvert.toHtml(rootNode);
                if (WordConstants.WordContentType.Content.getType() == rootNode.getContentType()) {
                    htmlNode.setHtml(html);
                    continue;
                }
                if (WordConstants.WordContentType.Head.getType() == rootNode.getContentType()) {
                    htmlNode.setHeadHtml(html);
                    continue;
                }
                if (WordConstants.WordContentType.Foot.getType() != rootNode.getContentType()) continue;
                htmlNode.setFootHtml(html);
            }
            HtmlNode htmlNode2 = htmlNode;
            return htmlNode2;
        }
        catch (KDBizException kdEx) {
            throw kdEx;
        }
        catch (Exception ex) {
            tips = ResManager.loadKDString((String)"\u8f6c\u6362\u5728\u7ebf\u6587\u6863\u663e\u793a\u6570\u636e\u5931\u8d25\u3002", (String)"WebHtmlService_0", (String)"epm-far-business", (Object[])new Object[0]);
            logger.error("dm convert", (Throwable)ex);
            throw new KDBizException(tips);
        }
    }

    public DynamicObject getChapterDesginHtmlObject(Long chapterId, Date modifytime) {
        int savewordtype = 0;
        if (chapterId != null && chapterId > 0L) {
            DynamicObject chapter = DisclosureChapterHelper.getChapter(chapterId);
            if (modifytime == null) {
                modifytime = chapter.getDate("modifytime");
                savewordtype = chapter.getInt("savewordtype");
            }
        } else {
            return null;
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("reportId", "=", (Object)0L));
        qFilters.add(new QFilter("chapterid", "=", (Object)chapterId));
        qFilters.add(new QFilter("type", "=", (Object)WordDataType.ChapterDeginJson.getType()));
        DynamicObjectCollection webList = QueryServiceHelper.query((String)"fidm_word_history", (String)"id,downloadurl,chapterid,content,modifytime", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"modifytime desc", (int)1);
        if (webList.size() == 0) {
            return null;
        }
        DynamicObject wordHistory = (DynamicObject)webList.get(0);
        if (savewordtype == OpenWordEnum.WEB.getTypeToInt() || modifytime.getTime() <= wordHistory.getDate("modifytime").getTime() + 10L) {
            return wordHistory;
        }
        return null;
    }

    public DynamicObject getChapterPreviewJsonObject(Long reportId, Long chapterId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("reportId", "=", (Object)reportId));
        qFilters.add(new QFilter("chapterid", "=", (Object)chapterId));
        qFilters.add(new QFilter("type", "=", (Object)WordDataType.ChapterPreviewJson.getType()));
        DynamicObjectCollection webList = QueryServiceHelper.query((String)"fidm_word_history", (String)"id,downloadurl,chapterid,content,modifytime", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"modifytime desc", (int)1);
        if (webList.size() == 0) {
            return null;
        }
        DynamicObject wordHistory = (DynamicObject)webList.get(0);
        return wordHistory;
    }

    public HtmlNode getChapterDesginHtml(Long chapterId, String docUrl, boolean isTempFile) {
        HtmlNode htmlNode = new HtmlNode();
        DynamicObject htmlDy = this.getChapterDesginHtmlObject(chapterId, null);
        if (htmlDy != null) {
            String content = htmlDy.getString("content");
            if (StringUtils.isEmpty((String)content)) {
                return htmlNode;
            }
            htmlNode = (HtmlNode)JSON.parseObject((String)content, HtmlNode.class);
        } else {
            htmlNode = this.getHtmlByUrl(docUrl, isTempFile);
        }
        this.htmlReplaceOther(htmlNode);
        return htmlNode;
    }

    public HtmlPreviewNode createPreviewHtml(List<JSONObject> itemList, HtmlNode htmlNode, List<DimensionInfo> dimensionInfos) {
        HtmlPreviewNode previewResult = new HtmlPreviewNode();
        try {
            JSONArray itemArray = new JSONArray();
            for (JSONObject item : itemList) {
                itemArray.add((Object)item);
            }
            Map<String, WordNode> bookmarkNodes = WebModuleToNodeHelper.createBookmarkNodes(itemArray);
            HtmlNode newNode = this.htmlReplaceBookmark(htmlNode, bookmarkNodes, false);
            previewResult.setHtmlNode(newNode);
            previewResult.setItemList(itemArray);
            previewResult.setDimensionInfos(dimensionInfos);
            return previewResult;
        }
        catch (Exception ex) {
            logger.error("dm  createPreviewHtml fail2 ", (Throwable)ex);
            throw ex;
        }
    }

    public HtmlNode htmlReplaceBookmark(HtmlNode htmlNode, Map<String, WordNode> bookmarkNodes, boolean nullNodeExists) {
        if (htmlNode == null) {
            return null;
        }
        HtmlNode newNode = null;
        try {
            newNode = htmlNode.clone();
        }
        catch (CloneNotSupportedException clonEx) {
            logger.error("dm  createPreviewHtml fail1 ", (Throwable)clonEx);
            throw new KDBizException("createPreviewHtml:" + clonEx.getMessage());
        }
        if (!StringUtils.isEmpty((String)htmlNode.getHtml())) {
            newNode.setHtml(HtmlReplaceHelper.replaceBookmark(htmlNode.getHtml(), bookmarkNodes, nullNodeExists));
        }
        if (!StringUtils.isEmpty((String)htmlNode.getHeadHtml())) {
            newNode.setHeadHtml(HtmlReplaceHelper.replaceBookmark(htmlNode.getHeadHtml(), bookmarkNodes, nullNodeExists));
        }
        if (!StringUtils.isEmpty((String)htmlNode.getFootHtml())) {
            newNode.setFootHtml(HtmlReplaceHelper.replaceBookmark(htmlNode.getFootHtml(), bookmarkNodes, nullNodeExists));
        }
        this.htmlReplaceOther(newNode);
        return newNode;
    }

    public HtmlPreviewNode createPreviewHtmlByInit(Long chapterId, HtmlNode htmlNode) {
        HtmlPreviewNode previewResult = new HtmlPreviewNode();
        try {
            DynamicObject[] moduleList;
            JSONArray itemList = new JSONArray();
            DynamicObject chapter = BusinessDataServiceHelper.loadSingle((String)"fidm_chapter", (String)"entryentity.key, entryentity.module", (QFilter[])new QFilter("id", "=", (Object)chapterId).toArray());
            DynamicObjectCollection chapterModules = chapter.getDynamicObjectCollection("entryentity");
            List moduleIds = chapterModules.stream().map(e -> e.getLong("module.id")).filter(e -> !e.equals(0L)).distinct().collect(Collectors.toList());
            for (DynamicObject module : moduleList = BusinessDataServiceHelper.load((Object[])moduleIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fidm_modulerepository"))) {
                JSONObject itemObject = JSONObject.parseObject((String)module.getString("properties"));
                if (itemObject == null) continue;
                itemList.add((Object)itemObject);
            }
            Map<String, WordNode> bookmarkNodes = WebModuleToNodeHelper.createBookmarkNodes(itemList);
            HtmlNode newNode = this.htmlReplaceBookmark(htmlNode, bookmarkNodes, false);
            previewResult.setHtmlNode(newNode);
            previewResult.setItemList(itemList);
            return previewResult;
        }
        catch (Exception ex) {
            logger.error("dm  createPreviewHtml fail2 ", (Throwable)ex);
            throw ex;
        }
    }

    public HtmlPreviewNode createPreviewHtml(Long dmModelId, Long reportId, Long chapterId, HtmlNode htmlNode) {
        HtmlPreviewNode previewResult = new HtmlPreviewNode();
        try {
            JSONArray itemList = new JSONArray();
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
            qFilters.add(new QFilter("model", "=", (Object)dmModelId));
            qFilters.add(new QFilter("reportId", "=", (Object)reportId));
            if (chapterId != null && chapterId > 0L) {
                qFilters.add(new QFilter("chapterId", "=", (Object)chapterId));
            }
            qFilters.add(new QFilter("type", "=", (Object)WordDataType.ReportResultJson.getType()));
            DynamicObject reportResult = QueryServiceHelper.queryOne((String)"fidm_word_history", (String)"id,content", (QFilter[])qFilters.toArray(new QFilter[0]));
            if (reportResult == null) {
                previewResult.setHtmlNode(htmlNode);
                previewResult.setItemList(itemList);
                return previewResult;
            }
            JSONObject result = JSON.parseObject((String)reportResult.getString("content"));
            itemList = result.getJSONArray("itemList");
            Map<String, WordNode> bookmarkNodes = WebModuleToNodeHelper.createBookmarkNodes(itemList);
            HtmlNode newNode = this.htmlReplaceBookmark(htmlNode, bookmarkNodes, false);
            previewResult.setHtmlNode(newNode);
            previewResult.setItemList(itemList);
            return previewResult;
        }
        catch (Exception ex) {
            logger.error("dm  createPreviewHtml fail2 ", (Throwable)ex);
            throw ex;
        }
    }

    public DynamicObject savePreviewHtml(Long dmModelId, Long reportId, Long chapterId, String docPreivewUrl, HtmlPreviewNode previewJson) {
        DynamicObject htmlDy = BusinessDataServiceHelper.newDynamicObject((String)"fidm_word_history");
        htmlDy.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        htmlDy.set("model", (Object)dmModelId);
        htmlDy.set("remark", (Object)"");
        htmlDy.set("docid", (Object)"");
        htmlDy.set("type", (Object)WordDataType.ChapterPreviewJson.getType());
        htmlDy.set("reportId", (Object)reportId);
        htmlDy.set("chapterid", (Object)chapterId);
        htmlDy.set("creator", (Object)RequestContext.get().getCurrUserId());
        htmlDy.set("createtime", (Object)new Date());
        htmlDy.set("modifier", (Object)RequestContext.get().getCurrUserId());
        htmlDy.set("modifytime", (Object)new Date());
        htmlDy.set("downloadurl", (Object)docPreivewUrl);
        htmlDy.set("content", (Object)JSON.toJSONString((Object)previewJson, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
        htmlDy.set("name", (Object)"PreviewHtmlAndJson");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{htmlDy});
        return htmlDy;
    }

    public String createUrlByHtml(Long chapterId, String fileName, HtmlNode htmlNode, JSONArray itemList, JSONArray bookmarkList, boolean isDesign) {
        String tips = "";
        String docUrl = "";
        LinkedHashMap<String, JSONObject> itemPropertyMap = new LinkedHashMap<String, JSONObject>(2);
        for (Object item : itemList) {
            JSONObject find;
            JSONObject itemObject = (JSONObject)item;
            if (itemObject == null) continue;
            String itemId = itemObject.getString("id");
            if (bookmarkList != null && (find = (JSONObject)bookmarkList.stream().filter(m -> ((JSONObject)m).getString("itemId").equals(itemId)).findAny().orElse(null)) != null) {
                itemPropertyMap.put(find.getString("key"), itemObject);
            }
            itemPropertyMap.put(itemId, itemObject);
        }
        HtmlConvert htmlConvert = new HtmlConvert(itemPropertyMap);
        WordConvert wordConvert = new WordConvert();
        try {
            WordRootNode footNode;
            WordRootNode headNode;
            WordRootNode rootNode;
            ArrayList<WordRootNode> rootNodes = new ArrayList<WordRootNode>(3);
            String html = htmlNode.getHtml();
            String headHtml = htmlNode.getHeadHtml();
            String footHtml = htmlNode.getFootHtml();
            if (isDesign) {
                html = HtmlReplaceHelper.changeBookmarkElement(html, itemPropertyMap);
                headHtml = HtmlReplaceHelper.changeBookmarkElement(headHtml, itemPropertyMap);
                footHtml = HtmlReplaceHelper.changeBookmarkElement(footHtml, itemPropertyMap);
            }
            if ((rootNode = htmlConvert.fromHtml(html, WordConstants.WordContentType.Content.getType())) != null) {
                rootNodes.add(rootNode);
            }
            if ((headNode = htmlConvert.fromHtml(headHtml, WordConstants.WordContentType.Head.getType())) != null) {
                rootNodes.add(headNode);
            }
            if ((footNode = htmlConvert.fromHtml(footHtml, WordConstants.WordContentType.Foot.getType())) != null) {
                rootNodes.add(footNode);
            }
            byte[] outputStreamByte = wordConvert.toWord(rootNodes);
            ByteArrayInputStream in = new ByteArrayInputStream(outputStreamByte);
            String formId = "fidm_webdesign";
            docUrl = DisclosureFileHelper.saveAsNew(in, "fidm", formId, chapterId, fileName);
            return docUrl;
        }
        catch (Exception ex) {
            tips = ResManager.loadKDString((String)"HTML\u8f6c\u6362\u4e3a\u5728\u7ebf\u6587\u6863\u5931\u8d25\u3002", (String)"WebHtmlService_1", (String)"epm-far-business", (Object[])new Object[0]);
            logger.error("dm html convert word", (Throwable)ex);
            throw new KDBizException(tips);
        }
    }

    public DynamicObject saveTemplateDesginHtml(Long dmModelId, Long chapterId, String docId, String downloadurl, HtmlNode htmlNode) {
        DynamicObject newHistory = BusinessDataServiceHelper.newDynamicObject((String)"fidm_word_history");
        newHistory.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        newHistory.set("model", (Object)dmModelId);
        newHistory.set("remark", (Object)"");
        newHistory.set("docid", (Object)docId);
        newHistory.set("type", (Object)WordDataType.ChapterDeginJson.getType());
        newHistory.set("reportId", (Object)0L);
        newHistory.set("chapterid", (Object)chapterId);
        newHistory.set("creator", (Object)RequestContext.get().getCurrUserId());
        newHistory.set("createtime", (Object)new Date());
        newHistory.set("modifier", (Object)RequestContext.get().getCurrUserId());
        newHistory.set("modifytime", (Object)new Date());
        newHistory.set("downloadurl", (Object)downloadurl);
        newHistory.set("content", (Object)JSON.toJSONString((Object)htmlNode));
        newHistory.set("name", (Object)docId);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newHistory});
        return newHistory;
    }

    public void htmlReplaceOther(HtmlNode htmlNode) {
        if (htmlNode == null) {
            return;
        }
        if (StringUtils.isEmpty((String)htmlNode.getHtml())) {
            return;
        }
        String imageTicket = DisclosureFileHelper.getTicket();
        htmlNode.setHtml(this.htmlReplaceOther(htmlNode.getHtml(), imageTicket));
        htmlNode.setHeadHtml(this.htmlReplaceOther(htmlNode.getHeadHtml(), imageTicket));
        htmlNode.setFootHtml(this.htmlReplaceOther(htmlNode.getFootHtml(), imageTicket));
    }

    private String htmlReplaceOther(String html, String imageTicket) {
        html = HtmlReplaceHelper.replaceImageTicket(html, imageTicket);
        html = HtmlReplaceHelper.replaceInputToIamge(html);
        return html;
    }
}

