/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.web;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.far.business.common.enums.ModuleEnum;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.module.calculate.VarHelper;
import kd.epm.far.business.fidm.module.calculate.dto.VarResult;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;

public class WebModuleConvert {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(WebModuleConvert.class);

    public static JSONObject convertToHtml(JSONObject itemObject) {
        String tipsGeneral = ResManager.loadKDString((String)"\u8f6c\u6362\u8ba1\u7b97\u6570\u636e\u5230\u524d\u7aef\uff0c\u672a\u77e5\u5f02\u5e38\u3002", (String)"WebHtmlService_2", (String)"epm-far-business", (Object[])new Object[0]);
        String tips = "";
        JSONObject result = new JSONObject();
        result.put("code", (Object)"0000");
        try {
            JSONObject dataResult = itemObject.getJSONObject("dataResult");
            if (dataResult == null) {
                tips = ResManager.loadKDString((String)"\u8f6c\u6362\u8ba1\u7b97\u6570\u636e\u5230\u524d\u7aef\uff0c\u7ec4\u4ef6\u6ca1\u6709\u8fdb\u884c\u8ba1\u7b97\u6216\u8005\u8ba1\u7b97\u7ed3\u679c\u4e22\u5931\u3002", (String)"WebHtmlService_3", (String)"epm-far-business", (Object[])new Object[0]);
                throw new KDBizException(tips);
            }
            String resultCode = DisclosureJsonHelper.getValue(itemObject, "dataResult", "code", "0000");
            if (!resultCode.equalsIgnoreCase("0000")) {
                result.put("code", (Object)"0001");
                result.put("message", (Object)DisclosureJsonHelper.getValue(itemObject, "dataResult", "message", tipsGeneral));
                return result;
            }
            if (dataResult.get((Object)"data") == null) {
                result.put("code", (Object)"0001");
                result.put("message", (Object)tipsGeneral);
                return result;
            }
            JSONObject data = dataResult.getJSONObject("data");
            String moduleType = itemObject.getString("type");
            if (ModuleEnum.VAR.getType().equals(moduleType)) {
                result.put("data", (Object)WebModuleConvert.varConvert(itemObject, data));
            } else if (ModuleEnum.REPORT_INFO.getType().equals(moduleType)) {
                result.put("data", (Object)WebModuleConvert.reportInfoConvert(data));
            } else if (ModuleEnum.TOC.getType().equals(moduleType)) {
                result.put("data", (Object)WebModuleConvert.tocConvert(data));
            } else if (ModuleEnum.PIE.getType().equals(moduleType) || ModuleEnum.DOUGHNUT.getType().equals(moduleType)) {
                result.put("data", (Object)WebModuleConvert.pieConvert(data));
            } else if (ModuleEnum.STACKED_COLUMNAR.getType().equals(moduleType) || ModuleEnum.STACKED_BAR.getType().equals(moduleType) || ModuleEnum.CLUSTERED_BAR.getType().equals(moduleType) || ModuleEnum.CLUSTERED_COLUMNAR.getType().equals(moduleType) || ModuleEnum.LINE.getType().equals(moduleType) || ModuleEnum.AREA.getType().equals(moduleType)) {
                result.put("data", (Object)WebModuleConvert.lineConvert(data, moduleType));
            } else if (ModuleEnum.LINE_STACKED_COLUMNAR.getType().equals(moduleType) || ModuleEnum.LINE_CLUSTERED_COLUMNAR.getType().equals(moduleType)) {
                result.put("data", (Object)WebModuleConvert.lineStackedColumnarConvert(data, moduleType));
            } else {
                result.put("data", (Object)data);
            }
        }
        catch (KDBizException kdEx) {
            result.put("code", (Object)"0001");
            result.put("message", (Object)kdEx.getMessage());
        }
        catch (Exception ex) {
            logger.error("dm convertToHtml error", (Throwable)ex);
            result.put("code", (Object)"0001");
            result.put("message", (Object)tipsGeneral);
        }
        return result;
    }

    private static JSONObject lineStackedColumnarConvert(JSONObject dataObject, String moduleType) {
        JSONObject result = new JSONObject();
        String axisName = "xAxis";
        JSONArray newXAxis = new JSONArray();
        JSONArray newSeries = new JSONArray();
        result.put(axisName, (Object)newXAxis);
        result.put("series", (Object)newSeries);
        JSONObject data = dataObject.getJSONObject("data");
        if (data == null) {
            return result;
        }
        for (Object itemObejct : data.getJSONArray("xAxis")) {
            newXAxis.add((Object)(itemObejct == null ? "" : itemObejct.toString()));
        }
        for (Object itemObejct : data.getJSONArray("series")) {
            JSONObject item = DisclosureJsonHelper.copyEntity((JSONObject)itemObejct);
            if ("line".equals(item.getString("type"))) {
                item.put("yAxisIndex", (Object)1);
            }
            if (ModuleEnum.LINE_STACKED_COLUMNAR.getType().equals(moduleType)) {
                item.put("stack", (Object)"stack");
            }
            newSeries.add((Object)item);
        }
        result.put(axisName, (Object)newXAxis);
        result.put("series", (Object)newSeries);
        return result;
    }

    private static JSONObject lineConvert(JSONObject dataObject, String moduleType) {
        JSONObject result = new JSONObject();
        String axisName = "xAxis";
        if (ModuleEnum.STACKED_BAR.getType().equals(moduleType) || ModuleEnum.CLUSTERED_BAR.getType().equals(moduleType)) {
            axisName = "yAxis";
        }
        JSONArray newXAxis = new JSONArray();
        JSONArray newSeries = new JSONArray();
        result.put(axisName, (Object)newXAxis);
        result.put("series", (Object)newSeries);
        JSONObject data = dataObject.getJSONObject("data");
        if (data == null) {
            return result;
        }
        for (Object itemObejct : data.getJSONArray("xAxis")) {
            newXAxis.add((Object)(itemObejct == null ? "" : itemObejct.toString()));
        }
        for (Object itemObejct : data.getJSONArray("series")) {
            JSONObject item = DisclosureJsonHelper.copyEntity((JSONObject)itemObejct);
            JSONObject label = new JSONObject();
            label.put("position", (Object)"inside");
            item.put("label", (Object)label);
            if (ModuleEnum.STACKED_COLUMNAR.getType().equals(moduleType)) {
                item.put("stack", (Object)"stack");
                item.put("type", (Object)"bar");
            } else if (ModuleEnum.CLUSTERED_COLUMNAR.getType().equals(moduleType)) {
                item.put("type", (Object)"bar");
            } else if (ModuleEnum.STACKED_BAR.getType().equals(moduleType)) {
                item.put("stack", (Object)"stack");
                item.put("type", (Object)"bar");
            } else if (ModuleEnum.CLUSTERED_BAR.getType().equals(moduleType)) {
                item.put("type", (Object)"bar");
            } else if (ModuleEnum.LINE.getType().equals(moduleType)) {
                item.put("type", (Object)"line");
            } else if (ModuleEnum.AREA.getType().equals(moduleType)) {
                item.put("stack", (Object)"stack");
                item.put("type", (Object)"line");
                label = new JSONObject();
                label.put("position", (Object)"top");
                item.put("label", (Object)label);
                item.put("areaStyle", (Object)new JSONObject());
            } else {
                item.put("type", (Object)"bar");
            }
            newSeries.add((Object)item);
        }
        result.put(axisName, (Object)newXAxis);
        result.put("series", (Object)newSeries);
        return result;
    }

    private static JSONArray pieConvert(JSONObject dataObject) {
        JSONArray data = dataObject.getJSONArray("data");
        if (data == null) {
            return new JSONArray();
        }
        return data;
    }

    private static JSONObject tocConvert(JSONObject dataObject) {
        JSONObject result = new JSONObject();
        String thing = "";
        if (dataObject != null) {
            thing = dataObject.getString("labelName");
        }
        result.put("result", (Object)thing);
        return result;
    }

    private static JSONObject reportInfoConvert(JSONObject dataObject) {
        JSONObject result = new JSONObject();
        String thing = "";
        if (dataObject != null) {
            thing = dataObject.getString("text");
        }
        result.put("result", (Object)thing);
        return result;
    }

    private static JSONObject varConvert(JSONObject itemObject, JSONObject dataObject) {
        JSONObject result = new JSONObject();
        VarResult varResult = VarHelper.getVar(itemObject, (Map)dataObject);
        result.put("result", (Object)varResult);
        return result;
    }
}

