/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.web;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import kd.epm.far.business.common.enums.ModuleEnum;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.util.TypeUtils;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;

public class WebModuleRefreshHelper {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(WebModuleRefreshHelper.class);

    public static void resetDataResultByWebData(JSONArray itemList) {
        if (itemList == null || itemList.size() == 0) {
            return;
        }
        for (Object item : itemList) {
            JSONObject itemObject = (JSONObject)item;
            if (itemObject == null) continue;
            WebModuleRefreshHelper.resetDataResultByWebData(itemObject);
        }
    }

    public static void resetDataResultByWebData(JSONObject itemObject) {
        try {
            Object webData = itemObject.get((Object)"data");
            if (webData == null) {
                return;
            }
            JSONObject dataResult = itemObject.getJSONObject("dataResult");
            if (dataResult == null) {
                return;
            }
            String resultCode = DisclosureJsonHelper.getValue(itemObject, "dataResult", "code", "0000");
            if (!resultCode.equalsIgnoreCase("0000")) {
                return;
            }
            if (dataResult.get((Object)"data") == null) {
                return;
            }
            JSONObject newData = null;
            String moduleType = itemObject.getString("type");
            if (ModuleEnum.PIE.getType().equals(moduleType) || ModuleEnum.DOUGHNUT.getType().equals(moduleType)) {
                newData = WebModuleRefreshHelper.pieConvert(webData);
            } else if (ModuleEnum.STACKED_COLUMNAR.getType().equals(moduleType) || ModuleEnum.STACKED_BAR.getType().equals(moduleType) || ModuleEnum.CLUSTERED_BAR.getType().equals(moduleType) || ModuleEnum.CLUSTERED_COLUMNAR.getType().equals(moduleType) || ModuleEnum.LINE.getType().equals(moduleType) || ModuleEnum.AREA.getType().equals(moduleType)) {
                newData = WebModuleRefreshHelper.lineConvert(webData, moduleType);
            } else if (ModuleEnum.LINE_STACKED_COLUMNAR.getType().equals(moduleType) || ModuleEnum.LINE_CLUSTERED_COLUMNAR.getType().equals(moduleType)) {
                newData = WebModuleRefreshHelper.lineStackedColumnarConvert(webData);
            }
            if (newData != null) {
                dataResult.put("data", (Object)newData);
            }
        }
        catch (Exception ex) {
            logger.error("dm convertToHtml error", (Throwable)ex);
        }
    }

    private static JSONObject lineStackedColumnarConvert(Object webData) {
        if (webData == null || !(webData instanceof JSONObject)) {
            return null;
        }
        JSONObject webDataObject = (JSONObject)webData;
        JSONArray axisData = webDataObject.getJSONArray("xAxis");
        JSONArray seriesData = webDataObject.getJSONArray("series");
        JSONArray newXAxis = new JSONArray();
        JSONArray newSeries = new JSONArray();
        for (Object itemObejct : axisData) {
            newXAxis.add((Object)(itemObejct == null ? "" : itemObejct.toString()));
        }
        for (Object itemObejct : seriesData) {
            JSONObject item = (JSONObject)itemObejct;
            JSONArray valueData = item.getJSONArray("data");
            String name = item.getString("name");
            String type = item.getString("type");
            JSONArray newValueData = new JSONArray();
            if (valueData == null) {
                valueData = new JSONArray();
            }
            for (Object valueObject : valueData) {
                newValueData.add((Object)TypeUtils.convertToDecimal(valueObject));
            }
            JSONObject newItem = new JSONObject();
            newItem.put("name", (Object)name);
            newItem.put("type", (Object)type);
            newItem.put("data", (Object)newValueData);
            newSeries.add((Object)newItem);
            newSeries.add((Object)item);
        }
        JSONObject newRows = new JSONObject();
        newRows.put("xAxis", (Object)newXAxis);
        newRows.put("series", (Object)newSeries);
        JSONObject newDta = new JSONObject();
        newDta.put("data", (Object)newRows);
        return newDta;
    }

    private static JSONObject lineConvert(Object webData, String moduleType) {
        if (webData == null || !(webData instanceof JSONObject)) {
            return null;
        }
        JSONObject webDataObject = (JSONObject)webData;
        String axisName = "xAxis";
        if (ModuleEnum.STACKED_BAR.getType().equals(moduleType) || ModuleEnum.CLUSTERED_BAR.getType().equals(moduleType)) {
            axisName = "yAxis";
        }
        JSONArray axisData = webDataObject.getJSONArray(axisName);
        JSONArray seriesData = webDataObject.getJSONArray("series");
        if (axisData == null) {
            axisData = new JSONArray();
        }
        if (seriesData == null) {
            seriesData = new JSONArray();
        }
        JSONArray newXAxis = new JSONArray();
        JSONArray newSeries = new JSONArray();
        for (Object itemObejct : axisData) {
            newXAxis.add((Object)(itemObejct == null ? "" : itemObejct.toString()));
        }
        for (Object itemObejct : seriesData) {
            JSONObject item = (JSONObject)itemObejct;
            JSONArray valueData = item.getJSONArray("data");
            String name = item.getString("name");
            String type = "bar";
            if (ModuleEnum.STACKED_COLUMNAR.getType().equals(moduleType)) {
                type = "bar";
            } else if (ModuleEnum.CLUSTERED_COLUMNAR.getType().equals(moduleType)) {
                type = "bar";
            } else if (ModuleEnum.STACKED_BAR.getType().equals(moduleType)) {
                type = "bar";
            } else if (ModuleEnum.CLUSTERED_BAR.getType().equals(moduleType)) {
                type = "bar";
            } else if (ModuleEnum.LINE.getType().equals(moduleType)) {
                type = "line";
            } else if (ModuleEnum.AREA.getType().equals(moduleType)) {
                type = "line";
            }
            JSONArray newValueData = new JSONArray();
            if (valueData == null) {
                valueData = new JSONArray();
            }
            for (Object valueObject : valueData) {
                newValueData.add((Object)TypeUtils.convertToDecimal(valueObject));
            }
            JSONObject newItem = new JSONObject();
            newItem.put("name", (Object)name);
            newItem.put("type", (Object)type);
            newItem.put("data", (Object)newValueData);
            newSeries.add((Object)newItem);
        }
        JSONObject newRows = new JSONObject();
        newRows.put("xAxis", (Object)newXAxis);
        newRows.put("series", (Object)newSeries);
        JSONObject newDta = new JSONObject();
        newDta.put("data", (Object)newRows);
        return newDta;
    }

    private static JSONObject pieConvert(Object webData) {
        if (webData == null || !(webData instanceof JSONArray)) {
            return null;
        }
        JSONArray webDataObject = (JSONArray)webData;
        JSONArray newRows = new JSONArray();
        for (Object obj : webDataObject) {
            JSONObject item = (JSONObject)obj;
            String name = item.getString("name");
            String value = item.getString("value");
            JSONObject newItem = new JSONObject();
            newItem.put("name", (Object)name);
            newItem.put("value", (Object)TypeUtils.convertValueToDecimal(value));
            newRows.add((Object)newItem);
        }
        JSONObject newDta = new JSONObject();
        newDta.put("data", (Object)newRows);
        return newDta;
    }
}

