/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.WordDataType;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.common.model.dto.DimensionInfo;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.base.DisclosureVueHelper;
import kd.epm.far.business.fidm.design.DisclosureDesignHelper;
import kd.epm.far.business.fidm.design.dto.PreviewSaveResult;
import kd.epm.far.business.fidm.gpt.DiscloseGPTService;
import kd.epm.far.business.fidm.html.HtmlReplaceHelper;
import kd.epm.far.business.fidm.html.dto.HtmlNode;
import kd.epm.far.business.fidm.html.dto.HtmlPreviewNode;
import kd.epm.far.business.fidm.report.ReportChapterHelper;
import kd.epm.far.business.fidm.report.ReportModuleResetService;
import kd.epm.far.business.fidm.report.dto.ModuleResetInput;
import kd.epm.far.business.fidm.report.dto.ModuleResetResult;
import kd.epm.far.business.fidm.web.WebHtmlService;
import kd.epm.far.business.fidm.web.WebModuleToNodeHelper;
import kd.epm.far.business.fidm.web.WebServiceHelper;
import kd.epm.far.business.fidm.word.dto.WordNode;

public class WebModuleResetHelper {
    private static final Log logger = LogFactory.getLog(WebModuleResetHelper.class);

    public static List<JSONObject> check(Long dmModelId, Long reportId, Long chapterId, HtmlNode htmlNode, JSONObject jsonObject, boolean resetAll) {
        List<Map<String, String>> bookmarkElements = HtmlReplaceHelper.getBookmarkEntitys(htmlNode.getHtml());
        if (bookmarkElements.size() == 0) {
            String tips = ResManager.loadKDString((String)"\u6587\u6863\u5185\u5bb9\u6ca1\u6709\u7ec4\u4ef6\uff0c\u4e0d\u80fd\u505a\u7ec4\u4ef6\u6570\u636e\u91cd\u7f6e\u64cd\u4f5c\u3002", (String)"DisclosureServiceHelper_11", (String)"epm-far-business", (Object[])new Object[0]);
            throw new KDBizException(tips);
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("model", "=", (Object)dmModelId));
        qFilters.add(new QFilter("reportId", "=", (Object)reportId));
        if (chapterId != null && chapterId > 0L) {
            qFilters.add(new QFilter("chapterId", "=", (Object)chapterId));
        }
        qFilters.add(new QFilter("type", "=", (Object)WordDataType.ReportResultJson.getType()));
        DynamicObject reportResult = QueryServiceHelper.queryOne((String)"fidm_word_history", (String)"id,content", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (reportResult == null) {
            String tips = ResManager.loadKDString((String)"\u62a5\u544a\u6570\u636e\u7ed3\u679c\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u505a\u7ec4\u4ef6\u6570\u636e\u91cd\u7f6e\u64cd\u4f5c\u3002", (String)"DisclosureServiceHelper_12", (String)"epm-far-business", (Object[])new Object[0]);
            throw new KDBizException(tips);
        }
        PreviewSaveResult saveResult = (PreviewSaveResult)JSON.parseObject((String)reportResult.getString("content"), PreviewSaveResult.class);
        if (saveResult == null) {
            String tips = ResManager.loadKDString((String)"\u62a5\u544a\u6570\u636e\u7ed3\u679c\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u505a\u7ec4\u4ef6\u6570\u636e\u91cd\u7f6e\u64cd\u4f5c\u3002", (String)"DisclosureServiceHelper_12", (String)"epm-far-business", (Object[])new Object[0]);
            throw new KDBizException(tips);
        }
        List<JSONObject> itemList = ReportModuleResetService.getValidItems(jsonObject, resetAll);
        return itemList;
    }

    public static HtmlPreviewNode replaceData(ModuleResetResult moduleResetResult) {
        String tips = "";
        try {
            List<JSONObject> itemList = moduleResetResult.getModuleList();
            HtmlNode htmlNode = moduleResetResult.getInput().getHtmlNode();
            HtmlPreviewNode previewResult = new HtmlPreviewNode();
            List<Map<String, String>> bookmarkElements = HtmlReplaceHelper.getBookmarkEntitys(htmlNode.getHtml());
            if (bookmarkElements.size() == 0) {
                tips = ResManager.loadKDString((String)"\u6587\u6863\u5185\u5bb9\u6ca1\u6709\u7ec4\u4ef6\uff0c\u4e0d\u80fd\u505a\u7ec4\u4ef6\u6570\u636e\u91cd\u7f6e\u64cd\u4f5c\u3002", (String)"DisclosureServiceHelper_11", (String)"epm-far-business", (Object[])new Object[0]);
                throw new KDBizException(tips);
            }
            JSONArray newItemList = new JSONArray();
            for (JSONObject itemOject : itemList) {
                String bookmarkKey;
                String id = itemOject.getString("id");
                Map find = bookmarkElements.stream().filter(m -> ((String)m.get("id")).equals(id) || ((String)m.get("moduleId")).equals(id)).findAny().orElse(null);
                if (find == null && StringUtils.isNotEmpty((String)(bookmarkKey = DisclosureJsonHelper.getValue(itemOject, "bookmark", "key", "")))) {
                    find = bookmarkElements.stream().filter(m -> ((String)m.get("id")).equals(id) || ((String)m.get("moduleId")).equals(id)).findAny().orElse(null);
                }
                if (find == null) continue;
                newItemList.add((Object)itemOject);
            }
            if (newItemList.size() == 0) {
                tips = ResManager.loadKDString((String)"\u6587\u6863\u5185\u5bb9\u6ca1\u6709\u7ec4\u4ef6\uff0c\u4e0d\u80fd\u505a\u7ec4\u4ef6\u6570\u636e\u91cd\u7f6e\u64cd\u4f5c\u3002", (String)"DisclosureServiceHelper_11", (String)"epm-far-business", (Object[])new Object[0]);
                throw new KDBizException(tips);
            }
            Map<String, WordNode> bookmarkNodes = WebModuleToNodeHelper.createBookmarkNodes(newItemList);
            HtmlNode newNode = new WebHtmlService().htmlReplaceBookmark(htmlNode, bookmarkNodes, true);
            previewResult.setHtmlNode(newNode);
            previewResult.setItemList(newItemList);
            return previewResult;
        }
        catch (Exception ex) {
            logger.error("dm  createPreviewHtmlByResetModule fail2 ", (Throwable)ex);
            throw ex;
        }
    }

    public static JSONObject moduleResetReturn(ModuleResetResult moduleResetResult) {
        ModuleResetInput input = moduleResetResult.getInput();
        JSONObject pageConfig = WebServiceHelper.getDefaultPageConfig(input.getDmModelId(), input.getChapterId(), moduleResetResult.getPreviewJson().getHtmlNode());
        List<JSONObject> itemList = moduleResetResult.getModuleList();
        Map<String, Object> dataInit = DisclosureDesignHelper.getDataInit(input.getDmModelId(), input.getChapterId(), false, new ArrayList<String>(10));
        List realModules = (List)dataInit.get("itemList");
        JSONArray newItemList = new JSONArray();
        for (JSONObject oldItem : realModules) {
            String moduleId = oldItem.getString("id");
            if (StringUtils.isEmpty((String)moduleId)) continue;
            JSONObject find = itemList.stream().filter(m -> moduleId.equalsIgnoreCase(m.getString("id"))).findFirst().orElse(null);
            if (find != null) {
                newItemList.add((Object)find);
                continue;
            }
            newItemList.add((Object)oldItem);
        }
        List<DimensionInfo> allDims = new ModelStrategyEx(input.getDmModelId()).getDim().getDimList();
        List<Map<String, Object>> dimList = DimensionUtils.dimConvertToMap(allDims);
        JSONObject gpt = DiscloseGPTService.getGptConfig();
        Map<String, String> report = ReportChapterHelper.getReport(input.getReportId());
        List<Map<String, Object>> chapters = ReportChapterHelper.getChapterInfoByReportAndPerm(input.getDmModelId(), input.getReportId());
        JSONObject dataVueObj = DisclosureVueHelper.dataChapterPreviewResult(report, chapters, DisclosureDesignHelper.getItemListByNoDataResult(newItemList), DisclosureDesignHelper.convertToBookList(newItemList), pageConfig, gpt, dimList, DisclosureDesignHelper.getI18n());
        return DisclosureDesignHelper.convertVueToFile(dataVueObj);
    }
}

