/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.web;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.ModuleEnum;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.module.calculate.dto.VarResult;
import kd.epm.far.business.fidm.web.WebModuleConvert;
import kd.epm.far.business.fidm.word.dto.WordImageNode;
import kd.epm.far.business.fidm.word.dto.WordNode;
import kd.epm.far.business.fidm.word.dto.WordTableNode;
import kd.epm.far.business.fidm.word.dto.WordTextNode;
import kd.epm.far.business.fidm.word.helper.WordNodeJsonHelper;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.util.GlobalIdUtil;

public class WebModuleToNodeHelper {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(WebModuleToNodeHelper.class);

    public static Map<String, WordNode> createBookmarkNodes(JSONArray itemList) {
        String tips = "";
        LinkedHashMap<String, WordNode> bookmarkNodes = new LinkedHashMap<String, WordNode>(2);
        for (Object item : itemList) {
            JSONObject itemObject = (JSONObject)item;
            if (itemObject == null) continue;
            WordNode moduleNode = null;
            String bookmarkKey = DisclosureJsonHelper.getValue(itemObject, "bookmark", "key", "module01");
            if (StringUtils.isEmpty((String)bookmarkKey)) {
                bookmarkKey = String.valueOf(GlobalIdUtil.genGlobalLongId());
            }
            String moduleId = itemObject.getString("id");
            String resultCode = "";
            HashMap<String, String> userFlag = new HashMap<String, String>(2);
            userFlag.put("moduleName", itemObject.getString("name"));
            userFlag.put("moduleId", moduleId);
            userFlag.put("moduleType", itemObject.getString("type"));
            try {
                JSONObject dataResult = WebModuleConvert.convertToHtml(itemObject);
                resultCode = DisclosureJsonHelper.getValue(dataResult, "code", "0000");
                if (!resultCode.equalsIgnoreCase("0000")) {
                    moduleNode = WebModuleToNodeHelper.createTextNode(DisclosureJsonHelper.getValue(dataResult, "message", ""));
                } else {
                    String moduleType = itemObject.getString("type");
                    if (ModuleEnum.VAR.getType().equalsIgnoreCase(moduleType)) {
                        VarResult varResult = (VarResult)DisclosureJsonHelper.getValueObject(dataResult, "data", "result");
                        moduleNode = WebModuleToNodeHelper.createTextNode(varResult.getResult(), varResult.getColor());
                    } else {
                        moduleNode = ModuleEnum.REPORT_INFO.getType().equalsIgnoreCase(moduleType) || ModuleEnum.TOC.getType().equalsIgnoreCase(moduleType) ? WebModuleToNodeHelper.createTextNode(DisclosureJsonHelper.getValue(dataResult, "data", "result", "")) : (ModuleEnum.TABLE.getType().equalsIgnoreCase(moduleType) ? WebModuleToNodeHelper.createTableNode(dataResult) : (ModuleEnum.REPORT_SECTION.getType().equalsIgnoreCase(moduleType) || ModuleEnum.EB_REPORT_SECTION.getType().equalsIgnoreCase(moduleType) ? WebModuleToNodeHelper.createTableNodeByReportSection(dataResult) : WebModuleToNodeHelper.createImageNode(itemObject)));
                    }
                    itemObject.put("data", dataResult.get((Object)"data"));
                }
            }
            catch (Exception ex) {
                logger.error("dm createBookmarkNodes fail", (Throwable)ex);
                tips = ResManager.loadKDString((String)"\u7ed3\u679c\u6570\u636e\u8f6c\u4e3aHtml\u65f6\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"WebHtmlService_6", (String)"epm-far-business", (Object[])new Object[0]);
                moduleNode = WebModuleToNodeHelper.createTextNode(tips);
                resultCode = "0001";
            }
            if (moduleNode == null) continue;
            moduleNode.setId(bookmarkKey);
            moduleNode.setDataModeuleId(moduleId);
            moduleNode.setDataModeuleResultCode(resultCode);
            moduleNode.setUserFlag(userFlag);
            bookmarkNodes.put(bookmarkKey, moduleNode);
        }
        return bookmarkNodes;
    }

    private static WordNode createTableNode(JSONObject dataResult) {
        String tips = "";
        WordTableNode tableNode = null;
        WordTextNode textNode = null;
        if (dataResult.getJSONObject("data") != null) {
            tableNode = (WordTableNode)WordNodeJsonHelper.parseObject(dataResult.getJSONObject("data").getString("tableNode"));
            String displayTextNodeString = dataResult.getJSONObject("data").getString("displayTextNode");
            if (StringUtils.isNotEmpty((String)displayTextNodeString)) {
                textNode = (WordTextNode)WordNodeJsonHelper.parseObject(displayTextNodeString);
            }
        }
        if (tableNode == null) {
            tips = ResManager.loadKDString((String)"\u8ba1\u7b97\u7ed3\u679c\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"WebHtmlService_4", (String)"epm-far-business", (Object[])new Object[0]);
            return WebModuleToNodeHelper.createTextNode(tips);
        }
        if (textNode != null) {
            return textNode;
        }
        return tableNode;
    }

    private static WordNode createImageNode(JSONObject itemObject) {
        WordImageNode imageNode = new WordImageNode();
        imageNode.setDescription(itemObject.getString("name"));
        imageNode.setName(itemObject.getString("name"));
        imageNode.setWidth(DisclosureJsonHelper.getValue(itemObject, "width", 15.0) * 27.62);
        imageNode.setHeight(DisclosureJsonHelper.getValue(itemObject, "height", 10.0) * 27.62);
        return imageNode;
    }

    private static WordNode createTableNodeByReportSection(JSONObject dataResult) {
        String tips = "";
        WordTableNode tableNode = null;
        if (dataResult.getJSONObject("data") != null) {
            tableNode = (WordTableNode)WordNodeJsonHelper.parseObject(dataResult.getJSONObject("data").getString("tableNode"));
        }
        if (tableNode == null) {
            tips = ResManager.loadKDString((String)"\u8ba1\u7b97\u7ed3\u679c\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"WebHtmlService_4", (String)"epm-far-business", (Object[])new Object[0]);
            return WebModuleToNodeHelper.createTextNode(tips);
        }
        return tableNode;
    }

    private static WordTextNode createTextNode(String content) {
        return WebModuleToNodeHelper.createTextNode(content, null);
    }

    private static WordTextNode createTextNode(String content, String fontColor) {
        WordTextNode textNode = new WordTextNode();
        textNode.setContent(content);
        if (StringUtils.isNotEmpty((String)fontColor)) {
            textNode.setFontColor(fontColor);
        }
        return textNode;
    }
}

