/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.web;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.PreviewFormType;
import kd.epm.far.business.common.expression.base.ExpressionResultTypeEnum;
import kd.epm.far.business.common.expression.base.ExpressionUtils;
import kd.epm.far.business.common.expression.calculate.ds.ExpressionDSTextHelper;
import kd.epm.far.business.common.expression.dto.ExpressionResult;
import kd.epm.far.business.common.expression.dto.eval.ExpressionDSEval;
import kd.epm.far.business.fidm.design.dto.PreviewInput;
import kd.epm.far.business.fidm.html.HtmlConvert;
import kd.epm.far.business.fidm.html.dto.HtmlNode;
import kd.epm.far.business.fidm.html.helper.HtmlSpecilCharHelper;
import kd.epm.far.business.fidm.html.helper.HtmlTableHelper;
import kd.epm.far.business.fidm.html.helper.HtmlTextHelper;
import kd.epm.far.business.fidm.util.TypeUtils;
import kd.epm.far.business.fidm.web.WebHtmlService;
import kd.epm.far.business.fidm.word.base.WordConstants;
import kd.epm.far.business.fidm.word.dto.WordRootNode;
import kd.epm.far.business.fidm.word.dto.WordTableNode;
import kd.epm.far.business.fidm.word.dto.expression.CellDataFill;
import kd.epm.far.business.fidm.word.helper.WordTableExpressionHelper;
import kd.epm.far.common.common.Tuple;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;

public class WebPluginExpressionHelper {
    protected static final WatchLogger logger = BcmLogFactory.getWatchLogInstance(WebPluginExpressionHelper.class);

    public static HtmlNode getHtmlNode(PreviewInput previewInput) {
        if (previewInput == null) {
            return null;
        }
        WebHtmlService webHtmlService = new WebHtmlService();
        String previewFormType = previewInput.getPreviewFormType();
        HtmlNode sourceHtmlNode = new HtmlNode();
        Long chapterId = previewInput.getChapterId();
        if (chapterId != null && chapterId > 0L) {
            sourceHtmlNode = webHtmlService.getChapterDesginHtml(chapterId, previewInput.getDocUrl(), previewInput.getDocUrlIsTempFile());
        }
        if (PreviewFormType.ModuleRepository.getType().equals(previewFormType)) {
            sourceHtmlNode = webHtmlService.getHtmlByUrl(previewInput.getDocUrl(), previewInput.getDocUrlIsTempFile());
        }
        boolean htmlChange = false;
        Tuple<List<WordTableNode>, Element, String> tableInfo = HtmlTableHelper.getTableNodes(sourceHtmlNode.getHtml());
        List tableNodes = (List)tableInfo.p1;
        for (WordTableNode tableNode : tableNodes) {
            WordTableExpressionHelper.IOperation operation;
            boolean isChange = WordTableExpressionHelper.reset(tableNode, operation = cellDataFillMap -> WebPluginExpressionHelper.refreshHtml(cellDataFillMap));
            if (!isChange) continue;
            htmlChange = true;
        }
        if (htmlChange) {
            sourceHtmlNode.setHtml(HtmlSpecilCharHelper.convertToHtmlBody(((Element)tableInfo.p2).html()));
        }
        return sourceHtmlNode;
    }

    private static boolean refreshHtml(Map<String, CellDataFill> cellDataFillMap) {
        boolean isChange = false;
        for (Map.Entry<String, CellDataFill> entry : cellDataFillMap.entrySet()) {
            CellDataFill cellDataFill = entry.getValue();
            if (!cellDataFill.isChange() || !(cellDataFill.getCell().getUserFlag() instanceof Element)) continue;
            HtmlTextHelper.setText((Node)((Element)cellDataFill.getCell().getUserFlag()), ExpressionDSTextHelper.getText(cellDataFill.getDs()));
            isChange = true;
        }
        return isChange;
    }

    public static WordRootNode getHtmlData(HtmlNode sourceHtmlNode) {
        HtmlConvert convert = new HtmlConvert();
        WordRootNode root = convert.fromHtml(sourceHtmlNode.getHtml(), WordConstants.WordContentType.Content.getType());
        return root;
    }

    public static HtmlNode resetHtmlData(HtmlNode sourceHtmlNode, Map<String, ExpressionResult> expressionMap) {
        if (sourceHtmlNode == null || expressionMap == null || expressionMap.isEmpty()) {
            return null;
        }
        String html = sourceHtmlNode.getHtml();
        if (StringUtils.isEmpty((String)sourceHtmlNode.getHtml())) {
            return null;
        }
        try {
            html = HtmlSpecilCharHelper.convertToHtmlTextByEmptyChar(html);
            Document doc = Jsoup.parse((String)html);
            Element body = doc.body();
            for (Element element : body.children()) {
                String tagName = element.tagName().toLowerCase();
                if ("table".equals(tagName)) {
                    WebPluginExpressionHelper.updateTable(element, expressionMap);
                    continue;
                }
                WebPluginExpressionHelper.updateParagraph(element, expressionMap);
            }
            String newHtml = HtmlSpecilCharHelper.convertToHtmlBody(body.html());
            return new HtmlNode(newHtml, sourceHtmlNode.getHeadHtml(), sourceHtmlNode.getFootHtml());
        }
        catch (KDBizException kdBizException) {
            throw kdBizException;
        }
        catch (Exception ex) {
            String message = ResManager.loadKDString((String)"\u91cd\u7f6e\u5728\u7ebf\u6570\u636e\u4e2d\u7684\u8868\u8fbe\u5f0f\u7ed3\u679c\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"WpsPluginExpressionHelper_2", (String)"epm-far-business", (Object[])new Object[0]);
            logger.error(message, (Throwable)ex);
            throw new KDBizException(message);
        }
    }

    private static void updateParagraph(Element element, Map<String, ExpressionResult> expressionMap) {
        boolean isParagraphValiad = false;
        FloatCellDataCommon common = new FloatCellDataCommon();
        common.row = null;
        common.rowIndex = -1;
        common.cell = element;
        common.cellIndex = -1;
        common.floatCellDataList = new ArrayList<FloatCellData>(10);
        common.expressionMap = expressionMap;
        ExpressionResult parentResult = expressionMap.get(element.text());
        if (parentResult != null && parentResult.isValiad()) {
            isParagraphValiad = true;
        }
        WebPluginExpressionHelper.updateNode(common, (Node)element, isParagraphValiad);
    }

    private static void updateTable(Element element, Map<String, ExpressionResult> expressionMap) {
        Element tbody = element.children().stream().filter(m -> "tbody".equalsIgnoreCase(m.tagName())).findFirst().orElse(null);
        if (tbody == null) {
            return;
        }
        Elements rowsList = tbody.getElementsByTag("tr");
        ArrayList<FloatCellData> floatCellDataList = new ArrayList<FloatCellData>(10);
        for (int i = 0; i < rowsList.size(); ++i) {
            Element rowElement = (Element)rowsList.get(i);
            for (int j = 0; j < rowElement.children().size(); ++j) {
                Element cellElement = (Element)rowElement.children().get(j);
                FloatCellDataCommon common = new FloatCellDataCommon();
                common.row = rowElement;
                common.rowIndex = i;
                common.cell = cellElement;
                common.cellIndex = j;
                common.floatCellDataList = floatCellDataList;
                common.expressionMap = expressionMap;
                boolean isCellValiad = false;
                ExpressionResult parentResult = expressionMap.get(cellElement.text());
                if (parentResult != null && parentResult.isValiad()) {
                    isCellValiad = true;
                }
                WebPluginExpressionHelper.updateNode(common, (Node)cellElement, isCellValiad);
            }
        }
        WebPluginExpressionHelper.updateFloatTable(tbody, floatCellDataList);
    }

    private static boolean updateNode(FloatCellDataCommon common, Node parent, boolean isCellValiad) {
        String content;
        ExpressionResult expressionResult;
        boolean isSuccess = false;
        Map<String, ExpressionResult> expressionMap = common.expressionMap;
        for (Node node : parent.childNodes()) {
            if (!WebPluginExpressionHelper.updateNode(common, node, isCellValiad)) continue;
            isSuccess = true;
        }
        if (!(isSuccess || (expressionResult = expressionMap.get(content = HtmlTextHelper.getText(parent))) == null || !expressionResult.isValiad() && isCellValiad)) {
            ExpressionDSEval floatDs = ExpressionUtils.getFloatDs(expressionResult.getRoot());
            if (floatDs != null && ExpressionResultTypeEnum.List.getType().equalsIgnoreCase(floatDs.getResultType())) {
                FloatCellData floatCellData = new FloatCellData();
                floatCellData.row = common.row;
                floatCellData.rowIndex = common.rowIndex;
                floatCellData.cell = common.cell;
                floatCellData.cellIndex = common.cellIndex;
                floatCellData.run = parent;
                floatCellData.expressionResult = expressionResult;
                floatCellData.floatDS = floatDs;
                common.floatCellDataList.add(floatCellData);
            } else {
                HtmlTextHelper.setText(parent, expressionResult.getResult());
            }
            isSuccess = true;
        }
        return isSuccess;
    }

    private static void updateFloatTable(Element tbody, List<FloatCellData> floatCellDataList) {
        int rowCellMaxCount = WebPluginExpressionHelper.getMaxColumns(tbody);
        String tips = "";
        for (FloatCellData floatCell : floatCellDataList) {
            List<Map<String, Object>> cellDatas = floatCell.floatDS.getListResult();
            int rowCount = cellDatas.size();
            int cloumnCount = cellDatas.size() > 0 ? cellDatas.get(0).size() : 0;
            if (WebPluginExpressionHelper.isMergeRow(floatCell, rowCellMaxCount) || rowCount <= 0 || (cloumnCount += floatCell.cellIndex) <= 0) continue;
            if (cloumnCount > floatCell.row.children().size()) {
                if (WebPluginExpressionHelper.isMergeColumn(tbody, floatCell)) continue;
                WebPluginExpressionHelper.insertColumn(tbody, cloumnCount - floatCell.row.children().size());
            }
            WebPluginExpressionHelper.setCell(floatCell.row, cellDatas.get(0), floatCell.cellIndex);
            if (rowCount <= 1) continue;
            WebPluginExpressionHelper.insertRows(tbody, floatCell.row, cellDatas, floatCell.cellIndex);
        }
    }

    private static void insertColumn(Element tbody, int insertColumnCount) {
        Elements rowsList = tbody.getElementsByTag("tr");
        for (int i = 0; i < rowsList.size(); ++i) {
            Element rowElement = (Element)rowsList.get(i);
            Element lastCellElement = (Element)rowElement.children().get(rowElement.children().size() - 1);
            for (int inc = 0; inc < insertColumnCount; ++inc) {
                Element newCopyCell = lastCellElement.clone();
                rowElement.appendChild((Node)newCopyCell);
            }
        }
    }

    private static boolean isMergeColumn(Element tbody, FloatCellData floatCell) {
        boolean isMerge = false;
        Elements rowsList = tbody.getElementsByTag("tr");
        for (int i = 0; i < rowsList.size(); ++i) {
            Element rowElement = (Element)rowsList.get(i);
            Element lastCellElement = (Element)rowElement.children().get(rowElement.children().size() - 1);
            int columnspan = TypeUtils.convertValueToInt(lastCellElement.attr("colspan"));
            if (columnspan <= 1) continue;
            isMerge = true;
        }
        if (isMerge) {
            String tips = ResManager.loadKDString((String)"\u6700\u540e\u4e00\u5217\u5b58\u5728\u5408\u5e76\u5355\u5143\u683c\uff0c\u4e0d\u652f\u6301\u6d6e\u52a8\u7ed1\u5b9a\u516c\u5f0f\u6269\u5145\u5217\u3002", (String)"ExpressionDSHelper_17", (String)"epm-far-business", (Object[])new Object[0]);
            if (floatCell.run instanceof Element) {
                ((Element)floatCell.run).text("#" + tips);
            }
            if (floatCell.run instanceof TextNode) {
                ((TextNode)floatCell.run).text("#" + tips);
            }
        }
        return isMerge;
    }

    private static boolean isMergeRow(FloatCellData floatCell, int rowCellMaxCount) {
        boolean isMerge = false;
        if (floatCell.row.children().size() < rowCellMaxCount) {
            isMerge = true;
        } else {
            for (int j = 0; j < floatCell.row.children().size(); ++j) {
                Element cellElement = (Element)floatCell.row.children().get(j);
                int rowSpan = TypeUtils.convertValueToInt(cellElement.attr("rowspan"));
                if (rowSpan <= 1) continue;
                isMerge = true;
            }
        }
        if (isMerge) {
            String tips = ResManager.loadKDString((String)"\u5f53\u524d\u884c\u5b58\u5728\u5408\u5e76\u5355\u5143\u683c\uff0c\u4e0d\u652f\u6301\u6d6e\u52a8\u7ed1\u5b9a\u516c\u5f0f\u3002", (String)"ExpressionDSHelper_16", (String)"epm-far-business", (Object[])new Object[0]);
            if (floatCell.run instanceof Element) {
                ((Element)floatCell.run).text("#" + tips);
            }
            if (floatCell.run instanceof TextNode) {
                ((TextNode)floatCell.run).text("#" + tips);
            }
        }
        return isMerge;
    }

    private static void setCell(Element rowElement, Map<String, Object> cellData, int cellIndex) {
        int cloumnCount;
        if (cellIndex < 0) {
            cellIndex = 0;
        }
        if ((cloumnCount = cellData.size()) == 0) {
            return;
        }
        ArrayList<String> runData = new ArrayList<String>(cellData.size());
        for (Map.Entry<String, Object> item : cellData.entrySet()) {
            runData.add(item.getValue() == null ? "" : item.getValue().toString());
        }
        for (int j = cellIndex; j < cellIndex + cloumnCount; ++j) {
            Element cellElement;
            if (rowElement.children().size() <= j || (cellElement = (Element)rowElement.children().get(j)) == null) continue;
            String val = runData.get(j - cellIndex) == null ? "" : (String)runData.get(j - cellIndex);
            Elements spans = cellElement.getElementsByTag("span");
            Elements ps = cellElement.getElementsByTag("p");
            if (spans.size() > 0) {
                ((Element)spans.get(0)).text(val);
                continue;
            }
            if (ps.size() > 0) {
                ((Element)ps.get(0)).text(val);
                continue;
            }
            cellElement.text(val);
        }
    }

    private static void insertRows(Element tbody, Element row, List<Map<String, Object>> cellDatas, int cellIndex) {
        int insertRowCount = cellDatas.size() - 1;
        ArrayList<Element> rows = new ArrayList<Element>(insertRowCount);
        for (int i = 0; i < insertRowCount; ++i) {
            Element newCopyRow = row.clone();
            WebPluginExpressionHelper.setCell(newCopyRow, cellDatas.get(i + 1), cellIndex);
            rows.add(newCopyRow);
        }
        int index = tbody.childNodes().indexOf(row);
        if (index >= 0) {
            tbody.insertChildren(index + 1, rows);
        }
    }

    private static int getMaxColumns(Element tbody) {
        Elements rowsList = tbody.getElementsByTag("tr");
        int cellCount = 0;
        for (int i = 0; i < rowsList.size(); ++i) {
            Element rowElement = (Element)rowsList.get(i);
            if (rowElement.children().size() <= cellCount) continue;
            cellCount = rowElement.children().size();
        }
        return cellCount;
    }

    private static class FloatCellData {
        public Element row;
        public int rowIndex;
        public Element cell;
        public int cellIndex;
        public Node run;
        public ExpressionResult expressionResult;
        public ExpressionDSEval floatDS;

        private FloatCellData() {
        }
    }

    private static class FloatCellDataCommon {
        public Element row;
        public int rowIndex;
        public Element cell;
        public int cellIndex;
        public List<FloatCellData> floatCellDataList;
        public Map<String, ExpressionResult> expressionMap;

        private FloatCellDataCommon() {
        }
    }
}

