/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.web;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.OpenWordEnum;
import kd.epm.far.business.common.model.DimensionUtils;
import kd.epm.far.business.common.model.ModelStrategyEx;
import kd.epm.far.business.fidm.base.DisclosureVueHelper;
import kd.epm.far.business.fidm.base.ISaveOperation;
import kd.epm.far.business.fidm.chapter.DisclosureChapterHelper;
import kd.epm.far.business.fidm.design.DisclosureDesignHelper;
import kd.epm.far.business.fidm.design.dto.ChapterPreviewResult;
import kd.epm.far.business.fidm.design.dto.PreviewResult;
import kd.epm.far.business.fidm.gpt.DiscloseGPTService;
import kd.epm.far.business.fidm.html.dto.HtmlNode;
import kd.epm.far.business.fidm.html.dto.HtmlPreviewNode;
import kd.epm.far.business.fidm.html.helper.HtmlTocHelper;
import kd.epm.far.business.fidm.perm.PermClassReportHelper;
import kd.epm.far.business.fidm.report.DisclosureReportHelper;
import kd.epm.far.business.fidm.report.ReportChapterHelper;
import kd.epm.far.business.fidm.web.WebHtmlService;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.util.GlobalIdUtil;
import kd.epm.far.common.common.util.QFBuilder;

public class WebServiceHelper {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(WebServiceHelper.class);

    public static JSONObject dataInit(Long dmModelId, Long chapterId, boolean isReset, List<String> strTips, Map<Long, String> chapterPermMap) {
        JSONObject dataObj = DisclosureDesignHelper.dataInit(dmModelId, chapterId, isReset, strTips, chapterPermMap);
        DynamicObject chapter = DisclosureChapterHelper.getChapter(chapterId);
        List<String> charpterTips = DisclosureDesignHelper.checkChapter(chapterId, OpenWordEnum.WEB.getTypeToInt());
        if (charpterTips.size() > 0) {
            strTips.addAll(charpterTips);
        }
        HtmlNode htmlNode = new WebHtmlService().getChapterDesginHtml(chapterId, chapter.getString("url"), false);
        JSONObject pageConfig = WebServiceHelper.getDefaultPageConfig(0L, chapterId, htmlNode);
        pageConfig.put("intelliEnabled", (Object)true);
        dataObj.put("pageConfig", (Object)pageConfig);
        dataObj.put("gpt", (Object)DiscloseGPTService.getGptConfig());
        return DisclosureDesignHelper.convertVueToFile(dataObj);
    }

    public static JSONObject dataReportPreview(Long dmModelId, Long reportId) {
        Tuple<HtmlNode, JSONArray> reportView = WebServiceHelper.getReportView(dmModelId, reportId);
        JSONObject pageConfig = WebServiceHelper.getDefaultPageConfig(reportId, 0L, (HtmlNode)reportView.item1);
        pageConfig.put("showToc", (Object)true);
        JSONObject dataVueObj = DisclosureVueHelper.dataPreviewResult(pageConfig, DisclosureDesignHelper.getI18n(), DisclosureDesignHelper.getItemListByNoDataResult((JSONArray)reportView.item2), DisclosureDesignHelper.convertToBookList((JSONArray)reportView.item2));
        return DisclosureDesignHelper.convertVueToFile(dataVueObj);
    }

    private static Tuple<HtmlNode, JSONArray> getReportView(Long dmModelId, Long reportId) {
        List<Long> chapterids = PermClassReportHelper.getValiadChaptersByReport(dmModelId, reportId);
        WebHtmlService webHtmlService = new WebHtmlService();
        StringBuilder chapterHtml = new StringBuilder();
        String headHtml = "";
        String footHtml = "";
        JSONArray allChapterItemList = new JSONArray();
        QFBuilder qf = new QFBuilder("model", "=", (Object)dmModelId);
        qf.add(new QFilter("id", "in", chapterids));
        DynamicObject[] chapters = BusinessDataServiceHelper.load((String)"fidm_chapter", (String)"id,previewurl", (QFilter[])qf.toArray(), (String)"sequence");
        HtmlPreviewNode previewJson = null;
        for (DynamicObject chapter : chapters) {
            Long chapterId = chapter.getLong("id");
            String docUrl = chapter.getString("previewurl");
            DynamicObject reportJsonDy = webHtmlService.getChapterPreviewJsonObject(reportId, chapterId);
            if (reportJsonDy == null) {
                HtmlNode sourceHtmlNode = webHtmlService.getHtmlByUrl(docUrl, false);
                previewJson = webHtmlService.createPreviewHtml(dmModelId, reportId, chapterId, sourceHtmlNode);
            } else {
                previewJson = (HtmlPreviewNode)JSON.parseObject((String)reportJsonDy.getString("content"), HtmlPreviewNode.class);
                webHtmlService.htmlReplaceOther(previewJson.getHtmlNode());
            }
            HtmlNode previewNode = previewJson.getHtmlNode();
            JSONArray previewItemList = previewJson.getItemList();
            if (StringUtils.isNotEmpty((String)previewNode.getHtml())) {
                chapterHtml.append(previewNode.getHtml());
            }
            if (previewItemList != null && previewItemList.size() > 0) {
                allChapterItemList.addAll((Collection)previewItemList);
            }
            if (StringUtils.isNotEmpty((String)previewNode.getHeadHtml())) {
                headHtml = previewNode.getHeadHtml();
            }
            if (!StringUtils.isNotEmpty((String)previewNode.getFootHtml())) continue;
            footHtml = previewNode.getFootHtml();
        }
        String bodyHtml = HtmlTocHelper.refreshToc(chapterHtml.toString());
        return new Tuple((Object)new HtmlNode(bodyHtml, headHtml, footHtml), (Object)allChapterItemList);
    }

    public static void createReportHtml(Long dmModelId, Long reportId, ChapterPreviewResult chapterPreviewResult) {
        DynamicObject report = BusinessDataServiceHelper.loadSingle((Object)reportId, (String)"fidm_report");
        if (report == null) {
            return;
        }
        DynamicObjectCollection entryEntitys = report.getDynamicObjectCollection("entryentity");
        WebHtmlService webHtmlService = new WebHtmlService();
        for (DynamicObject entry : entryEntitys) {
            Long chapterId = entry.getLong("chapter.id");
            String docUrl = entry.getString("chapter.url");
            String previewUrl = entry.getString("chapter.previewurl");
            PreviewResult previewResult = chapterPreviewResult.getPreviewResults().stream().filter(m -> Objects.equals(m.getInput().getChapterId(), chapterId)).findFirst().orElse(null);
            if (previewResult == null) continue;
            HtmlPreviewNode previewJson = null;
            if (previewResult.getHtmlPreviewNode() == null) {
                HtmlNode sourceHtmlNode = null;
                DynamicObject htmlDy = webHtmlService.getChapterDesginHtmlObject(chapterId, new Date(631123200000L));
                sourceHtmlNode = htmlDy == null ? webHtmlService.getHtmlByUrl(docUrl, false) : (HtmlNode)JSONObject.parseObject((String)htmlDy.getString("content"), HtmlNode.class);
                previewJson = webHtmlService.createPreviewHtml(dmModelId, reportId, chapterId, sourceHtmlNode);
            } else {
                previewJson = previewResult.getHtmlPreviewNode();
            }
            webHtmlService.savePreviewHtml(dmModelId, reportId, chapterId, previewUrl, previewJson);
        }
    }

    public static JSONObject dataReportEdit(Long dmModelId, Long reportId, Long chapterId, List<String> strTips, Map<Long, String> chapterPermMap, boolean convertVueToFile) {
        HtmlNode sourceHtmlNode;
        String docUrl;
        WebHtmlService webHtmlService = new WebHtmlService();
        DynamicObject chapter = DisclosureChapterHelper.getChapter(chapterId);
        int savewordtype = chapter.getInt("savewordtype");
        HtmlPreviewNode previewJson = null;
        DynamicObject reportJsonDy = webHtmlService.getChapterPreviewJsonObject(reportId, chapterId);
        if (savewordtype != OpenWordEnum.WEB.getTypeToInt()) {
            docUrl = chapter.getString("previewurl");
            sourceHtmlNode = webHtmlService.getHtmlByUrl(docUrl, false);
            previewJson = webHtmlService.createPreviewHtmlByInit(chapterId, sourceHtmlNode);
        } else if (reportJsonDy == null) {
            docUrl = chapter.getString("previewurl");
            sourceHtmlNode = webHtmlService.getHtmlByUrl(docUrl, false);
            previewJson = webHtmlService.createPreviewHtml(dmModelId, reportId, chapterId, sourceHtmlNode);
        } else {
            previewJson = (HtmlPreviewNode)JSON.parseObject((String)reportJsonDy.getString("content"), HtmlPreviewNode.class);
            webHtmlService.htmlReplaceOther(previewJson.getHtmlNode());
        }
        List<String> charpterTips = DisclosureDesignHelper.checkChapter(chapterId, OpenWordEnum.WEB.getTypeToInt());
        if (charpterTips.size() > 0) {
            strTips.addAll(charpterTips);
        }
        JSONObject pageConfig = WebServiceHelper.getDefaultPageConfig(dmModelId, chapterId, previewJson.getHtmlNode());
        JSONArray itemList = previewJson.getItemList();
        if (itemList == null) {
            itemList = new JSONArray();
        }
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        List<Map<String, Object>> dimList = DimensionUtils.dimConvertToMap(modelStrategyEx.getDim().getDimList());
        JSONObject gpt = DiscloseGPTService.getGptConfig();
        Map<String, String> report = ReportChapterHelper.getReport(reportId);
        List<Map<String, Object>> chapters = ReportChapterHelper.getChapterInfoByReportAndPerm(reportId, chapterPermMap);
        JSONObject dataVueObj = DisclosureVueHelper.dataChapterPreviewResult(report, chapters, DisclosureDesignHelper.getItemListByNoDataResult(itemList), DisclosureDesignHelper.convertToBookList(itemList), pageConfig, gpt, dimList, DisclosureDesignHelper.getI18n());
        if (convertVueToFile) {
            return DisclosureDesignHelper.convertVueToFile(dataVueObj);
        }
        return dataVueObj;
    }

    public static JSONObject dataReportEdit(Long dmModelId, Long reportId, Map<Long, String> chapterPermMap) {
        Tuple<HtmlNode, JSONArray> reportView = WebServiceHelper.getReportView(dmModelId, reportId);
        JSONObject pageConfig = WebServiceHelper.getDefaultPageConfig(dmModelId, 0L, (HtmlNode)reportView.item1);
        JSONArray itemList = (JSONArray)reportView.item2;
        if (itemList == null) {
            itemList = new JSONArray();
        }
        ModelStrategyEx modelStrategyEx = new ModelStrategyEx(dmModelId);
        List<Map<String, Object>> dimList = DimensionUtils.dimConvertToMap(modelStrategyEx.getDim().getDimList());
        JSONObject gpt = DiscloseGPTService.getGptConfig();
        Map<String, String> report = ReportChapterHelper.getReport(reportId);
        List<Map<String, Object>> chapters = ReportChapterHelper.getChapterInfoByReportAndPerm(reportId, chapterPermMap);
        JSONObject dataVueObj = DisclosureVueHelper.dataChapterPreviewResult(report, chapters, DisclosureDesignHelper.getItemListByNoDataResult(itemList), DisclosureDesignHelper.convertToBookList(itemList), pageConfig, gpt, dimList, DisclosureDesignHelper.getI18n());
        return DisclosureDesignHelper.convertVueToFile(dataVueObj);
    }

    public static JSONObject dataPreview(ChapterPreviewResult previewResult) {
        if (previewResult == null || previewResult.getPreviewResults().size() == 0) {
            return null;
        }
        PreviewResult firestChapterResult = previewResult.getPreviewResults().get(0);
        Long chapterId = previewResult.getPreviewResults().size() > 1 ? firestChapterResult.getInput().getChapterId() : 0L;
        HtmlPreviewNode previewJson = new HtmlPreviewNode();
        StringBuilder chapterHtml = new StringBuilder();
        JSONArray allChapterItemList = new JSONArray();
        String headHtml = "";
        String footHtml = "";
        boolean isFirst = true;
        for (PreviewResult chapterResult : previewResult.getPreviewResults()) {
            previewJson = chapterResult.getHtmlPreviewNode();
            HtmlNode previewHtmlNode = previewJson.getHtmlNode();
            if (StringUtils.isNotEmpty((String)previewHtmlNode.getHtml())) {
                chapterHtml.append(previewHtmlNode.getHtml());
            }
            if (chapterResult.getInput().getModuleList().size() > 0) {
                allChapterItemList.addAll(chapterResult.getInput().getModuleList());
            }
            if (!isFirst) continue;
            isFirst = false;
            headHtml = previewHtmlNode.getHeadHtml();
            footHtml = previewHtmlNode.getFootHtml();
        }
        String bodyHtml = HtmlTocHelper.refreshToc(chapterHtml.toString());
        previewJson.setHtmlNode(new HtmlNode(bodyHtml, headHtml, footHtml));
        previewJson.setItemList(allChapterItemList);
        JSONObject pageConfig = WebServiceHelper.getDefaultPageConfig(firestChapterResult.getInput().getId(), chapterId, previewJson.getHtmlNode());
        JSONArray itemList = previewJson.getItemList();
        JSONObject dataVueObj = DisclosureVueHelper.dataPreviewResult(pageConfig, DisclosureDesignHelper.getI18n(), DisclosureDesignHelper.getItemListByNoDataResult(itemList), DisclosureDesignHelper.convertToBookList(itemList));
        return DisclosureDesignHelper.convertVueToFile(dataVueObj);
    }

    public static boolean saveTemplateChapter(Long dmModelId, Long chapterId, String eventArgs) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        JSONObject pageConfig = jsonObject.getJSONObject("pageConfig");
        JSONArray itemList = jsonObject.getJSONArray("itemList");
        JSONArray bookmarkList = jsonObject.getJSONArray("bookmarkList");
        DynamicObject chapter = DisclosureChapterHelper.getChapter(chapterId);
        HtmlNode htmlNode = new HtmlNode(pageConfig.getString("html"), pageConfig.getString("headHtml"), pageConfig.getString("footHtml"));
        WebHtmlService webHtmlService = new WebHtmlService();
        String pageConfigId = pageConfig.getString("id");
        if (!chapterId.toString().equalsIgnoreCase(pageConfigId)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u7684\u5185\u5bb9\u4e0d\u662f\u7ae0\u8282\u201c%1$s\u201c\u7684\u5185\u5bb9\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u5f53\u524d\u7ae0\u8282\u6216\u9000\u51fa\u91cd\u8fdb\u3002", (String)"DisclosureServiceHelper_25", (String)"epm-far-business", (Object[])new Object[0]), chapter.getString("name")));
        }
        ISaveOperation saveOperation = c -> {
            String docUrl = webHtmlService.createUrlByHtml(chapterId, chapter.getString("name"), htmlNode, itemList, bookmarkList, true);
            return docUrl;
        };
        String docId = pageConfig.getString("docId");
        if (StringUtils.isEmpty((String)docId)) {
            docId = String.valueOf(GlobalIdUtil.genGlobalLongId());
        }
        Tuple<Boolean, String> result = DisclosureDesignHelper.save(dmModelId, chapterId, saveOperation, eventArgs, OpenWordEnum.WEB.getTypeToInt());
        if (((Boolean)result.item1).booleanValue()) {
            webHtmlService.saveTemplateDesginHtml(dmModelId, chapterId, docId, (String)result.item2, htmlNode);
        }
        return (Boolean)result.item1;
    }

    public static void previewByUrl(IFormView view, String appId, Long dmModelId, ChapterPreviewResult previewResult) {
        if (previewResult == null) {
            return;
        }
        IFormView mainPageView = view.getMainView();
        IFormView parentView = view.getParentView();
        if (view.getFormShowParameter().getOpenStyle().getShowType() == ShowType.NewWindow) {
            parentView = null;
        }
        String formId = "fidm_webpreview";
        String pageId = GlobalIdUtil.genGlobalLongId() + formId;
        String tips = ResManager.loadKDString((String)"\u9884\u89c8", (String)"DisclosureServiceHelper_4", (String)"epm-far-business", (Object[])new Object[0]);
        if (mainPageView == null || mainPageView.getView(pageId) == null) {
            HashMap<String, Object> customParams = new HashMap<String, Object>(8);
            customParams.put("previewResult", JSON.toJSONString((Object)previewResult));
            customParams.put("KEY_MODEL_ID", dmModelId);
            customParams.put("appId", appId);
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId(formId);
            formShowParameter.setCustomParams(customParams);
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            formShowParameter.setCaption(previewResult.getTitle() + "-" + tips);
            formShowParameter.setPageId(pageId);
            if (parentView != null) {
                parentView.showForm(formShowParameter);
                view.sendFormAction(parentView);
            } else {
                formShowParameter.getOpenStyle().setShowType(ShowType.NewWindow);
                view.showForm(formShowParameter);
            }
        } else {
            IFormView childFormView = mainPageView.getView(pageId);
            childFormView.activate();
            view.sendFormAction(childFormView);
        }
    }

    public static JSONObject getDefaultPageConfig(Long reportId, Long chapterId, HtmlNode htmlNode) {
        JSONObject dataObj = new JSONObject();
        dataObj.put("id", (Object)(chapterId == null || chapterId <= 0L ? String.valueOf(GlobalIdUtil.genStringId()) : chapterId.toString()));
        if (reportId != null && reportId > 0L) {
            dataObj.put("reportId", (Object)reportId);
        }
        if (chapterId != null && chapterId > 0L) {
            DisclosureDesignHelper.setPageConfigForChapterInfo(dataObj, chapterId);
        }
        dataObj.put("docId", (Object)String.valueOf(GlobalIdUtil.genGlobalLongId()));
        dataObj.put("html", (Object)htmlNode.getHtml());
        dataObj.put("headHtml", (Object)htmlNode.getHeadHtml());
        dataObj.put("footHtml", (Object)htmlNode.getFootHtml());
        dataObj.put("type", (Object)OpenWordEnum.WEB.toString().toLowerCase());
        if (!StringUtils.isEmpty((String)RequestContext.get().getGlobalSessionId())) {
            dataObj.put("token", (Object)RequestContext.get().getGlobalSessionId());
        }
        return dataObj;
    }

    public static boolean saveReportChapter(Long reportId, Long chapterId, String eventArgs) {
        JSONObject jsonObject = JSON.parseObject((String)eventArgs);
        JSONObject pageConfig = jsonObject.getJSONObject("pageConfig");
        JSONArray itemList = jsonObject.getJSONArray("itemList");
        DynamicObject chapter = BusinessDataServiceHelper.loadSingle((Object)chapterId, (String)"fidm_chapter");
        if (chapter == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ae0\u8282\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"DisclosureServiceHelper_3", (String)"epm-far-business", (Object[])new Object[0]));
        }
        Long dmModelId = chapter.getLong("model.id");
        HtmlNode htmlNode = new HtmlNode(pageConfig.getString("html"), pageConfig.getString("headHtml"), pageConfig.getString("footHtml"));
        WebHtmlService webHtmlService = new WebHtmlService();
        String pageConfigId = pageConfig.getString("id");
        if (!chapterId.toString().equalsIgnoreCase(pageConfigId)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u7684\u5185\u5bb9\u4e0d\u662f\u7ae0\u8282\u201c%1$s\u201c\u7684\u5185\u5bb9\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u5f53\u524d\u7ae0\u8282\u6216\u9000\u51fa\u91cd\u8fdb\u3002", (String)"DisclosureServiceHelper_25", (String)"epm-far-business", (Object[])new Object[0]), chapter.getString("name")));
        }
        ISaveOperation saveOperation = c -> {
            String docUrl = webHtmlService.createUrlByHtml(chapterId, chapter.getString("name"), htmlNode, itemList, null, false);
            return docUrl;
        };
        Tuple<Boolean, String> result = DisclosureReportHelper.saveReportChapter(reportId, chapterId, saveOperation, eventArgs, OpenWordEnum.WEB.getTypeToInt());
        if (((Boolean)result.item1).booleanValue()) {
            HtmlPreviewNode previewJson = null;
            DynamicObject reportJsonDy = webHtmlService.getChapterPreviewJsonObject(reportId, chapterId);
            if (reportJsonDy == null) {
                previewJson = webHtmlService.createPreviewHtml(dmModelId, reportId, chapterId, htmlNode);
            } else {
                previewJson = (HtmlPreviewNode)JSON.parseObject((String)reportJsonDy.getString("content"), HtmlPreviewNode.class);
                previewJson.setHtmlNode(htmlNode);
            }
            previewJson.setItemList(itemList);
            webHtmlService.savePreviewHtml(dmModelId, reportId, chapterId, (String)result.item2, previewJson);
        }
        return (Boolean)result.item1;
    }

    public static JSONObject getModuleByReport(Long reportId, Long chapterId, Long moduleId) {
        JSONObject item;
        WebHtmlService webHtmlService = new WebHtmlService();
        DynamicObject reportJsonDy = webHtmlService.getChapterPreviewJsonObject(reportId, chapterId);
        if (reportJsonDy == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u544a\u4e2d\u7684\u7ec4\u4ef6\u6570\u636e\u6b8b\u7f3a\uff0c\u53ef\u80fd\u4e3a\u65e7\u7248\u672c\u4e0d\u652f\u6301\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DisclosureServiceHelper_17", (String)"epm-far-business", (Object[])new Object[0]));
        }
        HtmlPreviewNode previewJson = (HtmlPreviewNode)JSON.parseObject((String)reportJsonDy.getString("content"), HtmlPreviewNode.class);
        JSONArray itemList = previewJson.getItemList();
        if (itemList == null) {
            itemList = new JSONArray();
        }
        if ((item = (JSONObject)itemList.stream().filter(m -> ((Map)m).get("id").toString().equalsIgnoreCase(String.valueOf(moduleId))).findFirst().orElse(null)) == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9875\u9762\u7ec4\u4ef6\u5bf9\u5e94\u7ec4\u4ef6\u6570\u636e\u67e5\u627e\u5931\u8d25\uff0c\u53ef\u80fd\u4e3a\u65e7\u7248\u672c\u4e0d\u652f\u6301\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"DisclosureServiceHelper_18", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return item;
    }
}

