/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.word;

import com.deepoove.poi.xwpf.NiceXWPFDocument;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.epm.far.business.fidm.base.DisclosureFileHelper;
import kd.epm.far.business.fidm.word.dto.MergeDocFileItem;
import kd.epm.far.business.fidm.word.helper.WordRepairHelper;
import kd.epm.far.business.fidm.word.poi.PoiOoxmlUpdateUtil;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import org.apache.poi.xwpf.usermodel.BreakType;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSimpleField;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STHighlightColor;

public class MergeDocUtils {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(MergeDocUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] merge(List<MergeDocFileItem> fileItems, List<String> tips) {
        if (fileItems == null) {
            return null;
        }
        if (fileItems.size() > 1) {
            fileItems.sort(new Comparator<MergeDocFileItem>(){

                @Override
                public int compare(MergeDocFileItem o1, MergeDocFileItem o2) {
                    return o1.getSeq() - o2.getSeq();
                }
            });
        }
        try {
            NiceXWPFDocument newDoc = null;
            for (int i = 0; i < fileItems.size(); ++i) {
                MergeDocFileItem item = fileItems.get(i);
                try (InputStream in = null;){
                    String msg;
                    String fileName;
                    in = DisclosureFileHelper.getFileInputStream(item.getUrl(), item.getTempFile());
                    if (i != 0 && newDoc != null) {
                        newDoc.createParagraph().createRun().addBreak(BreakType.PAGE);
                        try {
                            NiceXWPFDocument sub = new NiceXWPFDocument(in);
                            newDoc = newDoc.merge(sub);
                        }
                        catch (Exception exception) {
                            fileName = item.getName();
                            msg = ResManager.loadKDString((String)"\u6309\u7ae0\u8282\u5408\u5e76\u751f\u6210\u62a5\u544a\u5f02\u5e38\u3002", (String)"ReportEditPlgin_14", (String)"epm-far-business", (Object[])new Object[0]);
                            tips.add(fileName + ":" + msg);
                        }
                        continue;
                    }
                    try {
                        newDoc = new NiceXWPFDocument(in);
                    }
                    catch (Exception exception) {
                        fileName = item.getName();
                        msg = ResManager.loadKDString((String)"\u6309\u7ae0\u8282\u5408\u5e76\u751f\u6210\u62a5\u544a\u5f02\u5e38\u3002", (String)"ReportEditPlgin_14", (String)"epm-far-business", (Object[])new Object[0]);
                        tips.add(fileName + ":" + msg);
                    }
                    continue;
                }
            }
            if (newDoc == null) {
                return null;
            }
            MergeDocUtils.generateTOC(newDoc);
            WordRepairHelper.repair(newDoc);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            newDoc.write((OutputStream)baos);
            return baos.toByteArray();
        }
        catch (KDBizException kdEx) {
            throw kdEx;
        }
        catch (Exception ex) {
            String msg = ResManager.loadKDString((String)"\u6309\u7ae0\u8282\u5408\u5e76\u751f\u6210\u62a5\u544a\u5f02\u5e38\u3002", (String)"ReportEditPlgin_14", (String)"epm-far-business", (Object[])new Object[0]);
            logger.error(msg, (Throwable)ex);
            throw new KDBizException(msg);
        }
    }

    private static void generateTOC(XWPFDocument document) {
        try {
            String findText = "Table of Contents";
            String replaceText = ResManager.loadKDString((String)"\u76ee  \u5f55", (String)"MergeDocPlugin_1", (String)"epm-far-business", (Object[])new Object[0]);
            boolean flag = false;
            for (XWPFParagraph p : document.getParagraphs()) {
                for (XWPFRun r : p.getRuns()) {
                    int pos;
                    String text = r.getText(pos = r.getTextPosition());
                    if (text == null || !text.contains(findText)) continue;
                    text = text.replace(findText, replaceText);
                    p.setAlignment(ParagraphAlignment.CENTER);
                    r.setText(text, 0);
                    r.setBold(true);
                    r.setFontSize(24);
                    r.setItalic(false);
                    r.setUnderline(UnderlinePatterns.NONE);
                    r.getCTR().addNewRPr().addNewHighlight().setVal(STHighlightColor.WHITE);
                    CTShd ctShd = r.getCTR().addNewRPr().addNewShd();
                    ctShd.setFill(null);
                    MergeDocUtils.addTocFields(p, "TOC \\o \"1-3\" \\h \\z \\u");
                    flag = true;
                    break;
                }
                if (!flag) continue;
                break;
            }
            if (flag) {
                document.enforceUpdateFields();
            }
        }
        catch (Exception ex) {
            logger.error("generateTOC fail", (Throwable)ex);
        }
    }

    private static void addTocFields(XWPFParagraph paragraph, String fieldName) {
        try {
            paragraph.getCTP().addNewR().addNewBr();
            CTSimpleField ctSimpleField = paragraph.getCTP().addNewFldSimple();
            ctSimpleField.setInstr(fieldName);
            ctSimpleField.setDirty(PoiOoxmlUpdateUtil.getOn());
            CTR ctr = ctSimpleField.addNewR();
            ctr.addNewInstrText().setStringValue(ResManager.loadKDString((String)"\u8bf7\u60a8\u5355\u51fb\u672c\u884c\u6587\u672c\uff0c\u9f20\u6807\u53f3\u952e\u9009\u62e9\u5feb\u6377\u83dc\u5355\u4e2d\u7684\"\u66f4\u65b0\u57df\"\uff0c\u751f\u6210\u6700\u65b0\u76ee\u5f55", (String)"MergeDocPlugin_2", (String)"epm-far-business", (Object[])new Object[0]));
            CTRPr ctrPr = ctr.getRPr() == null ? ctr.addNewRPr() : ctr.getRPr();
            ctrPr.addNewHighlight().setVal(STHighlightColor.LIGHT_GRAY);
            paragraph.getCTP().addNewR().addNewBr();
            paragraph.createRun().addBreak(BreakType.PAGE);
        }
        catch (Exception ex) {
            logger.error("addTocFields fail", (Throwable)ex);
        }
    }
}

