/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.word;

import com.alibaba.fastjson.JSONObject;
import com.deepoove.poi.xwpf.NiceXWPFDocument;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.util.StringUtils;
import kd.epm.far.business.fidm.util.TypeUtils;
import kd.epm.far.business.fidm.word.base.WordConstants;
import kd.epm.far.business.fidm.word.dto.IWordOperation;
import kd.epm.far.business.fidm.word.dto.WordImageNode;
import kd.epm.far.business.fidm.word.dto.WordModuleNode;
import kd.epm.far.business.fidm.word.dto.WordNode;
import kd.epm.far.business.fidm.word.dto.WordPageBreakNode;
import kd.epm.far.business.fidm.word.dto.WordParagraphNode;
import kd.epm.far.business.fidm.word.dto.WordRootNode;
import kd.epm.far.business.fidm.word.dto.WordTableCellNode;
import kd.epm.far.business.fidm.word.dto.WordTableCellNodeEx;
import kd.epm.far.business.fidm.word.dto.WordTableNode;
import kd.epm.far.business.fidm.word.dto.WordTableRowNode;
import kd.epm.far.business.fidm.word.dto.WordTextNode;
import kd.epm.far.business.fidm.word.helper.ColorStyleHelper;
import kd.epm.far.business.fidm.word.helper.WordModuleNodeHelper;
import kd.epm.far.business.fidm.word.helper.WordNodeHelper;
import kd.epm.far.business.fidm.word.helper.WordNodeJsonHelper;
import kd.epm.far.business.fidm.word.helper.WordRepairHelper;
import kd.epm.far.business.fidm.word.helper.WordStyleHelper;
import kd.epm.far.business.fidm.word.helper.WordTableHelper;
import kd.epm.far.business.fidm.word.poi.VarPoi;
import kd.epm.far.common.common.Tuple;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import kd.epm.far.common.common.util.GlobalIdUtil;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.util.Units;
import org.apache.poi.wp.usermodel.HeaderFooterType;
import org.apache.poi.xwpf.usermodel.BreakType;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.TableRowAlign;
import org.apache.poi.xwpf.usermodel.TableWidthType;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.XWPFAbstractNum;
import org.apache.poi.xwpf.usermodel.XWPFFooter;
import org.apache.poi.xwpf.usermodel.XWPFHeader;
import org.apache.poi.xwpf.usermodel.XWPFNum;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFPicture;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.officeDocument.x2006.sharedTypes.STVerticalAlignRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBookmark;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTColumn;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDecimalNumber;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDocGrid;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTInd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTShd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSpacing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTString;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblBorders;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblLayoutType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTVMerge;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTVerticalJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBrType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STDocGrid;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STMerge;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTblLayoutType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STVerticalJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.impl.CTShdImpl;
import org.w3c.dom.Node;

public class WordConvert {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(WordConvert.class);
    private List<String> bookmarkLimits = new ArrayList<String>(2);
    private int abstractNumIdStartIndex = 1;
    private Map<String, BigInteger> numIdMap = new LinkedHashMap<String, BigInteger>(2);
    private Map<BigInteger, String> numStrMap = new LinkedHashMap<BigInteger, String>(2);

    public WordConvert() {
        this.bookmarkLimits = new ArrayList<String>(2);
    }

    public WordConvert(List<String> bookmarkLimits) {
        this.bookmarkLimits = bookmarkLimits;
    }

    public Tuple<List<WordRootNode>, NiceXWPFDocument, String> getDatafromWord(InputStream in) throws IOException {
        WordRootNode contentRootNode;
        ArrayList<WordRootNode> rootNodes = new ArrayList<WordRootNode>(2);
        ZipSecureFile.setMinInflateRatio((double)0.0);
        NiceXWPFDocument newDoc = new NiceXWPFDocument(in);
        if (newDoc.getHeaderFooterPolicy() != null) {
            WordRootNode footRootNode;
            XWPFFooter footer;
            WordRootNode headRootNode;
            XWPFHeader header = newDoc.getHeaderFooterPolicy().getDefaultHeader();
            if (header != null && (headRootNode = this.createRootNode(WordConstants.WordContentType.Head.getType(), header.getBodyElements(), false)) != null) {
                rootNodes.add(headRootNode);
            }
            if ((footer = newDoc.getHeaderFooterPolicy().getDefaultFooter()) != null && (footRootNode = this.createRootNode(WordConstants.WordContentType.Foot.getType(), footer.getBodyElements(), false)) != null) {
                rootNodes.add(footRootNode);
            }
        }
        if ((contentRootNode = this.createRootNode(WordConstants.WordContentType.Content.getType(), newDoc.getBodyElements(), true)) != null) {
            rootNodes.add(contentRootNode);
        }
        return new Tuple(rootNodes, (Object)newDoc, null);
    }

    public List<WordRootNode> fromWord(InputStream in) throws IOException {
        WordRootNode contentRootNode;
        ArrayList<WordRootNode> rootNodes = new ArrayList<WordRootNode>(2);
        ZipSecureFile.setMinInflateRatio((double)0.0);
        NiceXWPFDocument newDoc = new NiceXWPFDocument(in);
        if (newDoc.getHeaderFooterPolicy() != null) {
            WordRootNode footRootNode;
            XWPFFooter footer;
            WordRootNode headRootNode;
            XWPFHeader header = newDoc.getHeaderFooterPolicy().getDefaultHeader();
            if (header != null && (headRootNode = this.createRootNode(WordConstants.WordContentType.Head.getType(), header.getBodyElements(), false)) != null) {
                rootNodes.add(headRootNode);
            }
            if ((footer = newDoc.getHeaderFooterPolicy().getDefaultFooter()) != null && (footRootNode = this.createRootNode(WordConstants.WordContentType.Foot.getType(), footer.getBodyElements(), false)) != null) {
                rootNodes.add(footRootNode);
            }
        }
        if ((contentRootNode = this.createRootNode(WordConstants.WordContentType.Content.getType(), newDoc.getBodyElements(), false)) != null) {
            rootNodes.add(contentRootNode);
        }
        return rootNodes;
    }

    private WordRootNode createRootNode(int contentType, List<IBodyElement> bodyElementList, boolean isAddElement) {
        WordRootNode root = new WordRootNode(contentType);
        for (IBodyElement bodyElement : bodyElementList) {
            XWPFTable table;
            WordTableNode tableNode;
            if (bodyElement instanceof XWPFParagraph) {
                XWPFParagraph x = (XWPFParagraph)bodyElement;
                List<WordParagraphNode> paragraphNodes = this.createParagraphNode(x);
                if (paragraphNodes == null || paragraphNodes.size() <= 0) continue;
                root.getChilds().addAll(paragraphNodes);
                continue;
            }
            if (!(bodyElement instanceof XWPFTable) || (tableNode = this.createTableNode(table = (XWPFTable)bodyElement, isAddElement)) == null) continue;
            root.getChilds().add(tableNode);
        }
        return root;
    }

    public byte[] toWord(List<WordRootNode> rootNodes) throws IOException {
        WordRootNode rootNode = WordRootNode.getFirst(rootNodes, WordConstants.WordContentType.Content.getType());
        WordRootNode headRootNode = WordRootNode.getFirst(rootNodes, WordConstants.WordContentType.Head.getType());
        WordRootNode footRootNode = WordRootNode.getFirst(rootNodes, WordConstants.WordContentType.Foot.getType());
        byte[] fileData = null;
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            NiceXWPFDocument newDoc = new NiceXWPFDocument();
            WordStyleHelper.initCustomStyle(newDoc.getXWPFDocument(), 6);
            this.toWordByType(rootNode, newDoc);
            boolean isCreatePageSect = false;
            if (headRootNode != null && headRootNode.getChilds().size() > 0) {
                XWPFHeader header = newDoc.createHeader(HeaderFooterType.DEFAULT);
                this.toWordByType(headRootNode, header);
                isCreatePageSect = true;
            }
            if (footRootNode != null && footRootNode.getChilds().size() > 0) {
                XWPFFooter footer = newDoc.createFooter(HeaderFooterType.DEFAULT);
                this.toWordByType(footRootNode, footer);
                isCreatePageSect = true;
            }
            if (isCreatePageSect) {
                this.headerFooterStyle(newDoc);
            }
            WordRepairHelper.repair(newDoc);
            newDoc.write((OutputStream)outputStream);
            fileData = outputStream.toByteArray();
        }
        return fileData;
    }

    private void headerFooterStyle(NiceXWPFDocument newDoc) {
        CTSectPr sectPr = newDoc.getDocument().getBody().getSectPr();
        if (sectPr == null) {
            sectPr = newDoc.getDocument().getBody().addNewSectPr();
        }
        CTColumn ctColumn = sectPr.addNewCols().addNewCol();
        ctColumn.setSpace((Object)"720");
        CTDocGrid ctDocGrid = sectPr.addNewDocGrid();
        ctDocGrid.setType(STDocGrid.Enum.forString((String)"lines"));
        ctDocGrid.setCharSpace(BigInteger.valueOf(0L));
        ctDocGrid.setLinePitch(BigInteger.valueOf(312L));
    }

    private void toWordByType(WordRootNode rootNode, Object parentObject) {
        if (rootNode == null || rootNode.getChilds().size() == 0 || parentObject == null) {
            return;
        }
        for (WordNode node : rootNode.getChilds()) {
            WordTableNode tableNode;
            if (node.getType() == WordConstants.WordNodeType.Paragraph.getType()) {
                WordParagraphNode paragraphNode = (WordParagraphNode)node;
                if (paragraphNode == null) continue;
                if (parentObject instanceof NiceXWPFDocument) {
                    this.toParagraphWord(paragraphNode, ((NiceXWPFDocument)parentObject).createParagraph());
                    continue;
                }
                if (parentObject instanceof XWPFHeader) {
                    this.toParagraphWord(paragraphNode, ((XWPFHeader)parentObject).createParagraph());
                    continue;
                }
                if (!(parentObject instanceof XWPFFooter)) continue;
                this.toParagraphWord(paragraphNode, ((XWPFFooter)parentObject).createParagraph());
                continue;
            }
            if (node.getType() != WordConstants.WordNodeType.Table.getType() || (tableNode = (WordTableNode)node) == null) continue;
            if (parentObject instanceof NiceXWPFDocument) {
                this.toTableWord(tableNode, ((NiceXWPFDocument)parentObject).createTable());
                continue;
            }
            if (parentObject instanceof XWPFHeader) {
                this.toTableWord(tableNode, ((XWPFHeader)parentObject).createTable(1, 1));
                continue;
            }
            if (!(parentObject instanceof XWPFFooter)) continue;
            this.toTableWord(tableNode, ((XWPFFooter)parentObject).createTable(1, 1));
        }
    }

    public void toTableWord(WordTableNode sourceTableNode, XWPFTable table) {
        WordTableNode tableNode = (WordTableNode)WordNodeJsonHelper.copy(sourceTableNode);
        if (tableNode == null) {
            return;
        }
        table.setStyleID("t1");
        table.setTableAlignment(this.toTableAlignment(tableNode));
        this.toTableWordSetWidth(tableNode, table);
        WordNodeHelper.expand(tableNode);
        int rowIndex = 0;
        for (WordNode rowNodeItem : tableNode.getChilds()) {
            WordTableRowNode rowNode = (WordTableRowNode)rowNodeItem;
            if (rowNode == null) continue;
            XWPFTableRow row = null;
            row = table.getRows().size() > rowIndex ? table.getRow(rowIndex) : table.createRow();
            if (rowNode.getHeight() > 0.0) {
                row.setHeight((int)rowNode.getHeight());
            }
            int cellIndex = 0;
            for (WordNode cellNodeItem : rowNode.getChilds()) {
                CTVMerge ctvMerge;
                WordTableCellNodeEx cellNode = (WordTableCellNodeEx)cellNodeItem;
                if (cellNode == null || !"".equals(cellNode.getBing()) && !cellNode.getBing().contains("RowSpan.Begin") && !cellNode.getBing().contains("ColumnSpan.Begin") && !cellNode.getBing().equalsIgnoreCase("RowSpan.Middle")) continue;
                XWPFTableCell cell = null;
                cell = row.getTableCells().size() > cellIndex ? row.getCell(cellIndex) : row.createCell();
                CTTcPr ctTcPr = this.getTableCellCTTcPr(cell);
                boolean isEmpty = false;
                if (cellNode.getBing().contains("RowSpan.Begin")) {
                    ctvMerge = (CTVMerge)CTVMerge.Factory.newInstance();
                    ctvMerge.setVal(STMerge.RESTART);
                    ctTcPr.setVMerge(ctvMerge);
                }
                if (cellNode.getBing().contains("ColumnSpan.Begin")) {
                    CTDecimalNumber ctDecimalNumber = ctTcPr.getGridSpan();
                    if (ctDecimalNumber == null) {
                        ctDecimalNumber = ctTcPr.addNewGridSpan();
                    }
                    ctDecimalNumber.setVal(BigInteger.valueOf(cellNode.getSource().getColumnSpan()));
                    CTTblWidth ctTblWidth = (CTTblWidth)CTTblWidth.Factory.newInstance();
                    ctTblWidth.setType(STTblWidth.Enum.forString((String)"auto"));
                    ctTcPr.setTcW(ctTblWidth);
                }
                if (cellNode.getBing().equalsIgnoreCase("RowSpan.Middle")) {
                    ctvMerge = (CTVMerge)CTVMerge.Factory.newInstance();
                    ctvMerge.setVal(STMerge.CONTINUE);
                    ctTcPr.setVMerge(ctvMerge);
                    isEmpty = true;
                    if (cellNode.getSource().getColumnSpan() > 1) {
                        CTDecimalNumber ctDecimalNumber = ctTcPr.getGridSpan();
                        if (ctDecimalNumber == null) {
                            ctDecimalNumber = ctTcPr.addNewGridSpan();
                        }
                        ctDecimalNumber.setVal(BigInteger.valueOf(cellNode.getSource().getColumnSpan()));
                    }
                }
                this.toTableCellWord(cellNode.getSource(), cell, isEmpty);
                ++cellIndex;
            }
            if (row.getTableCells().size() > cellIndex) {
                int removeSize = row.getTableCells().size() - cellIndex;
                for (int i = 0; i < removeSize; ++i) {
                    row.removeCell(row.getTableCells().size() - 1);
                }
            }
            ++rowIndex;
        }
        this.toTableBookmark(tableNode, table);
    }

    private void toTableWordSetWidth(WordTableNode tableNode, XWPFTable table) {
        if (table.getCTTbl() != null && table.getCTTbl().getTblPr() != null) {
            CTTblLayoutType tblLayoutType = (CTTblLayoutType)CTTblLayoutType.Factory.newInstance();
            if (WordConstants.WordWidthType.Percentage.getType() == tableNode.getWidthType()) {
                tblLayoutType.setType(STTblLayoutType.Enum.forString((String)"autofit"));
                table.getCTTbl().getTblPr().setTblLayout(tblLayoutType);
                if (tableNode.getWidth() > 0.0) {
                    table.setWidth(tableNode.getWidth() * 100.0 + "%");
                } else {
                    table.setWidth("100%");
                }
            } else {
                tblLayoutType.setType(STTblLayoutType.Enum.forString((String)"fixed"));
                table.getCTTbl().getTblPr().setTblLayout(tblLayoutType);
            }
            if (StringUtils.isNotEmpty((String)tableNode.getDataModeuleId())) {
                CTString ctString = (CTString)CTString.Factory.newInstance();
                ctString.setVal(tableNode.getDataModeuleId());
                table.getCTTbl().getTblPr().setTblDescription(ctString);
            }
        }
        WordTableHelper.toTableLeftInd(tableNode, table);
        WordTableHelper.toTableMargin(tableNode, table);
    }

    private void toTableBookmark(WordTableNode tableNode, XWPFTable table) {
        if (StringUtils.isEmpty((String)tableNode.getId())) {
            return;
        }
        if (table.getRows().size() > 0 && ((XWPFTableRow)table.getRows().get(0)).getTableCells().size() > 0 && ((XWPFTableRow)table.getRows().get(0)).getCell(0).getParagraphs().size() > 0 && ((XWPFParagraph)((XWPFTableRow)table.getRows().get(0)).getCell(0).getParagraphs().get(0)).getCTP() != null) {
            long bookmarkId = GlobalIdUtil.genGlobalLongId();
            CTBookmark newBookMark = ((XWPFParagraph)((XWPFTableRow)table.getRows().get(0)).getCell(0).getParagraphs().get(0)).getCTP().addNewBookmarkStart();
            newBookMark.setName(tableNode.getId());
            newBookMark.setId(BigInteger.valueOf(bookmarkId));
            table.getCTTbl().addNewBookmarkEnd().setId(BigInteger.valueOf(bookmarkId));
        }
    }

    private TableRowAlign toTableAlignment(WordTableNode tableNode) {
        TableRowAlign tableRowAlign = TableRowAlign.LEFT;
        if (tableNode.getAlignment() == 2) {
            tableRowAlign = TableRowAlign.CENTER;
        } else if (tableNode.getAlignment() == 3) {
            tableRowAlign = TableRowAlign.RIGHT;
        }
        return tableRowAlign;
    }

    private void toTableCellWord(WordTableCellNode cellNode, XWPFTableCell cell, boolean isEmpty) {
        CTShd shd;
        CTTcPr ctTcPr = this.getTableCellCTTcPr(cell);
        if (cellNode.getWidth() > 0.0) {
            if (WordConstants.WordWidthType.Percentage.getType() == cellNode.getWidthType()) {
                cell.setWidth(cellNode.getWidth() * 100.0 + "%");
            } else {
                cell.setWidth(String.valueOf((int)cellNode.getWidth()));
            }
        }
        if (StringUtils.isNotEmpty((String)cellNode.getFontColor())) {
            shd = ctTcPr.getShd();
            if (shd == null) {
                shd = cell.getCTTc().getTcPr().addNewShd();
            }
            shd.setColor((Object)cellNode.getFontColor().replace("#", ""));
        }
        if (StringUtils.isNotEmpty((String)cellNode.getHightlightColor())) {
            shd = ctTcPr.getShd();
            if (shd == null) {
                shd = cell.getCTTc().getTcPr().addNewShd();
            }
            shd.setFill((Object)cellNode.getHightlightColor().replace("#", ""));
        }
        WordTableHelper.toTableCellBorders(cellNode, cell);
        CTVerticalJc ctVerticalJc = (CTVerticalJc)CTVerticalJc.Factory.newInstance();
        ctVerticalJc.setVal(STVerticalJc.Enum.forString((String)"center"));
        ctTcPr.setVAlign(ctVerticalJc);
        if (!isEmpty) {
            int paragraphIndex = 0;
            for (WordNode paragraphItemNode : cellNode.getChilds()) {
                WordParagraphNode paragraphNode = (WordParagraphNode)paragraphItemNode;
                if (paragraphNode == null) continue;
                XWPFParagraph paragraph = null;
                paragraph = cell.getParagraphs().size() > paragraphIndex ? (XWPFParagraph)cell.getParagraphs().get(paragraphIndex) : cell.addParagraph();
                this.toParagraphWord(paragraphNode, paragraph);
                ++paragraphIndex;
            }
        }
    }

    private CTTcPr getTableCellCTTcPr(XWPFTableCell cell) {
        CTTcPr ctTcPr = cell.getCTTc().getTcPr();
        if (ctTcPr == null) {
            ctTcPr = cell.getCTTc().addNewTcPr();
        }
        return ctTcPr;
    }

    private void toParagraphWord(WordParagraphNode paragraphNode, XWPFParagraph paragraph) {
        CTShd shd;
        paragraph.setAlignment(paragraphNode.getAlignment());
        this.toParagraphWordForNumber(paragraphNode, paragraph);
        this.setLeftChars(paragraph, paragraphNode);
        if (paragraphNode.getTitleStyle() > 0) {
            paragraph.setStyle(String.valueOf(paragraphNode.getTitleStyle() + 1));
        }
        if (StringUtils.isNotEmpty((String)paragraphNode.getHightlightColor()) && paragraph.getCTPPr() != null) {
            shd = paragraph.getCTPPr().getShd();
            if (shd == null) {
                shd = paragraph.getCTPPr().addNewShd();
            }
            shd.setFill((Object)paragraphNode.getHightlightColor().replace("#", ""));
        }
        if (StringUtils.isNotEmpty((String)paragraphNode.getFontColor()) && paragraph.getCTPPr() != null) {
            shd = paragraph.getCTPPr().getShd();
            if (shd == null) {
                shd = paragraph.getCTPPr().addNewShd();
            }
            shd.setColor((Object)paragraphNode.getFontColor().replace("#", ""));
        }
        for (WordNode textNode : paragraphNode.getChilds()) {
            if (textNode.getType() != WordConstants.WordNodeType.Text.getType()) continue;
            this.toTextWord((WordTextNode)textNode, paragraph);
        }
    }

    private void toParagraphWordForNumber(WordParagraphNode paragraphNode, XWPFParagraph paragraph) {
        if (StringUtils.isNotEmpty((String)paragraphNode.getNumIdStr())) {
            if (paragraphNode.getLeft() > 0) {
                paragraph.setNumILvl(BigInteger.valueOf(paragraphNode.getLeft()));
            } else {
                paragraph.setNumILvl(BigInteger.valueOf(0L));
            }
            paragraph.setNumID(BigInteger.valueOf(1L));
            if (paragraphNode.getNumIdStr().startsWith("ol")) {
                if (this.numIdMap.get(paragraphNode.getNumIdStr()) == null) {
                    this.numIdMap.put(paragraphNode.getNumIdStr(), WordStyleHelper.addOrderListStyle(paragraph.getDocument(), BigInteger.valueOf(this.abstractNumIdStartIndex)));
                    ++this.abstractNumIdStartIndex;
                }
                paragraph.setNumID(this.numIdMap.get(paragraphNode.getNumIdStr()));
            }
        }
    }

    private void toTextWord(WordTextNode textNode, XWPFParagraph paragraph) {
        String hightlightColor;
        BigInteger bookmarkId = null;
        if (textNode.getBookMarkKeys().size() > 0) {
            bookmarkId = BigInteger.valueOf(GlobalIdUtil.genGlobalLongId());
            String bookmarkKey = textNode.getBookMarkKeys().get(textNode.getBookMarkKeys().size() - 1);
            CTBookmark newBookMark = paragraph.getCTP().addNewBookmarkStart();
            newBookMark.setName(bookmarkKey);
            newBookMark.setId(bookmarkId);
        }
        XWPFRun run = paragraph.createRun();
        if (StringUtils.isNotEmpty((String)textNode.getFontFamily())) {
            run.setFontFamily(textNode.getFontFamily());
        }
        if (textNode.getFontSize() > 0.0) {
            run.setFontSize(textNode.getFontSize());
        }
        if (StringUtils.isNotEmpty((String)textNode.getFontColor())) {
            run.setColor(textNode.getFontColor().replace("#", ""));
        }
        if (StringUtils.isNotEmpty((String)textNode.getHightlightColor()) && StringUtils.isNotEmpty((String)(hightlightColor = ColorStyleHelper.getHexadecimalColor(textNode.getHightlightColor())))) {
            if (hightlightColor.contains("#")) {
                CTRPr runCTRPr = run.getCTR().getRPr();
                if (runCTRPr == null) {
                    runCTRPr = run.getCTR().addNewRPr();
                }
                if ((runCTRPr.getShdList() == null || runCTRPr.getShdList().size() == 0) && StringUtils.isNotEmpty((String)hightlightColor)) {
                    runCTRPr.addNewShd().setFill((Object)hightlightColor.replace("#", ""));
                }
            } else if (StringUtils.isNotEmpty((String)hightlightColor)) {
                run.setTextHighlightColor(hightlightColor.replace("#", ""));
            }
        }
        if (textNode.getBold()) {
            run.setBold(textNode.getBold());
        }
        if (textNode.getItalic()) {
            run.setItalic(textNode.getItalic());
        }
        if (textNode.getStrikeThrough()) {
            run.setStrikeThrough(textNode.getStrikeThrough());
        }
        if (textNode.getUnderline()) {
            run.setUnderline(UnderlinePatterns.SINGLE);
        } else {
            run.setUnderline(UnderlinePatterns.NONE);
        }
        run.setVerticalAlignment(textNode.getVerticalAlignment());
        run.setText(textNode.getContent());
        for (WordNode node : textNode.getChilds()) {
            if (node.getType() == WordConstants.WordNodeType.Image.getType()) {
                this.toImageWord((WordImageNode)node, run);
                continue;
            }
            if (node.getType() == WordConstants.WordNodeType.PageBreak.getType()) {
                this.toPageBreakWord(run);
                continue;
            }
            if (node.getType() != WordConstants.WordNodeType.Module.getType()) continue;
            WordModuleNodeHelper.toModuleWord((WordModuleNode)node, run);
        }
        if (bookmarkId != null) {
            paragraph.getCTP().addNewBookmarkEnd().setId(bookmarkId);
        }
    }

    private void toPageBreakWord(XWPFRun run) {
        try {
            run.addBreak(BreakType.PAGE);
        }
        catch (Exception ex) {
            logger.error("dm wordconvert fail", (Throwable)ex);
        }
    }

    private void toImageWord(WordImageNode imageNode, XWPFRun run) {
        try {
            if (imageNode.getData() == null) {
                return;
            }
            ByteArrayInputStream inputStream = new ByteArrayInputStream(imageNode.getData());
            run.addPicture((InputStream)inputStream, 5, "image.jpg", Units.toEMU((double)imageNode.getWidth()), Units.toEMU((double)imageNode.getHeight()));
        }
        catch (Exception ex) {
            logger.error("dm wordconvert fail", (Throwable)ex);
        }
    }

    private void setLeftChars(XWPFParagraph x, WordParagraphNode paragraphNode) {
        if (x.getCTPPr() == null) {
            return;
        }
        CTInd ctInd = x.getCTPPr().getInd();
        if (x.getCTPPr().getInd() == null) {
            ctInd = x.getCTPPr().addNewInd();
        }
        if (paragraphNode.getLeftChars() > 0) {
            ctInd.setLeftChars(BigInteger.valueOf(100 * paragraphNode.getLeftChars()));
        }
        if (paragraphNode.getLeft() > 0) {
            ctInd.setLeft((Object)BigInteger.valueOf(420 * paragraphNode.getLeft()));
        }
        if (paragraphNode.getLineHegiht() > 0.0 && paragraphNode.getLineHegiht() != 1.0) {
            CTSpacing spacing = x.getCTPPr().getSpacing();
            if (spacing == null) {
                spacing = x.getCTPPr().addNewSpacing();
            }
            spacing.setLine((Object)BigInteger.valueOf((int)(paragraphNode.getLineHegiht() * 240.0)));
        }
    }

    public WordTableNode createTableNode(XWPFTable table) {
        return this.createTableNode(table, false);
    }

    public WordTableNode createTableNode(XWPFTable table, boolean isAddElement) {
        WordTableNode tableNode = new WordTableNode();
        tableNode.setWidth(0.0);
        tableNode.setAlignment(WordTableHelper.getTableAlignment(table));
        tableNode.setId(WordTableHelper.getTableBookmark(table));
        HashMap<Integer, WordTableCellNode> rowSpanBeginMap = new HashMap<Integer, WordTableCellNode>(2);
        boolean isPercentageLength = false;
        double maxRowWidth = 0.0;
        for (XWPFTableRow row : table.getRows()) {
            WordTableRowNode rowNode = new WordTableRowNode();
            double rowWidth = 0.0;
            int columnIndex = 0;
            CTTblBorders rowBorders = null;
            if (row.getCtRow() != null && row.getCtRow().getTblPrEx() != null) {
                rowBorders = row.getCtRow().getTblPrEx().getTblBorders();
            }
            for (XWPFTableCell cell : row.getTableCells()) {
                WordTableCellNode cellNode = new WordTableCellNode();
                if (cell.getCTTc() != null && cell.getCTTc().getTcPr() != null && cell.getCTTc().getTcPr().getShd() != null) {
                    CTShdImpl shd = (CTShdImpl)cell.getCTTc().getTcPr().getShd();
                    if (shd != null && shd.xgetColor() != null) {
                        String color = shd.xgetColor().getStringValue();
                        cellNode.setFontColor(ColorStyleHelper.getHexadecimalColor(color));
                    }
                    if (shd != null && shd.xgetFill() != null) {
                        String hightlightColor = shd.xgetFill().getStringValue();
                        cellNode.setHightlightColor(ColorStyleHelper.getHexadecimalColor(hightlightColor));
                    }
                }
                for (XWPFParagraph paragraph : cell.getParagraphs()) {
                    List<WordParagraphNode> paragraphNodes = this.createParagraphNode(paragraph);
                    if (paragraphNodes == null || paragraphNodes.size() <= 0) continue;
                    cellNode.getChilds().addAll(paragraphNodes);
                }
                if (cell.getCTTc().getTcPr() != null && cell.getCTTc().getTcPr().isSetTcW() && cell.getCTTc().getTcPr().getTcW().getW() != null) {
                    if (cell.getWidthType() == TableWidthType.PCT) {
                        cellNode.setWidth(cell.getWidthDecimal() / 100.0);
                        cellNode.setWidthType(WordConstants.WordWidthType.Percentage.getType());
                        isPercentageLength = true;
                    } else {
                        cellNode.setWidth(cell.getWidth());
                        cellNode.setWidthType(WordConstants.WordWidthType.Absolute.getType());
                    }
                }
                rowWidth += cellNode.getWidth();
                if (cell.getCTTc().getTcPr() != null && cell.getCTTc().getTcPr().getGridSpan() != null && cell.getCTTc().getTcPr().getGridSpan().getVal() != null) {
                    cellNode.setColumnSpan(cell.getCTTc().getTcPr().getGridSpan().getVal().intValue());
                }
                columnIndex += cellNode.getColumnSpan();
                if (cell.getCTTc().getTcPr() != null && cell.getCTTc().getTcPr().getVMerge() != null) {
                    if (cell.getCTTc().getTcPr().getVMerge().getVal() == STMerge.RESTART) {
                        rowSpanBeginMap.put(columnIndex, cellNode);
                    } else {
                        WordTableCellNode cellRowSpanNode = (WordTableCellNode)rowSpanBeginMap.get(columnIndex);
                        if (cellRowSpanNode != null) {
                            cellRowSpanNode.setRowSpan(cellRowSpanNode.getRowSpan() + 1);
                            continue;
                        }
                    }
                } else if (rowSpanBeginMap.containsKey(columnIndex)) {
                    rowSpanBeginMap.remove(columnIndex);
                }
                cellNode.setBorders(WordTableHelper.createWordCellBorders(cell, rowBorders));
                if (isAddElement) {
                    cellNode.setUserFlag(cell);
                }
                rowNode.getChilds().add(cellNode);
            }
            rowNode.setWidth(rowWidth);
            rowNode.setWidthType(isPercentageLength ? WordConstants.WordWidthType.Percentage.getType() : WordConstants.WordWidthType.Absolute.getType());
            rowNode.setHeight(row.getHeight());
            tableNode.getChilds().add(rowNode);
            if (!(rowWidth > maxRowWidth)) continue;
            maxRowWidth = rowWidth;
        }
        if (table.getWidthType() == TableWidthType.PCT) {
            if (table.getWidthDecimal() > 0.0) {
                tableNode.setWidth(table.getWidthDecimal() / 100.0);
            } else {
                tableNode.setWidth(0.99);
            }
            tableNode.setWidthType(WordConstants.WordWidthType.Percentage.getType());
        } else {
            if (maxRowWidth > 0.0) {
                tableNode.setWidth(maxRowWidth);
            }
            tableNode.setWidthType(WordConstants.WordWidthType.Absolute.getType());
        }
        WordTableHelper.createTableMargin(tableNode, table);
        return tableNode;
    }

    private List<WordParagraphNode> createParagraphNode(XWPFParagraph paragraph) {
        int h;
        ArrayList<WordParagraphNode> list = new ArrayList<WordParagraphNode>(100);
        WordParagraphNode paragraphNode = new WordParagraphNode();
        paragraphNode.setAlignment(paragraph.getAlignment());
        if (StringUtils.isNotEmpty((String)paragraph.getStyle()) && (h = TypeUtils.convertValueToInt(paragraph.getStyle()).intValue()) > 1) {
            paragraphNode.setTitleStyle(h - 1);
        }
        this.createParagraphNodeForNumId(paragraphNode, paragraph);
        paragraphNode.setLeft(this.getParagraphLeftChars(paragraph, "Left"));
        paragraphNode.setLeftChars(this.getParagraphLeftChars(paragraph, "LeftChars"));
        if (paragraph.getCTPPr() != null && paragraph.getCTPPr().getSpacing() != null && paragraph.getCTPPr().getSpacing().getLine() != null) {
            paragraphNode.setLineHegiht(TypeUtils.convertValueToDoule(paragraph.getCTPPr().getSpacing().getLine().toString()) / 240.0);
        }
        if (paragraph.getCTPPr() != null && paragraph.getCTPPr().getShd() != null) {
            CTShdImpl shd = (CTShdImpl)paragraph.getCTPPr().getShd();
            if (shd != null && shd.xgetColor() != null) {
                String color = shd.xgetColor().getStringValue();
                paragraphNode.setFontColor(ColorStyleHelper.getHexadecimalColor(color));
            }
            if (shd != null && shd.xgetFill() != null) {
                String hightlightColor = shd.xgetFill().getStringValue();
                paragraphNode.setHightlightColor(ColorStyleHelper.getHexadecimalColor(hightlightColor));
            }
        }
        JSONObject lastBookMark = new JSONObject();
        List runs = paragraph.getRuns();
        for (XWPFRun run : runs) {
            boolean needNewParagraph = false;
            if (run.getCTR() != null && run.getCTR().getBrArray().length > 0 && run.getCTR().getBrArray(0).getType() == STBrType.Enum.forString((String)"textWrapping")) {
                needNewParagraph = true;
            }
            if (needNewParagraph) {
                this.mergeBookMarkKey(paragraphNode, null, lastBookMark);
                list.add(paragraphNode);
                lastBookMark = new JSONObject();
                WordParagraphNode newParagraphNode = (WordParagraphNode)WordNodeJsonHelper.copy(paragraphNode);
                newParagraphNode.getChilds().clear();
                paragraphNode = newParagraphNode;
            }
            WordTextNode text = this.createTextNode(run, paragraphNode);
            paragraphNode.getChilds().add(text);
            this.mergeBookMarkKey(paragraphNode, text, lastBookMark);
        }
        this.mergeBookMarkKey(paragraphNode, null, lastBookMark);
        list.add(paragraphNode);
        return list;
    }

    private void createParagraphNodeForNumId(WordParagraphNode paragraphNode, XWPFParagraph paragraph) {
        if (paragraph.getCTPPr() != null && paragraph.getCTPPr().getNumPr() != null && paragraph.getCTPPr().getNumPr().getNumId() != null) {
            paragraphNode.setNumIdStr("ul");
            BigInteger numId = paragraph.getCTPPr().getNumPr().getNumId().getVal();
            if (numId == null) {
                return;
            }
            XWPFNum xwpfNum = null;
            if (paragraph.getDocument().getNumbering() != null) {
                xwpfNum = paragraph.getDocument().getNumbering().getNum(numId);
            }
            if (xwpfNum == null || xwpfNum.getCTNum() == null || xwpfNum.getCTNum().getAbstractNumId() == null) {
                return;
            }
            BigInteger abstractNumId = xwpfNum.getCTNum().getAbstractNumId().getVal();
            if (abstractNumId == null) {
                return;
            }
            XWPFAbstractNum abstractNum = paragraph.getDocument().getNumbering().getAbstractNum(abstractNumId);
            if (abstractNum == null) {
                return;
            }
            if (abstractNum == null || abstractNum.getCTAbstractNum() == null || abstractNum.getCTAbstractNum().getLvlArray().length == 0) {
                return;
            }
            if ("%1.".equals(abstractNum.getCTAbstractNum().getLvlArray(0).getLvlText().getVal())) {
                if (this.numStrMap.get(abstractNumId) == null) {
                    this.numStrMap.put(abstractNumId, "ol-" + GlobalIdUtil.genGlobalLongId());
                }
                paragraphNode.setNumIdStr(this.numStrMap.get(abstractNumId));
            }
        }
    }

    private void mergeBookMarkKey(WordParagraphNode paragraphNode, WordTextNode text, JSONObject lastBookMark) {
        String lastBookMarkKey = lastBookMark.getString("key");
        ArrayList<WordTextNode> nodes = (ArrayList<WordTextNode>)lastBookMark.get((Object)"textNodes");
        if (nodes == null) {
            nodes = new ArrayList<WordTextNode>(2);
        }
        if (text != null) {
            if (text.getChilds().size() > 0) {
                lastBookMark.clear();
            } else if (text.getBookMarkKeys().size() > 0) {
                String bookMark = text.getBookMarkKeys().get(text.getBookMarkKeys().size() - 1);
                if (bookMark.equalsIgnoreCase(lastBookMarkKey)) {
                    nodes.add(text);
                    lastBookMark.put("textNodes", nodes);
                    lastBookMark.put("key", (Object)bookMark);
                    return;
                }
                ArrayList newNodes = new ArrayList(2);
                newNodes.add(text);
                lastBookMark.put("textNodes", (Object)newNodes);
                lastBookMark.put("key", (Object)bookMark);
            } else {
                lastBookMark.clear();
            }
        }
        if (!StringUtils.isEmpty((String)lastBookMarkKey) && nodes.size() > 1) {
            StringBuilder newContent = new StringBuilder();
            for (WordTextNode item : nodes) {
                newContent.append(item.getContent());
            }
            WordTextNode textNode = (WordTextNode)nodes.get(nodes.size() - 1);
            textNode.setContent(newContent.toString());
            nodes.remove(textNode);
            paragraphNode.getChilds().removeAll(nodes);
        }
    }

    private int getParagraphLeftChars(XWPFParagraph paragraph, String operType) {
        if (paragraph.getCTPPr() == null || paragraph.getCTPPr().getInd() == null) {
            return 0;
        }
        CTInd ctInd = paragraph.getCTPPr().getInd();
        if ("Left".equals(operType)) {
            BigInteger left = (BigInteger)ctInd.getLeft();
            if (left != null) {
                BigInteger result = left.divide(BigInteger.valueOf(420L));
                return result.intValue() > 0 ? result.intValue() : 0;
            }
        } else {
            BigInteger leftChars = ctInd.getLeftChars();
            if (leftChars != null) {
                BigInteger result = leftChars.divide(BigInteger.valueOf(100L));
                return result.intValue() > 0 ? result.intValue() : 0;
            }
        }
        return 0;
    }

    private WordTextNode createTextNode(XWPFRun run, WordParagraphNode paragraphNode) {
        List<WordNode> breakNodes;
        List<WordModuleNode> charts;
        List<WordImageNode> images;
        String instrText;
        List shds;
        WordTextNode textNode = new WordTextNode();
        String fontfamily = run.getFontFamily();
        if (fontfamily == null) {
            fontfamily = "";
        }
        double fontSize = run.getFontSize();
        boolean bold = run.isBold();
        String hightlightColor = run.getTextHightlightColor().toString();
        textNode.setFontFamily(fontfamily);
        if (fontSize > 0.0) {
            textNode.setFontSize(fontSize);
        }
        textNode.setFontColor(ColorStyleHelper.getHexadecimalColor(run.getColor()));
        if (hightlightColor == null || hightlightColor.equalsIgnoreCase("none")) {
            hightlightColor = "";
        }
        if (StringUtils.isEmpty((String)hightlightColor) && run.getCTR() != null && run.getCTR().getRPr() != null && run.getCTR().getRPr().getShdList() != null && (shds = run.getCTR().getRPr().getShdList()).size() > 0 && ((CTShd)shds.get(0)).xgetFill() != null) {
            hightlightColor = ((CTShd)shds.get(0)).xgetFill().getStringValue();
        }
        if (StringUtils.isNotEmpty((String)hightlightColor)) {
            textNode.setHightlightColor(ColorStyleHelper.getHexadecimalColor(hightlightColor));
        }
        textNode.setBold(bold);
        textNode.setItalic(run.isItalic());
        textNode.setStrikeThrough(run.isStrikeThrough());
        textNode.setUnderline(run.getUnderline() != UnderlinePatterns.NONE);
        textNode.setVerticalAlignment(this.convertToSTVerticalAlignRunEnum(run.getVerticalAlignment()));
        String content = run.getText(0);
        if (StringUtils.isNotEmpty((String)content)) {
            textNode.setContent(content);
        }
        if (StringUtils.isNotEmpty((String)(instrText = this.getInstrText(run)))) {
            textNode.setInstrText(instrText);
            instrText = instrText.trim().toUpperCase();
            String id = VarPoi.getIdFromFormularString(instrText);
            if (StringUtils.isNotEmpty((String)id)) {
                textNode.setDataModeuleId(id);
            }
        }
        if ((images = this.createImageNode(run)).size() > 0) {
            textNode.getChilds().addAll(images);
        }
        if ((charts = WordModuleNodeHelper.creatCharts(run)).size() > 0) {
            textNode.getChilds().addAll(charts);
        }
        if ((breakNodes = this.createPageBreakNode(run)).size() > 0) {
            textNode.getChilds().addAll(breakNodes);
        }
        this.createBookmarks(run, textNode);
        return textNode;
    }

    private void createBookmarks(XWPFRun run, WordTextNode textNode) {
        if (StringUtils.isEmpty((String)textNode.getContent()) && textNode.getChilds().size() == 0) {
            return;
        }
        block0: for (CTBookmark bookStart : run.getParagraph().getCTP().getBookmarkStartArray()) {
            String bookStartId = String.valueOf(bookStart.getId());
            String bookKey = WordNodeHelper.getNodeValue(bookStart.getDomNode(), "w:name");
            if (StringUtils.isEmpty((String)bookStartId) || StringUtils.isEmpty((String)bookKey) || this.bookmarkLimits.size() > 0 && !this.bookmarkLimits.contains(bookKey)) continue;
            Node nextSibling = bookStart.getDomNode().getNextSibling();
            for (int maxCount = 1000; nextSibling != null && maxCount > 0; --maxCount, nextSibling = nextSibling.getNextSibling()) {
                String bookEndId;
                if (nextSibling.equals(run.getCTR().getDomNode())) {
                    textNode.getBookMarkKeys().add(bookKey);
                    textNode.setId(bookKey);
                    continue block0;
                }
                if (nextSibling.getNodeName() != null && nextSibling.getNodeName().equals("w:bookmarkEnd") && bookStartId.equalsIgnoreCase(bookEndId = WordNodeHelper.getNodeValue(nextSibling, "w:id"))) continue block0;
            }
        }
    }

    private List<WordImageNode> createImageNode(XWPFRun run) {
        ArrayList<WordImageNode> images = new ArrayList<WordImageNode>(2);
        for (int i = 0; i < run.getEmbeddedPictures().size(); ++i) {
            XWPFPicture picture = (XWPFPicture)run.getEmbeddedPictures().get(i);
            if (picture.getPictureData() == null || picture.getPictureData().getData() == null) continue;
            WordImageNode imageNode = new WordImageNode();
            imageNode.setName(picture.getPictureData().getFileName());
            imageNode.setData(picture.getPictureData().getData());
            imageNode.setWidth(picture.getWidth());
            imageNode.setHeight(picture.getDepth());
            imageNode.setDescription(picture.getDescription());
            images.add(imageNode);
        }
        return images;
    }

    private List<WordNode> createPageBreakNode(XWPFRun run) {
        ArrayList<WordNode> breakNodes = new ArrayList<WordNode>(2);
        for (int i = 0; i < run.getCTR().getBrArray().length; ++i) {
            CTBr br = run.getCTR().getBrArray()[i];
            if (!br.getType().toString().equals(STBrType.Enum.forString((String)"page").toString())) continue;
            WordPageBreakNode breakNode = new WordPageBreakNode();
            breakNodes.add(breakNode);
        }
        return breakNodes;
    }

    private String getInstrText(XWPFRun run) {
        String instrText = "";
        XWPFParagraph paragraph = run.getParagraph();
        int index = paragraph.getRuns().indexOf(run);
        if (index - 2 < 0) {
            return instrText;
        }
        CTText[] ctTexts = ((XWPFRun)paragraph.getRuns().get(index - 2)).getCTR().getInstrTextArray();
        for (int j = 0; j < ctTexts.length; ++j) {
            String specail = ctTexts[j].getStringValue();
            if (!StringUtils.isNotEmpty((String)specail)) continue;
            instrText = specail;
            break;
        }
        return instrText;
    }

    private String convertToSTVerticalAlignRunEnum(STVerticalAlignRun.Enum verticalAlignment) {
        String verticalAlignmentStr = "baseline";
        if (verticalAlignment == STVerticalAlignRun.Enum.forString((String)"superscript")) {
            verticalAlignmentStr = "superscript";
        } else if (verticalAlignment == STVerticalAlignRun.Enum.forString((String)"subscript")) {
            verticalAlignmentStr = "subscript";
        }
        return verticalAlignmentStr;
    }

    public NiceXWPFDocument changeWordCotnent(InputStream in, IWordOperation operation) throws IOException {
        ZipSecureFile.setMinInflateRatio((double)0.0);
        NiceXWPFDocument newDoc = new NiceXWPFDocument(in);
        if (newDoc.getHeaderFooterPolicy() != null) {
            XWPFFooter footer;
            XWPFHeader header = newDoc.getHeaderFooterPolicy().getDefaultHeader();
            if (header != null) {
                this.changeBodyElement(header.getBodyElements(), operation);
            }
            if ((footer = newDoc.getHeaderFooterPolicy().getDefaultFooter()) != null) {
                this.changeBodyElement(footer.getBodyElements(), operation);
            }
        }
        this.changeBodyElement(newDoc.getBodyElements(), operation);
        return newDoc;
    }

    private void changeBodyElement(List<IBodyElement> bodyElementList, IWordOperation operation) {
        for (IBodyElement bodyElement : bodyElementList) {
            XWPFTable table;
            if (bodyElement instanceof XWPFParagraph) {
                XWPFParagraph paragraph = (XWPFParagraph)bodyElement;
                if (operation == null) continue;
                operation.changeParagraph(paragraph);
                continue;
            }
            if (!(bodyElement instanceof XWPFTable) || (table = (XWPFTable)bodyElement) == null || table.getRows() == null || table.getRows().size() == 0) continue;
            for (XWPFTableRow row : table.getRows()) {
                for (XWPFTableCell cell : row.getTableCells()) {
                    for (XWPFParagraph paragraph : cell.getParagraphs()) {
                        if (operation == null) continue;
                        operation.changeParagraph(paragraph);
                    }
                }
            }
        }
    }
}

