/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.word;

import java.io.InputStream;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.fileservice.enums.PreviewParams;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.epm.far.business.fidm.base.DisclosureFileHelper;

public class WordToPdfUtils {
    private static final Log log = LogFactory.getLog(WordToPdfUtils.class);

    public static String getPdfUrl(String docUrl, String fileName, String urlPrefix) {
        String docFileName = fileName + ".doc";
        log.info("wordToPdf docUrl : " + docUrl);
        if (StringUtils.isEmpty((String)docUrl)) {
            return docUrl;
        }
        try {
            InputStream pdfInputStream = WordToPdfUtils.wordToPdf(docUrl, docFileName);
            String path = DisclosureFileHelper.uploadTempFile(pdfInputStream, fileName, urlPrefix, ".pdf");
            log.info("wordToPdf path : " + path);
            return path;
        }
        catch (KDBizException kdBizException) {
            throw kdBizException;
        }
        catch (Exception ex) {
            log.error("dm getPdfUrl error", (Throwable)ex);
            throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"WordToPdfUtils_0", (String)"epm-far-business", (Object[])new Object[0]));
        }
    }

    private static InputStream wordToPdf(String path, String filename) {
        log.info("path:" + path + ",filename:" + filename);
        InputStream in = null;
        if (!StringUtils.isEmpty((String)filename) && !StringUtils.isEmpty((String)path)) {
            String subfix = filename.substring(filename.lastIndexOf(46) + 1);
            FileService service = FileServiceFactory.getAttachmentFileService();
            InputStream doc = service.getInputStream(path);
            if (!"doc".equalsIgnoreCase(subfix) && !"docx".equalsIgnoreCase(subfix)) {
                in = doc;
            } else {
                try {
                    Map preview = service.preview(filename, path, RequestContext.get().getUserAgent());
                    String status = (String)preview.get(PreviewParams.STATUS.getEnumName());
                    if (!PreviewParams.ERROR.getEnumName().equals(status) && !PreviewParams.XLSX_SUCCESS.getEnumName().equals(status) && (PreviewParams.PDF_SUCCESS.getEnumName().equals(status) || PreviewParams.NOT_NEED_CHANGE.getEnumName().equals(status))) {
                        in = (InputStream)preview.get(PreviewParams.RESULT.getEnumName());
                    }
                }
                catch (Exception var8) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210PDF\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u9884\u89c8\u670d\u52a1\u662f\u5426\u53ef\u7528\u3002", (String)"WordToPdfUtils_1", (String)"epm-far-business", (Object[])new Object[0]));
                }
            }
        }
        if (in == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210PDF\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u9884\u89c8\u670d\u52a1\u662f\u5426\u53ef\u7528\u3002", (String)"WordToPdfUtils_1", (String)"epm-far-business", (Object[])new Object[0]));
        }
        return in;
    }
}

