/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.word.helper;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.util.StringExUitls;
import kd.epm.far.business.fidm.util.TypeUtils;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;

public class WordBookmarkHelper {
    public static String[] chars = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(WordBookmarkHelper.class);
    public static final Map<Integer, String> bookMarkChars = new HashMap<Integer, String>(){
        {
            this.put(0, "A");
            this.put(1, "B");
            this.put(2, "C");
            this.put(3, "D");
            this.put(4, "E");
            this.put(5, "F");
            this.put(6, "G");
            this.put(7, "H");
            this.put(8, "I");
            this.put(9, "J");
        }
    };
    public static final String KeyBeginStr = "WPS";

    public static String createBookmarName(Long moduleId) {
        String[] strArray = String.valueOf(moduleId).split("");
        StringBuilder strB = new StringBuilder();
        for (int i = 0; i < strArray.length; ++i) {
            int c = TypeUtils.convertValueToInt(strArray[i]);
            strB.append(bookMarkChars.get(c));
        }
        return KeyBeginStr + strB.toString().toUpperCase().trim();
    }

    public static String createBookmarName(String suffix, int i, int j) {
        String randomI = chars[i % 26];
        String randomJ = chars[j % 26];
        return suffix.toUpperCase() + randomI.toUpperCase() + randomJ.toUpperCase();
    }

    public static void createBookmarkNode(JSONObject moduleProperties, String bookmarkKey) {
        if (moduleProperties == null) {
            return;
        }
        if (StringUtils.isEmpty((String)bookmarkKey)) {
            return;
        }
        JSONObject bookmark = new JSONObject();
        bookmark.put("key", (Object)bookmarkKey);
        moduleProperties.put("bookmark", (Object)bookmark);
    }

    public static boolean isOwnerBookmark(String bookmarkKey) {
        String bookmarkKeyUp = StringExUitls.toUpperCase(bookmarkKey);
        return bookmarkKeyUp.startsWith(KeyBeginStr) || bookmarkKeyUp.startsWith("MODULE") || bookmarkKeyUp.startsWith("WEBOFFICE");
    }
}

