/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.word.helper;

import java.io.InputStream;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.ModuleEnum;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.xddf.usermodel.chart.BarDirection;
import org.apache.poi.xddf.usermodel.chart.BarGrouping;
import org.apache.poi.xddf.usermodel.chart.XDDFBarChartData;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.usermodel.XWPFChart;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDrawing;
import org.w3c.dom.Node;

public class WordChartsHelper {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(WordChartsHelper.class);

    public static XWPFChart findChart(XWPFRun run, String rid) {
        XWPFChart find = null;
        PackagePart part = run.getParagraph().getDocument().getPartById(rid);
        if (part == null) {
            return find;
        }
        for (XWPFChart chart : run.getParagraph().getDocument().getCharts()) {
            if (!chart.getPackagePart().getPartName().equals((Object)part.getPartName())) continue;
            find = chart;
            break;
        }
        return find;
    }

    public static String getModuleIdFromChart(XWPFChart chart) {
        String moduleId = "";
        try {
            if (chart.getRelations().size() == 0) {
                return moduleId;
            }
            POIXMLDocumentPart xlsPart = (POIXMLDocumentPart)chart.getRelations().get(0);
            InputStream xlsin = xlsPart.getPackagePart().getInputStream();
            XSSFWorkbook workbook = new XSSFWorkbook(xlsin);
            XSSFSheet sheet = workbook.getSheetAt(0);
            XSSFRow row = sheet.getRow(0);
            if (row == null) {
                return moduleId;
            }
            XSSFCell cell = row.getCell(0);
            if (cell == null || StringUtils.isEmpty((String)cell.getStringCellValue())) {
                return moduleId;
            }
            moduleId = cell.getStringCellValue();
            workbook.close();
        }
        catch (Exception ex) {
            logger.error("dm wordconvert getModuleIdFromChart fail", (Throwable)ex);
        }
        return moduleId;
    }

    public static String getRidByDrawingInline(CTDrawing drawing) {
        String rid = "";
        if (drawing.getInlineArray().length == 0) {
            return rid;
        }
        if (drawing.getInlineArray(0).getGraphic().getGraphicData().getDomNode().getChildNodes().getLength() == 0) {
            return rid;
        }
        Node first = drawing.getInlineArray(0).getGraphic().getGraphicData().getDomNode().getChildNodes().item(0);
        Node idNode = first.getAttributes().getNamedItem("r:id");
        if (idNode == null) {
            return rid;
        }
        rid = idNode.getNodeValue();
        return rid;
    }

    public static String getRidByDrawingAnchor(CTDrawing drawing) {
        String rid = "";
        if (drawing.getAnchorArray().length == 0) {
            return rid;
        }
        if (drawing.getAnchorArray(0).getGraphic().getGraphicData().getDomNode().getChildNodes().getLength() == 0) {
            return rid;
        }
        Node first = drawing.getAnchorArray(0).getGraphic().getGraphicData().getDomNode().getChildNodes().item(0);
        Node idNode = first.getAttributes().getNamedItem("r:id");
        if (idNode == null) {
            return rid;
        }
        rid = idNode.getNodeValue();
        return rid;
    }

    public static boolean writeDescrtoDrawingInline(CTDrawing drawing, String moduleId) {
        if (StringUtils.isEmpty((String)moduleId)) {
            return false;
        }
        if (drawing.getInlineArray().length == 0) {
            return false;
        }
        if (drawing.getInlineArray(0).getDocPr() == null) {
            return false;
        }
        drawing.getInlineArray(0).getDocPr().setDescr(moduleId);
        return true;
    }

    public static boolean writeDescrtoDrawingAnchor(CTDrawing drawing, String moduleId) {
        if (StringUtils.isEmpty((String)moduleId)) {
            return false;
        }
        if (drawing.getAnchorArray().length == 0) {
            return false;
        }
        if (drawing.getAnchorArray(0).getDocPr() == null) {
            return false;
        }
        drawing.getAnchorArray(0).getDocPr().setDescr(moduleId);
        return true;
    }

    public static ModuleEnum getModuleEnum(XWPFChart chart) {
        boolean bar = chart.getCTChart().getPlotArea().getBarChartArray().length > 0 || chart.getCTChart().getPlotArea().getBar3DChartArray().length > 0;
        boolean line = chart.getCTChart().getPlotArea().getLineChartArray().length > 0 || chart.getCTChart().getPlotArea().getLine3DChartArray().length > 0;
        boolean doughnut = chart.getCTChart().getPlotArea().getDoughnutChartArray().length > 0;
        boolean pie = chart.getCTChart().getPlotArea().getPieChartArray().length > 0 || chart.getCTChart().getPlotArea().getOfPieChartArray().length > 0 || chart.getCTChart().getPlotArea().getPie3DChartArray().length > 0;
        boolean area = chart.getCTChart().getPlotArea().getAreaChartArray().length > 0 || chart.getCTChart().getPlotArea().getArea3DChartArray().length > 0;
        ModuleEnum moduleEnum = null;
        if (doughnut) {
            return ModuleEnum.DOUGHNUT;
        }
        if (pie) {
            return ModuleEnum.PIE;
        }
        if (area) {
            return ModuleEnum.AREA;
        }
        BarGrouping barGrouping = BarGrouping.CLUSTERED;
        BarDirection barDirection = BarDirection.BAR;
        if (bar) {
            if (chart.getChartSeries().size() > 0) {
                XDDFBarChartData barChartData = (XDDFBarChartData)chart.getChartSeries().get(0);
                try {
                    barDirection = barChartData.getBarDirection();
                    barGrouping = barChartData.getBarGrouping();
                }
                catch (Exception ex) {
                    logger.error("dm barChartData.getBarDirection() error", (Throwable)ex);
                }
            }
            moduleEnum = barGrouping == BarGrouping.STACKED && barDirection == BarDirection.BAR ? ModuleEnum.STACKED_BAR : (barGrouping == BarGrouping.STACKED && barDirection == BarDirection.COL ? ModuleEnum.STACKED_COLUMNAR : (barGrouping == BarGrouping.CLUSTERED && barDirection == BarDirection.COL ? ModuleEnum.CLUSTERED_COLUMNAR : ModuleEnum.CLUSTERED_BAR));
        }
        if (line) {
            moduleEnum = ModuleEnum.LINE;
        }
        if (bar && line) {
            moduleEnum = barGrouping == BarGrouping.CLUSTERED ? ModuleEnum.LINE_CLUSTERED_COLUMNAR : ModuleEnum.LINE_STACKED_COLUMNAR;
        }
        return moduleEnum;
    }
}

