/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.word.helper;

import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTc;

public class WordCopyHelper {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(WordCopyHelper.class);

    public static void copyTableCell(XWPFTableCell sourceCell, XWPFTableCell targetCell) {
        try {
            if (sourceCell.getCTTc() != null) {
                CTTc ctTc = (CTTc)sourceCell.getCTTc().copy();
                targetCell.getCTTc().setTcPr(ctTc.getTcPr());
            }
            targetCell.setWidthType(sourceCell.getWidthType());
            targetCell.setWidth(String.valueOf(sourceCell.getWidth()));
            targetCell.setColor(sourceCell.getColor());
            targetCell.setVerticalAlignment(sourceCell.getVerticalAlignment());
            for (int i = targetCell.getParagraphs().size() - 1; i >= 0; --i) {
                targetCell.removeParagraph(i);
            }
            if (sourceCell.getParagraphs() != null && sourceCell.getParagraphs().size() > 0) {
                for (XWPFParagraph sourceParagraph : sourceCell.getParagraphs()) {
                    XWPFParagraph targetParagraph = targetCell.addParagraph();
                    WordCopyHelper.copyParagraph(sourceParagraph, targetParagraph);
                }
            } else {
                targetCell.setText(sourceCell.getText());
            }
        }
        catch (Exception ex) {
            logger.error("dm copy cell fail", (Throwable)ex);
        }
    }

    public static void copyParagraph(XWPFParagraph sourceParagraph, XWPFParagraph targetParagraph) {
        try {
            if (sourceParagraph == null || targetParagraph == null) {
                return;
            }
            targetParagraph.setAlignment(sourceParagraph.getAlignment());
            targetParagraph.setVerticalAlignment(sourceParagraph.getVerticalAlignment());
            targetParagraph.setBorderBetween(sourceParagraph.getBorderBetween());
            targetParagraph.setBorderBottom(sourceParagraph.getBorderBottom());
            targetParagraph.setBorderLeft(sourceParagraph.getBorderLeft());
            targetParagraph.setBorderRight(sourceParagraph.getBorderRight());
            targetParagraph.setFirstLineIndent(sourceParagraph.getFirstLineIndent());
            targetParagraph.setIndentationHanging(sourceParagraph.getIndentationHanging());
            targetParagraph.setIndentationLeft(sourceParagraph.getIndentationLeft());
            targetParagraph.setIndentationLeftChars(sourceParagraph.getIndentationLeftChars());
            targetParagraph.setIndentationRight(sourceParagraph.getIndentationRight());
            targetParagraph.setIndentationRightChars(sourceParagraph.getIndentationRightChars());
            targetParagraph.setSpacingAfter(sourceParagraph.getSpacingAfter());
            targetParagraph.setSpacingAfterLines(sourceParagraph.getSpacingAfterLines());
            targetParagraph.setSpacingBetween(sourceParagraph.getSpacingBetween());
            targetParagraph.setSpacingBefore(sourceParagraph.getSpacingBefore());
            targetParagraph.setSpacingBeforeLines(sourceParagraph.getSpacingBeforeLines());
            if (sourceParagraph.getCTP() != null) {
                targetParagraph.getCTP().set(sourceParagraph.getCTP().copy());
            }
        }
        catch (Exception ex) {
            logger.error("dm copy Paragraph fail", (Throwable)ex);
        }
    }
}

