/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.word.helper;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.util.StringUtils;
import kd.epm.far.business.fidm.word.base.WordConstants;
import kd.epm.far.business.fidm.word.dto.WordNode;
import kd.epm.far.business.fidm.word.dto.WordParagraphNode;
import kd.epm.far.business.fidm.word.dto.WordTableCellMargins;
import kd.epm.far.business.fidm.word.dto.WordTableCellNode;
import kd.epm.far.business.fidm.word.dto.WordTableNode;
import kd.epm.far.business.fidm.word.dto.WordTableRowNode;
import kd.epm.far.business.fidm.word.dto.WordTextNode;
import kd.epm.far.business.fidm.word.dto.font.FontCalculateResult;
import kd.epm.far.business.fidm.word.dto.font.FontWidthResult;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;

public class WordFontHelper {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(WordFontHelper.class);

    public static void resetCellFont(WordTableNode tableNode) {
        long start = System.currentTimeMillis();
        Map<String, List<FontWidthResult>> fontWidthResultList = WordFontHelper.getFontWidthResult();
        for (WordNode rowItem : tableNode.getChilds()) {
            WordTableRowNode row = (WordTableRowNode)rowItem;
            if (row == null) continue;
            for (WordNode cellItem : row.getChilds()) {
                WordTableCellNode cellNode = (WordTableCellNode)cellItem;
                if (cellNode == null) continue;
                for (WordNode paragraphItemNode : cellNode.getChilds()) {
                    WordParagraphNode paragraphNode = (WordParagraphNode)paragraphItemNode;
                    if (paragraphNode == null) continue;
                    WordFontHelper.resetCellTextFontSize(fontWidthResultList, cellNode, paragraphNode, tableNode.getMargins());
                }
            }
        }
        logger.info(String.format("%s--fidm--resetCellTextFontSize--spentime-->%dms", Thread.currentThread().getName(), System.currentTimeMillis() - start));
    }

    public static void resetCellTextFontSize(Map<String, List<FontWidthResult>> fontWidthResultMap, WordTableCellNode cellNode, WordParagraphNode paragraphNode, WordTableCellMargins margins) {
        if (cellNode.getWidth() <= 0.0) {
            return;
        }
        for (WordNode textItemNode : paragraphNode.getChilds()) {
            FontCalculateResult fontCalculateResult;
            WordTextNode textNode = (WordTextNode)textItemNode;
            if (textNode == null) continue;
            textNode.setSoucreFontSize(textNode.getFontSize());
            if (cellNode.getColumnSpan() > 1 || StringUtils.isEmpty((String)textNode.getContent())) continue;
            String fontFamily = textNode.getFontFamily();
            List<FontWidthResult> fontWidthResultList = fontWidthResultMap.get(fontFamily);
            if (fontWidthResultList == null || fontWidthResultList.size() == 0) {
                fontWidthResultList = fontWidthResultMap.get(WordConstants.SimsunFont);
            }
            if ((fontCalculateResult = WordFontHelper.calculateFontSize(margins, fontWidthResultList, textNode.getContent(), cellNode.getWidth(), textNode.getFontSize(), textNode.getBold())) == null || !(fontCalculateResult.getFontSize() < textNode.getFontSize())) continue;
            textNode.setFontSize(fontCalculateResult.getFontSize());
        }
    }

    private static FontCalculateResult calculateFontSize(WordTableCellMargins margins, List<FontWidthResult> fontWidthResultList, String content, double width, double sourceFontSize, boolean isBold) {
        if (StringUtils.isEmpty((String)content) || width <= 0.0 || sourceFontSize <= 0.0) {
            return null;
        }
        double cmMarginLen = 0.0;
        cmMarginLen = margins != null && margins.getLeft() != null && margins.getLeft().getWidth() == 0.0 ? (cmMarginLen += margins.getLeft().getWidth()) : (cmMarginLen += 113.4);
        cmMarginLen = margins != null && margins.getRight() != null && margins.getRight().getWidth() == 0.0 ? (cmMarginLen += margins.getRight().getWidth()) : (cmMarginLen += 113.4);
        double fontAreaWidth = width - cmMarginLen;
        double fontSize = sourceFontSize;
        int hanCount = WordFontHelper.calculateChineseNumber(content);
        int suCount = content.length() - hanCount;
        FontWidthResult find = null;
        boolean sizeNoInData = false;
        for (int i = (int)sourceFontSize; i >= 0; --i) {
            if (i >= fontWidthResultList.size()) {
                sizeNoInData = true;
                break;
            }
            FontWidthResult cur = fontWidthResultList.get(i);
            if (!(cur.getSuSize() * (double)suCount * 567.0 + cur.getHanSize() * (double)hanCount * 567.0 < fontAreaWidth)) continue;
            find = cur;
            break;
        }
        if (find == null) {
            if (sizeNoInData) {
                int count = (content.length() - hanCount + 1) * 1 + hanCount * 2;
                fontSize = width / (double)count * 0.085 * (isBold ? 0.8 : 1.0);
            } else {
                fontSize = 1.0;
            }
        } else {
            fontSize = find.getFontSize();
        }
        if (fontSize > sourceFontSize) {
            fontSize = sourceFontSize;
        }
        FontCalculateResult fontCalculateResult = new FontCalculateResult();
        fontCalculateResult.setFontSize(fontSize);
        fontCalculateResult.setHanSize(hanCount);
        fontCalculateResult.setSuSize(suCount);
        return fontCalculateResult;
    }

    private static Map<String, List<FontWidthResult>> getFontWidthResult() {
        String simsunFontData = "[{\"fontSize\":1.0,\"hanSize\":0.02,\"suSize\":0.02},{\"fontSize\":2.0,\"hanSize\":0.07,\"suSize\":0.04},{\"fontSize\":3.0,\"hanSize\":0.11,\"suSize\":0.05},{\"fontSize\":4.0,\"hanSize\":0.14,\"suSize\":0.07},{\"fontSize\":5.0,\"hanSize\":0.18,\"suSize\":0.09},{\"fontSize\":6.0,\"hanSize\":0.21,\"suSize\":0.11},{\"fontSize\":7.0,\"hanSize\":0.25,\"suSize\":0.12},{\"fontSize\":8.0,\"hanSize\":0.28,\"suSize\":0.14},{\"fontSize\":9.0,\"hanSize\":0.32,\"suSize\":0.16},{\"fontSize\":10.0,\"hanSize\":0.35,\"suSize\":0.17},{\"fontSize\":11.0,\"hanSize\":0.39,\"suSize\":0.19},{\"fontSize\":12.0,\"hanSize\":0.42,\"suSize\":0.21},{\"fontSize\":13.0,\"hanSize\":0.46,\"suSize\":0.23},{\"fontSize\":14.0,\"hanSize\":0.49,\"suSize\":0.24},{\"fontSize\":15.0,\"hanSize\":0.53,\"suSize\":0.26},{\"fontSize\":16.0,\"hanSize\":0.56,\"suSize\":0.28},{\"fontSize\":17.0,\"hanSize\":0.6,\"suSize\":0.3},{\"fontSize\":18.0,\"hanSize\":0.64,\"suSize\":0.32},{\"fontSize\":19.0,\"hanSize\":0.67,\"suSize\":0.33},{\"fontSize\":20.0,\"hanSize\":0.71,\"suSize\":0.35},{\"fontSize\":21.0,\"hanSize\":0.74,\"suSize\":0.37},{\"fontSize\":22.0,\"hanSize\":0.78,\"suSize\":0.39},{\"fontSize\":23.0,\"hanSize\":0.81,\"suSize\":0.4},{\"fontSize\":24.0,\"hanSize\":0.85,\"suSize\":0.42},{\"fontSize\":25.0,\"hanSize\":0.88,\"suSize\":0.44},{\"fontSize\":26.0,\"hanSize\":0.92,\"suSize\":0.46},{\"fontSize\":27.0,\"hanSize\":0.95,\"suSize\":0.47},{\"fontSize\":28.0,\"hanSize\":0.99,\"suSize\":0.49},{\"fontSize\":29.0,\"hanSize\":1.02,\"suSize\":0.51},{\"fontSize\":30.0,\"hanSize\":1.06,\"suSize\":0.53},{\"fontSize\":31.0,\"hanSize\":1.09,\"suSize\":0.54},{\"fontSize\":32.0,\"hanSize\":1.13,\"suSize\":0.56},{\"fontSize\":33.0,\"hanSize\":1.16,\"suSize\":0.58},{\"fontSize\":34.0,\"hanSize\":1.2,\"suSize\":0.6},{\"fontSize\":35.0,\"hanSize\":1.23,\"suSize\":0.61},{\"fontSize\":36.0,\"hanSize\":1.27,\"suSize\":0.63},{\"fontSize\":37.0,\"hanSize\":1.31,\"suSize\":0.65},{\"fontSize\":38.0,\"hanSize\":1.34,\"suSize\":0.67},{\"fontSize\":39.0,\"hanSize\":1.38,\"suSize\":0.69},{\"fontSize\":40.0,\"hanSize\":1.41,\"suSize\":0.7},{\"fontSize\":41.0,\"hanSize\":1.45,\"suSize\":0.72},{\"fontSize\":42.0,\"hanSize\":1.48,\"suSize\":0.74},{\"fontSize\":43.0,\"hanSize\":1.52,\"suSize\":0.76},{\"fontSize\":44.0,\"hanSize\":1.55,\"suSize\":0.77},{\"fontSize\":45.0,\"hanSize\":1.59,\"suSize\":0.79},{\"fontSize\":46.0,\"hanSize\":1.62,\"suSize\":0.81},{\"fontSize\":47.0,\"hanSize\":1.66,\"suSize\":0.83},{\"fontSize\":48.0,\"hanSize\":1.69,\"suSize\":0.84},{\"fontSize\":49.0,\"hanSize\":1.73,\"suSize\":0.86},{\"fontSize\":50.0,\"hanSize\":1.76,\"suSize\":0.88},{\"fontSize\":51.0,\"hanSize\":1.8,\"suSize\":0.9},{\"fontSize\":52.0,\"hanSize\":1.83,\"suSize\":0.91},{\"fontSize\":53.0,\"hanSize\":1.87,\"suSize\":0.93},{\"fontSize\":54.0,\"hanSize\":1.91,\"suSize\":0.95},{\"fontSize\":55.0,\"hanSize\":1.94,\"suSize\":0.97},{\"fontSize\":56.0,\"hanSize\":1.98,\"suSize\":0.99},{\"fontSize\":57.0,\"hanSize\":2.01,\"suSize\":1.0},{\"fontSize\":58.0,\"hanSize\":2.05,\"suSize\":1.02},{\"fontSize\":59.0,\"hanSize\":2.08,\"suSize\":1.04},{\"fontSize\":60.0,\"hanSize\":2.12,\"suSize\":1.06},{\"fontSize\":61.0,\"hanSize\":2.15,\"suSize\":1.07},{\"fontSize\":62.0,\"hanSize\":2.19,\"suSize\":1.09},{\"fontSize\":63.0,\"hanSize\":2.22,\"suSize\":1.11},{\"fontSize\":64.0,\"hanSize\":2.26,\"suSize\":1.13},{\"fontSize\":65.0,\"hanSize\":2.29,\"suSize\":1.14},{\"fontSize\":66.0,\"hanSize\":2.33,\"suSize\":1.16},{\"fontSize\":67.0,\"hanSize\":2.36,\"suSize\":1.18},{\"fontSize\":68.0,\"hanSize\":2.4,\"suSize\":1.2},{\"fontSize\":69.0,\"hanSize\":2.43,\"suSize\":1.21},{\"fontSize\":70.0,\"hanSize\":2.47,\"suSize\":1.23},{\"fontSize\":71.0,\"hanSize\":2.5,\"suSize\":1.25},{\"fontSize\":72.0,\"hanSize\":2.54,\"suSize\":1.27},{\"fontSize\":73.0,\"hanSize\":2.57,\"suSize\":1.28},{\"fontSize\":74.0,\"hanSize\":2.61,\"suSize\":1.3},{\"fontSize\":75.0,\"hanSize\":2.64,\"suSize\":1.32},{\"fontSize\":76.0,\"hanSize\":2.68,\"suSize\":1.34},{\"fontSize\":77.0,\"hanSize\":2.71,\"suSize\":1.35},{\"fontSize\":78.0,\"hanSize\":2.75,\"suSize\":1.37},{\"fontSize\":79.0,\"hanSize\":2.78,\"suSize\":1.39},{\"fontSize\":80.0,\"hanSize\":2.82,\"suSize\":1.41},{\"fontSize\":81.0,\"hanSize\":2.85,\"suSize\":1.42},{\"fontSize\":82.0,\"hanSize\":2.89,\"suSize\":1.44},{\"fontSize\":83.0,\"hanSize\":2.93,\"suSize\":1.46},{\"fontSize\":84.0,\"hanSize\":2.96,\"suSize\":1.48},{\"fontSize\":85.0,\"hanSize\":3.0,\"suSize\":1.5},{\"fontSize\":86.0,\"hanSize\":3.03,\"suSize\":1.51},{\"fontSize\":87.0,\"hanSize\":3.07,\"suSize\":1.53},{\"fontSize\":88.0,\"hanSize\":3.1,\"suSize\":1.55},{\"fontSize\":89.0,\"hanSize\":3.14,\"suSize\":1.57},{\"fontSize\":90.0,\"hanSize\":3.18,\"suSize\":1.59},{\"fontSize\":91.0,\"hanSize\":3.21,\"suSize\":1.6},{\"fontSize\":92.0,\"hanSize\":3.25,\"suSize\":1.62},{\"fontSize\":93.0,\"hanSize\":3.28,\"suSize\":1.64},{\"fontSize\":94.0,\"hanSize\":3.3,\"suSize\":1.65},{\"fontSize\":95.0,\"hanSize\":3.35,\"suSize\":1.67},{\"fontSize\":96.0,\"hanSize\":3.39,\"suSize\":1.69},{\"fontSize\":97.0,\"hanSize\":3.42,\"suSize\":1.71},{\"fontSize\":98.0,\"hanSize\":3.46,\"suSize\":1.73},{\"fontSize\":99.0,\"hanSize\":3.49,\"suSize\":1.74},{\"fontSize\":100.0,\"hanSize\":3.53,\"suSize\":1.76}]";
        String yaheiFontData = "[{\"fontSize\":1.0,\"hanSize\":0.04,\"suSize\":0.02},{\"fontSize\":2.0,\"hanSize\":0.07,\"suSize\":0.04},{\"fontSize\":3.0,\"hanSize\":0.11,\"suSize\":0.07},{\"fontSize\":4.0,\"hanSize\":0.14,\"suSize\":0.09},{\"fontSize\":5.0,\"hanSize\":0.18,\"suSize\":0.12},{\"fontSize\":6.0,\"hanSize\":0.21,\"suSize\":0.14},{\"fontSize\":7.0,\"hanSize\":0.25,\"suSize\":0.17},{\"fontSize\":8.0,\"hanSize\":0.28,\"suSize\":0.19},{\"fontSize\":9.0,\"hanSize\":0.32,\"suSize\":0.22},{\"fontSize\":10.0,\"hanSize\":0.35,\"suSize\":0.24},{\"fontSize\":11.0,\"hanSize\":0.39,\"suSize\":0.27},{\"fontSize\":12.0,\"hanSize\":0.42,\"suSize\":0.29},{\"fontSize\":13.0,\"hanSize\":0.46,\"suSize\":0.32},{\"fontSize\":14.0,\"hanSize\":0.49,\"suSize\":0.34},{\"fontSize\":15.0,\"hanSize\":0.53,\"suSize\":0.37},{\"fontSize\":16.0,\"hanSize\":0.56,\"suSize\":0.39},{\"fontSize\":17.0,\"hanSize\":0.6,\"suSize\":0.42},{\"fontSize\":18.0,\"hanSize\":0.64,\"suSize\":0.44},{\"fontSize\":19.0,\"hanSize\":0.67,\"suSize\":0.46},{\"fontSize\":20.0,\"hanSize\":0.71,\"suSize\":0.49},{\"fontSize\":21.0,\"hanSize\":0.74,\"suSize\":0.51},{\"fontSize\":22.0,\"hanSize\":0.78,\"suSize\":0.54},{\"fontSize\":23.0,\"hanSize\":0.81,\"suSize\":0.56},{\"fontSize\":24.0,\"hanSize\":0.85,\"suSize\":0.59},{\"fontSize\":25.0,\"hanSize\":0.88,\"suSize\":0.61},{\"fontSize\":26.0,\"hanSize\":0.92,\"suSize\":0.64},{\"fontSize\":27.0,\"hanSize\":0.95,\"suSize\":0.66},{\"fontSize\":28.0,\"hanSize\":0.99,\"suSize\":0.69},{\"fontSize\":29.0,\"hanSize\":1.02,\"suSize\":0.71},{\"fontSize\":30.0,\"hanSize\":1.06,\"suSize\":0.74},{\"fontSize\":31.0,\"hanSize\":1.09,\"suSize\":0.76},{\"fontSize\":32.0,\"hanSize\":1.13,\"suSize\":0.79},{\"fontSize\":33.0,\"hanSize\":1.16,\"suSize\":0.81},{\"fontSize\":34.0,\"hanSize\":1.2,\"suSize\":0.84},{\"fontSize\":35.0,\"hanSize\":1.23,\"suSize\":0.86},{\"fontSize\":36.0,\"hanSize\":1.27,\"suSize\":0.88},{\"fontSize\":37.0,\"hanSize\":1.31,\"suSize\":0.91},{\"fontSize\":38.0,\"hanSize\":1.34,\"suSize\":0.93},{\"fontSize\":39.0,\"hanSize\":1.38,\"suSize\":0.96},{\"fontSize\":40.0,\"hanSize\":1.41,\"suSize\":0.98},{\"fontSize\":41.0,\"hanSize\":1.45,\"suSize\":1.01},{\"fontSize\":42.0,\"hanSize\":1.48,\"suSize\":1.03},{\"fontSize\":43.0,\"hanSize\":1.52,\"suSize\":1.06},{\"fontSize\":44.0,\"hanSize\":1.55,\"suSize\":1.08},{\"fontSize\":45.0,\"hanSize\":1.59,\"suSize\":1.11},{\"fontSize\":46.0,\"hanSize\":1.62,\"suSize\":1.13},{\"fontSize\":47.0,\"hanSize\":1.66,\"suSize\":1.16},{\"fontSize\":48.0,\"hanSize\":1.69,\"suSize\":1.18},{\"fontSize\":49.0,\"hanSize\":1.73,\"suSize\":1.21},{\"fontSize\":50.0,\"hanSize\":1.76,\"suSize\":1.23},{\"fontSize\":51.0,\"hanSize\":1.8,\"suSize\":1.26},{\"fontSize\":52.0,\"hanSize\":1.83,\"suSize\":1.28},{\"fontSize\":53.0,\"hanSize\":1.87,\"suSize\":1.3},{\"fontSize\":54.0,\"hanSize\":1.91,\"suSize\":1.33},{\"fontSize\":55.0,\"hanSize\":1.94,\"suSize\":1.35},{\"fontSize\":56.0,\"hanSize\":1.98,\"suSize\":1.38},{\"fontSize\":57.0,\"hanSize\":2.01,\"suSize\":1.4},{\"fontSize\":58.0,\"hanSize\":2.05,\"suSize\":1.43},{\"fontSize\":59.0,\"hanSize\":2.08,\"suSize\":1.45},{\"fontSize\":60.0,\"hanSize\":2.12,\"suSize\":1.48},{\"fontSize\":61.0,\"hanSize\":2.15,\"suSize\":1.5},{\"fontSize\":62.0,\"hanSize\":2.19,\"suSize\":1.53},{\"fontSize\":63.0,\"hanSize\":2.22,\"suSize\":1.55},{\"fontSize\":64.0,\"hanSize\":2.26,\"suSize\":1.58},{\"fontSize\":65.0,\"hanSize\":2.29,\"suSize\":1.6},{\"fontSize\":66.0,\"hanSize\":2.33,\"suSize\":1.63},{\"fontSize\":67.0,\"hanSize\":2.36,\"suSize\":1.65},{\"fontSize\":68.0,\"hanSize\":2.4,\"suSize\":1.68},{\"fontSize\":69.0,\"hanSize\":2.43,\"suSize\":1.7},{\"fontSize\":70.0,\"hanSize\":2.47,\"suSize\":1.72},{\"fontSize\":71.0,\"hanSize\":2.5,\"suSize\":1.75},{\"fontSize\":72.0,\"hanSize\":2.54,\"suSize\":1.77},{\"fontSize\":73.0,\"hanSize\":2.57,\"suSize\":1.79},{\"fontSize\":74.0,\"hanSize\":2.61,\"suSize\":1.82},{\"fontSize\":75.0,\"hanSize\":2.64,\"suSize\":1.84},{\"fontSize\":76.0,\"hanSize\":2.68,\"suSize\":1.87},{\"fontSize\":77.0,\"hanSize\":2.71,\"suSize\":1.89},{\"fontSize\":78.0,\"hanSize\":2.75,\"suSize\":1.92},{\"fontSize\":79.0,\"hanSize\":2.78,\"suSize\":1.94},{\"fontSize\":80.0,\"hanSize\":2.82,\"suSize\":1.97},{\"fontSize\":81.0,\"hanSize\":2.85,\"suSize\":1.99},{\"fontSize\":82.0,\"hanSize\":2.89,\"suSize\":2.02},{\"fontSize\":83.0,\"hanSize\":2.93,\"suSize\":2.05},{\"fontSize\":84.0,\"hanSize\":2.96,\"suSize\":2.07},{\"fontSize\":85.0,\"hanSize\":3.0,\"suSize\":2.1},{\"fontSize\":86.0,\"hanSize\":3.03,\"suSize\":2.12},{\"fontSize\":87.0,\"hanSize\":3.07,\"suSize\":2.14},{\"fontSize\":88.0,\"hanSize\":3.1,\"suSize\":2.17},{\"fontSize\":89.0,\"hanSize\":3.14,\"suSize\":2.19},{\"fontSize\":90.0,\"hanSize\":3.18,\"suSize\":2.22},{\"fontSize\":91.0,\"hanSize\":3.21,\"suSize\":2.24},{\"fontSize\":92.0,\"hanSize\":3.25,\"suSize\":2.27},{\"fontSize\":93.0,\"hanSize\":3.28,\"suSize\":2.29},{\"fontSize\":94.0,\"hanSize\":3.3,\"suSize\":2.31},{\"fontSize\":95.0,\"hanSize\":3.35,\"suSize\":2.34},{\"fontSize\":96.0,\"hanSize\":3.39,\"suSize\":2.37},{\"fontSize\":97.0,\"hanSize\":3.42,\"suSize\":2.39},{\"fontSize\":98.0,\"hanSize\":3.46,\"suSize\":2.42},{\"fontSize\":99.0,\"hanSize\":3.49,\"suSize\":2.44},{\"fontSize\":100.0,\"hanSize\":3.53,\"suSize\":2.47}]";
        HashMap<String, List<FontWidthResult>> result = new HashMap<String, List<FontWidthResult>>(10);
        result.put(WordConstants.SimsunFont, JSON.parseArray((String)simsunFontData, FontWidthResult.class));
        result.put(WordConstants.YaheiFont, JSON.parseArray((String)yaheiFontData, FontWidthResult.class));
        result.put("Courier New", JSON.parseArray((String)yaheiFontData, FontWidthResult.class));
        return result;
    }

    private static int calculateChineseNumber(String str) {
        int count = 0;
        String regEx = "[\\u4e00-\\u9fa5]";
        Pattern pattern = Pattern.compile(regEx);
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            for (int i = 0; i <= matcher.groupCount(); ++i) {
                ++count;
            }
        }
        return count;
    }
}

