/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.word.helper;

import java.util.ArrayList;
import java.util.List;
import kd.bos.util.StringUtils;
import kd.epm.far.business.fidm.word.helper.WordNodeTextHelper;
import kd.epm.far.business.fidm.word.poi.VarPoi;
import kd.epm.far.business.fidm.wpsplugin.dto.FormularCTText;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.apache.xmlbeans.impl.xb.xmlschema.SpaceAttribute;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STFldCharType;
import org.w3c.dom.Node;

public class WordFormulaHelper {
    public static List<FormularCTText> getFormulaList(XWPFDocument document, List<String> moduleIds) {
        ArrayList<FormularCTText> reuslt = new ArrayList<FormularCTText>(1000);
        if (document == null || moduleIds == null || moduleIds.size() == 0) {
            return reuslt;
        }
        List<FormularCTText> list = WordFormulaHelper.getFormulaList(document);
        if (list == null || list.size() == 0) {
            return reuslt;
        }
        reuslt = new ArrayList(list.size());
        for (FormularCTText formularCTText : list) {
            String moduleId;
            if (!VarPoi.checkFormularString(formularCTText.getInstrText()) || StringUtils.isEmpty((String)(moduleId = (String)moduleIds.stream().filter(x -> formularCTText.getInstrText().contains((CharSequence)x)).findAny().orElse(null)))) continue;
            reuslt.add(formularCTText);
        }
        return reuslt;
    }

    public static FormularCTText findFormula(List<FormularCTText> list, String moduleId) {
        if (list == null || StringUtils.isEmpty((String)moduleId) || list.size() == 0) {
            return null;
        }
        for (FormularCTText formularCTText : list) {
            if (!VarPoi.checkFormularString(formularCTText.getInstrText()) || !formularCTText.getInstrText().contains(moduleId)) continue;
            return formularCTText;
        }
        return null;
    }

    public static List<FormularCTText> getFormulaList(XWPFDocument document) {
        ArrayList<FormularCTText> reuslt = new ArrayList<FormularCTText>(1000);
        if (document == null) {
            return reuslt;
        }
        List paragraphList = document.getParagraphs();
        List<FormularCTText> r1 = WordFormulaHelper.getFormularCTText(paragraphList);
        if (r1.size() > 0) {
            reuslt.addAll(r1);
        }
        List tableList = document.getTables();
        for (XWPFTable xwpfTable : tableList) {
            List rows = xwpfTable.getRows();
            for (XWPFTableRow xwpfTableRow : rows) {
                List tableCells = xwpfTableRow.getTableCells();
                for (XWPFTableCell xwpfTableCell : tableCells) {
                    List cellParagraphs = xwpfTableCell.getParagraphs();
                    List<FormularCTText> r = WordFormulaHelper.getFormularCTText(cellParagraphs);
                    if (r.size() <= 0) continue;
                    reuslt.addAll(r);
                }
            }
        }
        return reuslt;
    }

    private static List<FormularCTText> getFormularCTText(List<XWPFParagraph> xwpfParagraphs) {
        ArrayList<FormularCTText> reuslt = new ArrayList<FormularCTText>(2);
        FormularCTText cur = new FormularCTText();
        for (XWPFParagraph xwpfParagraph : xwpfParagraphs) {
            List runs = xwpfParagraph.getRuns();
            for (XWPFRun run : runs) {
                Node runNode = run.getCTR().getDomNode();
                if (runNode == null || !runNode.getNodeName().equals("w:r")) continue;
                if (run.getCTR() != null && run.getCTR().getFldCharArray().length > 0) {
                    STFldCharType.Enum curCharType = run.getCTR().getFldCharArray(0).getFldCharType();
                    if (curCharType == STFldCharType.Enum.forString((String)"begin")) {
                        cur = new FormularCTText();
                        cur.setBegin(run);
                        cur.setPreserve(null);
                        cur.setSeparate(null);
                        cur.setContents(new ArrayList<XWPFRun>(10));
                        cur.setEnd(null);
                        continue;
                    }
                    if (curCharType == STFldCharType.Enum.forString((String)"separate")) {
                        cur.setSeparate(run);
                        cur.setContents(new ArrayList<XWPFRun>(10));
                        cur.setEnd(null);
                        continue;
                    }
                    if (curCharType == STFldCharType.Enum.forString((String)"end")) {
                        cur.setEnd(run);
                        if (cur.getBegin() == null || cur.getPreserve() == null || cur.getSeparate() == null || cur.getContents().size() <= 0 || cur.getEnd() == null) continue;
                        reuslt.add(cur);
                        cur = new FormularCTText();
                        continue;
                    }
                }
                if (run.getCTR() != null && run.getCTR().getInstrTextArray().length > 0) {
                    CTText ctText = run.getCTR().getInstrTextArray(0);
                    SpaceAttribute.Space.Enum curSpace = ctText.getSpace();
                    String formularStr = ctText.getStringValue();
                    if (curSpace == SpaceAttribute.Space.Enum.forString((String)"preserve")) {
                        cur.setInstrText(formularStr);
                        cur.setPreserve(run);
                        cur.setSeparate(null);
                        cur.setContents(new ArrayList<XWPFRun>(10));
                        cur.setEnd(null);
                        continue;
                    }
                }
                if (cur.getBegin() == null || cur.getPreserve() == null || cur.getSeparate() == null || cur.getEnd() != null) continue;
                cur.getContents().add(run);
            }
        }
        return reuslt;
    }

    public static XWPFRun removeAndGetContentNode(FormularCTText formularCTText) {
        WordNodeTextHelper.removeRun(formularCTText.getBegin());
        WordNodeTextHelper.removeRun(formularCTText.getPreserve());
        WordNodeTextHelper.removeRun(formularCTText.getSeparate());
        WordNodeTextHelper.removeRun(formularCTText.getEnd());
        if (formularCTText.getContents().size() > 0) {
            XWPFRun run = formularCTText.getContents().get(0);
            run.setText("", 0);
            for (int i = formularCTText.getContents().size() - 1; i > 0; --i) {
                WordNodeTextHelper.removeRun(formularCTText.getContents().get(i));
            }
            return run;
        }
        return null;
    }
}

