/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.word.helper;

import java.util.ArrayList;
import java.util.List;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.ModuleEnum;
import kd.epm.far.business.fidm.word.dto.WordModuleNode;
import kd.epm.far.business.fidm.word.dto.WordNode;
import kd.epm.far.business.fidm.word.dto.WordTextNode;
import kd.epm.far.business.fidm.word.helper.WordChartsHelper;
import kd.epm.far.business.fidm.word.poi.WordModuleUtils;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import org.apache.poi.util.Units;
import org.apache.poi.xwpf.usermodel.XWPFChart;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDrawing;

public class WordModuleNodeHelper {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(WordModuleNodeHelper.class);

    public static List<WordModuleNode> creatCharts(XWPFRun run) {
        ArrayList<WordModuleNode> charts = new ArrayList<WordModuleNode>(2);
        for (CTDrawing drawing : run.getCTR().getDrawingArray()) {
            double width = 0.0;
            double height = 0.0;
            String rid = WordChartsHelper.getRidByDrawingInline(drawing);
            if (StringUtils.isNotEmpty((String)rid)) {
                width = Units.toPoints((long)drawing.getInlineArray(0).getExtent().getCx());
                height = Units.toPoints((long)drawing.getInlineArray(0).getExtent().getCy());
            } else {
                rid = WordChartsHelper.getRidByDrawingAnchor(drawing);
                if (StringUtils.isEmpty((String)rid)) continue;
                width = Units.toPoints((long)drawing.getAnchorArray(0).getExtent().getCx());
                height = Units.toPoints((long)drawing.getAnchorArray(0).getExtent().getCy());
            }
            XWPFChart chart = WordChartsHelper.findChart(run, rid);
            if (chart == null) continue;
            ModuleEnum moduleEnum = WordChartsHelper.getModuleEnum(chart);
            String chartId = WordChartsHelper.getModuleIdFromChart(chart);
            WordModuleNode wordModuleNode = new WordModuleNode();
            wordModuleNode.setModuleProperties(null);
            wordModuleNode.setName("Chart" + rid);
            wordModuleNode.setWidth(width / 1.28);
            wordModuleNode.setHeight(height);
            wordModuleNode.setModuleType(moduleEnum == null ? null : moduleEnum.getType());
            wordModuleNode.setDataModeuleId(chartId);
            charts.add(wordModuleNode);
        }
        return charts;
    }

    public static void toModuleWord(WordModuleNode moduleNode, XWPFRun run) {
        try {
            if (moduleNode.getModuleProperties() != null) {
                WordModuleUtils.createModule(run, moduleNode.getModuleProperties());
            }
        }
        catch (Exception ex) {
            logger.error("dm wordconvert fail", (Throwable)ex);
        }
    }

    public static List<WordModuleNode> getWordModuleNodes(WordTextNode textNode) {
        ArrayList<WordModuleNode> wordModuleNodes = new ArrayList<WordModuleNode>(2);
        for (WordNode wordNode : textNode.getChilds()) {
            if (!(wordNode instanceof WordModuleNode)) continue;
            wordModuleNodes.add((WordModuleNode)wordNode);
        }
        return wordModuleNodes;
    }
}

