/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.word.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.util.StringUtils;
import kd.epm.far.business.fidm.word.base.WordConstants;
import kd.epm.far.business.fidm.word.dto.WordNode;
import kd.epm.far.business.fidm.word.dto.WordParagraphNode;
import kd.epm.far.business.fidm.word.dto.WordTableCellBorders;
import kd.epm.far.business.fidm.word.dto.WordTableCellNode;
import kd.epm.far.business.fidm.word.dto.WordTableCellNodeEx;
import kd.epm.far.business.fidm.word.dto.WordTableNode;
import kd.epm.far.business.fidm.word.dto.WordTableRowNode;
import kd.epm.far.business.fidm.word.dto.WordTextNode;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.w3c.dom.Node;

public class WordNodeHelper {
    public static final String RowSpanBegin = "RowSpan.Begin";
    public static final String ColumnSpanBegin = "ColumnSpan.Begin";
    public static final String ColumnSpanMiddle = "ColumnSpan.Middle";
    public static final String RowSpanMiddle = "RowSpan.Middle";
    public static final String JoinString = ";";

    public static void expand(WordTableNode tableNode) {
        Tuple<Integer, Integer> max = WordNodeHelper.getMax(tableNode);
        int columnMax = (Integer)max.item1;
        int rowMax = (Integer)max.item2;
        LinkedHashMap<Integer, RowCalEntity> rowMap = new LinkedHashMap<Integer, RowCalEntity>(rowMax);
        int realRowIndex = 0;
        for (int rowIndex = 0; rowIndex < tableNode.getChilds().size(); ++rowIndex) {
            WordTableRowNode rowNode = (WordTableRowNode)tableNode.getChilds().get(rowIndex);
            RowCalEntity rowCalEntity = WordNodeHelper.getRow(rowMap, rowNode, realRowIndex, columnMax);
            rowCalEntity.rowNode = rowNode;
            if (rowNode.getChilds().size() == 0) continue;
            int realColumnIndex = 0;
            for (int cellIndex = 0; cellIndex < rowNode.getChilds().size(); ++cellIndex) {
                String bing = "";
                if (!(rowNode.getChilds().get(cellIndex) instanceof WordTableCellNode)) continue;
                WordTableCellNode cellNode = (WordTableCellNode)rowNode.getChilds().get(cellIndex);
                if (cellNode.getRowSpan() > 1) {
                    bing = RowSpanBegin;
                }
                if (cellNode.getColumnSpan() > 1) {
                    bing = bing + (StringUtils.isNotEmpty((String)bing) ? JoinString : "") + ColumnSpanBegin;
                }
                if ((realColumnIndex = WordNodeHelper.getIndexNullItem(rowCalEntity.cells, realColumnIndex)) == -1) {
                    realColumnIndex = 0;
                    continue;
                }
                if (realColumnIndex >= columnMax) break;
                rowCalEntity.cells[realColumnIndex] = new WordTableCellNodeEx(cellNode, bing);
                int realColumnIndexForNextRow = realColumnIndex;
                if (cellNode.getColumnSpan() > 1) {
                    WordNodeHelper.createColumnSpan(rowCalEntity.cells, cellNode, columnMax, realColumnIndex + 1, ColumnSpanMiddle);
                    realColumnIndex = realColumnIndex + cellNode.getColumnSpan() - 1;
                }
                if (cellNode.getRowSpan() > 1) {
                    for (int i = 1; i < cellNode.getRowSpan(); ++i) {
                        int curRowIndex = realRowIndex + i;
                        RowCalEntity nextRowEntity = WordNodeHelper.getRow(rowMap, null, curRowIndex, columnMax);
                        nextRowEntity.cells[realColumnIndexForNextRow] = new WordTableCellNodeEx(cellNode, RowSpanMiddle);
                        if (cellNode.getColumnSpan() <= 1) continue;
                        WordNodeHelper.createColumnSpan(nextRowEntity.cells, cellNode, columnMax, realColumnIndexForNextRow + 1, "RowSpan.Middle;ColumnSpan.Middle");
                    }
                }
                ++realColumnIndex;
            }
            ++realRowIndex;
            realRowIndex = WordNodeHelper.nextRowAutoFill(rowMap, realRowIndex, 0);
        }
        tableNode.setChilds(WordNodeHelper.converToRowList(rowMap));
        WordNodeHelper.calWidth(tableNode);
    }

    public static void shrink(WordTableNode tableNode) {
        ArrayList<WordNode> rowsNodes = new ArrayList<WordNode>(tableNode.getChilds().size());
        for (int i = 0; i < tableNode.getChilds().size(); ++i) {
            WordTableRowNode rowNode = (WordTableRowNode)tableNode.getChilds().get(i);
            ArrayList<WordNode> cellNodes = new ArrayList<WordNode>(rowNode.getChilds().size());
            for (int j = 0; j < rowNode.getChilds().size(); ++j) {
                WordTableCellNodeEx cellNode = (WordTableCellNodeEx)rowNode.getChilds().get(j);
                if (cellNode == null || !"".equals(cellNode.getBing()) && !cellNode.getBing().contains(RowSpanBegin) && !cellNode.getBing().contains(ColumnSpanBegin)) continue;
                cellNodes.add(cellNode.getSource());
            }
            rowNode.setChilds(cellNodes);
            rowsNodes.add(rowNode);
        }
        tableNode.setChilds(rowsNodes);
    }

    private static List<WordNode> converToRowList(Map<Integer, RowCalEntity> rowMap) {
        ArrayList<WordNode> rowNodeList = new ArrayList<WordNode>(rowMap.size());
        for (int i = 0; i < rowMap.size(); ++i) {
            RowCalEntity rowCalEntity = rowMap.get(i);
            if (rowCalEntity == null) continue;
            rowCalEntity.rowNode.setChilds(WordNodeHelper.convertToChild(rowCalEntity.cells));
            rowNodeList.add(rowCalEntity.rowNode);
        }
        return rowNodeList;
    }

    private static int nextRowAutoFill(Map<Integer, RowCalEntity> rowMap, int realRowIndex, int realColumnIndex) {
        int nexRow = realRowIndex;
        while (rowMap.containsKey(nexRow)) {
            int rowResult;
            RowCalEntity nextCalEntity = rowMap.get(nexRow);
            ++nexRow;
            if (nextCalEntity == null || (rowResult = WordNodeHelper.getIndexNullItem(nextCalEntity.cells, realColumnIndex)) != -1) break;
            ++realRowIndex;
        }
        return realRowIndex;
    }

    private static RowCalEntity getRow(Map<Integer, RowCalEntity> rowMap, WordTableRowNode rowNode, int realRowIndex, int columnMax) {
        RowCalEntity rowCalEntity = rowMap.get(realRowIndex);
        if (rowCalEntity == null) {
            if (rowNode == null) {
                rowNode = new WordTableRowNode();
                rowNode.setHeight(0.0);
                rowNode.setWidth(0.0);
            }
            rowCalEntity = new RowCalEntity();
            rowCalEntity.cells = new WordTableCellNodeEx[columnMax];
            rowCalEntity.rowNode = rowNode;
            rowMap.put(realRowIndex, rowCalEntity);
        }
        return rowCalEntity;
    }

    private static void createColumnSpan(WordTableCellNodeEx[] realRowNode, WordTableCellNode cellNode, int columnMax, int startColumnIndex, String bing) {
        if (cellNode.getColumnSpan() > 1) {
            for (int i = 1; i < cellNode.getColumnSpan(); ++i) {
                if (startColumnIndex >= columnMax) continue;
                realRowNode[startColumnIndex] = new WordTableCellNodeEx(cellNode, bing);
                ++startColumnIndex;
            }
        }
    }

    private static Tuple<Integer, Integer> getMax(WordTableNode tableNode) {
        int columnMax = 0;
        int rowMax = 0;
        if (tableNode.getChilds().size() > 0) {
            for (int i = 0; i < tableNode.getChilds().size(); ++i) {
                int rowSpan = 1;
                int rowColumn = 0;
                WordTableRowNode rowNode = (WordTableRowNode)tableNode.getChilds().get(i);
                if (rowNode != null && rowNode.getChilds().size() > 0) {
                    for (WordNode cellItem : rowNode.getChilds()) {
                        WordTableCellNode cellNode = (WordTableCellNode)cellItem;
                        if (cellNode == null) continue;
                        rowColumn += cellNode.getColumnSpan();
                    }
                    if (rowColumn > columnMax) {
                        columnMax = rowColumn;
                    }
                    WordTableCellNode cellNode = (WordTableCellNode)rowNode.getChilds().get(0);
                    rowSpan += cellNode.getRowSpan() - 1;
                    i = i + cellNode.getRowSpan() - 1;
                }
                rowMax += rowSpan;
            }
        }
        return new Tuple((Object)columnMax, (Object)rowMax);
    }

    private static int getIndexNullItem(WordTableCellNodeEx[] wordTableCellNodeExes, int startColumnIndex) {
        if (startColumnIndex >= wordTableCellNodeExes.length) {
            return startColumnIndex;
        }
        for (int i = startColumnIndex; i < wordTableCellNodeExes.length; ++i) {
            if (wordTableCellNodeExes[i] != null) continue;
            return i;
        }
        return -1;
    }

    private static List<WordNode> convertToChild(WordTableCellNodeEx[] wordTableCellNodeExes) {
        ArrayList<WordNode> childs = new ArrayList<WordNode>(wordTableCellNodeExes.length);
        for (int i = 0; i < wordTableCellNodeExes.length; ++i) {
            if (wordTableCellNodeExes[i] == null) {
                wordTableCellNodeExes[i] = WordNodeHelper.createDefaultCellNode();
            }
            childs.add(wordTableCellNodeExes[i]);
        }
        return childs;
    }

    public static WordTableCellNodeEx createDefaultCellNode() {
        WordTableCellNode cellNode = new WordTableCellNode();
        WordTableCellBorders headCellBorders = new WordTableCellBorders();
        headCellBorders.getLeft().setType(WordConstants.WordBorderType.None.getType());
        headCellBorders.getRight().setType(WordConstants.WordBorderType.None.getType());
        headCellBorders.getTop().setType(WordConstants.WordBorderType.None.getType());
        headCellBorders.getBottom().setType(WordConstants.WordBorderType.None.getType());
        cellNode.setBorders(headCellBorders);
        WordParagraphNode paragraphNode = new WordParagraphNode();
        paragraphNode.setAlignment(ParagraphAlignment.LEFT);
        cellNode.getChilds().add(paragraphNode);
        WordTextNode textNode = new WordTextNode();
        textNode.setContent("");
        paragraphNode.getChilds().add(textNode);
        return new WordTableCellNodeEx(cellNode, "");
    }

    public static void calWidth(WordTableNode tableNode) {
        WordTableCellNodeEx cellNode;
        int cellIndex;
        WordTableRowNode rowNode;
        HashMap<Integer, Double> cellWidthMap = new HashMap<Integer, Double>(2);
        block0: for (WordNode rowNodeItem : tableNode.getChilds()) {
            rowNode = (WordTableRowNode)rowNodeItem;
            if (rowNode == null) continue;
            cellIndex = 0;
            for (WordNode cellNodeItem : rowNode.getChilds()) {
                if (!(cellNodeItem instanceof WordTableCellNodeEx) || (cellNode = (WordTableCellNodeEx)cellNodeItem) == null) continue;
                if (cellWidthMap.size() == rowNode.getChilds().size()) continue block0;
                if (cellNode.getSource().getColumnSpan() == 1) {
                    cellWidthMap.put(cellIndex, cellNode.getSource().getWidth());
                }
                ++cellIndex;
            }
        }
        for (WordNode rowNodeItem : tableNode.getChilds()) {
            rowNode = (WordTableRowNode)rowNodeItem;
            if (rowNode == null) continue;
            cellIndex = 0;
            for (WordNode cellNodeItem : rowNode.getChilds()) {
                cellNode = (WordTableCellNodeEx)cellNodeItem;
                if (cellNode == null) continue;
                if (!cellNode.getBing().contains("Middle")) {
                    double width = 0.0;
                    boolean isCalSuccess = true;
                    for (int i = 0; i < cellNode.getSource().getColumnSpan(); ++i) {
                        if (!cellWidthMap.containsKey(cellIndex + i)) {
                            isCalSuccess = false;
                            break;
                        }
                        width += ((Double)cellWidthMap.get(cellIndex + i)).doubleValue();
                    }
                    if (isCalSuccess) {
                        cellNode.getSource().setWidth(width);
                    }
                }
                ++cellIndex;
            }
        }
    }

    public static String getNodeValue(Node node, String nodeName) {
        for (int i = 0; i < node.getAttributes().getLength(); ++i) {
            if (!node.getAttributes().item(i).getNodeName().equalsIgnoreCase(nodeName)) continue;
            return node.getAttributes().item(i).getNodeValue();
        }
        return "";
    }

    private static class RowCalEntity {
        public WordTableCellNodeEx[] cells;
        public WordTableRowNode rowNode;

        private RowCalEntity() {
        }
    }
}

