/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.word.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import kd.bos.util.StringUtils;
import kd.epm.far.business.fidm.word.base.WordConstants;
import kd.epm.far.business.fidm.word.dto.WordImageNode;
import kd.epm.far.business.fidm.word.dto.WordModuleNode;
import kd.epm.far.business.fidm.word.dto.WordNode;
import kd.epm.far.business.fidm.word.dto.WordPageBreakNode;
import kd.epm.far.business.fidm.word.dto.WordParagraphNode;
import kd.epm.far.business.fidm.word.dto.WordRootNode;
import kd.epm.far.business.fidm.word.dto.WordTableCellNode;
import kd.epm.far.business.fidm.word.dto.WordTableNode;
import kd.epm.far.business.fidm.word.dto.WordTableRowNode;
import kd.epm.far.business.fidm.word.dto.WordTextNode;
import kd.epm.far.business.fidm.word.dto.WordTocNode;

public class WordNodeJsonHelper {
    public static <T> T parseObject(String text) {
        if (StringUtils.isEmpty((String)text)) {
            return null;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)text);
        WordNode wordNode = WordNodeJsonHelper.convertToEntity(jsonObject);
        if (wordNode == null) {
            return null;
        }
        WordNode valEx = wordNode;
        return (T)valEx;
    }

    public static <T> T copy(WordNode source) {
        return WordNodeJsonHelper.parseObject(JSON.toJSONString((Object)source));
    }

    public static <T> T copyEx(Object source, Class<T> tClass) {
        if (source == null) {
            return null;
        }
        return (T)JSONObject.parseObject((String)JSON.toJSONString((Object)source), tClass);
    }

    public static WordNode convertToEntity(JSONObject jsonObject) {
        WordNode wordNode = null;
        if (jsonObject == null) {
            return wordNode;
        }
        int type = jsonObject.getInteger("type");
        Class<WordNode> wordNodeType = WordNode.class;
        if (WordConstants.WordNodeType.Root.getType() == type) {
            wordNodeType = WordRootNode.class;
        } else if (WordConstants.WordNodeType.Paragraph.getType() == type) {
            wordNodeType = WordParagraphNode.class;
        } else if (WordConstants.WordNodeType.Text.getType() == type) {
            wordNodeType = WordTextNode.class;
        } else if (WordConstants.WordNodeType.Image.getType() == type) {
            wordNodeType = WordImageNode.class;
        } else if (WordConstants.WordNodeType.Table.getType() == type) {
            wordNodeType = WordTableNode.class;
        } else if (WordConstants.WordNodeType.TableRow.getType() == type) {
            wordNodeType = WordTableRowNode.class;
        } else if (WordConstants.WordNodeType.TableCell.getType() == type) {
            wordNodeType = WordTableCellNode.class;
        } else if (WordConstants.WordNodeType.PageBreak.getType() == type) {
            wordNodeType = WordPageBreakNode.class;
        } else if (WordConstants.WordNodeType.Module.getType() == type) {
            wordNodeType = WordModuleNode.class;
        } else if (WordConstants.WordNodeType.Toc.getType() == type) {
            wordNodeType = WordTocNode.class;
        }
        wordNode = (WordNode)jsonObject.toJavaObject(wordNodeType);
        wordNode.getChilds().clear();
        JSONArray array = jsonObject.getJSONArray("childs");
        if (array != null) {
            for (Object childObject : array) {
                WordNode childNode;
                JSONObject child = (JSONObject)childObject;
                if (child == null || (childNode = WordNodeJsonHelper.convertToEntity(child)) == null) continue;
                wordNode.getChilds().add(childNode);
            }
        }
        return wordNode;
    }
}

