/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.word.helper;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;

public class WordNodeTextHelper {
    public static String getText(Object node) {
        String content = null;
        if (node instanceof XWPFTableCell) {
            XWPFTableCell cell = (XWPFTableCell)node;
            content = cell.getText();
        } else if (node instanceof XWPFParagraph) {
            XWPFParagraph paragraph = (XWPFParagraph)node;
            content = paragraph.getText();
        } else if (node instanceof XWPFRun) {
            XWPFRun run = (XWPFRun)node;
            content = run.getText(0);
        }
        return content;
    }

    public static void setText(Object node, String text) {
        if (node instanceof XWPFTableCell) {
            XWPFTableCell cell = (XWPFTableCell)node;
            cell.setText(text);
        } else if (node instanceof XWPFParagraph) {
            XWPFParagraph paragraph = (XWPFParagraph)node;
            XWPFRun xwpfRun = paragraph.getRuns().size() == 0 ? paragraph.createRun() : (XWPFRun)paragraph.getRuns().get(0);
            xwpfRun.setText(text, 0);
            while (paragraph.getRuns().size() > 1) {
                paragraph.removeRun(paragraph.getRuns().size() - 1);
            }
        } else if (node instanceof XWPFRun) {
            XWPFRun run = (XWPFRun)node;
            run.setText(text, 0);
        }
    }

    public static List children(Object node) {
        List list = new ArrayList(1);
        if (node instanceof XWPFTableCell) {
            XWPFTableCell cell = (XWPFTableCell)node;
            list = cell.getParagraphs();
        } else if (node instanceof XWPFParagraph) {
            XWPFParagraph paragraph = (XWPFParagraph)node;
            list = paragraph.getRuns();
        }
        return list;
    }

    public static void removeRun(XWPFRun run) {
        if (run == null) {
            return;
        }
        if (run.getParagraph() == null) {
            return;
        }
        int index = run.getParagraph().getRuns().indexOf(run);
        if (index >= 0) {
            run.getParagraph().removeRun(index);
        }
    }
}

