/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.word.helper;

import com.deepoove.poi.xwpf.NiceXWPFDocument;
import java.util.List;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFComment;
import org.apache.poi.xwpf.usermodel.XWPFFooter;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.officeDocument.x2006.sharedTypes.STVerticalAlignRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;

public class WordRepairHelper {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(WordRepairHelper.class);

    public static void repair(NiceXWPFDocument newDoc) {
        if (newDoc == null) {
            return;
        }
        if (newDoc.getHeaderFooterPolicy() != null) {
            XWPFFooter footer;
            XWPFComment[] header = newDoc.getHeaderFooterPolicy().getDefaultHeader();
            if (header != null) {
                WordRepairHelper.repair(header.getBodyElements());
            }
            if ((footer = newDoc.getHeaderFooterPolicy().getDefaultFooter()) != null) {
                WordRepairHelper.repair(footer.getBodyElements());
            }
        }
        try {
            for (XWPFComment comment : newDoc.getComments()) {
                if (comment == null) continue;
                WordRepairHelper.repair(comment.getBodyElements());
            }
        }
        catch (Exception ex) {
            logger.error("dm repair word fail", (Throwable)ex);
        }
        WordRepairHelper.repair(newDoc.getBodyElements());
    }

    public static void repair(List<IBodyElement> bodyElements) {
        if (bodyElements == null) {
            return;
        }
        for (IBodyElement bodyElement : bodyElements) {
            if (bodyElement instanceof XWPFParagraph) {
                WordRepairHelper.repairParagraph((XWPFParagraph)bodyElement);
                continue;
            }
            if (!(bodyElement instanceof XWPFTable)) continue;
            WordRepairHelper.repairTable((XWPFTable)bodyElement);
        }
    }

    public static void repairTable(XWPFTable table) {
        if (table == null) {
            return;
        }
        for (XWPFTableRow row : table.getRows()) {
            if (row == null) continue;
            for (XWPFTableCell cell : row.getTableCells()) {
                if (cell == null) continue;
                for (XWPFParagraph paragraph : cell.getParagraphs()) {
                    WordRepairHelper.repairParagraph(paragraph);
                }
            }
        }
    }

    public static void repairParagraph(XWPFParagraph xwpfParagraph) {
        if (xwpfParagraph == null) {
            return;
        }
        for (XWPFRun run : xwpfParagraph.getRuns()) {
            WordRepairHelper.repairRun(run);
        }
    }

    public static void repairRun(XWPFRun run) {
        if (run == null) {
            return;
        }
        if (run.getCTR() == null) {
            return;
        }
        CTRPr ctrPr = run.getCTR().getRPr();
        if (ctrPr == null) {
            return;
        }
        for (int i = 0; i < ctrPr.getVertAlignArray().length; ++i) {
            if (ctrPr.getVertAlignArray(i).getVal() != null) continue;
            ctrPr.getVertAlignArray(i).setVal(STVerticalAlignRun.Enum.forString((String)"baseline"));
        }
    }
}

