/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.word.helper;

import java.util.ArrayList;
import java.util.List;
import kd.epm.far.business.fidm.word.base.WordConstants;
import kd.epm.far.business.fidm.word.dto.WordNode;
import kd.epm.far.business.fidm.word.dto.WordRootNode;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;

public class WordRootHelper {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(WordRootHelper.class);

    public static WordRootNode find(List<WordRootNode> rootNodes, WordConstants.WordContentType contentType) {
        return rootNodes.stream().filter(m -> m.getContentType() == contentType.getType()).findFirst().orElse(null);
    }

    public static List<WordRootNode> combine(WordRootNode content, WordRootNode head, WordRootNode foot) {
        ArrayList<WordRootNode> rootNodes = new ArrayList<WordRootNode>(3);
        if (content == null) {
            return rootNodes;
        }
        rootNodes.add(content);
        if (head != null) {
            rootNodes.add(head);
        }
        if (foot != null) {
            rootNodes.add(foot);
        }
        return rootNodes;
    }

    public static WordRootNode append(WordRootNode first, WordRootNode second) {
        if (first == null && second == null) {
            return null;
        }
        if (first == null && second != null) {
            return second;
        }
        if (first != null && second == null) {
            return first;
        }
        for (WordNode wordNode : second.getChilds()) {
            first.getChilds().add(wordNode);
        }
        return first;
    }
}

