/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.word.helper;

import java.math.BigInteger;
import kd.epm.far.business.fidm.word.base.WordConstants;
import kd.epm.far.common.common.log.BcmLogFactory;
import kd.epm.far.common.common.log.WatchLogger;
import org.apache.poi.xwpf.usermodel.XWPFAbstractNum;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFNumbering;
import org.apache.poi.xwpf.usermodel.XWPFStyle;
import org.apache.poi.xwpf.usermodel.XWPFStyles;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTAbstractNum;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDecimalNumber;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFonts;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHpsMeasure;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTLanguage;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPrGeneral;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTString;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyle;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblBorders;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblCellMar;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPrBase;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STStyleType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTblWidth;

public class WordStyleHelper {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(WordStyleHelper.class);

    public static void initCustomStyle(XWPFDocument document, int max) {
        WordStyleHelper.addDefaultCustomHeadingStyle(document);
        WordStyleHelper.addCustomHeadingStyle(document);
        WordStyleHelper.addDefaultCustomTableStyle(document);
        WordStyleHelper.addListStyle(document);
    }

    public static BigInteger addOrderListStyle(XWPFDocument document, BigInteger abstractId) {
        String styleMaybe = "<xml-fragment w15:restartNumberingAfterBreak=\"0\" xmlns:wpc=\"http://schemas.microsoft.com/office/word/2010/wordprocessingCanvas\" xmlns:cx=\"http://schemas.microsoft.com/office/drawing/2014/chartex\" xmlns:mc=\"http://schemas.openxmlformats.org/markup-compatibility/2006\" xmlns:o=\"urn:schemas-microsoft-com:office:office\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xmlns:m=\"http://schemas.openxmlformats.org/officeDocument/2006/math\" xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:wp14=\"http://schemas.microsoft.com/office/word/2010/wordprocessingDrawing\" xmlns:wp=\"http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing\" xmlns:w10=\"urn:schemas-microsoft-com:office:word\" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\" xmlns:w14=\"http://schemas.microsoft.com/office/word/2010/wordml\" xmlns:w15=\"http://schemas.microsoft.com/office/word/2012/wordml\" xmlns:w16se=\"http://schemas.microsoft.com/office/word/2015/wordml/symex\" xmlns:wpg=\"http://schemas.microsoft.com/office/word/2010/wordprocessingGroup\" xmlns:wpi=\"http://schemas.microsoft.com/office/word/2010/wordprocessingInk\" xmlns:wne=\"http://schemas.microsoft.com/office/word/2006/wordml\" xmlns:wps=\"http://schemas.microsoft.com/office/word/2010/wordprocessingShape\">\n  <w:multiLevelType w:val=\"hybridMultilevel\"/>\n  <w:lvl w:ilvl=\"0\" w:tplc=\"0409000F\">\n    <w:start w:val=\"1\"/>\n    <w:numFmt w:val=\"decimal\"/>\n    <w:lvlText w:val=\"%1.\"/>\n    <w:lvlJc w:val=\"left\"/>\n    <w:pPr>\n      <w:ind w:left=\"420\" w:hanging=\"420\"/>\n    </w:pPr>\n  </w:lvl>\n  <w:lvl w:ilvl=\"1\" w:tplc=\"04090019\" w:tentative=\"1\">\n    <w:start w:val=\"1\"/>\n    <w:numFmt w:val=\"lowerLetter\"/>\n    <w:lvlText w:val=\"%2)\"/>\n    <w:lvlJc w:val=\"left\"/>\n    <w:pPr>\n      <w:ind w:left=\"840\" w:hanging=\"420\"/>\n    </w:pPr>\n  </w:lvl>\n  <w:lvl w:ilvl=\"2\" w:tplc=\"0409001B\" w:tentative=\"1\">\n    <w:start w:val=\"1\"/>\n    <w:numFmt w:val=\"lowerRoman\"/>\n    <w:lvlText w:val=\"%3.\"/>\n    <w:lvlJc w:val=\"right\"/>\n    <w:pPr>\n      <w:ind w:left=\"1260\" w:hanging=\"420\"/>\n    </w:pPr>\n  </w:lvl>\n  <w:lvl w:ilvl=\"3\" w:tplc=\"0409000F\" w:tentative=\"1\">\n    <w:start w:val=\"1\"/>\n    <w:numFmt w:val=\"decimal\"/>\n    <w:lvlText w:val=\"%4.\"/>\n    <w:lvlJc w:val=\"left\"/>\n    <w:pPr>\n      <w:ind w:left=\"1680\" w:hanging=\"420\"/>\n    </w:pPr>\n  </w:lvl>\n  <w:lvl w:ilvl=\"4\" w:tplc=\"04090019\" w:tentative=\"1\">\n    <w:start w:val=\"1\"/>\n    <w:numFmt w:val=\"lowerLetter\"/>\n    <w:lvlText w:val=\"%5)\"/>\n    <w:lvlJc w:val=\"left\"/>\n    <w:pPr>\n      <w:ind w:left=\"2100\" w:hanging=\"420\"/>\n    </w:pPr>\n  </w:lvl>\n  <w:lvl w:ilvl=\"5\" w:tplc=\"0409001B\" w:tentative=\"1\">\n    <w:start w:val=\"1\"/>\n    <w:numFmt w:val=\"lowerRoman\"/>\n    <w:lvlText w:val=\"%6.\"/>\n    <w:lvlJc w:val=\"right\"/>\n    <w:pPr>\n      <w:ind w:left=\"2520\" w:hanging=\"420\"/>\n    </w:pPr>\n  </w:lvl>\n  <w:lvl w:ilvl=\"6\" w:tplc=\"0409000F\" w:tentative=\"1\">\n    <w:start w:val=\"1\"/>\n    <w:numFmt w:val=\"decimal\"/>\n    <w:lvlText w:val=\"%7.\"/>\n    <w:lvlJc w:val=\"left\"/>\n    <w:pPr>\n      <w:ind w:left=\"2940\" w:hanging=\"420\"/>\n    </w:pPr>\n  </w:lvl>\n  <w:lvl w:ilvl=\"7\" w:tplc=\"04090019\" w:tentative=\"1\">\n    <w:start w:val=\"1\"/>\n    <w:numFmt w:val=\"lowerLetter\"/>\n    <w:lvlText w:val=\"%8)\"/>\n    <w:lvlJc w:val=\"left\"/>\n    <w:pPr>\n      <w:ind w:left=\"3360\" w:hanging=\"420\"/>\n    </w:pPr>\n  </w:lvl>\n  <w:lvl w:ilvl=\"8\" w:tplc=\"0409001B\" w:tentative=\"1\">\n    <w:start w:val=\"1\"/>\n    <w:numFmt w:val=\"lowerRoman\"/>\n    <w:lvlText w:val=\"%9.\"/>\n    <w:lvlJc w:val=\"right\"/>\n    <w:pPr>\n      <w:ind w:left=\"3780\" w:hanging=\"420\"/>\n    </w:pPr>\n  </w:lvl>\n</xml-fragment>";
        try {
            XWPFNumbering numbering = document.createNumbering();
            CTAbstractNum abstractNum = (CTAbstractNum)CTAbstractNum.Factory.parse(styleMaybe);
            abstractNum.setAbstractNumId(abstractId);
            XWPFAbstractNum abs = new XWPFAbstractNum(abstractNum, numbering);
            BigInteger id = numbering.addAbstractNum(abs);
            BigInteger realId = document.getNumbering().addNum(id);
            return realId;
        }
        catch (Exception ex) {
            return BigInteger.valueOf(0L);
        }
    }

    private static void addListStyle(XWPFDocument document) {
        String styleMaybe = "<xml-fragment w:abstractNumId=\"1\" w15:restartNumberingAfterBreak=\"0\" xmlns:wpc=\"http://schemas.microsoft.com/office/word/2010/wordprocessingCanvas\" xmlns:cx=\"http://schemas.microsoft.com/office/drawing/2014/chartex\" xmlns:cx1=\"http://schemas.microsoft.com/office/drawing/2015/9/8/chartex\" xmlns:cx2=\"http://schemas.microsoft.com/office/drawing/2015/10/21/chartex\" xmlns:cx3=\"http://schemas.microsoft.com/office/drawing/2016/5/9/chartex\" xmlns:cx4=\"http://schemas.microsoft.com/office/drawing/2016/5/10/chartex\" xmlns:cx5=\"http://schemas.microsoft.com/office/drawing/2016/5/11/chartex\" xmlns:cx6=\"http://schemas.microsoft.com/office/drawing/2016/5/12/chartex\" xmlns:cx7=\"http://schemas.microsoft.com/office/drawing/2016/5/13/chartex\" xmlns:cx8=\"http://schemas.microsoft.com/office/drawing/2016/5/14/chartex\" xmlns:mc=\"http://schemas.openxmlformats.org/markup-compatibility/2006\" xmlns:aink=\"http://schemas.microsoft.com/office/drawing/2016/ink\" xmlns:am3d=\"http://schemas.microsoft.com/office/drawing/2017/model3d\" xmlns:o=\"urn:schemas-microsoft-com:office:office\" xmlns:oel=\"http://schemas.microsoft.com/office/2019/extlst\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\" xmlns:m=\"http://schemas.openxmlformats.org/officeDocument/2006/math\" xmlns:v=\"urn:schemas-microsoft-com:vml\" xmlns:wp14=\"http://schemas.microsoft.com/office/word/2010/wordprocessingDrawing\" xmlns:wp=\"http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing\" xmlns:w10=\"urn:schemas-microsoft-com:office:word\" xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\" xmlns:w14=\"http://schemas.microsoft.com/office/word/2010/wordml\" xmlns:w15=\"http://schemas.microsoft.com/office/word/2012/wordml\" xmlns:w16cex=\"http://schemas.microsoft.com/office/word/2018/wordml/cex\" xmlns:w16cid=\"http://schemas.microsoft.com/office/word/2016/wordml/cid\" xmlns:w16=\"http://schemas.microsoft.com/office/word/2018/wordml\" xmlns:w16sdtdh=\"http://schemas.microsoft.com/office/word/2020/wordml/sdtdatahash\" xmlns:w16se=\"http://schemas.microsoft.com/office/word/2015/wordml/symex\" xmlns:wpg=\"http://schemas.microsoft.com/office/word/2010/wordprocessingGroup\" xmlns:wpi=\"http://schemas.microsoft.com/office/word/2010/wordprocessingInk\" xmlns:wne=\"http://schemas.microsoft.com/office/word/2006/wordml\" xmlns:wps=\"http://schemas.microsoft.com/office/word/2010/wordprocessingShape\">\n  <w:nsid w:val=\"35FD7B0F\"/>\n  <w:multiLevelType w:val=\"hybridMultilevel\"/>\n  <w:tmpl w:val=\"A4D4F8D2\"/>\n  <w:lvl w:ilvl=\"0\" w:tplc=\"04090001\">\n    <w:start w:val=\"1\"/>\n    <w:numFmt w:val=\"bullet\"/>\n    <w:lvlText w:val=\"\uf06c\"/>\n    <w:lvlJc w:val=\"left\"/>\n    <w:pPr>\n      <w:ind w:left=\"440\" w:hanging=\"440\"/>\n    </w:pPr>\n    <w:rPr>\n      <w:rFonts w:ascii=\"Wingdings\" w:hAnsi=\"Wingdings\" w:hint=\"default\"/>\n    </w:rPr>\n  </w:lvl>\n  <w:lvl w:ilvl=\"1\" w:tplc=\"04090003\" w:tentative=\"1\">\n    <w:start w:val=\"1\"/>\n    <w:numFmt w:val=\"bullet\"/>\n    <w:lvlText w:val=\"\uf06e\"/>\n    <w:lvlJc w:val=\"left\"/>\n    <w:pPr>\n      <w:ind w:left=\"880\" w:hanging=\"440\"/>\n    </w:pPr>\n    <w:rPr>\n      <w:rFonts w:ascii=\"Wingdings\" w:hAnsi=\"Wingdings\" w:hint=\"default\"/>\n    </w:rPr>\n  </w:lvl>\n  <w:lvl w:ilvl=\"2\" w:tplc=\"04090005\" w:tentative=\"1\">\n    <w:start w:val=\"1\"/>\n    <w:numFmt w:val=\"bullet\"/>\n    <w:lvlText w:val=\"\uf075\"/>\n    <w:lvlJc w:val=\"left\"/>\n    <w:pPr>\n      <w:ind w:left=\"1320\" w:hanging=\"440\"/>\n    </w:pPr>\n    <w:rPr>\n      <w:rFonts w:ascii=\"Wingdings\" w:hAnsi=\"Wingdings\" w:hint=\"default\"/>\n    </w:rPr>\n  </w:lvl>\n  <w:lvl w:ilvl=\"3\" w:tplc=\"04090001\" w:tentative=\"1\">\n    <w:start w:val=\"1\"/>\n    <w:numFmt w:val=\"bullet\"/>\n    <w:lvlText w:val=\"\uf06c\"/>\n    <w:lvlJc w:val=\"left\"/>\n    <w:pPr>\n      <w:ind w:left=\"1760\" w:hanging=\"440\"/>\n    </w:pPr>\n    <w:rPr>\n      <w:rFonts w:ascii=\"Wingdings\" w:hAnsi=\"Wingdings\" w:hint=\"default\"/>\n    </w:rPr>\n  </w:lvl>\n  <w:lvl w:ilvl=\"4\" w:tplc=\"04090003\" w:tentative=\"1\">\n    <w:start w:val=\"1\"/>\n    <w:numFmt w:val=\"bullet\"/>\n    <w:lvlText w:val=\"\uf06e\"/>\n    <w:lvlJc w:val=\"left\"/>\n    <w:pPr>\n      <w:ind w:left=\"2200\" w:hanging=\"440\"/>\n    </w:pPr>\n    <w:rPr>\n      <w:rFonts w:ascii=\"Wingdings\" w:hAnsi=\"Wingdings\" w:hint=\"default\"/>\n    </w:rPr>\n  </w:lvl>\n  <w:lvl w:ilvl=\"5\" w:tplc=\"04090005\" w:tentative=\"1\">\n    <w:start w:val=\"1\"/>\n    <w:numFmt w:val=\"bullet\"/>\n    <w:lvlText w:val=\"\uf075\"/>\n    <w:lvlJc w:val=\"left\"/>\n    <w:pPr>\n      <w:ind w:left=\"2640\" w:hanging=\"440\"/>\n    </w:pPr>\n    <w:rPr>\n      <w:rFonts w:ascii=\"Wingdings\" w:hAnsi=\"Wingdings\" w:hint=\"default\"/>\n    </w:rPr>\n  </w:lvl>\n  <w:lvl w:ilvl=\"6\" w:tplc=\"04090001\" w:tentative=\"1\">\n    <w:start w:val=\"1\"/>\n    <w:numFmt w:val=\"bullet\"/>\n    <w:lvlText w:val=\"\uf06c\"/>\n    <w:lvlJc w:val=\"left\"/>\n    <w:pPr>\n      <w:ind w:left=\"3080\" w:hanging=\"440\"/>\n    </w:pPr>\n    <w:rPr>\n      <w:rFonts w:ascii=\"Wingdings\" w:hAnsi=\"Wingdings\" w:hint=\"default\"/>\n    </w:rPr>\n  </w:lvl>\n  <w:lvl w:ilvl=\"7\" w:tplc=\"04090003\" w:tentative=\"1\">\n    <w:start w:val=\"1\"/>\n    <w:numFmt w:val=\"bullet\"/>\n    <w:lvlText w:val=\"\uf06e\"/>\n    <w:lvlJc w:val=\"left\"/>\n    <w:pPr>\n      <w:ind w:left=\"3520\" w:hanging=\"440\"/>\n    </w:pPr>\n    <w:rPr>\n      <w:rFonts w:ascii=\"Wingdings\" w:hAnsi=\"Wingdings\" w:hint=\"default\"/>\n    </w:rPr>\n  </w:lvl>\n  <w:lvl w:ilvl=\"8\" w:tplc=\"04090005\" w:tentative=\"1\">\n    <w:start w:val=\"1\"/>\n    <w:numFmt w:val=\"bullet\"/>\n    <w:lvlText w:val=\"\uf075\"/>\n    <w:lvlJc w:val=\"left\"/>\n    <w:pPr>\n      <w:ind w:left=\"3960\" w:hanging=\"440\"/>\n    </w:pPr>\n    <w:rPr>\n      <w:rFonts w:ascii=\"Wingdings\" w:hAnsi=\"Wingdings\" w:hint=\"default\"/>\n    </w:rPr>\n  </w:lvl>\n</xml-fragment>";
        try {
            XWPFNumbering numbering = document.createNumbering();
            CTAbstractNum abstractNum = (CTAbstractNum)CTAbstractNum.Factory.parse(styleMaybe);
            XWPFAbstractNum abs = new XWPFAbstractNum(abstractNum, numbering);
            BigInteger id = BigInteger.valueOf(0L);
            abs.getAbstractNum().setAbstractNumId(id);
            id = numbering.addAbstractNum(abs);
            document.getNumbering().addNum(id);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void addDefaultCustomHeadingStyle(XWPFDocument document) {
        CTStyle ctStyle = (CTStyle)CTStyle.Factory.newInstance();
        ctStyle.setStyleId("1");
        ctStyle.setDefault((Object)"1");
        ctStyle.setType(STStyleType.Enum.forString((String)"paragraph"));
        CTString styleName = (CTString)CTString.Factory.newInstance();
        styleName.setVal("Normal");
        ctStyle.setName(styleName);
        CTOnOff onoffnull = (CTOnOff)CTOnOff.Factory.newInstance();
        ctStyle.setUnhideWhenUsed(onoffnull);
        ctStyle.setQFormat(onoffnull);
        CTPPrGeneral ppr = (CTPPrGeneral)CTPPrGeneral.Factory.newInstance();
        CTOnOff keepNext = (CTOnOff)CTOnOff.Factory.newInstance();
        ppr.setKeepNext(keepNext);
        CTOnOff widowControl = (CTOnOff)CTOnOff.Factory.newInstance();
        widowControl.setVal((Object)"0");
        ppr.setWidowControl(widowControl);
        CTJc jc = (CTJc)CTJc.Factory.newInstance();
        jc.setVal(STJc.Enum.forString((String)"both"));
        ppr.setJc(jc);
        ctStyle.setPPr(ppr);
        CTRPr ctrPr = (CTRPr)CTRPr.Factory.newInstance();
        CTFonts ctFont = (CTFonts)CTFonts.Factory.newInstance();
        ctFont.setAscii(WordConstants.SimsunFont);
        ctFont.setHAnsi(WordConstants.SimsunFont);
        ctFont.setEastAsia(WordConstants.SimsunFont);
        ctFont.setCs(WordConstants.SimsunFont);
        CTFonts[] ctFonts = new CTFonts[]{ctFont};
        ctrPr.setRFontsArray(ctFonts);
        CTHpsMeasure kern = (CTHpsMeasure)CTHpsMeasure.Factory.newInstance();
        kern.setVal((Object)"2");
        CTHpsMeasure[] kerns = new CTHpsMeasure[]{kern};
        ctrPr.setKernArray(kerns);
        CTHpsMeasure sz = (CTHpsMeasure)CTHpsMeasure.Factory.newInstance();
        sz.setVal((Object)"21");
        CTHpsMeasure[] szs = new CTHpsMeasure[]{sz};
        ctrPr.setSzArray(szs);
        CTHpsMeasure szcs = (CTHpsMeasure)CTHpsMeasure.Factory.newInstance();
        szcs.setVal((Object)"24");
        CTHpsMeasure[] szcss = new CTHpsMeasure[]{szcs};
        ctrPr.setSzCsArray(szcss);
        CTLanguage language = (CTLanguage)CTLanguage.Factory.newInstance();
        language.setVal("en-US");
        language.setEastAsia("zh-CN");
        language.setBidi("ar-SA");
        CTLanguage[] languages = new CTLanguage[]{language};
        ctrPr.setLangArray(languages);
        ctStyle.setRPr(ctrPr);
        XWPFStyle style = new XWPFStyle(ctStyle);
        XWPFStyles styles = document.createStyles();
        style.setType(STStyleType.PARAGRAPH);
        styles.addStyle(style);
    }

    private static void addCustomHeadingStyle(XWPFDocument document) {
        try {
            WordStyleHelper.addCustomHeadingStyle1(document);
            WordStyleHelper.addCustomHeadingStyle2(document);
            WordStyleHelper.addCustomHeadingStyle3(document);
            WordStyleHelper.addCustomHeadingStyle4(document);
            WordStyleHelper.addCustomHeadingStyle5(document);
            WordStyleHelper.addCustomHeadingStyle6(document);
        }
        catch (Exception ex) {
            logger.error("dm wordstyle addCustomHeadingStyle error:", (Throwable)ex);
        }
    }

    private static void addCustomHeadingStyle1(XWPFDocument document) throws XmlException {
        CTStyle ctStyle = (CTStyle)CTStyle.Factory.parse("<xml-fragment main:type=\"paragraph\" xmlns:main=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\">\n\t<main:name main:val=\"heading 1\"/>\n\t<main:basedOn main:val=\"1\"/>\n\t<main:next main:val=\"1\"/>\n\t<main:unhideWhenUsed/>\n\t<main:qFormat/>\n\t<main:pPr>\n\t\t<main:keepNext/>\n\t\t<main:keepLines/>\n\t\t<main:spacing main:before=\"340\" main:beforeLines=\"0\" \n\t\t\t\t\t  main:beforeAutospacing=\"0\" main:after=\"330\" main:afterLines=\"0\" \n\t\t\t\t\t  main:afterAutospacing=\"0\" main:line=\"578\" main:lineRule=\"auto\"/>\n\t\t<main:outlineLvl main:val=\"0\"/>\n\t</main:pPr>\n\t<main:rPr>\n\t\t<main:b/>\n\t\t<main:sz main:val=\"44\"/>\n\t\t<main:sz main:val=\"44\"/>\n\t\t<main:sz main:val=\"44\"/>\n\t</main:rPr>\n</xml-fragment>");
        ctStyle.setStyleId("2");
        XWPFStyle style = new XWPFStyle(ctStyle);
        XWPFStyles styles = document.createStyles();
        style.setType(STStyleType.PARAGRAPH);
        styles.addStyle(style);
    }

    private static void addCustomHeadingStyle2(XWPFDocument document) throws XmlException {
        CTStyle ctStyle = (CTStyle)CTStyle.Factory.parse("<xml-fragment main:type=\"paragraph\" xmlns:main=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\">\n\t<main:name main:val=\"heading 2\"/>\n\t<main:basedOn main:val=\"a\"/>\n\t<main:next main:val=\"a\"/>\n\t<main:link main:val=\"2Char\"/>\n\t<main:uiPriority main:val=\"9\"/>\n\t<main:unhideWhenUsed/>\n\t<main:qFormat/>\n\t<main:rsid main:val=\"00D410FD\"/>\n\t<main:pPr>\n\t\t<main:keepNext/>\n\t\t<main:keepLines/>\n\t\t<main:spacing main:before=\"260\" main:after=\"260\" main:line=\"416\" main:lineRule=\"auto\"/>\n\t\t<main:outlineLvl main:val=\"1\"/>\n\t</main:pPr>\n\t<main:rPr>\n\t\t<main:rFonts main:asciiTheme=\"majorHAnsi\" main:eastAsiaTheme=\"majorEastAsia\" main:hAnsiTheme=\"majorHAnsi\" main:cstheme=\"majorBidi\"/>\n\t\t<main:b/>\n\t\t<main:bCs/>\n\t\t<main:sz main:val=\"32\"/>\n\t\t<main:szCs main:val=\"32\"/>\n\t</main:rPr>\n</xml-fragment>");
        ctStyle.setStyleId("3");
        XWPFStyle style = new XWPFStyle(ctStyle);
        XWPFStyles styles = document.createStyles();
        style.setType(STStyleType.PARAGRAPH);
        styles.addStyle(style);
    }

    private static void addCustomHeadingStyle3(XWPFDocument document) throws XmlException {
        CTStyle ctStyle = (CTStyle)CTStyle.Factory.parse("<xml-fragment main:type=\"paragraph\" xmlns:main=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\">\n\t<main:name main:val=\"heading 3\"/>\n\t<main:basedOn main:val=\"a\"/>\n\t<main:next main:val=\"a\"/>\n\t<main:link main:val=\"3Char\"/>\n\t<main:uiPriority main:val=\"9\"/>\n\t<main:unhideWhenUsed/>\n\t<main:qFormat/>\n\t<main:rsid main:val=\"00D410FD\"/>\n\t<main:pPr>\n\t\t<main:keepNext/>\n\t\t<main:keepLines/>\n\t\t<main:spacing main:before=\"260\" main:after=\"260\" main:line=\"416\" main:lineRule=\"auto\"/>\n\t\t<main:outlineLvl main:val=\"2\"/>\n\t</main:pPr>\n\t<main:rPr>\n\t\t<main:b/>\n\t\t<main:bCs/>\n\t\t<main:sz main:val=\"32\"/>\n\t\t<main:szCs main:val=\"32\"/>\n\t</main:rPr>\n</xml-fragment>");
        ctStyle.setStyleId("4");
        XWPFStyle style = new XWPFStyle(ctStyle);
        XWPFStyles styles = document.createStyles();
        style.setType(STStyleType.PARAGRAPH);
        styles.addStyle(style);
    }

    private static void addCustomHeadingStyle4(XWPFDocument document) throws XmlException {
        CTStyle ctStyle = (CTStyle)CTStyle.Factory.parse("<xml-fragment main:type=\"paragraph\" xmlns:main=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\">\n\t<main:name main:val=\"heading 4\"/>\n\t<main:basedOn main:val=\"a\"/>\n\t<main:next main:val=\"a\"/>\n\t<main:link main:val=\"4Char\"/>\n\t<main:uiPriority main:val=\"9\"/>\n\t<main:unhideWhenUsed/>\n\t<main:qFormat/>\n\t<main:rsid main:val=\"00D410FD\"/>\n\t<main:pPr>\n\t\t<main:keepNext/>\n\t\t<main:keepLines/>\n\t\t<main:spacing main:before=\"280\" main:after=\"290\" main:line=\"376\" main:lineRule=\"auto\"/>\n\t\t<main:outlineLvl main:val=\"3\"/>\n\t</main:pPr>\n\t<main:rPr>\n\t\t<main:rFonts main:asciiTheme=\"majorHAnsi\" main:eastAsiaTheme=\"majorEastAsia\" main:hAnsiTheme=\"majorHAnsi\" main:cstheme=\"majorBidi\"/>\n\t\t<main:b/>\n\t\t<main:bCs/>\n\t\t<main:sz main:val=\"28\"/>\n\t\t<main:szCs main:val=\"28\"/>\n\t</main:rPr>\n</xml-fragment>\n");
        ctStyle.setStyleId("5");
        XWPFStyle style = new XWPFStyle(ctStyle);
        XWPFStyles styles = document.createStyles();
        style.setType(STStyleType.PARAGRAPH);
        styles.addStyle(style);
    }

    private static void addCustomHeadingStyle5(XWPFDocument document) throws XmlException {
        CTStyle ctStyle = (CTStyle)CTStyle.Factory.parse("<xml-fragment main:type=\"paragraph\" xmlns:main=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\">\n\t<main:name main:val=\"heading 5\"/>\n\t<main:basedOn main:val=\"a\"/>\n\t<main:next main:val=\"a\"/>\n\t<main:link main:val=\"5Char\"/>\n\t<main:uiPriority main:val=\"9\"/>\n\t<main:unhideWhenUsed/>\n\t<main:qFormat/>\n\t<main:rsid main:val=\"00D410FD\"/>\n\t<main:pPr>\n\t\t<main:keepNext/>\n\t\t<main:keepLines/>\n\t\t<main:spacing main:before=\"280\" main:after=\"290\" main:line=\"376\" main:lineRule=\"auto\"/>\n\t\t<main:outlineLvl main:val=\"4\"/>\n\t</main:pPr>\n\t<main:rPr>\n\t\t<main:b/>\n\t\t<main:bCs/>\n\t\t<main:sz main:val=\"28\"/>\n\t\t<main:szCs main:val=\"28\"/>\n\t</main:rPr>\n</xml-fragment>");
        ctStyle.setStyleId("6");
        XWPFStyle style = new XWPFStyle(ctStyle);
        XWPFStyles styles = document.createStyles();
        style.setType(STStyleType.PARAGRAPH);
        styles.addStyle(style);
    }

    private static void addCustomHeadingStyle6(XWPFDocument document) throws XmlException {
        CTStyle ctStyle = (CTStyle)CTStyle.Factory.parse("<xml-fragment main:type=\"paragraph\" xmlns:main=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\">\n\t<main:name main:val=\"heading 6\"/>\n\t<main:basedOn main:val=\"a\"/>\n\t<main:next main:val=\"a\"/>\n\t<main:link main:val=\"6Char\"/>\n\t<main:uiPriority main:val=\"9\"/>\n\t<main:unhideWhenUsed/>\n\t<main:qFormat/>\n\t<main:rsid main:val=\"00D410FD\"/>\n\t<main:pPr>\n\t\t<main:keepNext/>\n\t\t<main:keepLines/>\n\t\t<main:spacing main:before=\"240\" main:after=\"64\" main:line=\"320\" main:lineRule=\"auto\"/>\n\t\t<main:outlineLvl main:val=\"5\"/>\n\t</main:pPr>\n\t<main:rPr>\n\t\t<main:rFonts main:asciiTheme=\"majorHAnsi\" main:eastAsiaTheme=\"majorEastAsia\" main:hAnsiTheme=\"majorHAnsi\" main:cstheme=\"majorBidi\"/>\n\t\t<main:b/>\n\t\t<main:bCs/>\n\t\t<main:sz main:val=\"24\"/>\n\t\t<main:szCs main:val=\"24\"/>\n\t</main:rPr>\n</xml-fragment>\n ");
        ctStyle.setStyleId("7");
        XWPFStyle style = new XWPFStyle(ctStyle);
        XWPFStyles styles = document.createStyles();
        style.setType(STStyleType.PARAGRAPH);
        styles.addStyle(style);
    }

    private static void addDefaultCustomTableStyle(XWPFDocument document) {
        CTStyle ctStyle = (CTStyle)CTStyle.Factory.newInstance();
        ctStyle.setStyleId("t1");
        ctStyle.setType(STStyleType.Enum.forString((String)"table"));
        CTString styleName = (CTString)CTString.Factory.newInstance();
        styleName.setVal("Table Grid");
        ctStyle.setName(styleName);
        CTDecimalNumber indentNumber = (CTDecimalNumber)CTDecimalNumber.Factory.newInstance();
        indentNumber.setVal(BigInteger.valueOf(0L));
        ctStyle.setUiPriority(indentNumber);
        CTPPrGeneral ctpPrGeneral = (CTPPrGeneral)CTPPrGeneral.Factory.newInstance();
        CTOnOff widowControl = (CTOnOff)CTOnOff.Factory.newInstance();
        widowControl.setVal((Object)"0");
        ctpPrGeneral.setWidowControl(widowControl);
        CTJc ctJc = (CTJc)CTJc.Factory.newInstance();
        ctJc.setVal(STJc.Enum.forString((String)"both"));
        ctpPrGeneral.setJc(ctJc);
        ctStyle.setPPr(ctpPrGeneral);
        CTRPr ctrPr = (CTRPr)CTRPr.Factory.newInstance();
        CTFonts ctFont = (CTFonts)CTFonts.Factory.newInstance();
        ctFont.setEastAsia(WordConstants.SimsunFont);
        CTFonts[] ctFonts = new CTFonts[]{ctFont};
        ctrPr.setRFontsArray(ctFonts);
        ctStyle.setRPr(ctrPr);
        CTTblPrBase ctTblPrBase = (CTTblPrBase)CTTblPrBase.Factory.newInstance();
        CTTblWidth ctTblWidth = (CTTblWidth)CTTblWidth.Factory.newInstance();
        ctTblWidth.setType(STTblWidth.Enum.forInt((int)3));
        ctTblWidth.setW((Object)"108");
        ctTblPrBase.setTblInd(ctTblWidth);
        CTTblBorders ctTblBorders = (CTTblBorders)CTTblBorders.Factory.newInstance();
        CTBorder topCTBorder = (CTBorder)CTBorder.Factory.newInstance();
        topCTBorder.setVal(STBorder.Enum.forString((String)"single"));
        topCTBorder.setSz(BigInteger.valueOf(4L));
        topCTBorder.setSpace(BigInteger.valueOf(0L));
        topCTBorder.setColor((Object)"auto");
        ctTblBorders.setTop(topCTBorder);
        CTBorder leftCTBorder = (CTBorder)CTBorder.Factory.newInstance();
        leftCTBorder.setVal(STBorder.Enum.forString((String)"single"));
        leftCTBorder.setSz(BigInteger.valueOf(4L));
        leftCTBorder.setSpace(BigInteger.valueOf(0L));
        leftCTBorder.setColor((Object)"auto");
        ctTblBorders.setLeft(leftCTBorder);
        CTBorder bottomCTBorder = (CTBorder)CTBorder.Factory.newInstance();
        bottomCTBorder.setVal(STBorder.Enum.forString((String)"single"));
        bottomCTBorder.setSz(BigInteger.valueOf(4L));
        bottomCTBorder.setSpace(BigInteger.valueOf(0L));
        bottomCTBorder.setColor((Object)"auto");
        ctTblBorders.setBottom(bottomCTBorder);
        CTBorder rightCTBorder = (CTBorder)CTBorder.Factory.newInstance();
        rightCTBorder.setVal(STBorder.Enum.forString((String)"single"));
        rightCTBorder.setSz(BigInteger.valueOf(4L));
        rightCTBorder.setSpace(BigInteger.valueOf(0L));
        rightCTBorder.setColor((Object)"auto");
        ctTblBorders.setRight(rightCTBorder);
        CTBorder insideHCTBorder = (CTBorder)CTBorder.Factory.newInstance();
        insideHCTBorder.setVal(STBorder.Enum.forString((String)"single"));
        insideHCTBorder.setSz(BigInteger.valueOf(4L));
        insideHCTBorder.setSpace(BigInteger.valueOf(0L));
        insideHCTBorder.setColor((Object)"auto");
        ctTblBorders.setInsideH(insideHCTBorder);
        CTBorder insideVCTBorder = (CTBorder)CTBorder.Factory.newInstance();
        insideVCTBorder.setVal(STBorder.Enum.forString((String)"single"));
        insideVCTBorder.setSz(BigInteger.valueOf(4L));
        insideVCTBorder.setSpace(BigInteger.valueOf(0L));
        insideVCTBorder.setColor((Object)"auto");
        ctTblBorders.setInsideV(insideVCTBorder);
        ctTblPrBase.setTblBorders(ctTblBorders);
        CTTblCellMar ctTblCellMar = (CTTblCellMar)CTTblCellMar.Factory.newInstance();
        CTTblWidth topCtTblWidth = (CTTblWidth)CTTblWidth.Factory.newInstance();
        topCtTblWidth.setW((Object)"108");
        topCtTblWidth.setType(STTblWidth.Enum.forString((String)"dxa"));
        ctTblCellMar.setTop(topCtTblWidth);
        CTTblWidth leftCtTblWidth = (CTTblWidth)CTTblWidth.Factory.newInstance();
        leftCtTblWidth.setW((Object)"108");
        leftCtTblWidth.setType(STTblWidth.Enum.forString((String)"dxa"));
        ctTblCellMar.setLeft(leftCtTblWidth);
        CTTblWidth bottomCtTblWidth = (CTTblWidth)CTTblWidth.Factory.newInstance();
        bottomCtTblWidth.setW((Object)"108");
        bottomCtTblWidth.setType(STTblWidth.Enum.forString((String)"dxa"));
        ctTblCellMar.setBottom(bottomCtTblWidth);
        CTTblWidth rightCtTblWidth = (CTTblWidth)CTTblWidth.Factory.newInstance();
        rightCtTblWidth.setW((Object)"108");
        rightCtTblWidth.setType(STTblWidth.Enum.forString((String)"dxa"));
        ctTblCellMar.setRight(rightCtTblWidth);
        ctTblPrBase.setTblCellMar(ctTblCellMar);
        ctStyle.setTblPr(ctTblPrBase);
        XWPFStyle style = new XWPFStyle(ctStyle);
        XWPFStyles styles = document.createStyles();
        style.setType(STStyleType.TABLE);
        styles.addStyle(style);
    }
}

