/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.word.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.dataset.util.DatasetSpecialVarHelper;
import kd.epm.far.business.common.expression.base.AbstractExpressionConditionItem;
import kd.epm.far.business.common.expression.base.AbstractExpressionEval;
import kd.epm.far.business.common.expression.calculate.ds.ExpressionDSSplitHelper;
import kd.epm.far.business.common.expression.dto.eval.ExpressionDSEval;
import kd.epm.far.business.common.expression.dto.eval.ds.ExpressionDSCondition;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.util.TypeUtils;
import kd.epm.far.business.fidm.word.dto.WordTableCellNodeEx;
import kd.epm.far.business.fidm.word.dto.WordTableNode;
import kd.epm.far.business.fidm.word.dto.WordTableRowNode;
import kd.epm.far.business.fidm.word.dto.expression.CellDataFill;
import kd.epm.far.business.fidm.word.dto.expression.CellDataFillMain;
import kd.epm.far.business.fidm.word.helper.WordNodeHelper;
import kd.epm.far.business.fidm.word.helper.WordTableHelper;

public class WordTableExpressionHelper {
    public static boolean reset(WordTableNode tableNode, IOperation operation) {
        boolean isTableChange = false;
        WordNodeHelper.expand(tableNode);
        Map<String, CellDataFill> cellDataFillMap = WordTableExpressionHelper.getCellDataFillMap(tableNode);
        boolean isChange = operation.refreshTable(cellDataFillMap);
        if (isChange) {
            isTableChange = true;
        }
        WordNodeHelper.shrink(tableNode);
        return isTableChange;
    }

    private static Map<String, CellDataFill> getCellDataFillMap(WordTableNode tableNode) {
        HashMap<String, CellDataFill> cellDataFillMap = new HashMap<String, CellDataFill>(2000);
        for (int rowIndex = 0; rowIndex < tableNode.getChilds().size(); ++rowIndex) {
            WordTableRowNode rowNode = (WordTableRowNode)tableNode.getChilds().get(rowIndex);
            CellDataFillMain curMainCell = null;
            for (int cellIndex = 0; cellIndex < rowNode.getChilds().size(); ++cellIndex) {
                CellDataFillMain mainCell;
                WordTableCellNodeEx cellNode = (WordTableCellNodeEx)rowNode.getChilds().get(cellIndex);
                CellDataFill cellDataFill = WordTableExpressionHelper.createCellFill(cellDataFillMap, cellNode, curMainCell, rowIndex, cellIndex);
                if (cellDataFill.isCheckOver()) continue;
                cellDataFill.setCheckOver(true);
                boolean isCompleteDs = WordTableExpressionHelper.isCompleteDs(cellDataFill, curMainCell);
                if (curMainCell != null) {
                    if (isCompleteDs) {
                        curMainCell.setEndCellIndex(cellIndex);
                        WordTableExpressionHelper.fillRange(tableNode, cellDataFillMap, curMainCell);
                        if (cellDataFill.isEndChar()) {
                            curMainCell = null;
                            continue;
                        }
                        mainCell = new CellDataFillMain();
                        mainCell.setMainCell(cellDataFill);
                        mainCell.setEndCellIndex(cellIndex - 1);
                        mainCell.setEndRowIndex(WordTableExpressionHelper.getRowRange(cellDataFillMap, tableNode, mainCell));
                        curMainCell = mainCell;
                        continue;
                    }
                    cellDataFill.setChange(WordTableExpressionHelper.dsFill(curMainCell.getMainCell(), cellDataFill.getDs()));
                    if (!cellDataFill.isEndChar()) continue;
                    curMainCell.setEndCellIndex(cellIndex);
                    WordTableExpressionHelper.fillRange(tableNode, cellDataFillMap, curMainCell);
                    curMainCell = null;
                    continue;
                }
                if (isCompleteDs) {
                    mainCell = new CellDataFillMain();
                    mainCell.setMainCell(cellDataFill);
                    mainCell.setEndCellIndex(cellIndex);
                    mainCell.setEndRowIndex(WordTableExpressionHelper.getRowRange(cellDataFillMap, tableNode, mainCell));
                    curMainCell = mainCell;
                }
                if (curMainCell == null) continue;
                curMainCell.setEndCellIndex(cellIndex);
                cellDataFill.setChange(WordTableExpressionHelper.dsFill(curMainCell.getMainCell(), cellDataFill.getDs()));
            }
            if (curMainCell == null) continue;
            curMainCell.setEndCellIndex(rowNode.getChilds().size() - 1);
            WordTableExpressionHelper.fillRange(tableNode, cellDataFillMap, curMainCell);
        }
        return cellDataFillMap;
    }

    private static void fillRange(WordTableNode tableNode, Map<String, CellDataFill> cellDataFillMap, CellDataFillMain curMainCell) {
        for (int rowIndex = curMainCell.getMainCell().getRowIndex() + 1; rowIndex <= curMainCell.getEndRowIndex(); ++rowIndex) {
            WordTableRowNode rowNode = (WordTableRowNode)tableNode.getChilds().get(rowIndex);
            for (int cellIndex = curMainCell.getMainCell().getCellIndex() + 1; cellIndex <= curMainCell.getEndCellIndex(); ++cellIndex) {
                WordTableCellNodeEx cellNode = (WordTableCellNodeEx)rowNode.getChilds().get(cellIndex);
                CellDataFill cellDataFill = WordTableExpressionHelper.createCellFill(cellDataFillMap, cellNode, curMainCell, rowIndex, cellIndex);
                if (cellDataFill.isCheckOver()) continue;
                cellDataFill.setCheckOver(true);
                boolean isCompleteDs = WordTableExpressionHelper.isCompleteDs(cellDataFill, curMainCell);
                if (isCompleteDs) continue;
                cellDataFill.setChange(WordTableExpressionHelper.dsFill(curMainCell.getMainCell().getDs(), cellDataFillMap.get(WordTableExpressionHelper.getCellKey(rowIndex, curMainCell.getMainCell().getCellIndex())), cellDataFillMap.get(WordTableExpressionHelper.getCellKey(curMainCell.getMainCell().getRowIndex(), cellIndex)), cellDataFill.getDs()));
            }
        }
    }

    private static int getRowRange(Map<String, CellDataFill> cellDataFillMap, WordTableNode tableNode, CellDataFillMain curMainCell) {
        int cellIndex = curMainCell.getMainCell().getCellIndex();
        int realRowIndex = curMainCell.getMainCell().getRowIndex();
        for (int rowIndex = curMainCell.getMainCell().getRowIndex() + 1; rowIndex < tableNode.getChilds().size(); ++rowIndex) {
            WordTableCellNodeEx cellNode;
            CellDataFill cellDataFill;
            WordTableRowNode rowNode = (WordTableRowNode)tableNode.getChilds().get(rowIndex);
            if (rowNode.getChilds().size() <= cellIndex || (cellDataFill = WordTableExpressionHelper.createCellFill(cellDataFillMap, cellNode = (WordTableCellNodeEx)rowNode.getChilds().get(cellIndex), curMainCell, rowIndex, cellIndex)).isCheckOver()) continue;
            cellDataFill.setCheckOver(true);
            boolean isCompleteDs = WordTableExpressionHelper.isCompleteDs(cellDataFill, curMainCell);
            if (isCompleteDs) {
                cellDataFill.setCheckOver(false);
                break;
            }
            cellDataFill.setChange(WordTableExpressionHelper.dsFill(curMainCell.getMainCell(), cellDataFill.getDs()));
            if (cellDataFill.isEndChar()) {
                realRowIndex = rowIndex;
                break;
            }
            realRowIndex = rowIndex;
        }
        return realRowIndex;
    }

    private static boolean isCompleteDs(CellDataFill cellDataFill, CellDataFillMain main) {
        if (main != null && main.getMainCell().getDs() != null && cellDataFill.getDs() != null && !main.getMainCell().getDs().getDsFlagType().equalsIgnoreCase(cellDataFill.getDs().getDsFlagType())) {
            return true;
        }
        return cellDataFill.getDs() != null && cellDataFill.isCompleteDs();
    }

    private static boolean dsFill(ExpressionDSEval main, CellDataFill first, CellDataFill second, ExpressionDSEval currentDs) {
        ExpressionDSCondition newFind;
        AbstractExpressionConditionItem findItem;
        ExpressionDSCondition find;
        if (main == null || currentDs == null) {
            return false;
        }
        boolean isChange = false;
        if (StringUtils.isEmpty((String)currentDs.getDsNumber())) {
            currentDs.setDsNumber(main.getDsNumber());
            isChange = true;
        }
        List<String> moneySet = new ArrayList<String>(2);
        if (currentDs.getMoneySet().size() == 0) {
            if (first != null && first.getDs() != null && first.getSourceMoneySet().size() > 0) {
                moneySet = first.getSourceMoneySet();
            } else if (second != null && second.getDs() != null && second.getSourceMoneySet().size() > 0) {
                moneySet = second.getSourceMoneySet();
            } else if (main != null && main.getMoneySet().size() > 0) {
                moneySet = main.getMoneySet();
            }
            if (moneySet.size() > 0) {
                currentDs.setMoneySet(moneySet);
                isChange = true;
            }
        }
        ArrayList<ExpressionDSCondition> newConditions = new ArrayList<ExpressionDSCondition>(10);
        if (first != null && first.getDs() != null && first.getSourceConditions().size() > 0) {
            for (ExpressionDSCondition condition : first.getSourceConditions()) {
                find = currentDs.getConditions().stream().filter(m -> m.getColumnNumber().equalsIgnoreCase(condition.getColumnNumber())).findFirst().orElse(null);
                if (find != null || (findItem = (AbstractExpressionConditionItem)condition.getItems().stream().filter(m -> DatasetSpecialVarHelper.isContainAllVar(m.getSource())).findFirst().orElse(null)) != null || (newFind = (ExpressionDSCondition)newConditions.stream().filter(m -> m.getColumnNumber().equalsIgnoreCase(condition.getColumnNumber())).findFirst().orElse(null)) != null) continue;
                newConditions.add(condition);
            }
        }
        if (second != null && second.getDs() != null && second.getSourceConditions().size() > 0) {
            for (ExpressionDSCondition condition : second.getSourceConditions()) {
                find = currentDs.getConditions().stream().filter(m -> m.getColumnNumber().equalsIgnoreCase(condition.getColumnNumber())).findFirst().orElse(null);
                if (find != null || (findItem = (AbstractExpressionConditionItem)condition.getItems().stream().filter(m -> DatasetSpecialVarHelper.isContainAllVar(m.getSource())).findFirst().orElse(null)) != null || (newFind = (ExpressionDSCondition)newConditions.stream().filter(m -> m.getColumnNumber().equalsIgnoreCase(condition.getColumnNumber())).findFirst().orElse(null)) != null) continue;
                newConditions.add(condition);
            }
        }
        for (ExpressionDSCondition condition : main.getConditions()) {
            find = currentDs.getConditions().stream().filter(m -> m.getColumnNumber().equalsIgnoreCase(condition.getColumnNumber())).findFirst().orElse(null);
            if (find != null || (findItem = (AbstractExpressionConditionItem)condition.getItems().stream().filter(m -> DatasetSpecialVarHelper.isContainAllVar(m.getSource())).findFirst().orElse(null)) != null || (newFind = (ExpressionDSCondition)newConditions.stream().filter(m -> m.getColumnNumber().equalsIgnoreCase(condition.getColumnNumber())).findFirst().orElse(null)) != null) continue;
            newConditions.add(condition);
        }
        for (ExpressionDSCondition condition : newConditions) {
            ExpressionDSCondition newCondition = DisclosureJsonHelper.copyEntity(condition, ExpressionDSCondition.class);
            currentDs.getConditions().add(newCondition);
            isChange = true;
        }
        return isChange;
    }

    private static boolean dsFill(CellDataFill first, ExpressionDSEval currentDs) {
        if (first == null || first.getDs() == null || currentDs == null) {
            return false;
        }
        if (first.getDs() == currentDs) {
            return false;
        }
        boolean isChange = false;
        if (StringUtils.isEmpty((String)currentDs.getDsNumber())) {
            currentDs.setDsNumber(first.getDs().getDsNumber());
            isChange = true;
        }
        if (currentDs.getMoneySet().size() == 0) {
            currentDs.setMoneySet(first.getDs().getMoneySet());
            isChange = true;
        }
        for (ExpressionDSCondition condition : first.getSourceConditions()) {
            AbstractExpressionConditionItem findItem;
            ExpressionDSCondition find = currentDs.getConditions().stream().filter(m -> m.getColumnNumber().equalsIgnoreCase(condition.getColumnNumber())).findFirst().orElse(null);
            if (find != null || (findItem = (AbstractExpressionConditionItem)condition.getItems().stream().filter(m -> DatasetSpecialVarHelper.isContainAllVar(m.getSource())).findFirst().orElse(null)) != null) continue;
            ExpressionDSCondition newCondition = DisclosureJsonHelper.copyEntity(condition, ExpressionDSCondition.class);
            currentDs.getConditions().add(newCondition);
            isChange = true;
        }
        return isChange;
    }

    private static CellDataFill createCellFill(Map<String, CellDataFill> cellDataFillMap, WordTableCellNodeEx cellNode, CellDataFillMain mainCell, int rowIndex, int cellIndex) {
        List<AbstractExpressionEval> evalList;
        int dsSzie;
        String cellKey = WordTableExpressionHelper.getCellKey(rowIndex, cellIndex);
        CellDataFill cellDataFill = cellDataFillMap.get(cellKey);
        if (cellDataFill == null) {
            cellDataFill = new CellDataFill();
            cellDataFill.setCell(cellNode.getSource());
            cellDataFill.setRowIndex(rowIndex);
            cellDataFill.setCellIndex(cellIndex);
            cellDataFillMap.put(cellKey, cellDataFill);
        }
        if (cellDataFill.isCheckOver()) {
            return cellDataFill;
        }
        if (mainCell != null && cellDataFill == mainCell.getMainCell()) {
            return cellDataFill;
        }
        String cellContent = WordTableHelper.getCellString(cellNode.getSource());
        boolean isEndChar = TypeUtils.endsWithIgnore("#END;", cellContent);
        if (isEndChar) {
            cellDataFill.setEndChar(true);
        }
        if ((dsSzie = ExpressionDSSplitHelper.getDsSize(evalList = ExpressionDSSplitHelper.splitDefault(cellContent))) == 0) {
            if (!cellDataFill.isEndChar()) {
                cellDataFill.setNormal(true);
            } else {
                cellDataFill.setMainCell(mainCell);
            }
            return cellDataFill;
        }
        cellDataFill.setDs(ExpressionDSSplitHelper.getDsFirst(evalList));
        if (cellDataFill.getDs() != null) {
            if (cellDataFill.getDs().getConditions() != null) {
                cellDataFill.setSourceConditions(DisclosureJsonHelper.copyList(cellDataFill.getDs().getConditions(), ExpressionDSCondition.class));
            }
            if (cellDataFill.getDs().getMoneySet() != null) {
                cellDataFill.setSourceMoneySet(DisclosureJsonHelper.copyList(cellDataFill.getDs().getMoneySet(), String.class));
            }
        }
        cellDataFill.setNormal(false);
        if (WordTableExpressionHelper.isFullDs(cellDataFill, mainCell)) {
            cellDataFill.setCompleteDs(true);
        } else {
            cellDataFill.setCompleteDs(false);
            cellDataFill.setMainCell(mainCell);
        }
        return cellDataFill;
    }

    private static String getCellKey(int rowIndex, int cellIndex) {
        return rowIndex + "-" + cellIndex;
    }

    private static boolean isFullDs(CellDataFill cellDataFill, CellDataFillMain main) {
        if (cellDataFill == null || cellDataFill.getDs() == null) {
            return true;
        }
        if (main != null && main.getMainCell().getDs() != null && cellDataFill.getDs() != null && StringUtils.isNotEmpty((String)main.getMainCell().getDs().getDsNumber()) && main.getMainCell().getDs().getDsFlagType().equalsIgnoreCase(cellDataFill.getDs().getDsFlagType()) && main.getMainCell().getDs().getDsNumber().equalsIgnoreCase(cellDataFill.getDs().getDsNumber())) {
            return false;
        }
        return !cellDataFill.getDs().isDefault();
    }

    public static interface IOperation {
        public boolean refreshTable(Map<String, CellDataFill> var1);
    }
}

