/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.word.helper;

import java.math.BigInteger;
import java.util.Locale;
import kd.bos.util.StringUtils;
import kd.epm.far.business.fidm.util.TypeUtils;
import kd.epm.far.business.fidm.word.base.WordConstants;
import kd.epm.far.business.fidm.word.dto.WordNode;
import kd.epm.far.business.fidm.word.dto.WordParagraphNode;
import kd.epm.far.business.fidm.word.dto.WordTableCellBorder;
import kd.epm.far.business.fidm.word.dto.WordTableCellBorders;
import kd.epm.far.business.fidm.word.dto.WordTableCellMargin;
import kd.epm.far.business.fidm.word.dto.WordTableCellMargins;
import kd.epm.far.business.fidm.word.dto.WordTableCellNode;
import kd.epm.far.business.fidm.word.dto.WordTableNode;
import kd.epm.far.business.fidm.word.helper.ColorStyleHelper;
import kd.epm.far.business.fidm.word.helper.WordParagraphNodeHelper;
import kd.epm.far.business.fidm.word.poi.PoiHelper;
import org.apache.poi.xwpf.usermodel.TableRowAlign;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.poi.xwpf.usermodel.XWPFTableRow;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBookmark;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblBorders;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblCellMar;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcBorders;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTblWidth;

public class WordTableHelper {
    public static int getTableAlignment(XWPFTable table) {
        int alignment = 1;
        if (table.getTableAlignment() == null) {
            return alignment;
        }
        alignment = table.getTableAlignment() == TableRowAlign.CENTER ? 2 : (table.getTableAlignment() == TableRowAlign.LEFT ? 1 : 3);
        return alignment;
    }

    public static String getTableBookmark(XWPFTable table) {
        CTBookmark bookmark;
        CTP ctp;
        if (table != null && table.getRows().size() > 0 && ((XWPFTableRow)table.getRows().get(0)).getTableCells().size() > 0 && ((XWPFTableRow)table.getRows().get(0)).getCell(0).getParagraphs().size() > 0 && ((XWPFParagraph)((XWPFTableRow)table.getRows().get(0)).getCell(0).getParagraphs().get(0)).getCTP() != null && (ctp = ((XWPFParagraph)((XWPFTableRow)table.getRows().get(0)).getCell(0).getParagraphs().get(0)).getCTP()).getBookmarkStartArray().length > 0 && (bookmark = ctp.getBookmarkStartArray(0)) != null && StringUtils.isNotEmpty((String)bookmark.getName())) {
            String name = bookmark.getName();
            PoiHelper.removeBookMark(ctp, new String[]{name});
            return name;
        }
        return null;
    }

    public static void createTableMargin(WordTableNode tableNode, XWPFTable table) {
        CTTblCellMar ctTblCellMar = table.getCTTbl().getTblPr().getTblCellMar();
        if (ctTblCellMar == null) {
            return;
        }
        WordTableCellMargins wordTableCellMargins = new WordTableCellMargins();
        if (ctTblCellMar.getLeft() != null && ctTblCellMar.getLeft().getType() == STTblWidth.Enum.forString((String)"dxa") && ctTblCellMar.getLeft().getW() != null) {
            WordTableCellMargin leftMargin = new WordTableCellMargin();
            leftMargin.setWidth(TypeUtils.convertValueToDoule(ctTblCellMar.getLeft().getW().toString()));
            wordTableCellMargins.setLeft(leftMargin);
        }
        if (ctTblCellMar.getRight() != null && ctTblCellMar.getRight().getType() == STTblWidth.Enum.forString((String)"dxa") && ctTblCellMar.getRight().getW() != null) {
            WordTableCellMargin rightMargin = new WordTableCellMargin();
            rightMargin.setWidth(TypeUtils.convertValueToDoule(ctTblCellMar.getRight().getW().toString()));
            wordTableCellMargins.setRight(rightMargin);
        }
        if (ctTblCellMar.getTop() != null && ctTblCellMar.getTop().getType() == STTblWidth.Enum.forString((String)"dxa") && ctTblCellMar.getTop().getW() != null) {
            WordTableCellMargin topMargin = new WordTableCellMargin();
            topMargin.setWidth(TypeUtils.convertValueToDoule(ctTblCellMar.getTop().getW().toString()));
            wordTableCellMargins.setTop(topMargin);
        }
        if (ctTblCellMar.getBottom() != null && ctTblCellMar.getBottom().getType() == STTblWidth.Enum.forString((String)"dxa") && ctTblCellMar.getBottom().getW() != null) {
            WordTableCellMargin bottomMargin = new WordTableCellMargin();
            bottomMargin.setWidth(TypeUtils.convertValueToDoule(ctTblCellMar.getBottom().getW().toString()));
            wordTableCellMargins.setBottom(bottomMargin);
        }
        tableNode.setMargins(wordTableCellMargins);
    }

    public static void toTableMargin(WordTableNode tableNode, XWPFTable table) {
        if (table.getCTTbl() != null && table.getCTTbl().getTblPr() != null && tableNode.getMargins() != null) {
            CTTblCellMar ctTblCellMar = table.getCTTbl().getTblPr().isSetTblCellMar() ? table.getCTTbl().getTblPr().getTblCellMar() : table.getCTTbl().getTblPr().addNewTblCellMar();
            CTTblWidth leftTblWidth = (CTTblWidth)CTTblWidth.Factory.newInstance();
            leftTblWidth.setW((Object)BigInteger.valueOf((int)(tableNode.getMargins().getLeft() == null ? 0.0 : tableNode.getMargins().getLeft().getWidth())));
            ctTblCellMar.setLeft(leftTblWidth);
            CTTblWidth rightTblWidth = (CTTblWidth)CTTblWidth.Factory.newInstance();
            rightTblWidth.setW((Object)BigInteger.valueOf((int)(tableNode.getMargins().getRight() == null ? 0.0 : tableNode.getMargins().getRight().getWidth())));
            ctTblCellMar.setRight(rightTblWidth);
            CTTblWidth topTblWidth = (CTTblWidth)CTTblWidth.Factory.newInstance();
            topTblWidth.setW((Object)BigInteger.valueOf((int)(tableNode.getMargins().getTop() == null ? 0.0 : tableNode.getMargins().getTop().getWidth())));
            ctTblCellMar.setTop(topTblWidth);
            CTTblWidth bottomTblWidth = (CTTblWidth)CTTblWidth.Factory.newInstance();
            bottomTblWidth.setW((Object)BigInteger.valueOf((int)(tableNode.getMargins().getBottom() == null ? 0.0 : tableNode.getMargins().getBottom().getWidth())));
            ctTblCellMar.setBottom(bottomTblWidth);
        }
    }

    public static void toTableLeftInd(WordTableNode tableNode, XWPFTable table) {
        if (table.getCTTbl() != null && table.getCTTbl().getTblPr() != null) {
            CTTblWidth tblWidth = table.getCTTbl().getTblPr().isSetTblInd() ? table.getCTTbl().getTblPr().getTblInd() : table.getCTTbl().getTblPr().addNewTblInd();
            tblWidth.setType(STTblWidth.Enum.forString((String)"dxa"));
            tblWidth.setW((Object)BigInteger.valueOf((int)tableNode.getLeftInd()));
        }
    }

    public static WordTableCellBorders createWordCellBorders(XWPFTableCell cell, CTTblBorders rowBorders) {
        WordTableCellBorders borders = new WordTableCellBorders();
        CTTcBorders ctTcBorders = null;
        if (cell.getCTTc() != null && cell.getCTTc().getTcPr() != null) {
            ctTcBorders = cell.getCTTc().getTcPr().getTcBorders();
        }
        if (ctTcBorders == null && rowBorders == null) {
            return null;
        }
        WordTableHelper.createWordCellBordersSingle(ctTcBorders == null ? null : ctTcBorders.getLeft(), rowBorders == null ? null : rowBorders.getLeft(), borders.getLeft());
        WordTableHelper.createWordCellBordersSingle(ctTcBorders == null ? null : ctTcBorders.getRight(), rowBorders == null ? null : rowBorders.getRight(), borders.getRight());
        WordTableHelper.createWordCellBordersSingle(ctTcBorders == null ? null : ctTcBorders.getTop(), rowBorders == null ? null : rowBorders.getTop(), borders.getTop());
        WordTableHelper.createWordCellBordersSingle(ctTcBorders == null ? null : ctTcBorders.getBottom(), rowBorders == null ? null : rowBorders.getBottom(), borders.getBottom());
        return borders;
    }

    public static void createWordCellBordersSingle(CTBorder ctTcBorder, CTBorder rowBorder, WordTableCellBorder border) {
        BigInteger sz;
        String colorObj;
        String color;
        if (border == null) {
            return;
        }
        if (ctTcBorder == null && rowBorder == null) {
            return;
        }
        if (ctTcBorder == null && rowBorder != null) {
            ctTcBorder = rowBorder;
        }
        if (StringUtils.isNotEmpty((String)(color = ColorStyleHelper.getHexadecimalColor(colorObj = ctTcBorder.xgetColor().getStringValue())))) {
            border.setColor(color);
        }
        if ((sz = ctTcBorder.getSz()) != null) {
            BigInteger val = sz.divide(BigInteger.valueOf(8L));
            border.setWidth(val.doubleValue());
        }
        WordConstants.WordBorderType borderType = WordConstants.WordBorderType.Solid;
        if (ctTcBorder.getVal() == STBorder.Enum.forString((String)"none") || ctTcBorder.getVal() == STBorder.Enum.forString((String)"nil")) {
            borderType = WordConstants.WordBorderType.None;
        } else if (ctTcBorder.getVal().toString().toLowerCase(Locale.ROOT).contains("double")) {
            borderType = WordConstants.WordBorderType.Solid;
            if (sz != null) {
                BigInteger val = sz.divide(BigInteger.valueOf(48L));
                border.setWidth(val.doubleValue());
            }
        } else if (ctTcBorder.getVal().toString().toLowerCase(Locale.ROOT).contains("medium")) {
            borderType = WordConstants.WordBorderType.Solid;
            if (sz != null) {
                BigInteger val = sz.divide(BigInteger.valueOf(24L));
                border.setWidth(val.doubleValue());
            }
        } else if (ctTcBorder.getVal().toString().toLowerCase(Locale.ROOT).contains("dashed")) {
            borderType = WordConstants.WordBorderType.Dashed;
        } else if (ctTcBorder.getVal().toString().toLowerCase(Locale.ROOT).contains("dotted")) {
            borderType = WordConstants.WordBorderType.Dotted;
        }
        border.setType(borderType.getType());
    }

    public static void toTableCellBorders(WordTableCellNode cellNode, XWPFTableCell cell) {
        CTTcBorders ctTcBorders;
        if (cellNode.getBorders() == null || cell.getCTTc() == null) {
            return;
        }
        if (cellNode.getBorders().isDefault()) {
            return;
        }
        CTTcPr ctTcPr = cell.getCTTc().getTcPr();
        if (ctTcPr == null) {
            ctTcPr = cell.getCTTc().addNewTcPr();
        }
        if ((ctTcBorders = ctTcPr.getTcBorders()) == null) {
            ctTcBorders = ctTcPr.addNewTcBorders();
        }
        if (!cellNode.getBorders().getLeft().isDefault()) {
            WordTableHelper.toTableCellBorderSingle(cellNode.getBorders().getLeft(), ctTcBorders.addNewLeft());
        }
        if (!cellNode.getBorders().getRight().isDefault()) {
            WordTableHelper.toTableCellBorderSingle(cellNode.getBorders().getRight(), ctTcBorders.addNewRight());
        }
        if (!cellNode.getBorders().getTop().isDefault()) {
            WordTableHelper.toTableCellBorderSingle(cellNode.getBorders().getTop(), ctTcBorders.addNewTop());
        }
        if (!cellNode.getBorders().getBottom().isDefault()) {
            WordTableHelper.toTableCellBorderSingle(cellNode.getBorders().getBottom(), ctTcBorders.addNewBottom());
        }
    }

    public static void toTableCellBorderSingle(WordTableCellBorder border, CTBorder ctBorder) {
        if (border == null || ctBorder == null) {
            return;
        }
        STBorder.Enum borderType = STBorder.Enum.forString((String)"single");
        if (border.getType() == WordConstants.WordBorderType.None.getType()) {
            borderType = STBorder.Enum.forString((String)"none");
        } else if (border.getType() == WordConstants.WordBorderType.Medium.getType()) {
            borderType = STBorder.Enum.forString((String)"single");
        } else if (border.getType() == WordConstants.WordBorderType.Dotted.getType()) {
            borderType = STBorder.Enum.forString((String)"dotted");
        } else if (border.getType() == WordConstants.WordBorderType.Dashed.getType()) {
            borderType = STBorder.Enum.forString((String)"dashed");
        }
        ctBorder.setVal(borderType);
        ctBorder.setColor((Object)border.getColor().replace("#", ""));
        ctBorder.setSz(BigInteger.valueOf((int)(border.getWidth() * 8.0)));
    }

    public static String getCellString(WordTableCellNode tableCellNode) {
        if (tableCellNode == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (WordNode wordNode : tableCellNode.getChilds()) {
            if (!(wordNode instanceof WordParagraphNode)) continue;
            sb.append(WordParagraphNodeHelper.getString((WordParagraphNode)wordNode));
        }
        return sb.toString();
    }
}

