/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.word.helper;

import java.util.ArrayList;
import kd.epm.far.business.fidm.word.base.WordConstants;
import kd.epm.far.business.fidm.word.dto.WordNode;
import kd.epm.far.business.fidm.word.dto.WordTableCellNode;
import kd.epm.far.business.fidm.word.dto.WordTableNode;
import kd.epm.far.business.fidm.word.dto.WordTableRowNode;

public class WordWidthHelper {
    public static void resetTableCellZeroWidth(WordTableNode tableNode) {
        double tableWidth = tableNode.getWidth();
        if (tableWidth <= 0.0) {
            return;
        }
        if (tableNode.getChilds().size() == 0) {
            return;
        }
        for (WordNode node : tableNode.getChilds()) {
            WordTableRowNode rowNode = (WordTableRowNode)node;
            if (rowNode == null) continue;
            ArrayList<WordTableCellNode> zeroList = new ArrayList<WordTableCellNode>(rowNode.getChilds().size());
            double rowWith = 0.0;
            for (WordNode cell : rowNode.getChilds()) {
                WordTableCellNode cellNode = (WordTableCellNode)cell;
                if (cellNode == null) continue;
                if (cellNode.getWidth() <= 0.0) {
                    zeroList.add(cellNode);
                    continue;
                }
                rowWith += cellNode.getWidth();
            }
            if (zeroList.size() <= 0 || !(tableWidth - rowWith > 0.0)) continue;
            double realCellWidth = (tableWidth - rowWith) / (double)zeroList.size();
            for (WordTableCellNode cellNode : zeroList) {
                cellNode.setWidth(realCellWidth);
            }
        }
    }

    public static double calcWordTableMaxRowWidth(WordTableNode tableNode) {
        double maxRowWidth = 0.0;
        for (WordNode row : tableNode.getChilds()) {
            double rowWidth = 0.0;
            for (WordNode cell : row.getChilds()) {
                rowWidth += ((WordTableCellNode)cell).getWidth();
            }
            if (!(rowWidth > maxRowWidth)) continue;
            maxRowWidth = rowWidth;
        }
        return maxRowWidth;
    }

    public static void resetTableWidth(WordTableNode tableNode, WordConstants.WordWidthType WordWidthType2, double widthRate) {
        if (WordWidthType2 == WordConstants.WordWidthType.Percentage) {
            double rowMaxWidth = WordWidthHelper.calcWordTableMaxRowWidth(tableNode);
            if (rowMaxWidth > 0.0) {
                for (WordNode rowItem : tableNode.getChilds()) {
                    WordTableRowNode row = (WordTableRowNode)rowItem;
                    row.setWidth(row.getWidth() / rowMaxWidth);
                    row.setHeight(row.getHeight() / rowMaxWidth);
                    row.setWidthType(WordConstants.WordWidthType.Percentage.getType());
                    for (WordNode cellItem : row.getChilds()) {
                        WordTableCellNode cell = (WordTableCellNode)cellItem;
                        cell.setWidth(cell.getWidth() / rowMaxWidth);
                        cell.setWidthType(WordConstants.WordWidthType.Percentage.getType());
                    }
                }
                tableNode.setWidth(0.99);
                tableNode.setWidthType(WordConstants.WordWidthType.Percentage.getType());
            }
        } else {
            if (widthRate <= 0.0) {
                return;
            }
            for (WordNode rowItem : tableNode.getChilds()) {
                WordTableRowNode row = (WordTableRowNode)rowItem;
                row.setWidth(row.getWidth() * widthRate);
                row.setHeight(row.getHeight() * widthRate);
                row.setWidthType(WordConstants.WordWidthType.Absolute.getType());
                for (WordNode cellItem : row.getChilds()) {
                    WordTableCellNode cell = (WordTableCellNode)cellItem;
                    cell.setWidth(cell.getWidth() * widthRate);
                    cell.setWidthType(WordConstants.WordWidthType.Absolute.getType());
                }
            }
            double rowMaxWidth = WordWidthHelper.calcWordTableMaxRowWidth(tableNode);
            if (rowMaxWidth > 0.0) {
                tableNode.setWidth(rowMaxWidth);
                tableNode.setWidthType(WordConstants.WordWidthType.Absolute.getType());
            }
        }
    }
}

