/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.word.poi;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.epm.far.business.common.enums.DataPatternEnum;
import kd.epm.far.business.common.enums.ModuleEnum;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.module.calculate.CalculateHelper;
import kd.epm.far.business.fidm.word.poi.AbstractPoi;
import kd.epm.far.business.fidm.word.poi.PoiHelper;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.xddf.usermodel.chart.AxisCrossBetween;
import org.apache.poi.xddf.usermodel.chart.AxisCrosses;
import org.apache.poi.xddf.usermodel.chart.AxisPosition;
import org.apache.poi.xddf.usermodel.chart.BarDirection;
import org.apache.poi.xddf.usermodel.chart.BarGrouping;
import org.apache.poi.xddf.usermodel.chart.ChartTypes;
import org.apache.poi.xddf.usermodel.chart.XDDFBarChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryAxis;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFChartAxis;
import org.apache.poi.xddf.usermodel.chart.XDDFChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSourcesFactory;
import org.apache.poi.xddf.usermodel.chart.XDDFValueAxis;
import org.apache.poi.xwpf.usermodel.XWPFChart;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBarSer;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTDLbls;
import org.openxmlformats.schemas.drawingml.x2006.chart.STDLblPos;

public class BarPoi
extends AbstractPoi {
    public static void bind(XWPFRun where, JSONObject moduleProperties) throws IOException, InvalidFormatException {
        XWPFChart chart = PoiHelper.createChart(where, moduleProperties);
        BarPoi.createChart(chart, moduleProperties, where);
        PoiHelper.clearPlaceholder(where, false);
    }

    public static void createChart(XWPFChart chart, JSONObject moduleProperties) {
        BarPoi.createChart(chart, moduleProperties, null);
    }

    public static void createChart(XWPFChart chart, JSONObject moduleProperties, XWPFRun run) {
        int i;
        Map dataObject = BarPoi.getData(moduleProperties);
        if (dataObject == null || dataObject.get("data") == null) {
            return;
        }
        Map soureceData = (Map)dataObject.get("data");
        List categories = new ArrayList(10);
        ArrayList<String> colorTitles = new ArrayList<String>(10);
        ArrayList<Number[]> tableData = new ArrayList<Number[]>(10);
        if (soureceData.get("xAxis") != null) {
            categories = (List)soureceData.get("xAxis");
        }
        JSONObject dataFormat = CalculateHelper.getDataFormart(moduleProperties, "dataFormat", "y1");
        for (Map yData : (List)soureceData.get("series")) {
            colorTitles.add(yData.get("name") == null ? "" : yData.get("name").toString());
            List<Number> valArarry = (List<Number>)yData.get("data");
            valArarry = PoiHelper.getVarArarry(dataFormat, valArarry);
            tableData.add(valArarry.toArray(new Number[0]));
        }
        BarGrouping barGrouping = BarGrouping.CLUSTERED;
        BarDirection barDirection = BarDirection.BAR;
        byte newOverlap = -20;
        String moduleType = moduleProperties.getString("type");
        if (ModuleEnum.CLUSTERED_COLUMNAR.getType().equals(moduleType) || ModuleEnum.STACKED_COLUMNAR.getType().equals(moduleType)) {
            barDirection = BarDirection.COL;
        }
        if (ModuleEnum.STACKED_COLUMNAR.getType().equals(moduleType) || ModuleEnum.STACKED_BAR.getType().equals(moduleType)) {
            barGrouping = BarGrouping.STACKED;
            newOverlap = 100;
        }
        if (colorTitles.size() != tableData.size()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u989c\u8272\u6807\u9898\u4e2a\u6570,\u5fc5\u987b\u548c\u6570\u7ec4\u4e2a\u6570\u76f8\u540c\u3002", (String)"WordUtils_0", (String)"epm-far-business", (Object[])new Object[0]));
        }
        for (Number[] tableDatum : tableData) {
            if (tableDatum.length == categories.size()) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u6bcf\u4e2a\u6570\u7ec4\u7684\u5143\u7d20\u4e2a\u6570,\u5fc5\u987b\u548c\u6570\u7ec4\u4e2a\u6570\u76f8\u540c", (String)"WordUtils_1", (String)"epm-far-business", (Object[])new Object[0]));
        }
        PoiHelper.createChartTitle(chart, moduleProperties, false);
        int numOfPoints = categories.size();
        XDDFCategoryDataSource categoriesData = XDDFDataSourcesFactory.fromArray((String[])categories.toArray(new String[0]), (String)PoiHelper.setDataSheetRange(chart, numOfPoints, 0), (int)0);
        PoiHelper.setTitleInDataSheet(chart, moduleProperties.getString("id"), 0);
        PoiHelper.setModuleId(run, moduleProperties.getString("id"));
        XDDFCategoryAxis bottomAxis = chart.createCategoryAxis(AxisPosition.BOTTOM);
        XDDFValueAxis leftAxis = chart.createValueAxis(AxisPosition.LEFT);
        leftAxis.setCrosses(AxisCrosses.AUTO_ZERO);
        leftAxis.setCrossBetween(AxisCrossBetween.BETWEEN);
        PoiHelper.setXAxisTitleFontSize(bottomAxis, moduleProperties);
        PoiHelper.setYAxisTitleFontSize(leftAxis, "y1", moduleProperties);
        PoiHelper.setYAxisMinAndMax(leftAxis, "y1", moduleProperties);
        XDDFChartData data = chart.createData(ChartTypes.BAR, (XDDFChartAxis)bottomAxis, leftAxis);
        for (i = 0; i < tableData.size(); ++i) {
            XDDFChartData.Series series = data.addSeries((XDDFDataSource)categoriesData, XDDFDataSourcesFactory.fromArray((Number[])((Number[])tableData.get(i)), (String)PoiHelper.setDataSheetRange(chart, numOfPoints, i + 1), (int)(i + 1)));
            PoiHelper.setSeriesTitle(chart, series, (String)colorTitles.get(i), i + 1);
        }
        if (tableData.size() > 1) {
            ((XDDFBarChartData)data).setBarGrouping(barGrouping);
            chart.getCTChart().getPlotArea().getBarChartArray(0).addNewOverlap().setVal((Object)newOverlap);
        }
        data.setVaryColors(Boolean.valueOf(true));
        for (i = 0; i < colorTitles.size(); ++i) {
            CTBarSer ser = chart.getCTChart().getPlotArea().getBarChartArray(0).getSerArray(i);
            ser.addNewSpPr().addNewSolidFill().addNewSrgbClr().xsetVal(PoiHelper.getCtdoptColor(i));
            ser.addNewInvertIfNegative().setVal(false);
        }
        boolean dataFormatVisible = DisclosureJsonHelper.getValue(moduleProperties, "dataFormat", "y1", "visible", true);
        String dataLabel = DisclosureJsonHelper.getValue(moduleProperties, "dataFormat", "y1", "dataLabel", "0");
        if (dataFormatVisible) {
            for (CTBarSer ctBarSer : chart.getCTChart().getPlotArea().getBarChartArray(0).getSerList()) {
                CTDLbls dLbls = ctBarSer.addNewDLbls();
                PoiHelper.setFormatCode(dLbls, dataFormat);
                PoiHelper.setDataFormatDLbls(dLbls, moduleProperties, "y1", false);
                if (!StringUtils.isNotEmpty((CharSequence)dataLabel) || "0".equals(dataLabel)) continue;
                dLbls.addNewDLblPos().setVal(STDLblPos.Enum.forString((String)dataLabel));
            }
        }
        ((XDDFBarChartData)data).setBarDirection(barDirection);
        PoiHelper.setLegendStyle(chart, moduleProperties);
        PoiHelper.setGridLine(chart, moduleProperties);
        PoiHelper.setBorder(chart, moduleProperties);
        PoiHelper.setAxisFormat(chart, moduleProperties, DataPatternEnum.getDataPatternByType(dataFormat.getString("unit")), null);
        PoiHelper.setAxisTextAngle(chart, moduleProperties);
        PoiHelper.setAxisVisible(bottomAxis, leftAxis, null, moduleProperties);
        chart.plot(data);
    }
}

