/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.word.poi;

import java.util.Collections;
import java.util.List;
import org.apache.poi.util.Internal;
import org.apache.poi.xddf.usermodel.XDDFShapeProperties;
import org.apache.poi.xddf.usermodel.chart.XDDFChart;
import org.apache.poi.xddf.usermodel.chart.XDDFChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSourcesFactory;
import org.apache.poi.xddf.usermodel.chart.XDDFNumericalDataSource;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAxDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTDPt;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTDoughnutChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPieSer;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTSerTx;

public class DoughnutChartData
extends XDDFChartData {
    private CTDoughnutChart chart;

    protected DoughnutChartData(XDDFChart parent, CTDoughnutChart chart) {
        super(parent);
        this.chart = chart;
        for (CTPieSer series : chart.getSerList()) {
            this.series.add(new Series(series, series.getCat(), series.getVal()));
        }
    }

    @Internal
    protected void removeCTSeries(int n) {
        this.chart.removeSer(n);
    }

    public void setVaryColors(Boolean varyColors) {
        if (varyColors == null) {
            if (this.chart.isSetVaryColors()) {
                this.chart.unsetVaryColors();
            }
        } else if (this.chart.isSetVaryColors()) {
            this.chart.getVaryColors().setVal(varyColors.booleanValue());
        } else {
            this.chart.addNewVaryColors().setVal(varyColors.booleanValue());
        }
    }

    public XDDFChartData.Series addSeries(XDDFDataSource<?> category, XDDFNumericalDataSource<? extends Number> values) {
        int index = this.series.size();
        CTPieSer ctSer = this.chart.addNewSer();
        ctSer.addNewCat();
        ctSer.addNewVal();
        ctSer.addNewIdx().setVal((long)index);
        ctSer.addNewOrder().setVal((long)index);
        Series added = new Series(ctSer, category, values);
        this.series.add(added);
        return added;
    }

    public class Series
    extends XDDFChartData.Series {
        private CTPieSer series;

        protected Series(CTPieSer series, XDDFDataSource<?> category, XDDFNumericalDataSource<? extends Number> values) {
            super((XDDFChartData)DoughnutChartData.this, category, values);
            this.series = series;
        }

        protected Series(CTPieSer series, CTAxDataSource category, CTNumDataSource values) {
            super((XDDFChartData)DoughnutChartData.this, (XDDFDataSource)XDDFDataSourcesFactory.fromDataSource((CTAxDataSource)category), XDDFDataSourcesFactory.fromDataSource((CTNumDataSource)values));
            this.series = series;
        }

        protected CTSerTx getSeriesText() {
            return this.series.isSetTx() ? this.series.getTx() : this.series.addNewTx();
        }

        public void setShowLeaderLines(boolean showLeaderLines) {
            if (!this.series.isSetDLbls()) {
                this.series.addNewDLbls();
            }
            if (this.series.getDLbls().isSetShowLeaderLines()) {
                this.series.getDLbls().getShowLeaderLines().setVal(showLeaderLines);
            } else {
                this.series.getDLbls().addNewShowLeaderLines().setVal(showLeaderLines);
            }
        }

        public XDDFShapeProperties getShapeProperties() {
            return this.series.isSetSpPr() ? new XDDFShapeProperties(this.series.getSpPr()) : null;
        }

        public void setShapeProperties(XDDFShapeProperties properties) {
            if (properties == null) {
                if (this.series.isSetSpPr()) {
                    this.series.unsetSpPr();
                }
            } else if (this.series.isSetSpPr()) {
                this.series.setSpPr(properties.getXmlObject());
            } else {
                this.series.addNewSpPr().set((XmlObject)properties.getXmlObject());
            }
        }

        public long getExplosion() {
            return this.series.isSetExplosion() ? this.series.getExplosion().getVal() : 0L;
        }

        public void setExplosion(long explosion) {
            if (this.series.isSetExplosion()) {
                this.series.getExplosion().setVal(explosion);
            } else {
                this.series.addNewExplosion().setVal(explosion);
            }
        }

        protected CTAxDataSource getAxDS() {
            return this.series.getCat();
        }

        protected CTNumDataSource getNumDS() {
            return this.series.getVal();
        }

        protected void setIndex(long val) {
            this.series.getIdx().setVal(val);
        }

        protected void setOrder(long val) {
            this.series.getOrder().setVal(val);
        }

        protected List<CTDPt> getDPtList() {
            return Collections.emptyList();
        }
    }
}

