/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.word.poi;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.module.calculate.CalculateHelper;
import kd.epm.far.business.fidm.word.poi.AbstractPoi;
import kd.epm.far.business.fidm.word.poi.DoughnutChartData;
import kd.epm.far.business.fidm.word.poi.PoiHelper;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFChart;
import org.apache.poi.xddf.usermodel.chart.XDDFChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSourcesFactory;
import org.apache.poi.xddf.usermodel.chart.XDDFNumericalDataSource;
import org.apache.poi.xwpf.usermodel.XWPFChart;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTDLbls;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTDPt;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTHoleSize;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPieSer;

public class DoughnutPoi
extends AbstractPoi {
    public static void bind(XWPFRun where, JSONObject moduleProperties) throws IOException, InvalidFormatException {
        XWPFChart chart = PoiHelper.createChart(where, moduleProperties);
        DoughnutPoi.createChart(chart, moduleProperties, where);
        PoiHelper.clearPlaceholder(where, false);
    }

    public static void createChart(XWPFChart chart, JSONObject moduleProperties) {
        DoughnutPoi.createChart(chart, moduleProperties, null);
    }

    public static void createChart(XWPFChart chart, JSONObject moduleProperties, XWPFRun run) {
        Map dataObject = DoughnutPoi.getData(moduleProperties);
        JSONObject specialMap = DoughnutPoi.getSpecialMap(moduleProperties);
        if (dataObject == null || dataObject.get("data") == null) {
            return;
        }
        List soureceData = (List)dataObject.get("data");
        if (soureceData == null) {
            return;
        }
        JSONObject dataFormat = CalculateHelper.getDataFormart(moduleProperties, "dataFormat", "pie");
        ArrayList<String> bottomData = new ArrayList<String>(2);
        ArrayList<BigDecimal> leftData = new ArrayList<BigDecimal>(2);
        for (Map item : soureceData) {
            bottomData.add(item.get("name") == null ? "" : item.get("name").toString());
            BigDecimal val = CalculateHelper.convertValueToDecimal(item.get("value") == null ? "0" : item.get("value").toString(), dataFormat);
            leftData.add(val);
        }
        String yName = null;
        if (specialMap != null) {
            yName = (String)specialMap.get((Object)"detail_name");
        }
        PoiHelper.createChartTitle(chart, moduleProperties, false);
        PoiHelper.setLegendStyle(chart, moduleProperties);
        int rownum = bottomData.size();
        XDDFCategoryDataSource bottomDataSource = XDDFDataSourcesFactory.fromArray((String[])bottomData.toArray(new String[0]), (String)PoiHelper.setDataSheetRange(chart, rownum, 0), (int)0);
        XDDFNumericalDataSource leftDataSource = XDDFDataSourcesFactory.fromArray((Number[])leftData.toArray(new BigDecimal[0]), (String)PoiHelper.setDataSheetRange(chart, rownum, 1), (int)1);
        DoughnutChartData data = new DoughnutChartData((XDDFChart)chart, chart.getCTChart().getPlotArea().insertNewDoughnutChart(0));
        data.setVaryColors(true);
        PoiHelper.setTitleInDataSheet(chart, moduleProperties.getString("id"), 0);
        PoiHelper.setModuleId(run, moduleProperties.getString("id"));
        XDDFChartData.Series series = data.addSeries((XDDFDataSource)bottomDataSource, leftDataSource);
        if (StringUtils.isNotEmpty((CharSequence)yName)) {
            PoiHelper.setSeriesTitle(chart, series, yName, 1);
        }
        CTPieSer ser = chart.getCTChart().getPlotArea().getDoughnutChartArray(0).getSerArray(0);
        for (int cIndex = 0; cIndex < rownum; ++cIndex) {
            CTDPt dpt = ser.addNewDPt();
            dpt.addNewIdx().setVal((long)cIndex);
            dpt.addNewSpPr().addNewSolidFill().addNewSrgbClr().xsetVal(PoiHelper.getCtdoptColor(cIndex));
        }
        boolean dataFormatVisible = DisclosureJsonHelper.getValue(moduleProperties, "dataFormat", "pie", "visible", true);
        if (dataFormatVisible) {
            CTDLbls dLbls = chart.getCTChart().getPlotArea().getDoughnutChartArray(0).getSerArray(0).addNewDLbls();
            PoiHelper.setFormatCode(dLbls, DisclosureJsonHelper.getJsonObject(moduleProperties, "dataFormat", "pie"));
            PoiHelper.setDataFormatDLbls(dLbls, moduleProperties, "pie", true);
        }
        CTHoleSize holeSize = chart.getCTChart().getPlotArea().getDoughnutChartArray(0).addNewHoleSize();
        holeSize.setVal((Object)50);
        PoiHelper.setBorder(chart, moduleProperties);
        chart.plot((XDDFChartData)data);
    }
}

