/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.word.poi;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.epm.far.business.common.enums.DataPatternEnum;
import kd.epm.far.business.common.enums.ModuleEnum;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.module.calculate.CalculateHelper;
import kd.epm.far.business.fidm.word.poi.AbstractPoi;
import kd.epm.far.business.fidm.word.poi.PoiHelper;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.xddf.usermodel.chart.AxisCrossBetween;
import org.apache.poi.xddf.usermodel.chart.AxisCrosses;
import org.apache.poi.xddf.usermodel.chart.AxisPosition;
import org.apache.poi.xddf.usermodel.chart.BarDirection;
import org.apache.poi.xddf.usermodel.chart.BarGrouping;
import org.apache.poi.xddf.usermodel.chart.ChartTypes;
import org.apache.poi.xddf.usermodel.chart.MarkerStyle;
import org.apache.poi.xddf.usermodel.chart.XDDFBarChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryAxis;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFChartAxis;
import org.apache.poi.xddf.usermodel.chart.XDDFChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSourcesFactory;
import org.apache.poi.xddf.usermodel.chart.XDDFLineChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFNumericalDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFValueAxis;
import org.apache.poi.xwpf.usermodel.XWPFChart;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBarSer;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTDLbls;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTLineSer;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPlotArea;
import org.openxmlformats.schemas.drawingml.x2006.chart.STDLblPos;

public class LineColumnarPoi
extends AbstractPoi {
    public static void bind(XWPFRun where, JSONObject moduleProperties) throws IOException, InvalidFormatException {
        XWPFChart chart = PoiHelper.createChart(where, moduleProperties);
        LineColumnarPoi.createChart(chart, moduleProperties, where);
        PoiHelper.clearPlaceholder(where, false);
    }

    public static void createChart(XWPFChart chart, JSONObject moduleProperties) {
        LineColumnarPoi.createChart(chart, moduleProperties, null);
    }

    public static void createChart(XWPFChart chart, JSONObject moduleProperties, XWPFRun run) {
        int i;
        Map dataObject = LineColumnarPoi.getData(moduleProperties);
        if (dataObject == null || dataObject.get("data") == null) {
            return;
        }
        Map soureceData = (Map)dataObject.get("data");
        List categories = new ArrayList(10);
        ArrayList<String> leftTitles = new ArrayList<String>(10);
        ArrayList<Number[]> leftData = new ArrayList<Number[]>(10);
        ArrayList<String> rightTitles = new ArrayList<String>(10);
        ArrayList<Number[]> rightData = new ArrayList<Number[]>(10);
        if (soureceData.get("xAxis") != null) {
            categories = (List)soureceData.get("xAxis");
        }
        JSONObject dataFormatY1 = CalculateHelper.getDataFormart(moduleProperties, "dataFormat", "y1");
        JSONObject dataFormatY2 = CalculateHelper.getDataFormart(moduleProperties, "dataFormat", "y2");
        for (Map yData : (List)soureceData.get("series")) {
            List<Number> valArarry;
            if ("line".equals(yData.get("type"))) {
                rightTitles.add(yData.get("name") == null ? "" : yData.get("name").toString());
                valArarry = (List<Number>)yData.get("data");
                valArarry = PoiHelper.getVarArarry(dataFormatY2, valArarry);
                rightData.add(valArarry.toArray(new Number[0]));
                continue;
            }
            leftTitles.add(yData.get("name") == null ? "" : yData.get("name").toString());
            valArarry = (List)yData.get("data");
            valArarry = PoiHelper.getVarArarry(dataFormatY1, valArarry);
            leftData.add(valArarry.toArray(new Number[0]));
        }
        BarGrouping barGrouping = BarGrouping.CLUSTERED;
        BarDirection barDirection = BarDirection.COL;
        String moduleType = moduleProperties.getString("type");
        if (ModuleEnum.LINE_CLUSTERED_COLUMNAR.getType().equals(moduleType)) {
            barGrouping = BarGrouping.CLUSTERED;
        } else if (ModuleEnum.LINE_STACKED_COLUMNAR.getType().equals(moduleType)) {
            barGrouping = BarGrouping.STACKED;
        }
        PoiHelper.createChartTitle(chart, moduleProperties, false);
        PoiHelper.setTitleInDataSheet(chart, moduleProperties.getString("id"), 0);
        PoiHelper.setModuleId(run, moduleProperties.getString("id"));
        int numOfPoints = categories.size();
        XDDFCategoryDataSource categoriesData = XDDFDataSourcesFactory.fromArray((String[])categories.toArray(new String[0]), (String)PoiHelper.setDataSheetRange(chart, numOfPoints, 0), (int)0);
        XDDFCategoryAxis bottomAxis = chart.createCategoryAxis(AxisPosition.TOP);
        XDDFValueAxis leftAxis = chart.createValueAxis(AxisPosition.LEFT);
        PoiHelper.setXAxisTitleFontSize(bottomAxis, moduleProperties);
        PoiHelper.setYAxisTitleFontSize(leftAxis, "y1", moduleProperties);
        PoiHelper.setYAxisMinAndMax(leftAxis, "y1", moduleProperties);
        leftAxis.crossAxis((XDDFChartAxis)bottomAxis);
        bottomAxis.crossAxis((XDDFChartAxis)leftAxis);
        leftAxis.setCrosses(AxisCrosses.MIN);
        leftAxis.setCrossBetween(AxisCrossBetween.BETWEEN);
        CTPlotArea plotArea = chart.getCTChart().getPlotArea();
        XDDFChartData barData = chart.createData(ChartTypes.BAR, (XDDFChartAxis)bottomAxis, leftAxis);
        for (i = 0; i < leftData.size(); ++i) {
            XDDFNumericalDataSource dataSource = XDDFDataSourcesFactory.fromArray((Number[])((Number[])leftData.get(i)), (String)PoiHelper.setDataSheetRange(chart, numOfPoints, i + 1), (int)(i + 1));
            XDDFChartData.Series series = barData.addSeries((XDDFDataSource)categoriesData, dataSource);
            PoiHelper.setSeriesTitle(chart, series, (String)leftTitles.get(i), i + 1);
        }
        ((XDDFBarChartData)barData).setBarDirection(barDirection);
        ((XDDFBarChartData)barData).setBarGrouping(barGrouping);
        plotArea.getBarChartArray(0).addNewOverlap().setVal((Object)(barGrouping == BarGrouping.STACKED ? (byte)100 : -20));
        barData.setVaryColors(Boolean.valueOf(true));
        for (i = 0; i < leftTitles.size(); ++i) {
            CTBarSer ser = chart.getCTChart().getPlotArea().getBarChartArray(0).getSerArray(i);
            ser.addNewSpPr().addNewSolidFill().addNewSrgbClr().xsetVal(PoiHelper.getCtdoptColor(i));
        }
        boolean dataFormatVisible = DisclosureJsonHelper.getValue(moduleProperties, "dataFormat", "y1", "visible", true);
        String dataLabel = DisclosureJsonHelper.getValue(moduleProperties, "dataFormat", "y1", "dataLabel", "0");
        if (dataFormatVisible) {
            for (int i2 = 0; i2 < leftTitles.size(); ++i2) {
                CTDLbls dLbls = chart.getCTChart().getPlotArea().getBarChartArray(0).getSerArray(i2).addNewDLbls();
                PoiHelper.setFormatCode(dLbls, dataFormatY1);
                PoiHelper.setDataFormatDLbls(dLbls, moduleProperties, "y1", false);
                if (!StringUtils.isNotEmpty((CharSequence)dataLabel) || "0".equals(dataLabel)) continue;
                dLbls.addNewDLblPos().setVal(STDLblPos.Enum.forString((String)dataLabel));
            }
        }
        chart.plot(barData);
        XDDFValueAxis rightAxis = null;
        if (rightData != null && rightData.size() > 0) {
            int i3;
            rightAxis = chart.createValueAxis(AxisPosition.RIGHT);
            PoiHelper.setYAxisTitleFontSize(rightAxis, "y2", moduleProperties);
            PoiHelper.setYAxisMinAndMax(rightAxis, "y2", moduleProperties);
            rightAxis.setCrosses(AxisCrosses.MAX);
            rightAxis.setCrossBetween(AxisCrossBetween.BETWEEN);
            rightAxis.crossAxis((XDDFChartAxis)bottomAxis);
            bottomAxis.crossAxis((XDDFChartAxis)rightAxis);
            XDDFChartData lineData = chart.createData(ChartTypes.LINE, (XDDFChartAxis)bottomAxis, rightAxis);
            for (i3 = 0; i3 < rightData.size(); ++i3) {
                XDDFNumericalDataSource dataSource = XDDFDataSourcesFactory.fromArray((Number[])((Number[])rightData.get(i3)), (String)PoiHelper.setDataSheetRange(chart, numOfPoints, i3 + 1), (int)(i3 + 1));
                XDDFLineChartData.Series series = (XDDFLineChartData.Series)lineData.addSeries((XDDFDataSource)categoriesData, dataSource);
                PoiHelper.setSeriesTitle(chart, (XDDFChartData.Series)series, (String)rightTitles.get(i3), i3 + 1);
                series.setMarkerStyle(MarkerStyle.NONE);
            }
            lineData.setVaryColors(Boolean.valueOf(true));
            for (i3 = 0; i3 < rightTitles.size(); ++i3) {
                CTLineSer ser = chart.getCTChart().getPlotArea().getLineChartArray(0).getSerArray(i3);
                ser.addNewSpPr().addNewLn().addNewSolidFill().addNewSrgbClr().xsetVal(PoiHelper.getCtdoptColor(i3));
            }
            boolean dataFormatVisible2 = DisclosureJsonHelper.getValue(moduleProperties, "dataFormat", "y2", "visible", true);
            String dataLabel2 = DisclosureJsonHelper.getValue(moduleProperties, "dataFormat", "y2", "dataLabel", "0");
            if (dataFormatVisible2) {
                for (int i4 = 0; i4 < rightTitles.size(); ++i4) {
                    CTDLbls dLbls = chart.getCTChart().getPlotArea().getLineChartArray(0).getSerArray(i4).addNewDLbls();
                    PoiHelper.setFormatCode(dLbls, dataFormatY2);
                    dLbls.addNewShowSerName().setVal(false);
                    dLbls.addNewShowCatName().setVal(false);
                    dLbls.addNewShowVal().setVal(true);
                    PoiHelper.setDataFormatDLbls(dLbls, moduleProperties, "y2", false);
                    if (!StringUtils.isNotEmpty((CharSequence)dataLabel2) || "0".equals(dataLabel2)) continue;
                    dLbls.addNewDLblPos().setVal(STDLblPos.Enum.forString((String)dataLabel2));
                }
            }
            chart.plot(lineData);
        }
        PoiHelper.setGridLine(chart, moduleProperties);
        PoiHelper.setBorder(chart, moduleProperties);
        PoiHelper.setAxisFormat(chart, moduleProperties, DataPatternEnum.getDataPatternByType(dataFormatY1.getString("unit")), DataPatternEnum.getDataPatternByType(dataFormatY2.getString("unit")));
        PoiHelper.setAxisTextAngle(chart, moduleProperties);
        PoiHelper.setAxisVisible(bottomAxis, leftAxis, rightAxis, moduleProperties);
        PoiHelper.setLegendStyle(chart, moduleProperties);
    }
}

