/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.word.poi;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.epm.far.business.common.enums.DataPatternEnum;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.module.calculate.CalculateHelper;
import kd.epm.far.business.fidm.word.poi.AbstractPoi;
import kd.epm.far.business.fidm.word.poi.PoiHelper;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.xddf.usermodel.chart.AxisPosition;
import org.apache.poi.xddf.usermodel.chart.ChartTypes;
import org.apache.poi.xddf.usermodel.chart.MarkerStyle;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryAxis;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFChartAxis;
import org.apache.poi.xddf.usermodel.chart.XDDFChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSourcesFactory;
import org.apache.poi.xddf.usermodel.chart.XDDFLineChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFNumericalDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFValueAxis;
import org.apache.poi.xwpf.usermodel.XWPFChart;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTDLbls;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTLineSer;
import org.openxmlformats.schemas.drawingml.x2006.chart.STDLblPos;

public class LinePoi
extends AbstractPoi {
    public static void bind(XWPFRun where, JSONObject moduleProperties) throws IOException, InvalidFormatException {
        XWPFChart chart = PoiHelper.createChart(where, moduleProperties);
        LinePoi.createChart(chart, moduleProperties, where);
        PoiHelper.clearPlaceholder(where, false);
    }

    public static void createChart(XWPFChart chart, JSONObject moduleProperties) {
        LinePoi.createChart(chart, moduleProperties, null);
    }

    public static void createChart(XWPFChart chart, JSONObject moduleProperties, XWPFRun run) {
        int i;
        Map dataObject = LinePoi.getData(moduleProperties);
        if (dataObject == null || dataObject.get("data") == null) {
            return;
        }
        Map soureceData = (Map)dataObject.get("data");
        List categories = new ArrayList(10);
        ArrayList<String> colorTitles = new ArrayList<String>(10);
        ArrayList<Number[]> tableData = new ArrayList<Number[]>(10);
        if (soureceData.get("xAxis") != null) {
            categories = (List)soureceData.get("xAxis");
        }
        JSONObject dataFormat = CalculateHelper.getDataFormart(moduleProperties, "dataFormat", "y1");
        for (Map yData : (List)soureceData.get("series")) {
            colorTitles.add(yData.get("name") == null ? "" : yData.get("name").toString());
            List<Number> valArarry = (List<Number>)yData.get("data");
            valArarry = PoiHelper.getVarArarry(dataFormat, valArarry);
            tableData.add(valArarry.toArray(new Number[0]));
        }
        if (colorTitles.size() != tableData.size()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u989c\u8272\u6807\u9898\u4e2a\u6570,\u5fc5\u987b\u548c\u6570\u7ec4\u4e2a\u6570\u76f8\u540c\u3002", (String)"FidmCalculate_4", (String)"epm-far-business", (Object[])new Object[0]));
        }
        for (Number[] tableDatum : tableData) {
            if (tableDatum.length == categories.size()) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u6bcf\u4e2a\u6570\u7ec4\u7684\u5143\u7d20\u4e2a\u6570,\u5fc5\u987b\u548c\u6570\u7ec4\u4e2a\u6570\u76f8\u540c", (String)"FidmCalculate_5", (String)"epm-far-business", (Object[])new Object[0]));
        }
        PoiHelper.createChartTitle(chart, moduleProperties, false);
        PoiHelper.setLegendStyle(chart, moduleProperties);
        XDDFCategoryAxis bottomAxis = chart.createCategoryAxis(AxisPosition.BOTTOM);
        XDDFValueAxis leftAxis = chart.createValueAxis(AxisPosition.LEFT);
        PoiHelper.setXAxisTitleFontSize(bottomAxis, moduleProperties);
        PoiHelper.setYAxisTitleFontSize(leftAxis, "y1", moduleProperties);
        PoiHelper.setYAxisMinAndMax(leftAxis, "y1", moduleProperties);
        int rownum = categories.size();
        XDDFCategoryDataSource bottomDataSource = XDDFDataSourcesFactory.fromArray((String[])categories.toArray(new String[0]), (String)PoiHelper.setDataSheetRange(chart, rownum, 0), (int)0);
        XDDFLineChartData data = (XDDFLineChartData)chart.createData(ChartTypes.LINE, (XDDFChartAxis)bottomAxis, leftAxis);
        PoiHelper.setAxisFormat(chart, moduleProperties, DataPatternEnum.getDataPatternByType(dataFormat.getString("unit")), null);
        PoiHelper.setAxisTextAngle(chart, moduleProperties);
        PoiHelper.setAxisVisible(bottomAxis, leftAxis, null, moduleProperties);
        PoiHelper.setTitleInDataSheet(chart, moduleProperties.getString("id"), 0);
        PoiHelper.setModuleId(run, moduleProperties.getString("id"));
        for (i = 0; i < colorTitles.size(); ++i) {
            XDDFNumericalDataSource leftDataSource = XDDFDataSourcesFactory.fromArray((Number[])((Number[])tableData.get(i)), (String)PoiHelper.setDataSheetRange(chart, rownum, i + 1), (int)(i + 1));
            XDDFLineChartData.Series series = (XDDFLineChartData.Series)data.addSeries((XDDFDataSource)bottomDataSource, leftDataSource);
            PoiHelper.setSeriesTitle(chart, (XDDFChartData.Series)series, (String)colorTitles.get(i), i + 1);
            series.setSmooth(Boolean.valueOf(false));
            series.setMarkerStyle(MarkerStyle.NONE);
        }
        data.setVaryColors(Boolean.valueOf(true));
        for (i = 0; i < colorTitles.size(); ++i) {
            CTLineSer ser = chart.getCTChart().getPlotArea().getLineChartArray(0).getSerArray(i);
            ser.addNewSpPr().addNewLn().addNewSolidFill().addNewSrgbClr().xsetVal(PoiHelper.getCtdoptColor(i));
        }
        boolean dataFormatVisible = DisclosureJsonHelper.getValue(moduleProperties, "dataFormat", "y1", "visible", true);
        String dataLabel = DisclosureJsonHelper.getValue(moduleProperties, "dataFormat", "y1", "dataLabel", "0");
        if (dataFormatVisible) {
            for (int i2 = 0; i2 < colorTitles.size(); ++i2) {
                CTDLbls dLbls = chart.getCTChart().getPlotArea().getLineChartArray(0).getSerArray(i2).addNewDLbls();
                PoiHelper.setFormatCode(dLbls, dataFormat);
                PoiHelper.setDataFormatDLbls(dLbls, moduleProperties, "y1", false);
                if (!StringUtils.isNotEmpty((CharSequence)dataLabel) || "0".equals(dataLabel)) continue;
                dLbls.addNewDLblPos().setVal(STDLblPos.Enum.forString((String)dataLabel));
            }
        }
        PoiHelper.setGridLine(chart, moduleProperties);
        PoiHelper.setBorder(chart, moduleProperties);
        chart.plot((XDDFChartData)data);
    }
}

