/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.word.poi;

import com.alibaba.fastjson.JSONObject;
import com.deepoove.poi.xwpf.BodyContainer;
import com.deepoove.poi.xwpf.BodyContainerFactory;
import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.util.StringUtils;
import kd.epm.far.business.common.enums.DataPatternEnum;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.module.calculate.CalculateHelper;
import kd.epm.far.business.fidm.word.helper.WordChartsHelper;
import kd.epm.far.common.common.util.GlobalIdUtil;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xddf.usermodel.chart.LegendPosition;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryAxis;
import org.apache.poi.xddf.usermodel.chart.XDDFChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFChartLegend;
import org.apache.poi.xddf.usermodel.chart.XDDFTitle;
import org.apache.poi.xddf.usermodel.chart.XDDFValueAxis;
import org.apache.poi.xddf.usermodel.text.TextContainer;
import org.apache.poi.xddf.usermodel.text.UnderlineType;
import org.apache.poi.xddf.usermodel.text.XDDFTextBody;
import org.apache.poi.xddf.usermodel.text.XDDFTextParagraph;
import org.apache.poi.xddf.usermodel.text.XDDFTextRun;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.TableRowAlign;
import org.apache.poi.xwpf.usermodel.XWPFChart;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBuiltInUnit;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTCatAx;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTDLbls;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTDispUnits;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTDispUnitsLbl;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumFmt;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPlotArea;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTValAx;
import org.openxmlformats.schemas.drawingml.x2006.chart.STBuiltInUnit;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSolidColorFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBody;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBodyProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextCharacterProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraph;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraphProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.STSchemeColorVal;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextStrikeType;
import org.openxmlformats.schemas.officeDocument.x2006.sharedTypes.STHexColorRGB;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBookmark;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDrawing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTMarkupRange;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;

public class PoiHelper {
    private static final Log log = LogFactory.getLog(PoiHelper.class);
    private static List<String> CtdoptColorList = Arrays.asList("40A9FF", "45DAD1", "8785FB", "5372F0", "39CA26", "A0D911", "FFA940", "FFDB4A", "F57582");

    public static XWPFChart createChart(XWPFRun run, JSONObject moduleProperties) throws IOException, InvalidFormatException {
        int alignment = DisclosureJsonHelper.getValue(moduleProperties, "alignment", 2);
        int width = DisclosureJsonHelper.getValue(moduleProperties, "width", 15);
        int height = DisclosureJsonHelper.getValue(moduleProperties, "height", 10);
        XWPFDocument document = run.getDocument();
        ((XWPFParagraph)run.getParent()).setAlignment(ParagraphAlignment.valueOf((int)alignment));
        return document.createChart(run, width * 360000, height * 360000);
    }

    public static void clearPlaceholder(XWPFRun run, boolean clearParagraph) {
        if (clearParagraph) {
            BodyContainer bodyContainer = BodyContainerFactory.getBodyContainer((XWPFRun)run);
            bodyContainer.clearPlaceholder(run);
        } else {
            run.setText("", 0);
        }
    }

    public static void createChartTitle(XWPFChart chart, JSONObject moduleProperties, boolean titleOverlay) {
        boolean titleVisible = DisclosureJsonHelper.getValue(moduleProperties, "title", "visible", true);
        if (titleVisible) {
            double fontSize = DisclosureJsonHelper.getValue(moduleProperties, "title", "fontSize", 10.0);
            boolean bold = !"normal".equalsIgnoreCase(DisclosureJsonHelper.getValue(moduleProperties, "title", "weight", "normal"));
            boolean underline = !"normal".equalsIgnoreCase(DisclosureJsonHelper.getValue(moduleProperties, "title", "underline", "normal"));
            boolean italic = !"normal".equalsIgnoreCase(DisclosureJsonHelper.getValue(moduleProperties, "title", "style", "normal"));
            chart.setTitleText(DisclosureJsonHelper.getValue(moduleProperties, "title", "name", ""));
            XDDFTextRun run = (XDDFTextRun)((XDDFTextParagraph)chart.getTitle().getBody().getParagraphs().get(0)).getTextRuns().get(0);
            run.setFontSize(new Double(fontSize));
            if (bold) {
                run.setBold(Boolean.valueOf(bold));
            }
            if (italic) {
                run.setItalic(Boolean.valueOf(italic));
            }
            if (underline) {
                run.setUnderline(UnderlineType.SINGLE);
            }
            chart.setTitleOverlay(titleOverlay);
        }
    }

    public static void setLegendStyle(XWPFChart chart, JSONObject moduleProperties) {
        boolean visiable = DisclosureJsonHelper.getValue(moduleProperties, "legend", "visible", true);
        boolean overlay = DisclosureJsonHelper.getValue(moduleProperties, "legend", "overlay", true);
        LegendPosition position = PoiHelper.getLegendPosition(DisclosureJsonHelper.getValue(moduleProperties, "legend", "position", "1"));
        double fontSize = DisclosureJsonHelper.getValue(moduleProperties, "legend", "fontSize", 10.0);
        if (visiable && Objects.nonNull(chart)) {
            XDDFChartLegend chartLegend = chart.getOrAddLegend();
            chartLegend.setPosition(position);
            chartLegend.setOverlay(!overlay);
            XDDFTextBody legendTextBody = new XDDFTextBody((TextContainer)chartLegend);
            legendTextBody.getXmlObject().addNewBodyPr();
            legendTextBody.addNewParagraph().addDefaultRunProperties().setFontSize(new Double(fontSize));
            chartLegend.setTextBody(legendTextBody);
        }
    }

    private static LegendPosition getLegendPosition(String position) {
        LegendPosition p = LegendPosition.TOP;
        if (Objects.nonNull(position)) {
            switch (position) {
                case "1": {
                    p = LegendPosition.TOP;
                    break;
                }
                case "2": {
                    p = LegendPosition.BOTTOM;
                    break;
                }
                case "3": {
                    p = LegendPosition.LEFT;
                    break;
                }
                case "4": {
                    p = LegendPosition.RIGHT;
                    break;
                }
                case "5": {
                    p = LegendPosition.TOP_RIGHT;
                    break;
                }
            }
        }
        return p;
    }

    public static CellReference setTitleInDataSheet(XWPFChart chart, String title, int column) {
        try {
            XSSFCell cell;
            XSSFWorkbook workbook = chart.getWorkbook();
            XSSFSheet sheet = workbook.getSheetAt(0);
            XSSFRow row = sheet.getRow(0);
            if (row == null) {
                row = sheet.createRow(0);
            }
            if ((cell = row.getCell(column)) == null) {
                cell = row.createCell(column);
            }
            cell.setCellValue(title);
            return new CellReference(sheet.getSheetName(), 0, column, true, true);
        }
        catch (Exception e) {
            log.error("setTitleInDataSheet error", (Throwable)e);
            return null;
        }
    }

    public static void setModuleId(XWPFRun run, String moduleId) {
        if (run == null || run.getCTR() == null || run.getCTR().getDrawingArray() == null) {
            return;
        }
        for (CTDrawing drawing : run.getCTR().getDrawingArray()) {
            WordChartsHelper.writeDescrtoDrawingInline(drawing, moduleId);
            WordChartsHelper.writeDescrtoDrawingAnchor(drawing, moduleId);
        }
    }

    public static String setDataSheetRange(XWPFChart chart, int rownum, int col) {
        return chart.formatRange(new CellRangeAddress(1, rownum, col, col));
    }

    public static void setSeriesTitle(XWPFChart chart, XDDFChartData.Series series, String title, int col) {
        series.setTitle(title, PoiHelper.setTitleInDataSheet(chart, title, col));
    }

    public static void setFormatCode(CTDLbls dLbls, JSONObject dataFormat) {
        if (dataFormat == null) {
            return;
        }
        dLbls.addNewShowPercent().setVal(false);
        CTNumFmt fmt = dLbls.addNewNumFmt();
        fmt.setFormatCode(CalculateHelper.getNumberFormatCode(dataFormat));
        fmt.setSourceLinked(false);
    }

    private static String getUnitStr(JSONObject dataFormat) {
        String dataPatternEnumType;
        DataPatternEnum unit;
        String numbertype;
        String unitStr = "";
        String string = numbertype = StringUtils.isNotEmpty((String)dataFormat.getString("numbertype")) ? dataFormat.getString("numbertype") : "1";
        if ((Objects.equals("1", numbertype) || Objects.equals("2", numbertype)) && (unit = DataPatternEnum.getDataPatternByType(dataPatternEnumType = dataFormat.getString("unit"))) != null && unit != DataPatternEnum.YUAN) {
            unitStr = unit.getName();
        }
        return unitStr;
    }

    public static void setXAxisTitleFontSize(XDDFCategoryAxis bottomAxis, JSONObject moduleProperties) {
        boolean visiable = DisclosureJsonHelper.getValue(moduleProperties, "axis", "x", "visible", true);
        if (visiable) {
            XDDFTitle title;
            String axisXTitle = DisclosureJsonHelper.getValue(moduleProperties, "axis", "x", "title", "");
            double fontSize = DisclosureJsonHelper.getValue(moduleProperties, "axis", "x", "fontSize", 10.0);
            bottomAxis.setTitle(axisXTitle);
            if (StringUtils.isNotEmpty((String)axisXTitle) && Objects.nonNull(title = PoiHelper.getOrSetAxisTitle(bottomAxis))) {
                title.getBody().getParagraph(0).addDefaultRunProperties().setFontSize(new Double(fontSize));
            }
        }
    }

    public static void setYAxisTitleFontSize(XDDFValueAxis leftAxis, String axisName, JSONObject moduleProperties) {
        boolean visiable = DisclosureJsonHelper.getValue(moduleProperties, "axis", axisName, "visible", true);
        String axisTitle = DisclosureJsonHelper.getValue(moduleProperties, "axis", axisName, "title", "");
        double fontSize = DisclosureJsonHelper.getValue(moduleProperties, "axis", axisName, "fontSize", 10.0);
        if (visiable) {
            XDDFTitle title;
            leftAxis.setTitle(axisTitle);
            if (StringUtils.isNotEmpty((String)axisTitle) && Objects.nonNull(title = PoiHelper.getOrSetAxisTitle(leftAxis))) {
                title.getBody().getParagraph(0).addDefaultRunProperties().setFontSize(new Double(fontSize));
            }
        }
    }

    private static XDDFTitle getOrSetAxisTitle(XDDFValueAxis axis) {
        try {
            Field _ctValAx = XDDFValueAxis.class.getDeclaredField("ctValAx");
            ReflectionUtils.makeAccessible((Field)_ctValAx);
            CTValAx ctValAx = (CTValAx)_ctValAx.get(axis);
            if (!ctValAx.isSetTitle()) {
                ctValAx.addNewTitle();
            }
            XDDFTitle title = new XDDFTitle(null, ctValAx.getTitle());
            return title;
        }
        catch (Exception ex) {
            return null;
        }
    }

    private static XDDFTitle getOrSetAxisTitle(XDDFCategoryAxis axis) {
        try {
            Field _ctCatAx = XDDFCategoryAxis.class.getDeclaredField("ctCatAx");
            ReflectionUtils.makeAccessible((Field)_ctCatAx);
            CTCatAx ctCatAx = (CTCatAx)_ctCatAx.get(axis);
            if (!ctCatAx.isSetTitle()) {
                ctCatAx.addNewTitle();
            }
            XDDFTitle title = new XDDFTitle(null, ctCatAx.getTitle());
            return title;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static void setAxisFormat(XWPFChart chart, JSONObject moduleProperties, DataPatternEnum x1Unit, DataPatternEnum x2Unit) {
        int length;
        JSONObject dataFormatY2;
        int length2;
        if (moduleProperties == null) {
            return;
        }
        JSONObject dataFormatY1 = DisclosureJsonHelper.getJsonObject(moduleProperties, "axis", "y1", "dataFormat");
        if (dataFormatY1 != null && (length2 = chart.getCTChart().getPlotArea().getValAxArray().length) > 0) {
            CTNumFmt ct = chart.getCTChart().getPlotArea().getValAxArray(0).addNewNumFmt();
            ct.setFormatCode(CalculateHelper.getNumberFormatCode(dataFormatY1));
            ct.setSourceLinked(false);
            DataPatternEnum y1Unit = DataPatternEnum.getDataPatternByType(dataFormatY1.getString("unit"));
            if (y1Unit != null && y1Unit.getRatio() > 0) {
                CTValAx valAx1 = chart.getCTChart().getPlotArea().getValAxArray(0);
                PoiHelper.addDispUnits(valAx1, y1Unit, dataFormatY1);
            }
        }
        if ((dataFormatY2 = DisclosureJsonHelper.getJsonObject(moduleProperties, "axis", "y2", "dataFormat")) != null && (length = chart.getCTChart().getPlotArea().getValAxArray().length) > 1) {
            CTNumFmt ct = chart.getCTChart().getPlotArea().getValAxArray(1).addNewNumFmt();
            ct.setFormatCode(CalculateHelper.getNumberFormatCode(dataFormatY2));
            ct.setSourceLinked(false);
            DataPatternEnum y2Unit = DataPatternEnum.getDataPatternByType(dataFormatY2.getString("unit"));
            if (y2Unit != null && y2Unit.getRatio() > 0) {
                CTValAx valAx2 = chart.getCTChart().getPlotArea().getValAxArray(1);
                PoiHelper.addDispUnits(valAx2, y2Unit, dataFormatY2);
            }
        }
    }

    private static void addDispUnits(CTValAx valAx, DataPatternEnum yUnit, JSONObject dataFormatY) {
        if (valAx == null || yUnit == null) {
            return;
        }
        STBuiltInUnit.Enum builtUnitEnum = null;
        if (DataPatternEnum.THOUSAND_YUAN.getType().equalsIgnoreCase(yUnit.getType())) {
            builtUnitEnum = STBuiltInUnit.THOUSANDS;
        } else if (DataPatternEnum.TEN_THOUSAND_YUAN.getType().equalsIgnoreCase(yUnit.getType())) {
            builtUnitEnum = STBuiltInUnit.TEN_THOUSANDS;
        } else if (DataPatternEnum.MILLION_YUAN.getType().equalsIgnoreCase(yUnit.getType())) {
            builtUnitEnum = STBuiltInUnit.MILLIONS;
        } else if (DataPatternEnum.BILLION_YUAN.getType().equalsIgnoreCase(yUnit.getType())) {
            builtUnitEnum = STBuiltInUnit.HUNDRED_MILLIONS;
        }
        if (builtUnitEnum == null) {
            return;
        }
        boolean isShowUnitText = DisclosureJsonHelper.getValue(dataFormatY, "showUnit", false);
        CTDispUnits ctDispUnits = null;
        try {
            ctDispUnits = valAx.addNewDispUnits();
            CTBuiltInUnit ctBuiltInUnit = ctDispUnits.addNewBuiltInUnit();
            ctBuiltInUnit.setVal(builtUnitEnum);
            if (isShowUnitText) {
                CTDispUnitsLbl ctDispUnitsLbl = ctDispUnits.addNewDispUnitsLbl();
                ctDispUnitsLbl.addNewLayout();
                CTTextBody textBody = ctDispUnitsLbl.addNewTxPr();
                CTTextBodyProperties ctTextBodyProperties = textBody.addNewBodyPr();
                ctTextBodyProperties.addNewNoAutofit();
                textBody.addNewLstStyle();
                CTTextParagraph p = textBody.addNewP();
                CTTextParagraphProperties ctTextParagraphProperties = p.addNewPPr();
                CTTextCharacterProperties ctTextCharacterProperties = ctTextParagraphProperties.addNewDefRPr();
                ctTextCharacterProperties.setLang("zh-CN");
                ctTextCharacterProperties.setSz(1000);
                ctTextCharacterProperties.setB(false);
                ctTextCharacterProperties.setKern(1200);
                ctTextCharacterProperties.setStrike(STTextStrikeType.Enum.forString((String)"noStrike"));
                CTSolidColorFillProperties ctSolidColorFillProperties = ctTextCharacterProperties.addNewSolidFill();
                ctSolidColorFillProperties.addNewSchemeClr().setVal(STSchemeColorVal.Enum.forString((String)"tx1"));
            }
        }
        catch (Exception ex) {
            log.error("dm create addDispUnits error", (Throwable)ex);
        }
    }

    public static void setAxisTextAngle(XWPFChart chart, JSONObject moduleProperties) {
        int length;
        int angleX;
        int length2;
        int angleY2;
        int length3;
        if (moduleProperties == null) {
            return;
        }
        int angleY1 = DisclosureJsonHelper.getValue(moduleProperties, "axis", "y1", "angle", 0);
        if (angleY1 != 0 && angleY1 >= -90 && angleY1 <= 90 && (length3 = chart.getCTChart().getPlotArea().getValAxArray().length) > 0) {
            chart.getCTChart().getPlotArea().getValAxArray(0).addNewTxPr().addNewBodyPr().setRot(angleY1 * 60000);
        }
        if ((angleY2 = DisclosureJsonHelper.getValue(moduleProperties, "axis", "y2", "angle", 0)) != 0 && angleY2 >= -90 && angleY2 <= 90 && (length2 = chart.getCTChart().getPlotArea().getValAxArray().length) > 1) {
            chart.getCTChart().getPlotArea().getValAxArray(1).addNewTxPr().addNewBodyPr().setRot(angleY2 * 60000);
        }
        if ((angleX = DisclosureJsonHelper.getValue(moduleProperties, "axis", "x", "angle", 0)) != 0 && angleX >= -90 && angleX <= 90 && (length = chart.getCTChart().getPlotArea().getCatAxArray().length) > 0) {
            chart.getCTChart().getPlotArea().getCatAxArray(0).addNewTxPr().addNewBodyPr().setRot(angleX * 60000);
        }
    }

    public static void setGridLine(XWPFChart chart, JSONObject moduleProperties) {
        CTValAx[] ctValAxes;
        boolean visible = DisclosureJsonHelper.getValue(moduleProperties, "gridLine", "visible", true);
        if (!visible) {
            return;
        }
        boolean xVisible = DisclosureJsonHelper.getValue(moduleProperties, "gridLine", "x", false);
        boolean y1Visible = DisclosureJsonHelper.getValue(moduleProperties, "gridLine", "y1", false);
        boolean y2Visible = DisclosureJsonHelper.getValue(moduleProperties, "gridLine", "y2", false);
        CTChart ctChart = chart.getCTChart();
        if (ctChart == null) {
            return;
        }
        CTPlotArea plotArea = ctChart.getPlotArea();
        if (plotArea == null) {
            return;
        }
        CTCatAx[] ctArr = plotArea.getCatAxArray();
        if (ctArr != null && ctArr.length > 0 && y1Visible) {
            ctArr[0].addNewMajorGridlines();
        }
        if ((ctValAxes = plotArea.getValAxArray()) != null && ctValAxes.length > 0) {
            if (xVisible) {
                ctValAxes[0].addNewMajorGridlines();
            }
            if (ctValAxes.length > 1 && y2Visible) {
                ctValAxes[1].addNewMajorGridlines();
            }
        }
    }

    public static TableRowAlign tableAlignment(int alignmentVal) {
        TableRowAlign align = TableRowAlign.CENTER;
        String alignment = "CENTER";
        switch (alignmentVal) {
            case 1: {
                alignment = "LEFT";
                break;
            }
            case 2: {
                alignment = "CENTER";
                break;
            }
            case 3: {
                alignment = "RIGHT";
                break;
            }
        }
        for (TableRowAlign e : TableRowAlign.values()) {
            if (!Objects.equals(e.name(), alignment)) continue;
            align = e;
        }
        return align;
    }

    public static boolean insertBookMark(XWPFParagraph paragraph, String moduleId, String bookmarkKey) {
        return PoiHelper.insertBookMark(paragraph, moduleId, bookmarkKey, " ");
    }

    public static boolean insertBookMark(XWPFParagraph paragraph, String moduleId, String bookmarkKey, String text) {
        try {
            long bookmarkId = GlobalIdUtil.genGlobalLongId();
            CTBookmark newBookMark = paragraph.getCTP().addNewBookmarkStart();
            newBookMark.setName(bookmarkKey);
            newBookMark.setId(BigInteger.valueOf(bookmarkId));
            XWPFRun replaceRun = paragraph.createRun();
            replaceRun.setText(text);
            paragraph.getCTP().addNewBookmarkEnd().setId(BigInteger.valueOf(bookmarkId));
            return true;
        }
        catch (Exception ex) {
            log.error("insertBookMark moduleId=" + moduleId + ",error", (Throwable)ex);
            return false;
        }
    }

    public static CTBookmark findBookMark(CTP ctp, String[] bookmarkKeys) {
        try {
            for (int dwi = 0; dwi < ctp.sizeOfBookmarkStartArray(); ++dwi) {
                CTBookmark bookmark = ctp.getBookmarkStartArray(dwi);
                for (String containValue : bookmarkKeys) {
                    if (StringUtils.isEmpty((String)containValue) || !bookmark.getName().contains(containValue)) continue;
                    return bookmark;
                }
            }
            return null;
        }
        catch (Exception ex) {
            log.error("insertBookMark bookmarkKeys=" + JSONObject.toJSONString((Object)bookmarkKeys) + ",error", (Throwable)ex);
            return null;
        }
    }

    public static void removeBookMark(CTP ctp, String[] bookmarkKeys) {
        try {
            int startIndex = -1;
            String boodStartId = "";
            block2: for (int dwi = 0; dwi < ctp.sizeOfBookmarkStartArray(); ++dwi) {
                CTBookmark bookmark = ctp.getBookmarkStartArray(dwi);
                for (String containValue : bookmarkKeys) {
                    if (StringUtils.isEmpty((String)containValue) || !bookmark.getName().contains(containValue)) continue;
                    startIndex = dwi;
                    boodStartId = bookmark.getId().toString();
                    continue block2;
                }
            }
            int endIndex = -1;
            for (int dwi = 0; dwi < ctp.sizeOfBookmarkEndArray(); ++dwi) {
                CTMarkupRange bookmark = ctp.getBookmarkEndArray(dwi);
                if (!boodStartId.equalsIgnoreCase(bookmark.xgetId().getStringValue())) continue;
                endIndex = dwi;
                break;
            }
            if (startIndex >= 0) {
                ctp.removeBookmarkStart(startIndex);
            }
            if (endIndex >= 0) {
                ctp.removeBookmarkEnd(endIndex);
            }
        }
        catch (Exception ex) {
            log.error("removeBookMark bookmarkKeys=" + JSONObject.toJSONString((Object)bookmarkKeys) + ",error", (Throwable)ex);
        }
    }

    public static void deleteTable(XWPFTable table) {
        List rows = table.getRows();
        int rowLength = rows.size();
        for (int i = 0; i < rowLength; ++i) {
            table.removeRow(0);
        }
    }

    public static void setBorder(XWPFChart chart, JSONObject moduleProperties) {
        boolean visible = DisclosureJsonHelper.getValue(moduleProperties, "border", "visible", true);
        if (!visible) {
            chart.getCTChartSpace().addNewSpPr().addNewLn().addNewNoFill();
        }
    }

    public static void setYAxisMinAndMax(XDDFValueAxis leftAxis, String axisName, JSONObject moduleProperties) {
        String minStr = DisclosureJsonHelper.getValue(moduleProperties, "axis", axisName, "min", "");
        String maxStr = DisclosureJsonHelper.getValue(moduleProperties, "axis", axisName, "max", "");
        if (StringUtils.isNotEmpty((String)minStr)) {
            double min = -1.0;
            try {
                min = Double.parseDouble(minStr);
            }
            catch (Exception ex) {
                log.error("Double convert fail minStr=" + minStr, (Throwable)ex);
            }
            if (min > -1.0) {
                leftAxis.setMinimum(min);
            }
        }
        if (StringUtils.isNotEmpty((String)maxStr)) {
            double max = -1.0;
            try {
                max = Double.parseDouble(maxStr);
            }
            catch (Exception ex) {
                log.error("Double convert fail maxStr=" + maxStr, (Throwable)ex);
            }
            if (max > -1.0) {
                leftAxis.setMaximum(max);
            }
        }
    }

    public static void setAxisVisible(XDDFCategoryAxis bottomAxis, XDDFValueAxis leftAxis, XDDFValueAxis rightAxis, JSONObject moduleProperties) {
        boolean y2Visible;
        boolean y1Visible;
        boolean xVisible = DisclosureJsonHelper.getValue(moduleProperties, "axis", "x", "visible", true);
        if (!xVisible && bottomAxis != null) {
            bottomAxis.setVisible(xVisible);
        }
        if (!(y1Visible = DisclosureJsonHelper.getValue(moduleProperties, "axis", "y1", "visible", true)) && leftAxis != null) {
            leftAxis.setVisible(y1Visible);
        }
        if (rightAxis != null && !(y2Visible = DisclosureJsonHelper.getValue(moduleProperties, "axis", "y2", "visible", true)) && rightAxis != null) {
            rightAxis.setVisible(y2Visible);
        }
    }

    public static void setDataFormatDLbls(CTDLbls dLbls, JSONObject moduleProperties, String nodeName, boolean setPercent) {
        if (StringUtils.isEmpty((String)nodeName)) {
            return;
        }
        boolean visiable = DisclosureJsonHelper.getValue(moduleProperties, "dataFormat", nodeName, "visible", true);
        boolean showLegendKey = DisclosureJsonHelper.getValue(moduleProperties, "dataFormat", nodeName, "showLegendKey", false);
        boolean showSeriesName = DisclosureJsonHelper.getValue(moduleProperties, "dataFormat", nodeName, "showSeriesName", false);
        boolean showCategoryName = DisclosureJsonHelper.getValue(moduleProperties, "dataFormat", nodeName, "showCategoryName", false);
        boolean showDisplayValue = DisclosureJsonHelper.getValue(moduleProperties, "dataFormat", nodeName, "showDisplayValue", true);
        String splitSignal = ",";
        if (DisclosureJsonHelper.existValue(moduleProperties, "dataFormat", nodeName, "splitSignal")) {
            splitSignal = moduleProperties.getJSONObject("dataFormat").getJSONObject(nodeName).getString("splitSignal");
        }
        (dLbls.isSetShowLegendKey() ? dLbls.getShowLegendKey() : dLbls.addNewShowLegendKey()).setVal(visiable && showLegendKey);
        (dLbls.isSetShowSerName() ? dLbls.getShowSerName() : dLbls.addNewShowSerName()).setVal(visiable && showSeriesName);
        (dLbls.isSetShowCatName() ? dLbls.getShowCatName() : dLbls.addNewShowCatName()).setVal(visiable && showCategoryName);
        (dLbls.isSetShowVal() ? dLbls.getShowVal() : dLbls.addNewShowVal()).setVal(visiable && showDisplayValue);
        if (visiable && splitSignal != null && !",".equalsIgnoreCase(splitSignal)) {
            dLbls.setSeparator(splitSignal);
        }
        if (setPercent) {
            boolean showPercent = DisclosureJsonHelper.getValue(moduleProperties, "dataFormat", nodeName, "showPercent", false);
            (dLbls.isSetShowPercent() ? dLbls.getShowPercent() : dLbls.addNewShowPercent()).setVal(visiable && showPercent);
            if (visiable && showPercent) {
                int decimal = DisclosureJsonHelper.getValue(moduleProperties, "dataFormat", nodeName, "decimal", 2);
                String formatCode = "0";
                if (decimal > 0) {
                    StringBuilder s = new StringBuilder(".");
                    for (int i = 0; i < decimal; ++i) {
                        s.append("0");
                    }
                    formatCode = formatCode + s;
                }
                formatCode = formatCode + "%";
                CTNumFmt fmt = dLbls.isSetNumFmt() ? dLbls.getNumFmt() : dLbls.addNewNumFmt();
                fmt.setFormatCode(formatCode);
                fmt.setSourceLinked(false);
            }
        }
    }

    public static STHexColorRGB getCtdoptColor(int index) {
        int i = index % CtdoptColorList.size();
        STHexColorRGB hex = (STHexColorRGB)STHexColorRGB.Factory.newInstance();
        hex.setStringValue(CtdoptColorList.get(i));
        return hex;
    }

    public static List<Number> getVarArarry(JSONObject dataFormat, List<Number> valArarry) {
        ArrayList<Number> newValArrary = new ArrayList<Number>(valArarry.size());
        for (Number item : valArarry) {
            if (item != null) {
                newValArrary.add(item);
                continue;
            }
            newValArrary.add(BigDecimal.ZERO);
        }
        return newValArrary;
    }
}

