/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.far.business.fidm.word.poi;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.function.Function;
import kd.epm.far.business.fidm.base.DisclosureJsonHelper;
import kd.epm.far.business.fidm.word.WordConvert;
import kd.epm.far.business.fidm.word.dto.WordTableNode;
import kd.epm.far.business.fidm.word.helper.WordBookmarkHelper;
import kd.epm.far.business.fidm.word.helper.WordNodeJsonHelper;
import kd.epm.far.business.fidm.word.poi.AbstractPoi;
import kd.epm.far.business.fidm.word.poi.PoiHelper;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.poi.xwpf.usermodel.XWPFTable;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;
import org.apache.xmlbeans.XmlCursor;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STVerticalJc;

public class ReportSectionPoi
extends AbstractPoi {
    public static void bind(XWPFRun where, JSONObject moduleProperties) {
        int alignment = DisclosureJsonHelper.getValue(moduleProperties, "alignment", 2);
        String moduleId = moduleProperties.getString("id");
        String bookMarkKey = DisclosureJsonHelper.getValue(moduleProperties, "bookmark", "key", moduleId);
        XWPFDocument document = where.getDocument();
        XWPFParagraph paragraph = where.getParagraph();
        paragraph.setAlignment(ParagraphAlignment.valueOf((int)alignment));
        where.setText("", 0);
        XmlCursor cursor = paragraph.getCTP().newCursor();
        XWPFTable xwpfTable = document.insertNewTbl(cursor);
        xwpfTable.setTableAlignment(PoiHelper.tableAlignment(alignment));
        where.setText("", 0);
        Function<String, Boolean> callBack = msg -> {
            PoiHelper.removeBookMark(paragraph.getCTP(), new String[]{moduleId, bookMarkKey});
            return true;
        };
        ReportSectionPoi.createChart(xwpfTable, moduleProperties, callBack);
    }

    public static void createChart(XWPFTable table, JSONObject moduleProperties, Function callBack) {
        String moduleId = moduleProperties.getString("id");
        String bookMarkKey = DisclosureJsonHelper.getValue(moduleProperties, "bookmark", "key", moduleId);
        String resultCode = ReportSectionPoi.getDataCode(moduleProperties);
        if (!"0000".equals(resultCode)) {
            PoiHelper.deleteTable(table);
            String message = ReportSectionPoi.getDataMessage(moduleProperties);
            XWPFTableCell targetCell = table.insertNewTableRow(0).addNewTableCell();
            CTTblWidth cellW = targetCell.getCTTc().addNewTcPr().addNewTcW();
            cellW.setType(STTblWidth.AUTO);
            targetCell.getCTTc().getTcPr().addNewVAlign().setVal(STVerticalJc.CENTER);
            ((CTP)targetCell.getCTTc().getPList().get(0)).addNewPPr().addNewJc().setVal(STJc.CENTER);
            targetCell.setText(message);
            String newBookmarkKey = WordBookmarkHelper.createBookmarName(bookMarkKey, 0, 0);
            PoiHelper.insertBookMark((XWPFParagraph)targetCell.getParagraphs().get(0), moduleId, newBookmarkKey);
            return;
        }
        Map dataObject = ReportSectionPoi.getData(moduleProperties);
        if (dataObject != null && dataObject.get("tableNode") != null) {
            WordTableNode tableNode;
            PoiHelper.deleteTable(table);
            if (callBack != null) {
                callBack.apply(null);
            }
            if ((tableNode = (WordTableNode)WordNodeJsonHelper.parseObject(dataObject.get("tableNode").toString())) != null) {
                tableNode.setId(bookMarkKey);
                tableNode.setDataModeuleId(moduleId);
            }
            new WordConvert().toTableWord(tableNode, table);
        }
    }
}

